/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.upgrade.ConfigUpgrade;
import com.sonicsw.mf.common.config.upgrade.DirectoryService;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.MigrationException;
import com.sonicsw.mf.common.config.upgrade.OSrvrXSrvrException;
import com.sonicsw.mf.common.config.upgrade.UpgradeEnv;
import com.sonicsw.mf.common.config.upgrade.Utils;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ConfigurationDependencies
implements IMigrationProcess {
    private static final String MF_CONTAINER_NAME = "MF_CONTAINER";
    private static final String MF_ACTIVATION_DAEMON_NAME = "MF_ACTIVATION_DAEMON";
    private static final String MF_AUTHENTICATION_DOMAIN_NAME = "MF_AUTHENTICATION_DOMAIN";
    private static final String MQ_AUTHORIZATION_POLICY_NAME = "MQ_AUTHORIZATION_POLICY";
    private static final String MQ_CERTIFICATES_STORE_NAME = "MQ_CERTIFICATES_STORE";
    private static final String MQ_WS_PROTOCOL_NAME = "MQ_WS_PROTOCOL";
    private static final String MF_COMPONENT_COLLECTION_NAME = "MF_COMPONENT_COLLECTION";
    private static final String MF_CONTAINER_COLLECTION_NAME = "MF_CONTAINER_COLLECTION";
    static Vector allDependencies = new Vector();
    IDirectoryFileSystemService dsFileSystem;
    Utils m_utils = null;
    static JMSConnectorClient connector = null;
    static boolean wholeCluster = true;
    static boolean iwUpgrade = false;
    static boolean DEBUG = System.getProperty("DebugAll.debug", "false").equals("true");
    HashMap m_containerComponents = new HashMap();
    DirectoryService m_dsService = null;
    private boolean m_allowUpgraded = false;
    private final Map<String, IDirElement[]> fsCache = new HashMap<String, IDirElement[]>();

    public void closeDS() throws Exception {
        this.m_dsService.closeDS();
    }

    public IDirectoryFileSystemService getDS() {
        return this.dsFileSystem;
    }

    public ConfigurationDependencies(String url, String domainName, String username, String password, String mgmtNode, int rt) throws Exception {
        this.m_dsService = url.endsWith(".xml") ? new DirectoryService(url, true) : new DirectoryService(url, username, password, domainName, mgmtNode, rt);
        this.initFromConnection(this.m_dsService.getFileSystemService());
    }

    public ConfigurationDependencies(String url, String domainName, String username, String password, String mgmtNode) throws Exception {
        this(url, domainName, username, password, mgmtNode, 60);
    }

    public ConfigurationDependencies(UpgradeEnv env) {
        this.dsFileSystem = env.dsFileSystem;
        DEBUG = env.isDEBUG();
        this.m_utils = new Utils(env);
    }

    public ConfigurationDependencies(IDirectoryFileSystemService file) throws Exception {
        this.initFromConnection(file);
    }

    public void setDebug(boolean debug) {
        DEBUG = debug;
    }

    private IDirElement[] getFSElements(String fromType) throws DirectoryServiceException {
        if (!this.isEnterpriseEnabled()) {
            return this.retrieveFSElementsFromServer(fromType);
        }
        if (this.fsCache.containsKey(fromType)) {
            return this.fsCache.get(fromType);
        }
        IDirElement[] fsElements = this.retrieveFSElementsFromServer(fromType);
        this.fsCache.put(fromType, fsElements);
        return fsElements;
    }

    private boolean isEnterpriseEnabled() {
        return this.dsFileSystem instanceof DirectoryServiceProxy && ((DirectoryServiceProxy)this.dsFileSystem).isEnterpriseEnabled();
    }

    private IDirElement[] retrieveFSElementsFromServer(String fromType) throws DirectoryServiceException {
        Query typeQuery = new Query();
        typeQuery.setFrom(new FromElementType(fromType));
        return this.dsFileSystem.getFSElements(typeQuery, false);
    }

    private void initFromConnection(IDirectoryFileSystemService ds) throws Exception {
        this.dsFileSystem = ds;
        UpgradeEnv env = new UpgradeEnv(null);
        env.setDsFileSystem(ds);
        this.m_utils = new Utils(env);
    }

    public HashMap findConfigDependencies(String configName) throws Exception {
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.findConfigDependencies starting with configid " + configName);
        }
        IElementIdentity configID = null;
        try {
            configID = this.dsFileSystem.getFSIdentity(configName);
        }
        catch (DirectoryServiceException directoryServiceException) {
            // empty catch block
        }
        if (configID == null) {
            try {
                configID = this.dsFileSystem.getFSIdentity(configName + '/' + "_Default");
            }
            catch (DirectoryServiceException directoryServiceException) {
                // empty catch block
            }
        }
        if (configID == null) {
            throw new MigrationException(configName + " was not found in the Directory Service!");
        }
        String releaseVersion = configID.getReleaseVersion();
        if (releaseVersion.equals("109")) {
            this.m_allowUpgraded = true;
        }
        String type = configID.getType();
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.findConfigDependenices calling findConfigDependenciesInternal");
        }
        Vector configIDs = this.findConfigDependenciesInternal(configID.getName(), new Vector(), false, true);
        HashMap idsMap = new HashMap();
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.findConfigDependencies calling addContainerComponents");
        }
        this.addContainerComponents(idsMap, configIDs);
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.findConfigDependencies returning a map of " + idsMap.size() + " elements");
        }
        return idsMap;
    }

    public HashMap findAllContainers(String DMName) throws Exception {
        this.checkAllConfigVersions();
        HashMap ids = new HashMap();
        Vector dependencies = new Vector();
        iwUpgrade = true;
        this.addAllContainersToDependencies(new Vector(), dependencies);
        this.addSpecialMarker(this.dsFileSystem.getFSIdentity(DMName), "LOCAL");
        this.addContainerComponents(ids, dependencies);
        return ids;
    }

    private void addContainerComponents(HashMap dependenciesMap, Vector configIDs) {
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.addContainerComponents starting");
        }
        for (IElementIdentity id : configIDs) {
            if (DEBUG) {
                System.out.println("ConfigurationDependencies.addContainerComponents finding components for " + id.getName());
            }
            Vector components = (Vector)this.m_containerComponents.get(id);
            if (DEBUG && components != null) {
                System.out.println("ConfigurationDependencies.addContainerComponents found " + components.size() + " components for " + id.getName());
            }
            dependenciesMap.put(id, components);
        }
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.addContainerComponents exiting");
        }
    }

    Vector findNotificationDependencies(String configName, Vector knownAlready) throws Exception {
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.findNotificationDependencies " + configName);
        }
        knownAlready.remove(configName);
        Vector deps = this.findConfigDependenciesInternal(configName, knownAlready, true, false);
        knownAlready.add(configName);
        return deps;
    }

    void setWholeClusterUpgrade(boolean wholeClusterUpgrade) {
        wholeCluster = wholeClusterUpgrade;
    }

    /*
     * Unable to fully structure code
     */
    Vector findConfigDependenciesInternal(String configName, Vector knownAlready, boolean all, boolean onThisHost) throws Exception {
        if (ConfigurationDependencies.DEBUG) {
            System.out.println("ConfigurationDependencies.findConfigDependenciesInternal starting for configName " + configName);
        }
        copyKnown = new Vector<IElementIdentity>(knownAlready);
        dependencies = new Vector<E>();
        if (!copyKnown.contains(configName)) {
            if (ConfigurationDependencies.DEBUG) {
                System.out.println("ConfigurationDependencies.findConfigDependenciesInternal processing logical name " + configName);
            }
            el = this.dsFileSystem.getFSElement(configName, false);
            subDependencies = new Vector();
            copyKnown.add(el.getIdentity());
            if (!el.getIdentity().getType().equals("MQ_CLUSTER")) {
                this.addDependency(dependencies, el.getIdentity(), onThisHost);
            }
            if ((elType = el.getIdentity().getType()).equals("MQ_BROKER") || elType.equals("MQ_BACKUPBROKER")) {
                subDependencies = this.findBrokerDependencies(el, copyKnown, all, onThisHost);
            } else if (elType.equals("MF_CONTAINER")) {
                try {
                    subDependencies = this.findContainerDependencies(el, copyKnown, all, onThisHost);
                    if (!onThisHost) ** GOTO lbl42
                    this.addSpecialMarker(el.getIdentity(), "LOCAL");
                }
                catch (OSrvrXSrvrException oldStuff) {
                    return new Vector<E>();
                }
            } else if (elType.equals("MQ_CLUSTER")) {
                subDependencies = this.findClusterDependencies(el, copyKnown, all);
            } else if (elType.equals("MF_DIRECTORY_SERVICE")) {
                subDependencies = this.findDSDependencies(el, copyKnown, all, onThisHost);
            } else if (elType.equals("MF_ACTIVATION_DAEMON")) {
                subDependencies = this.findDaemonDependencies(el, copyKnown, all, onThisHost);
            } else if (elType.equals("MF_AGENT_MANAGER")) {
                subDependencies = this.findAgentManagerDependencies(el, copyKnown, all, onThisHost);
            } else if (elType.equals("XQ_CONTAINER")) {
                subDependencies = this.findXQContainerDependencies(el, copyKnown, all);
            } else if (elType.equals("MF_COLLECTION_MONITOR") || elType.equals("MF_LOGGER") || elType.equals("MF_BACKUP_DIRECTORY_SERVICE") || elType.equals("MF_BACKUP_AGENT_MANAGER") || elType.equals("MF_HOST_MANAGER")) {
                subDependencies = this.findComponentDependencies(el, copyKnown, all);
            }
lbl42:
            // 11 sources

            dependencies.addAll(subDependencies);
            copyKnown.addAll(subDependencies);
            if (el.getIdentity().getType().equals("MQ_CLUSTER")) {
                if (ConfigurationDependencies.DEBUG) {
                    System.out.println("ConfigurationDependencies.findConfigDependenciesInternal adding cluster");
                }
                this.addDependency(dependencies, el.getIdentity(), onThisHost);
            }
            if (el.isTemplate()) {
                subclasses = el.getSubclassedList();
                for (i = 0; i < subclasses.length; ++i) {
                    sub = subclasses[i];
                    subDependencies = this.findAndAddDependenciesInternal(copyKnown, sub, all, dependencies);
                }
                this.addSpecialMarker(el.getIdentity(), "TEMPLATE");
            }
            if (el.getSuperElementName() != null) {
                templateName = el.getSuperElementName();
                subDependencies = this.findAndAddDependenciesInternal(copyKnown, templateName, all, dependencies);
            }
        }
        if (ConfigurationDependencies.DEBUG) {
            System.out.println("ConfigurationDependencies.findConfigDependenciesInternal exiting");
        }
        return dependencies;
    }

    private Vector findAndAddDependenciesInternal(Vector copyKnown, String templateName, boolean all, Vector dependencies) throws Exception {
        Vector subDependencies = null;
        if (!copyKnown.contains(this.dsFileSystem.getFSIdentity(templateName))) {
            subDependencies = this.findConfigDependenciesInternal(templateName, copyKnown, all, false);
            dependencies.addAll(subDependencies);
            copyKnown.addAll(subDependencies);
        }
        return subDependencies;
    }

    private Vector findContainerDependencies(IDirElement container, Vector knownAlready, boolean all, boolean onThisHost) throws Exception {
        IDirElement[] daemons;
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.findContainerDependencies container " + container.getIdentity().getName() + " onThisHost == " + onThisHost);
        }
        Vector dependencies = new Vector();
        Vector<IElementIdentity> componentIDs = new Vector<IElementIdentity>();
        Vector copyKnown = new Vector(knownAlready);
        IAttributeSet components = (IAttributeSet)container.getAttributes().getAttribute("COMPONENTS");
        for (String key : components.getAttributes().keySet()) {
            IAttributeSet componentAttrs = (IAttributeSet)components.getAttribute(key);
            Reference compRef = (Reference)componentAttrs.getAttribute("CONFIG_REF");
            String compName = compRef.getElementName();
            IDirElement component = this.dsFileSystem.getFSElement(compName, false);
            IElementIdentity id = component.getIdentity();
            componentIDs.add(id);
            if (copyKnown.contains(id)) continue;
            Vector componentDependencies = this.findConfigDependenciesInternal(compName, copyKnown, all, onThisHost);
            dependencies.addAll(componentDependencies);
            copyKnown.addAll(componentDependencies);
        }
        Vector alreadySetVector = (Vector)this.m_containerComponents.get(container.getIdentity());
        if (alreadySetVector == null) {
            this.m_containerComponents.put(container.getIdentity(), componentIDs);
        } else {
            alreadySetVector.addAll(componentIDs);
        }
        try {
            daemons = this.getFSElements(MF_ACTIVATION_DAEMON_NAME);
        }
        catch (Exception e) {
            daemons = new IDirElement[]{};
        }
        for (int i = 0; i < daemons.length; ++i) {
            IDirElement daemon = daemons[i];
            IAttributeSet containers = (IAttributeSet)daemon.getAttributes().getAttribute("CONTAINERS");
            HashMap containersMap = containers.getAttributes();
            Collection containersCollection = containersMap.values();
            for (IAttributeSet containerSet : containersCollection) {
                Reference containerRef = (Reference)containerSet.getAttribute("CONTAINER_REF");
                String containerName = containerRef.getElementName();
                if (!containerName.equals(container.getIdentity().getName()) || copyKnown.contains(daemon.getIdentity())) continue;
                Vector daemonDependencies = this.findConfigDependenciesInternal(daemon.getIdentity().getName(), knownAlready, all, onThisHost);
                dependencies.addAll(daemonDependencies);
                copyKnown.addAll(daemonDependencies);
            }
        }
        return dependencies;
    }

    private Vector findComponentDependencies(IDirElement monitor, Vector knownAlready, boolean all) throws Exception {
        Vector dependencies = new Vector();
        Vector copyKnown = new Vector(knownAlready);
        this.findContainerForComponent(monitor.getIdentity().getName(), copyKnown, dependencies, all);
        return dependencies;
    }

    private Vector<?> findXQContainerDependencies(IDirElement esbContainer, Vector<?> knownAlready, boolean all) throws Exception {
        IDirectoryAdminService dsAdmin = (IDirectoryAdminService)((Object)this.dsFileSystem);
        String xqContainerName = esbContainer.getIdentity().getName();
        String storageXQName = this.dsFileSystem.logicalToStorage(xqContainerName);
        IDirElement xqContainer = dsAdmin.getElement(storageXQName, false);
        IAttributeSet servicesSet = (IAttributeSet)xqContainer.getAttributes().getAttribute("services");
        if (servicesSet != null) {
            this.checkOSrvrXSrvr(servicesSet, dsAdmin);
        }
        Vector dependencies = this.findComponentDependencies(esbContainer, knownAlready, all);
        return dependencies;
    }

    private Vector findBrokerDependencies(IDirElement broker, Vector knownAlready, boolean all, boolean onThisHost) throws Exception {
        Reference backupBrokerRef;
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.findBrokerDependencies " + broker.getIdentity().getName());
        }
        Vector dependencies = new Vector();
        Vector copyKnown = new Vector(knownAlready);
        IAttributeSet brokerReferences = (IAttributeSet)broker.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference clusterReference = (Reference)brokerReferences.getAttribute("CLUSTER_CONFIG_ELEMENT_REF");
        if (clusterReference != null) {
            if (DEBUG) {
                System.out.println("ConfigurationDependencies.findBrokerDependencies " + broker.getIdentity().getName() + " found cluster reference ");
            }
            String clusterName = clusterReference.getElementName();
            if (!copyKnown.contains(clusterReference)) {
                Vector clusterDependencies = this.findConfigDependenciesInternal(clusterName, copyKnown, all, false);
                dependencies.addAll(clusterDependencies);
                copyKnown.addAll(clusterDependencies);
            }
        }
        if ((backupBrokerRef = (Reference)brokerReferences.getAttribute("BACKUP_CONFIG_ELEMENT_REF")) != null) {
            if (DEBUG) {
                System.out.println("ConfigurationDependencies.findBrokerDependencies " + broker.getIdentity().getName() + " found backup broker reference ");
            }
            this.populateDependencies(backupBrokerRef, copyKnown, all, onThisHost, dependencies);
        } else if (DEBUG) {
            System.out.println("ConfigurationDependencies.findBrokerDependencies " + broker.getIdentity().getName() + " did not find backup broker reference ");
        }
        Reference primaryBrokerRef = (Reference)brokerReferences.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
        if (primaryBrokerRef != null) {
            if (DEBUG) {
                System.out.println("ConfigurationDependencies.findBrokerDependencies " + broker.getIdentity().getName() + " found primary broker reference ");
            }
            this.populateDependencies(primaryBrokerRef, copyKnown, all, onThisHost, dependencies);
        } else if (DEBUG) {
            System.out.println("ConfigurationDependencies.findBrokerDependencies " + broker.getIdentity().getName() + " did not find primary broker reference ");
        }
        this.findContainerForComponent(broker.getIdentity().getName(), copyKnown, dependencies, all);
        return dependencies;
    }

    private void populateDependencies(Reference primaryBrokerRef, Vector copyKnown, boolean all, boolean onThisHost, Vector dependencies) throws Exception {
        String primaryName = primaryBrokerRef.getElementName();
        if (!copyKnown.contains(this.dsFileSystem.getFSIdentity(primaryName))) {
            Vector primaryDependencies = this.findConfigDependenciesInternal(primaryName, copyKnown, all, !onThisHost);
            dependencies.addAll(primaryDependencies);
            copyKnown.addAll(primaryDependencies);
        }
    }

    private void addAllContainersToDependencies(Vector knownAlready, Vector dependencies) throws Exception {
        IDirElement[] fsContainers = this.retrieveContainers();
        int containerCount = fsContainers.length;
        for (int i = 0; i < containerCount; ++i) {
            IDirElement container = null;
            IElementIdentity containerID = null;
            container = fsContainers[i];
            containerID = container.getIdentity();
            if (!knownAlready.contains(containerID)) {
                knownAlready.add(containerID);
                this.addDependency(dependencies, containerID, true);
            }
            Vector subDependencies = null;
            try {
                subDependencies = this.findContainerDependencies(container, knownAlready, true, true);
                knownAlready.addAll(subDependencies);
                dependencies.addAll(subDependencies);
                continue;
            }
            catch (OSrvrXSrvrException oldStuff) {
                dependencies.remove(containerID);
            }
        }
    }

    private ArrayList findContainerForComponent(String componentName, Vector copyKnown, Vector dependencies, boolean all) throws Exception {
        ArrayList<IElementIdentity> inContainers = new ArrayList<IElementIdentity>();
        IDirElement[] fsContainers = this.retrieveContainers();
        for (int i = 0; i < fsContainers.length; ++i) {
            IDirElement container = null;
            String containerName = null;
            container = fsContainers[i];
            containerName = container.getIdentity().getName();
            IAttributeSet components = (IAttributeSet)container.getAttributes().getAttribute("COMPONENTS");
            IAttributeSet componentSet = this.findComponent(components, componentName);
            if (DEBUG && componentSet != null && copyKnown.contains(container.getIdentity())) {
                System.out.println("ConfigurationDependencies.findContainerForComponent " + componentName + " not adding " + containerName + " because it is in copyKnown already");
            }
            if (componentSet == null) continue;
            inContainers.add(container.getIdentity());
            if (copyKnown.contains(container.getIdentity())) continue;
            Vector containerDependencies = this.findConfigDependenciesInternal(containerName, copyKnown, all, false);
            dependencies.addAll(containerDependencies);
            copyKnown.addAll(containerDependencies);
        }
        return inContainers;
    }

    private IDirElement[] retrieveContainers() throws Exception {
        IDirElement[] fsContainers = this.getFSElements(MF_CONTAINER_NAME);
        if (fsContainers == null) {
            throw new Exception("Could not find any containers in the DS!");
        }
        return fsContainers;
    }

    private IAttributeSet findComponent(IAttributeSet componentsSet, String idToFind) {
        HashMap setMap = componentsSet.getAttributes();
        Collection mapValues = setMap.values();
        for (IAttributeSet componentSet : mapValues) {
            Reference compReference = (Reference)componentSet.getAttribute("CONFIG_REF");
            if (compReference.getElementName().compareTo(idToFind) != 0) continue;
            return componentSet;
        }
        return null;
    }

    private Vector findClusterDependencies(IDirElement cluster, Vector knownAlready, boolean all) throws Exception {
        Vector copyKnown = new Vector(knownAlready);
        Vector dependencies = new Vector();
        if (DEBUG) {
            System.out.println("Entering ConfigurationDependencies.findClusterDependencies");
        }
        if (all) {
            Object brokers = cluster.getAttributes().getAttribute("CLUSTER_MEMBERS");
            IAttributeSet brokersSet = (IAttributeSet)brokers;
            HashMap attributes = brokersSet.getAttributes();
            Collection brokerRefs = attributes.values();
            for (Reference broker : brokerRefs) {
                String brokerName = broker.getElementName();
                if (copyKnown.contains(this.dsFileSystem.getFSIdentity(brokerName))) continue;
                Vector brokerDependencies = this.findConfigDependenciesInternal(brokerName, copyKnown, true, false);
                dependencies.addAll(brokerDependencies);
                copyKnown.addAll(brokerDependencies);
            }
        }
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.findClusterDependencies returning vector of size " + dependencies.size());
        }
        return dependencies;
    }

    private Vector findAgentManagerDependencies(IDirElement AM, Vector knownAlready, boolean all, boolean onThisHost) throws Exception {
        Vector copyKnown = new Vector(knownAlready);
        Vector dependencies = new Vector();
        this.findContainerForComponent(AM.getIdentity().getName(), copyKnown, dependencies, all);
        return dependencies;
    }

    private Vector findDSDependencies(IDirElement DS, Vector knownAlready, boolean all, boolean onThisHost) throws Exception {
        Vector copyKnown = new Vector(knownAlready);
        Vector dependencies = new Vector();
        this.findContainerForComponent(DS.getIdentity().getName(), copyKnown, dependencies, all);
        IAttributeSet topSet = DS.getAttributes();
        String ftRole = (String)topSet.getAttribute("FAULT_TOLERANCE_ROLE");
        if (ftRole == null || ftRole.equals("PRIMARY")) {
            this.checkAllConfigVersions();
            IDirElement[] domains = this.getFSElements(MF_AUTHENTICATION_DOMAIN_NAME);
            this.addDependencyCopyKnownIdentity(domains, copyKnown, dependencies);
            IDirElement[] policies = this.getFSElements(MQ_AUTHORIZATION_POLICY_NAME);
            this.addDependencyCopyKnownIdentity(policies, copyKnown, dependencies);
            IDirElement[] stores = null;
            try {
                stores = this.getFSElements(MQ_CERTIFICATES_STORE_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stores != null) {
                this.addDependencyCopyKnownIdentity(stores, copyKnown, dependencies);
            }
            IDirElement[] protocols = null;
            try {
                protocols = this.getFSElements(MQ_WS_PROTOCOL_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (protocols != null) {
                this.addDependencyCopyKnownIdentity(protocols, copyKnown, dependencies);
            }
            IDirElement[] compCols = this.getFSElements(MF_COMPONENT_COLLECTION_NAME);
            this.addDependencyCopyKnownIdentity(compCols, copyKnown, dependencies);
            IDirElement[] containerCols = this.getFSElements(MF_CONTAINER_COLLECTION_NAME);
            this.addDependencyCopyKnownIdentity(containerCols, copyKnown, dependencies);
            this.findTypeAndDependencies("MF_AGENT_MANAGER", dependencies, copyKnown, all, !onThisHost);
            this.findTypeAndDependencies("MF_DIRECTORY_SERVICE", dependencies, copyKnown, all, !onThisHost);
            this.findTypeAndDependencies("MF_BACKUP_DIRECTORY_SERVICE", dependencies, copyKnown, all, !onThisHost);
            this.findTypeAndDependencies("MF_BACKUP_AGENT_MANAGER", dependencies, copyKnown, all, !onThisHost);
            if (iwUpgrade) {
                this.addAllContainersToDependencies(copyKnown, dependencies);
            }
        }
        return dependencies;
    }

    private void addDependencyCopyKnownIdentity(IDirElement[] stores, Vector copyKnown, Vector dependencies) throws Exception {
        for (int i = 0; i < stores.length; ++i) {
            this.addDependencyCopyKnownIdentity(copyKnown, stores, i, dependencies);
        }
    }

    private void addDependencyCopyKnownIdentity(Vector copyKnown, IDirElement[] containerCols, int i, Vector dependencies) throws Exception {
        if (!copyKnown.contains(containerCols[i].getIdentity())) {
            this.addDependency(dependencies, containerCols[i].getIdentity(), false);
            copyKnown.add(containerCols[i].getIdentity());
        }
    }

    private void findTypeAndDependencies(String type, Vector dependencies, Vector copyKnown, boolean all, boolean onThisHost) throws Exception {
        IDirElement[] ams = this.getFSElements(type);
        for (int i = 0; i < ams.length; ++i) {
            String name = ams[i].getIdentity().getName();
            if (copyKnown.contains(ams[i].getIdentity())) continue;
            Vector elDependencies = this.findConfigDependenciesInternal(name, copyKnown, all, onThisHost);
            dependencies.addAll(elDependencies);
            copyKnown.addAll(elDependencies);
        }
    }

    Vector findDaemonDependencies(IDirElement daemon, Vector knownAlready, boolean all, boolean onThisHost) throws Exception {
        if (DEBUG) {
            System.out.println("ConfigurationDependencies.findDaemonDependencies starting " + daemon.getIdentity().getName());
        }
        ArrayList<IElementIdentity> startsContainers = new ArrayList<IElementIdentity>();
        Vector dependencies = new Vector();
        Vector copyKnown = new Vector(knownAlready);
        ArrayList inContainers = this.findContainerForComponent(daemon.getIdentity().getName(), copyKnown, dependencies, all);
        if (dependencies.isEmpty()) {
            if (DEBUG) {
                int i;
                System.out.println("ConfigurationDependencies.findDaemonDependencies found no dependencies for " + daemon.getIdentity().getName());
                System.out.println("ConfigurationDependencies.findDaemonDependencies printing inContainers");
                for (i = 0; i < inContainers.size(); ++i) {
                    System.out.print(" " + ((IElementIdentity)inContainers.get(i)).getName());
                }
                System.out.println();
                System.out.println("ConfigurationDependencies.findDaemonDependencies printing copyKnown");
                for (i = 0; i < copyKnown.size(); ++i) {
                    System.out.print(" " + ((IElementIdentity)copyKnown.get(i)).getName());
                }
                System.out.println();
            }
            if (!inContainers.isEmpty()) {
                boolean known = false;
                for (IElementIdentity id : inContainers) {
                    if (!copyKnown.contains(id)) continue;
                    known = true;
                }
                if (!known) {
                    return dependencies;
                }
            }
        }
        IAttributeSet containers = (IAttributeSet)daemon.getAttributes().getAttribute("CONTAINERS");
        HashMap containersMap = containers.getAttributes();
        Collection containersCollection = containersMap.values();
        for (IAttributeSet containerSet : containersCollection) {
            Reference containerRef = (Reference)containerSet.getAttribute("CONTAINER_REF");
            String containerName = containerRef.getElementName();
            IElementIdentity childID = this.dsFileSystem.getFSIdentity(containerName);
            if (DEBUG) {
                System.out.println("ConfigurationDependencies.findDaemonDependencies adding " + childID + " to startsContainers list");
            }
            startsContainers.add(childID);
            if (copyKnown.contains(childID)) continue;
            Vector containerDependencies = this.findConfigDependenciesInternal(containerName, copyKnown, all, onThisHost);
            copyKnown.addAll(containerDependencies);
            dependencies.addAll(containerDependencies);
        }
        for (IElementIdentity childContainer : startsContainers) {
            if (DEBUG) {
                System.out.println("ConfigurationDependencies.findDaemonDependencies setting " + childContainer.getName() + " to NOTROOT");
            }
            this.addSpecialMarker(childContainer, "NOTROOT");
            if (!onThisHost) continue;
            this.addSpecialMarker(childContainer, "LOCAL");
        }
        return dependencies;
    }

    private void addSpecialMarker(IElementIdentity container, String specialChildName) {
        Vector<String> alreadySet;
        if (DEBUG) {
            System.out.println("ConfigurationDependencies adding " + specialChildName + " to " + container.getName());
        }
        if ((alreadySet = (Vector<String>)this.m_containerComponents.get(container)) != null) {
            if (!alreadySet.contains(specialChildName)) {
                alreadySet.add(specialChildName);
            }
        } else {
            alreadySet = new Vector<String>();
            alreadySet.add(specialChildName);
            this.m_containerComponents.put(container, alreadySet);
        }
    }

    private void addDependency(Vector dependencies, IElementIdentity id, boolean onThisHost) throws Exception {
        boolean okToAddESBContainer;
        String releaseVersion = id.getReleaseVersion();
        int versionInt = 0;
        try {
            versionInt = new Integer(releaseVersion);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean allowIt = releaseVersion.equals("109") && this.m_allowUpgraded && onThisHost;
        boolean bl = okToAddESBContainer = id.getType().equals("XQ_CONTAINER") && !this.isESBContainerUpgraded(id);
        if (allowIt || SUPPORTED_PRODUCT_VERSIONS.containsValue(releaseVersion) || okToAddESBContainer) {
            if (DEBUG) {
                System.out.println("ConfigurationDependencies.addDependency adding " + id.getName());
            }
            dependencies.add(id);
        }
    }

    private boolean isESBContainerUpgraded(IElementIdentity id) throws Exception {
        return this.m_utils.getProductVersion(id.getName()).equals("14.0");
    }

    private void checkAllConfigVersions() throws Exception {
        this.retrieveDirElementsAndValidateVersion(MF_CONTAINER_NAME);
        ArrayList allTypes = new ArrayList();
        allTypes.addAll(ConfigUpgrade.MF_TYPES);
        allTypes.remove("MF_HOST_MANAGER");
        allTypes.addAll(ConfigUpgrade.MQ_TYPES);
        for (String type : allTypes) {
            if (type.equals(MF_CONTAINER_NAME)) continue;
            this.retrieveDirElementsAndValidateVersion(type);
        }
    }

    private void retrieveDirElementsAndValidateVersion(String type) throws MigrationException, DirectoryServiceException {
        IDirElement[] els;
        for (IDirElement el : els = this.getFSElements(type)) {
            IElementIdentity id = null;
            id = el.getIdentity();
            if (id.getReleaseVersion().compareTo("107") >= 0) continue;
            throw new MigrationException("Cannot perform upgrade - found configurations of unsupported versions: " + id.getName() + " of version " + id.getReleaseVersion());
        }
    }

    private void checkOSrvrXSrvr(IAttributeSet services, IDirectoryAdminService dsAdmin) throws DirectoryServiceException, OSrvrXSrvrException {
        HashMap servicesMap = services.getAttributes();
        Collection servicesMaps = servicesMap.values();
        for (IAttributeSet serviceSet : servicesMaps) {
            String serviceType;
            String serviceName = (String)serviceSet.getAttribute("service_ref");
            IDirElement serviceEl = dsAdmin.getElement("/xqServices/" + serviceName, false);
            if (serviceEl == null || !(serviceType = (String)serviceEl.getAttributes().getAttribute("type_ref")).equals("XMLServiceType") && !serviceType.equals("OrchestrationServiceType") && !serviceType.equals("BPELServiceType")) continue;
            throw new OSrvrXSrvrException();
        }
    }
}

