/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.comm.ConnectTimeoutException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.MFSecurityException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.upgrade.ConfigurationDependencies;
import com.sonicsw.mf.common.config.upgrade.DirectoryService;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.MigrationException;
import com.sonicsw.mf.common.config.upgrade.Utils;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.agent.ContainerSetup;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.JMRuntimeException;

public class FindDependencies
implements IMigrationProcess {
    private String m_outFile = "." + System.getProperty("file.separator") + "upgrade.properties";
    private static String UPGRADEPROPS_ERROR = "upgradeProps error";
    private FileOutputStream m_outStream = null;
    private String m_url = null;
    private String m_username = null;
    private String m_password = null;
    private String m_node = null;
    private String m_domain = "Domain1";
    private static final String SONIC_HOME = System.getProperty("sonic.home");
    private boolean m_WBInstalled = false;
    private int m_requestTimeout = 60;
    private Vector m_rootIDs = null;
    private Vector m_upgradeIDs = null;
    private Vector m_onThisHost = null;
    private Vector m_templateList = null;
    private ConfigurationDependencies m_depends = null;
    private IDirectoryFileSystemService m_ds;
    private HashMap m_dependsMap = new HashMap();

    private void printUsage(String errorMessage) {
        if (errorMessage != null) {
            System.out.println();
            System.out.println("  error: " + errorMessage);
            System.out.println();
        }
        System.out.println();
        System.out.println("*****************************  upgradeProps usage ************************");
        System.out.println();
        System.out.println("Arguments to upgradeProps:");
        System.out.println();
        System.out.println("upgradeProps -url <connection url> -u <mgmt user> [-p <mgmt password>] -d <domain name> [-rt <request timeout>] <container name>");
        System.out.println();
        System.out.println("where:");
        System.out.println();
        System.out.println("<connection URL> is the url for a management connection, for instance, pcwork:2506");
        System.out.println("<mgmt user> is the user with Administrator privileges for the mgmt connection, for instance, Administrator");
        System.out.println("<mgmt password> is the password, if required, for the mgmt connection");
        System.out.println("<domain name> is the name of the Sonic domain, for instance, Domain1");
        System.out.println("<request timeout> is the maximum amount of time that upgradeProps will wait when invoking methods of the directory service. It defaults to 60");
        System.out.println("<container name> is the name of the container configuration to be upgraded, for instance, /Containers/DomainManager");
        System.out.println();
        System.out.println("<connection URL>, <mgmt user>, <domain name> and <container name> are required arguments; <mgmt password> is required only if the mgmt broker has security enabled");
        System.out.println();
        System.out.println("**************************************************************************");
        System.exit(0);
    }

    public static void main(String[] args) {
        FindDependencies fd = new FindDependencies();
        fd.parseParams(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseParams(String[] args) {
        String configName = null;
        String rt = null;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            String arg = args[argIndex];
            if ("-url".equalsIgnoreCase(arg)) {
                this.m_url = args[++argIndex];
                continue;
            }
            if ("-u".equalsIgnoreCase(arg)) {
                this.m_username = args[++argIndex];
                continue;
            }
            if ("-p".equalsIgnoreCase(arg)) {
                this.m_password = args[++argIndex];
                continue;
            }
            if ("-d".equalsIgnoreCase(arg)) {
                this.m_domain = args[++argIndex];
                continue;
            }
            if ("-n".equalsIgnoreCase(arg)) {
                this.m_node = args[++argIndex];
                continue;
            }
            if ("-f".equalsIgnoreCase(arg)) {
                this.m_outFile = args[++argIndex];
                continue;
            }
            if ("-rt".equalsIgnoreCase(arg)) {
                rt = args[++argIndex];
                continue;
            }
            if (arg.toLowerCase().startsWith("-h")) {
                this.printUsage(null);
                continue;
            }
            configName = arg;
        }
        if (this.m_url == null) {
            this.printUsage("upgradeProps requires a connection url.");
        }
        if (this.m_username == null) {
            this.printUsage("upgradeProps requires a user name for the mgmt connection.");
        }
        if (this.m_domain == null) {
            this.printUsage("upgradeProps requires a domain name.");
        }
        if (configName == null) {
            this.printUsage("You must provide a container configuration name to upgradeProps.");
        }
        if (rt != null) {
            try {
                this.m_requestTimeout = new Integer(rt);
            }
            catch (NumberFormatException noNum) {
                this.printUsage("Request timeout specified is not a number: " + rt);
            }
        }
        try {
            File propFile = new File(SONIC_HOME, "sonicsw.properties");
            if (propFile.exists()) {
                FileInputStream propsIn = new FileInputStream(propFile);
                Properties installProps = new Properties();
                installProps.load(propsIn);
                propsIn.close();
                String wbInstalled = installProps.getProperty("sonic.wb.installed");
                this.m_WBInstalled = wbInstalled != null && wbInstalled.equals("true");
            }
            Vector configIDs = this.findDependencies(this.m_url, this.m_domain, this.m_username, this.m_password, this.m_node, configName);
            this.writeProperties(configIDs, configName);
        }
        catch (MigrationException migE) {
            Utils.printError(UPGRADEPROPS_ERROR, null, migE.getMessage());
        }
        catch (ProxyRuntimeException proxyE) {
            Throwable cause = proxyE.getCause();
            if (cause != null && cause instanceof InvokeTimeoutException) {
                Utils.printError(UPGRADEPROPS_ERROR, null, "upgradeProps had a problem communicating with the domain manager. You might want to increase the request timeout parameter -rt <requestTimeout>. The default is 60 seconds.");
            } else {
                Utils.printError(UPGRADEPROPS_ERROR, proxyE, null);
            }
        }
        catch (JMRuntimeException jmsE) {
            Throwable cause = jmsE.getCause();
            if (cause != null && cause instanceof ConnectTimeoutException) {
                Utils.printError(UPGRADEPROPS_ERROR, null, "upgradeProps had a problem connecting to the domain manager. Check that your connection information is correct, and make sure that your domain manager is running.");
            } else if (cause != null && cause instanceof MFSecurityException) {
                Utils.printError(UPGRADEPROPS_ERROR, null, "The connection attempt threw a security exception. Check that the specified username and password are correct.");
            } else {
                Utils.printError(UPGRADEPROPS_ERROR, jmsE, null);
            }
        }
        catch (Exception e) {
            Utils.printError(UPGRADEPROPS_ERROR, e, null);
        }
        finally {
            try {
                this.closeConnection();
            }
            catch (Exception e) {
                Utils.printError(UPGRADEPROPS_ERROR, e, "Could not close the connection to the domain");
            }
            System.exit(0);
        }
    }

    public Vector findDependencies(String url, String domainName, String username, String password, String mgmtNode, String containerID) throws Exception {
        System.out.println("upgradeProps connecting to the Directory Service...");
        this.m_depends = new ConfigurationDependencies(url, domainName, username, password, mgmtNode, this.m_requestTimeout);
        System.out.println("upgradeProps connecting to the Directory Service...done");
        this.m_ds = this.m_depends.getDS();
        if (url.toLowerCase().endsWith("xml")) {
            IAttributeSet xmlSet = DirectoryService.getDSAttributes(url);
            if (this.m_domain == null) {
                this.m_domain = (String)xmlSet.getAttribute("DOMAIN_NAME");
            }
        }
        System.out.println("upgradeProps finding upgrade dependencies...");
        this.m_dependsMap = this.internalFindDependencies(containerID);
        System.out.println("upgradeProps finding upgrade dependencies...done");
        Set keySet = this.m_dependsMap.keySet();
        return new Vector(keySet);
    }

    private HashMap internalFindDependencies(String containerID) throws Exception {
        if (this.m_WBInstalled) {
            return this.m_depends.findAllContainers(containerID);
        }
        return this.m_depends.findConfigDependencies(containerID);
    }

    private void closeConnection() throws Exception {
        if (this.m_depends != null) {
            this.m_depends.closeDS();
        }
        if (this.m_url != null && this.m_url.toLowerCase().endsWith("xml")) {
            File tempStorage = new File(SONIC_HOME, "MigrationTemp");
            Utils.recursiveDeleteDirectory(tempStorage);
        }
    }

    private void writeProperties(Vector configIDs, String configID) throws IOException, DirectoryServiceException {
        try {
            this.m_outStream = new FileOutputStream(this.m_outFile);
        }
        catch (FileNotFoundException notFound) {
            notFound.printStackTrace();
            System.exit(0);
        }
        System.out.println("upgradeProps writing out properties file " + new File(this.m_outFile).getCanonicalPath() + "...");
        this.m_rootIDs = new Vector();
        this.m_upgradeIDs = new Vector();
        this.m_onThisHost = new Vector();
        this.m_templateList = new Vector();
        this.writeDebugFlag();
        this.writeConnectionProperties();
        this.writeControlCodes();
        this.writeUpgradeList(configIDs, configID);
        this.writeContainerProperties();
        this.m_outStream.close();
        System.out.println("upgradeProps writing out properties file " + new File(this.m_outFile).getCanonicalPath() + "...done");
    }

    private void writeDebugFlag() throws IOException {
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("!***************  debug flag - set to true to enable debugging output ".getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("migrate.debug=false".getBytes());
        this.m_outStream.write(NEWLINEBYTES);
    }

    private void writeConnectionProperties() throws IOException {
        String urlConverted = this.m_url;
        boolean xmlURL = urlConverted.toLowerCase().endsWith("xml");
        if (xmlURL) {
            urlConverted = Utils.replaceBackSlashes(urlConverted);
        }
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("!***************  Tool connection properties".getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(("ds.url=" + urlConverted).getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(("ds.username=" + (this.m_username == null ? "Administrator" : this.m_username)).getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(("ds.password=" + (this.m_password == null ? "" : this.m_password)).getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(("ds.domain=" + (this.m_domain == null ? "Domain1" : this.m_domain)).getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(("connection_node=" + (this.m_node == null ? "" : this.m_node)).getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(("request.timeout=" + this.m_requestTimeout).getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("connection.system.properties=".getBytes());
        this.m_outStream.write(NEWLINEBYTES);
    }

    private void writeControlCodes() throws IOException {
        File mqHome = new File(SONIC_HOME + FILESEPARATOR + "MQ" + "14.0");
        String mqControlCode = null;
        if (mqHome.exists()) {
            mqControlCode = this.writePropertyRetrieveControlCode(mqHome, mqControlCode, "sonic.mq.controlNumber");
        }
        File esbHome = new File(SONIC_HOME + FILESEPARATOR + "ESB" + "14.0");
        String esbControlCode = null;
        if (esbHome.exists()) {
            esbControlCode = this.writePropertyRetrieveControlCode(esbHome, esbControlCode, "sonic.esb.controlNumber");
        }
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("!***************    Control Numbers ".getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(("sonic.mq.controlNumber=" + (mqControlCode == null ? "" : mqControlCode)).getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(("sonic.esb.controlNumber=" + (esbControlCode == null ? "" : esbControlCode)).getBytes());
        this.m_outStream.write(NEWLINEBYTES);
    }

    private String writePropertyRetrieveControlCode(File esbHome, String esbControlCodeParam, String ESBCNPROP) throws IOException {
        String esbControlCode = esbControlCodeParam;
        File esbPropsFile = new File(esbHome, "product.properties");
        if (esbPropsFile.exists()) {
            FileInputStream esbPropsStream = new FileInputStream(esbPropsFile);
            Properties esbProps = new Properties();
            esbProps.load(esbPropsStream);
            esbPropsStream.close();
            esbControlCode = esbProps.getProperty(ESBCNPROP);
        }
        return esbControlCode;
    }

    private void writeUpgradeList(Vector configIDs, String configID) throws IOException {
        if (!configIDs.isEmpty()) {
            for (IElementIdentity id : configIDs) {
                if (id.getType().equals("MF_CONTAINER")) {
                    boolean isRoot = true;
                    boolean onThisHost = false;
                    Vector components = (Vector)this.m_dependsMap.get(id);
                    if (components == null) continue;
                    if (!(id.getName().equals(configID) || !components.contains("NOTROOT") && components.contains("LOCAL"))) {
                        isRoot = false;
                    }
                    if (components.contains("LOCAL")) {
                        onThisHost = true;
                    }
                    if (isRoot) {
                        this.m_rootIDs.add(id);
                    } else {
                        this.m_upgradeIDs.add(id);
                    }
                    if (!onThisHost) continue;
                    this.m_onThisHost.add(id);
                    continue;
                }
                if (!this.isATemplate(id)) continue;
                this.m_templateList.add(id);
            }
        }
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("!***************  Root container configurations".getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("root.list=".getBytes());
        Iterator idsIterator = this.m_rootIDs.iterator();
        while (idsIterator.hasNext()) {
            this.writeContainerId(idsIterator);
        }
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("!***************  Configurations to be upgraded ".getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("upgrade.list=".getBytes());
        idsIterator = this.m_upgradeIDs.iterator();
        while (idsIterator.hasNext()) {
            this.writeContainerId(idsIterator);
        }
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("!***************  Template list ".getBytes());
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("template.list=".getBytes());
        idsIterator = this.m_templateList.iterator();
        while (idsIterator.hasNext()) {
            this.writeContainerId(idsIterator);
        }
        this.m_outStream.write(NEWLINEBYTES);
    }

    private void writeContainerId(Iterator idsIterator) throws IOException {
        IElementIdentity elId = (IElementIdentity)idsIterator.next();
        this.m_outStream.write(elId.getName().getBytes());
        if (idsIterator.hasNext()) {
            this.m_outStream.write(",".getBytes());
        }
    }

    private void writeContainerProperties() throws IOException, DirectoryServiceException {
        Vector allConfigs = new Vector();
        allConfigs.addAll(this.m_rootIDs);
        allConfigs.addAll(this.m_upgradeIDs);
        for (IElementIdentity containerId : allConfigs) {
            boolean hasPrimaryDS;
            String containerName = containerId.getNameComponents()[containerId.getNameComponents().length - 1];
            String containerNameEscaped = containerName.replaceAll(" ", "\\\\ ");
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write(("!***************  Properties for container " + containerId.getName()).getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.writeSlashWarning();
            boolean bl = hasPrimaryDS = this.hasPrimaryDS(containerId) != null;
            if (containerId.getReleaseVersion().compareTo("107") >= 0 && !containerId.getReleaseVersion().equals("109") && !hasPrimaryDS) continue;
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "previous.working.directory" + "=").getBytes());
            if (hasPrimaryDS && containerId.getReleaseVersion().compareTo("107") >= 0) {
                String m_sonicHomeEscaped = SONIC_HOME.replaceAll("\\\\", "/");
                m_sonicHomeEscaped = m_sonicHomeEscaped.replaceAll(" ", "\\\\ ");
                this.m_outStream.write((m_sonicHomeEscaped + "/Containers/" + this.m_domain + "." + containerName).getBytes());
            }
            this.m_outStream.write(NEWLINEBYTES);
            if (containerId.getReleaseVersion().compareTo("107") >= 0 && !containerId.getReleaseVersion().equals("109")) continue;
            String containerLogDir = this.m_domain + "." + containerName + ".log";
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "boot.file.password" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "central.connection.url" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "central.connection.username" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "central.connection.password" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "central.connection.request.timeout" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "central.connection.connect.timeout" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "central.connection.socket.connect" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "central.connection.load.balancing" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "central.connection.system.properties" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            File containersDir = ContainerSetup.findSonicContainersDir((File)new File(SONIC_HOME));
            File thisContainerDir = ContainerSetup.findContainerDir((File)containersDir, (String)this.m_domain, (String)containerName);
            String containerDirAbsolute = ".";
            if (this.m_onThisHost.contains(containerId)) {
                containerDirAbsolute = thisContainerDir.getCanonicalPath();
                containerDirAbsolute = Utils.replaceBackSlashes(containerDirAbsolute);
            }
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "cache.dir" + "=./container.cache").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write(NEWLINEBYTES);
            this.m_outStream.write((containerNameEscaped + "." + "log.dir" + "=./" + containerLogDir).getBytes());
            this.m_outStream.write(NEWLINEBYTES);
            if (this.hasDS(containerId) != null) {
                this.m_outStream.write(NEWLINEBYTES);
                this.m_outStream.write((containerNameEscaped + "." + "host.directory" + "=.").getBytes());
                this.m_outStream.write(NEWLINEBYTES);
            }
            IDirElement brokerEl = null;
            brokerEl = this.hasBroker(containerId);
            if (brokerEl != null) {
                String sslCertChain;
                int backslashPos;
                int slashPos;
                this.m_outStream.write(NEWLINEBYTES);
                this.m_outStream.write("!If you use db.action=LEAVE, the mqstore.db.connect and recovery.log.file properties will be ignored".getBytes());
                this.m_outStream.write(NEWLINEBYTES);
                boolean local = this.m_onThisHost.contains(containerId);
                this.writeExclamation(local);
                this.m_outStream.write((containerNameEscaped + "." + "db.action" + "=COPY").getBytes());
                this.m_outStream.write(NEWLINEBYTES);
                IAttributeSet brokerSet = brokerEl.getAttributes();
                IAttributeSet dbParams = (IAttributeSet)brokerSet.getAttribute("BROKER_DATABASE_PARAMETERS");
                IAttributeSet logParams = (IAttributeSet)brokerSet.getAttribute("BROKER_RECOVERY_LOG_PARAMETERS");
                IAttributeSet sslParams = (IAttributeSet)brokerSet.getAttribute("BROKER_SSL_PARAMETERS");
                String mqStoreValue = (String)dbParams.getAttribute("MQSTORE_DB_CONNECT");
                if (mqStoreValue == null) {
                    mqStoreValue = "./SonicMQStore";
                }
                String DBName = (slashPos = mqStoreValue.lastIndexOf("/")) > (backslashPos = mqStoreValue.lastIndexOf("\\")) ? mqStoreValue.substring(slashPos + 1) : mqStoreValue.substring(backslashPos + 1);
                String newDBConnect = "./" + DBName;
                this.m_outStream.write(NEWLINEBYTES);
                if (!local) {
                    this.m_outStream.write("!".getBytes());
                }
                this.m_outStream.write((containerNameEscaped + "." + "mqstore.db.connect" + "=" + newDBConnect).getBytes());
                this.m_outStream.write(NEWLINEBYTES);
                String logLocation = (String)logParams.getAttribute("RECOVERY_LOG_PATH");
                if (logLocation == null) {
                    logLocation = "./log";
                }
                String logDir = (slashPos = logLocation.lastIndexOf("/")) > (backslashPos = logLocation.lastIndexOf("\\")) ? logLocation.substring(slashPos + 1) : logLocation.substring(backslashPos + 1);
                String newLogLocation = "./" + logDir;
                this.m_outStream.write(NEWLINEBYTES);
                if (!local) {
                    this.m_outStream.write("!".getBytes());
                }
                this.m_outStream.write((containerNameEscaped + "." + "recovery.log.file" + "=" + newLogLocation).getBytes());
                this.m_outStream.write(NEWLINEBYTES);
                String sslCertDir = (String)sslParams.getAttribute("SSL_CA_CERTIFICATES_DIR");
                if (sslCertDir != null && sslCertDir.length() != 0) {
                    this.writeData(local, containerNameEscaped, "ssl.certificates.dir", sslCertDir);
                }
                if ((sslCertChain = (String)sslParams.getAttribute("SSL_CERTIFICATE_CHAIN")) != null && sslCertChain.length() != 0) {
                    this.writeData(local, containerNameEscaped, "ssl.certificate.chain", sslCertChain);
                }
            }
            this.m_outStream.write((containerNameEscaped + "." + "windows.service.name" + "=").getBytes());
            this.m_outStream.write(NEWLINEBYTES);
        }
    }

    private void writeData(boolean local, String containerNameEscaped, String SSLCERTCHAINPROP, String sslCertChain) throws IOException {
        this.writeExclamation(local);
        this.m_outStream.write((containerNameEscaped + "." + SSLCERTCHAINPROP + "=" + Utils.replaceBackSlashes(sslCertChain)).getBytes());
        this.m_outStream.write(NEWLINEBYTES);
    }

    private void writeExclamation(boolean local) throws IOException {
        if (!local) {
            this.m_outStream.write("!".getBytes());
        }
    }

    private IDirElement hasBroker(IElementIdentity containerID) throws DirectoryServiceException {
        Vector components = (Vector)this.m_dependsMap.get(containerID);
        for (Object entry : components) {
            IElementIdentity compID;
            if (!(entry instanceof IElementIdentity) || !(compID = (IElementIdentity)entry).getType().equals("MQ_BROKER") && !compID.getType().equals("MQ_BACKUPBROKER")) continue;
            return this.m_ds.getFSElement(compID.getName(), false);
        }
        return null;
    }

    private IDirElement hasDS(IElementIdentity containerID) throws DirectoryServiceException {
        Vector components = (Vector)this.m_dependsMap.get(containerID);
        for (Object entry : components) {
            IElementIdentity compID;
            if (!(entry instanceof IElementIdentity) || !(compID = (IElementIdentity)entry).getType().equals("MF_DIRECTORY_SERVICE") && !compID.getType().equals("MF_BACKUP_DIRECTORY_SERVICE")) continue;
            return this.m_ds.getFSElement(compID.getName(), false);
        }
        return null;
    }

    private IDirElement hasPrimaryDS(IElementIdentity containerID) throws DirectoryServiceException {
        Vector components = (Vector)this.m_dependsMap.get(containerID);
        for (Object entry : components) {
            IElementIdentity compID;
            if (!(entry instanceof IElementIdentity) || !(compID = (IElementIdentity)entry).getType().equals("MF_DIRECTORY_SERVICE")) continue;
            return this.m_ds.getFSElement(compID.getName(), false);
        }
        return null;
    }

    private void writeSlashWarning() throws IOException {
        this.m_outStream.write(NEWLINEBYTES);
        this.m_outStream.write("!NOTE: Use Unix slashes '/' in all path values".getBytes());
        this.m_outStream.write(NEWLINEBYTES);
    }

    private boolean isATemplate(IElementIdentity id) {
        Vector components = (Vector)this.m_dependsMap.get(id);
        if (components != null) {
            return components.contains("TEMPLATE");
        }
        return false;
    }
}

