/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationUserBean;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractAuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.impl.AuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.impl.AuthenticationUserBean;
import com.sonicsw.mx.config.IConfigServer;
import java.util.HashMap;
import java.util.List;

public class AuthenticationDomainBean
extends AbstractAuthenticationDomainBean
implements IAuthenticationDomainBean {
    private boolean m_external = false;
    private static final String[] mandatoryGroups = new String[]{"Administrators", "PUBLIC", "TxnAdministrators", "$ISYS-BROKERS"};

    public AuthenticationDomainBean(MgmtBeanFactory factory) throws MgmtException {
        super(factory);
    }

    @Override
    public void createBean(String viewName, String type, String cVersion, String pVersion) throws MgmtException {
        super.createBean(viewName + "/" + "_MFDomainDescriptor", type, cVersion, pVersion, false);
        this.setDomainName(viewName.substring(viewName.lastIndexOf(47) + 1));
    }

    @Override
    public void loadBean(String viewName, String type) throws MgmtException {
        super.loadBean(viewName + "/" + "_MFDomainDescriptor", type);
    }

    @Override
    protected void deleteBean() throws Exception {
        this.getMgmtBeanFactory().getConfigServer().removeConfigElement(this.getConfigBean().getName());
        String path = this.getConfigBean().getName();
        path = path.substring(0, path.lastIndexOf("/"));
        this.getMgmtBeanFactory().getConfigServer().deleteFolder(path);
    }

    @Override
    public void saveBean() throws Exception {
        super.saveBean();
        if (this.isNewBean()) {
            this.setFolderElementAttributes();
            for (int i = 0; i < mandatoryGroups.length; ++i) {
                IAuthenticationGroupBean group = this.createGroupBean();
                group.setGroupName(mandatoryGroups[i]);
                if (mandatoryGroups[i].equals("Administrators") || mandatoryGroups[i].equals("PUBLIC")) {
                    IAuthenticationGroupBean.IGroupMembersType members = group.createGroupMembers();
                    IAuthenticationGroupBean.IGroupMemberType member = members.createMember();
                    member.setMemberName("Administrator");
                    member.setMemberType("user");
                    members.add("Administrator", member);
                    group.setGroupMembers(members);
                }
                this.getMgmtBeanFactory().saveBean(group);
            }
            IAuthenticationUserBean user = this.createUserBean();
            user.setUserName("Administrator");
            user.setPassword("Administrator");
            this.getMgmtBeanFactory().saveBean(user);
        }
    }

    @Override
    public IMgmtBeanBase clone(String viewName) throws MgmtException {
        throw new MgmtException("Illegal operation");
    }

    @Override
    public List getUserBeans() throws MgmtException {
        String beanName = this.getConfigBean().getName();
        int index = beanName.lastIndexOf(47);
        String userName = beanName.substring(0, index + 1) + "_MFUsers";
        return this.getMgmtBeanFactory().loadBeansInDirectory(userName);
    }

    @Override
    public IAuthenticationUserBean getUserBean(String name) throws MgmtException {
        IAuthenticationUserBean user2 = null;
        List users = this.getUserBeans();
        for (IAuthenticationUserBean user2 : users) {
            if (!user2.getUserName().equals(name)) continue;
            return user2;
        }
        throw new MgmtException("User " + name + " doesn't exist.");
    }

    @Override
    public List getGroupBeans() throws MgmtException {
        String beanName = this.getConfigBean().getName();
        int index = beanName.lastIndexOf(47);
        String userName = beanName.substring(0, index + 1) + "_MFGroups";
        return this.getMgmtBeanFactory().loadBeansInDirectory(userName);
    }

    @Override
    public IAuthenticationGroupBean getGroupBean(String name) throws MgmtException {
        IAuthenticationGroupBean group2 = null;
        List groups = this.getGroupBeans();
        for (IAuthenticationGroupBean group2 : groups) {
            if (!group2.getGroupName().equals(name)) continue;
            return group2;
        }
        throw new MgmtException("Group " + name + " doesn't exist.");
    }

    @Override
    public IAuthenticationUserBean createUserBean() throws MgmtException {
        return this.createUserBean(this.getMgmtBeanFactory().getConfigServer());
    }

    @Override
    public IAuthenticationUserBean createUserBean(String userName, String password) throws MgmtException {
        IAuthenticationUserBean user = this.createUserBean(this.getMgmtBeanFactory().getConfigServer());
        user.setUserName(userName);
        user.setPassword(password);
        return user;
    }

    @Override
    public IAuthenticationUserBean createUserBean(String userName, byte[] password) throws MgmtException {
        IAuthenticationUserBean user = this.createUserBean(this.getMgmtBeanFactory().getConfigServer());
        user.setUserName(userName);
        user.setPassword(password);
        return user;
    }

    @Override
    protected void setFolderElementAttributes() throws MgmtException {
        try {
            String path = this.getConfigBean().getName();
            path = path.substring(0, path.lastIndexOf("/"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("TYPE", this.getProperty("_TYPE"));
            map.put("CONFIG_VERSION", this.getProperty("_C_VERSION"));
            map.put("PRODUCT_VERSION", this.getProperty("_P_VERSION"));
            this.getMgmtBeanFactory().setFolderMetaAttributes(path, map);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to set folder element attributes- " + e.getMessage(), e);
        }
    }

    private IAuthenticationUserBean createUserBean(IConfigServer server) throws MgmtException {
        AuthenticationUserBean bean = new AuthenticationUserBean(this.getMgmtBeanFactory());
        String beanName = this.getConfigBean().getName();
        int index = beanName.lastIndexOf(47);
        String pattern = beanName.substring(0, index + 1) + "_MFUsers";
        bean.createBean(this.createUniqueName(pattern, false), "MF_AUTHENTICATION_USER", "110", "14.1", false);
        return bean;
    }

    @Override
    public void deleteUserBean(IAuthenticationUserBean bean) throws MgmtException {
        this.getMgmtBeanFactory().deleteBean(bean);
        List groupsToModify = this.getGroupBeans();
        for (IAuthenticationGroupBean group : groupsToModify) {
            try {
                IAuthenticationGroupBean.IGroupMembersType groupMembers = group.getGroupMembers();
                IAuthenticationGroupBean.IGroupMemberType thisUser = groupMembers.getMember(bean.getUserName());
                if (thisUser == null) continue;
                groupMembers.deleteMember(bean.getUserName());
            }
            catch (MgmtException mgmtException) {}
        }
    }

    @Override
    public IAuthenticationGroupBean createGroupBean() throws MgmtException {
        return this.createGroupBean(this.getMgmtBeanFactory().getConfigServer());
    }

    private IAuthenticationGroupBean createGroupBean(IConfigServer server) throws MgmtException {
        AuthenticationGroupBean bean = new AuthenticationGroupBean(this.getMgmtBeanFactory());
        String beanName = this.getConfigBean().getName();
        int index = beanName.lastIndexOf(47);
        String pattern = beanName.substring(0, index + 1) + "_MFGroups";
        bean.createBean(this.createUniqueName(pattern, false), "MF_AUTHENTICATION_GROUP", "110", "14.1", false);
        return bean;
    }

    @Override
    public void deleteGroupBean(IAuthenticationGroupBean bean) throws MgmtException {
        this.getMgmtBeanFactory().deleteBean(bean);
    }

    @Override
    public void setExternal(boolean value) throws MgmtException {
        this.m_external = value;
        super.setExternal(value);
    }

    @Override
    public boolean isExternal() {
        return this.m_external;
    }

    public static class GroupMapType
    extends AbstractAuthenticationDomainBean.AbstractGroupMapType
    implements IAuthenticationDomainBean.IGroupMapType {
        public GroupMapType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class ConnectionParamMap
    extends AbstractAuthenticationDomainBean.AbstractConnectionParamMap
    implements IAuthenticationDomainBean.IConnectionParamMap {
        public ConnectionParamMap(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }
}

