/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.query.impl;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.Select;
import com.sonicsw.mf.common.config.query.impl.Util;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.util.HashMap;
import java.util.Iterator;

public final class ElementSelection {
    AttributeSetNode m_tree;

    public ElementSelection(Select select) {
        this.m_tree = ElementSelection.SelectionListToTree(select);
    }

    public void removeUnselectedAttributes(IDirElement element) throws ReadOnlyException, ConfigException {
        ElementSelection.removeUnselectedAttributes(element.getAttributes(), this.m_tree);
    }

    private static void removeUnselectedAttributes(IAttributeSet attSet, AttributeSetNode selectionSet) throws ReadOnlyException, ConfigException {
        for (String attName : attSet.getAttributes().keySet()) {
            Object selection = selectionSet.get(attName);
            Object attVal = attSet.getAttribute(attName);
            if (selection == null) {
                attSet.deleteAttribute(attName);
                continue;
            }
            if (selection instanceof String) continue;
            if (selection instanceof AttributeListNode) {
                if (!(attVal instanceof IAttributeList)) {
                    attSet.deleteAttribute(attName);
                    continue;
                }
                ElementSelection.removeUnselectedAttributes((IAttributeList)attVal, (AttributeListNode)selection);
                continue;
            }
            if (!(selection instanceof AttributeSetNode)) continue;
            if (!(attVal instanceof IAttributeSet)) {
                attSet.deleteAttribute(attName);
                continue;
            }
            ElementSelection.removeUnselectedAttributes((IAttributeSet)attVal, (AttributeSetNode)selection);
        }
    }

    private static void removeUnselectedAttributes(IAttributeList attList, AttributeListNode selectionList) throws ReadOnlyException, ConfigException {
        int listCount = attList.getCount();
        for (int i = attList.getCount() - 1; i >= 0; --i) {
            Object selection = selectionList.get(new Integer(i));
            Object attVal = attList.getItem(i);
            if (selection == null) {
                attList.deleteAttributeItem(i);
                continue;
            }
            if (selection instanceof String) continue;
            if (selection instanceof AttributeListNode) {
                if (!(attVal instanceof IAttributeList)) {
                    attList.deleteAttributeItem(i);
                    continue;
                }
                ElementSelection.removeUnselectedAttributes((IAttributeList)attVal, (AttributeListNode)selection);
                continue;
            }
            if (!(selection instanceof AttributeSetNode)) continue;
            if (!(attVal instanceof IAttributeSet)) {
                attList.deleteAttributeItem(i);
                continue;
            }
            ElementSelection.removeUnselectedAttributes((IAttributeSet)attVal, (AttributeSetNode)selection);
        }
    }

    private static AttributeSetNode SelectionListToTree(Select select) {
        AttributeName[] nameList = select.getSelectionList();
        AttributeSetNode root = new AttributeSetNode();
        for (int i = 0; i < nameList.length; ++i) {
            AttributeName attName = nameList[i];
            if (attName.getComponentCount() == 0) continue;
            root.insert(attName.getComponent(0), Util.removeFirstComponent(attName));
        }
        return root;
    }

    private static class AttributeSetNode
    extends HashMap {
        static final String SELECTETD_ATTRIBUTE = "";
        private int m_level;

        AttributeSetNode() {
            this(0);
        }

        AttributeSetNode(int level) {
            this.m_level = level;
        }

        @Override
        public String toString() {
            Iterator iterator = this.keySet().iterator();
            String result = SELECTETD_ATTRIBUTE;
            String spaces = SELECTETD_ATTRIBUTE;
            for (int i = 0; i < this.m_level; ++i) {
                spaces = spaces + "  ";
            }
            while (iterator.hasNext()) {
                Object attName = iterator.next();
                result = result + "\n" + spaces + attName;
                Object node = this.get(attName);
                if (!(node instanceof AttributeSetNode)) continue;
                result = result + node.toString();
            }
            return result;
        }

        void insert(Object attName, AttributeName nameLowerLevels) {
            if (!this.correctType(attName)) {
                return;
            }
            if (nameLowerLevels.getComponentCount() == 0) {
                this.put(attName, SELECTETD_ATTRIBUTE);
                return;
            }
            Object insertedBefore = this.get(attName);
            Object nextComponent = nameLowerLevels.getComponent(0);
            if (insertedBefore == null) {
                insertedBefore = nextComponent instanceof Integer ? new AttributeListNode(this.m_level + 1) : new AttributeSetNode(this.m_level + 1);
                this.put(attName, insertedBefore);
            }
            if (insertedBefore instanceof String) {
                return;
            }
            if (insertedBefore instanceof AttributeSetNode) {
                ((AttributeSetNode)insertedBefore).insert(nextComponent, Util.removeFirstComponent(nameLowerLevels));
            }
        }

        boolean correctType(Object nameComponent) {
            return nameComponent instanceof String;
        }
    }

    private static class AttributeListNode
    extends AttributeSetNode {
        AttributeListNode() {
            this(0);
        }

        AttributeListNode(int level) {
            super(level);
        }

        @Override
        boolean correctType(Object nameComponent) {
            return nameComponent instanceof Integer;
        }
    }
}

