/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.config.upgrade.DomainManager100;
import com.sonicsw.mf.common.config.upgrade.DomainManager120;
import com.sonicsw.mf.common.config.upgrade.DomainManager140;
import com.sonicsw.mf.common.config.upgrade.IVersionedConfigUpgrade;
import com.sonicsw.mf.common.config.upgrade.IVersionedDomainManagerUpgrade;
import com.sonicsw.mf.common.config.upgrade.TypedConfigUpgrade100;
import com.sonicsw.mf.common.config.upgrade.TypedConfigUpgrade120;
import com.sonicsw.mf.common.config.upgrade.TypedConfigUpgrade140;
import java.util.HashMap;

public class UpgradeRegistry {
    private static final boolean DEBUG = System.getProperty("DebugAll.debug", "false").equals("true");
    private static HashMap CONFIG_UPGRADE_MAP = new HashMap();
    private static HashMap DOMAIN_UPGRADE_MAP = new HashMap();

    public static synchronized void registerConfigUpgrade(String releaseVersion, IVersionedConfigUpgrade upgradeObject) {
        if (DEBUG) {
            System.out.println("UpgradeRegistry.registerConfigUpgrade registering " + upgradeObject + " for version " + releaseVersion);
        }
        if (CONFIG_UPGRADE_MAP == null) {
            CONFIG_UPGRADE_MAP = new HashMap();
        }
        CONFIG_UPGRADE_MAP.put(releaseVersion, upgradeObject);
    }

    public static synchronized void registerDomainUpgrade(String releaseVersion, IVersionedDomainManagerUpgrade domainUpgrade) {
        if (DEBUG) {
            System.out.println("UpgradeRegistry.registerDomainUpgrade registering " + domainUpgrade + " for version " + releaseVersion);
        }
        if (DOMAIN_UPGRADE_MAP == null) {
            DOMAIN_UPGRADE_MAP = new HashMap();
        }
        DOMAIN_UPGRADE_MAP.put(releaseVersion, domainUpgrade);
    }

    public static synchronized IVersionedConfigUpgrade getConfigUpgrade(String releaseVersion) throws Exception {
        if (CONFIG_UPGRADE_MAP == null) {
            throw new Exception("There is no upgrade object registered to handle the upgrade from version " + releaseVersion);
        }
        IVersionedConfigUpgrade upgrade = (IVersionedConfigUpgrade)CONFIG_UPGRADE_MAP.get(releaseVersion);
        if (upgrade == null) {
            throw new Exception("There is no upgrade class registered to handle the upgrade from version " + releaseVersion);
        }
        return upgrade;
    }

    public static synchronized IVersionedDomainManagerUpgrade getConfigDomainUpgrade(String releaseVersion) throws Exception {
        if (DOMAIN_UPGRADE_MAP == null) {
            throw new Exception("There is no upgrade class registered to handle the domain upgrade from version " + releaseVersion);
        }
        IVersionedDomainManagerUpgrade upgrade = (IVersionedDomainManagerUpgrade)DOMAIN_UPGRADE_MAP.get(releaseVersion);
        if (upgrade == null) {
            throw new Exception("There is no upgrade class registered to handle the domain upgrade from version " + releaseVersion);
        }
        return upgrade;
    }

    static {
        DOMAIN_UPGRADE_MAP.put("107", new DomainManager100());
        DOMAIN_UPGRADE_MAP.put("108", new DomainManager120());
        DOMAIN_UPGRADE_MAP.put("109", new DomainManager140());
        CONFIG_UPGRADE_MAP.put("107", new TypedConfigUpgrade100());
        CONFIG_UPGRADE_MAP.put("108", new TypedConfigUpgrade120());
        CONFIG_UPGRADE_MAP.put("109", new TypedConfigUpgrade140());
    }
}

