/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.UpgradeEnv;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utils
implements IMigrationProcess {
    private static String FILE_SEPARATOR = System.getProperties().getProperty("file.separator");
    UpgradeEnv m_upgradeEnv = null;

    public Utils(UpgradeEnv env) {
        this.m_upgradeEnv = env;
    }

    String replaceAll(String origString, String[] removeString, String replaceWith) {
        return this.replaceAll(origString, removeString, replaceWith, false);
    }

    String replaceAll(String origString, String[] removeString, String replaceWith, boolean canBeEmpty) {
        String result = "";
        for (int i = 0; i < removeString.length; ++i) {
            int subsStart = origString.indexOf(removeString[i]);
            if (subsStart <= -1) continue;
            result = origString.substring(0, subsStart) + replaceWith + origString.substring(origString.indexOf(removeString[i]) + removeString[i].length());
            break;
        }
        if (result.length() == 0 && !canBeEmpty) {
            return origString;
        }
        return result;
    }

    void fixProductAndReleaseVersion(String logicalName, String storageSuffix) throws Exception {
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("ConfigUpgrade.fixProductAndReleaseVersion called for logical name == " + logicalName);
            String storageName = this.m_upgradeEnv.dsFileSystem.logicalToStorage(logicalName);
            System.out.println("ConfigUpgrade.fixProductAndReleaseVersion found storage name == " + storageName);
        }
        this.m_upgradeEnv.dsAdmin.setElementReleaseVersion(this.m_upgradeEnv.dsFileSystem.logicalToStorage(logicalName) + storageSuffix, "109");
        this.fixViewVersions(logicalName);
    }

    void fixProductAndReleaseVersion(String configName) throws Exception {
        this.fixProductAndReleaseVersion(configName, "");
    }

    void fixViewVersions(String viewName) throws Exception {
        this.fixViewVersionsHelper(viewName, true);
        if (viewName.indexOf("_Default") > 1) {
            String parentFolder = viewName.substring(0, viewName.lastIndexOf("/"));
            this.fixViewVersionsHelper(parentFolder, true);
        }
    }

    void fixViewVersionsHelper(String viewPath, boolean fixReleaseVersion) throws Exception {
        String attrs;
        HashMap metaAttributes = this.m_upgradeEnv.dsFileSystem.getMetaAttributes(viewPath);
        if (metaAttributes != null && (attrs = (String)metaAttributes.get("TOOL_ATTRIBUTES")) != null) {
            if (fixReleaseVersion) {
                for (String relVersion : SUPPORTED_PRODUCT_VERSIONS.values()) {
                    attrs = attrs.replace(relVersion, "109");
                }
            }
            for (String prodVersion : SUPPORTED_PRODUCT_VERSIONS.keySet()) {
                attrs = attrs.replace(prodVersion, "14.0");
            }
            metaAttributes.put("TOOL_ATTRIBUTES", attrs);
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("ConfigUpgrade.fixVuewVersionsHelper setting meta attributes, m_curTransaction == " + this.m_upgradeEnv.m_curTransaction);
            }
            if (this.m_upgradeEnv.m_curTransaction != null) {
                this.m_upgradeEnv.m_curTransaction.addSetAttributes(viewPath, metaAttributes);
            } else {
                this.m_upgradeEnv.dsFileSystem.setMetaAttributes(viewPath, metaAttributes);
            }
        }
    }

    boolean fixPath(IAttributeSet parentSet, AttributeName attrPath, String newValue) throws Exception {
        String brokerName = (String)parentSet.getAttribute("BROKER_NAME");
        IAttributeMetaData metaData = null;
        if (newValue != null) {
            IAttributeSet topSet = parentSet;
            for (int i = 0; i < attrPath.getComponentCount() - 1; ++i) {
                String currentAttribute;
                if (topSet != null) {
                    currentAttribute = (String)attrPath.getComponent(i);
                    metaData = topSet.getAttributeMetaData(currentAttribute);
                    if (metaData != null && metaData.isFromTemplate()) {
                        return false;
                    }
                } else {
                    return false;
                }
                topSet = (IAttributeSet)topSet.getAttribute(currentAttribute);
            }
            metaData = topSet.getAttributeMetaData((String)attrPath.getComponent(attrPath.getComponentCount() - 1));
            if (metaData == null || !metaData.isFromTemplate()) {
                topSet.setStringAttribute((String)attrPath.getComponent(attrPath.getComponentCount() - 1), newValue);
                return true;
            }
        }
        return false;
    }

    void fixHOST_DIRECTORY(IDirElement DS, String newDSHostDir) throws Exception {
        DS.getAttributes().setStringAttribute("HOST_DIRECTORY", newDSHostDir);
    }

    void upgradeBrokerAndDBPaths(IDirElement brokerEl) throws Exception {
        String parentContainerName;
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("ConfigUpgrade.upgradeBrokerAndDBPaths calling fixPath for MQSTORE_DB_CONNECT for " + brokerEl.getIdentity().getName());
        }
        if ((parentContainerName = (String)this.m_upgradeEnv.getProp("container.name")) == null) {
            return;
        }
        if (this.m_upgradeEnv.getContainerProp(parentContainerName, "db.action") == null) {
            return;
        }
        IAttributeSet topSet = brokerEl.getAttributes();
        AttributeName fixPath = new AttributeName("BROKER_DATABASE_PARAMETERS");
        fixPath.setNextComponent("MQSTORE_DB_CONNECT");
        String newMQStore = (String)this.m_upgradeEnv.getContainerProp(parentContainerName, "mqstore.db.connect");
        if (newMQStore != null) {
            this.fixPath(topSet, fixPath, newMQStore);
        }
        fixPath = new AttributeName("BROKER_RECOVERY_LOG_PARAMETERS");
        fixPath.setNextComponent("RECOVERY_LOG_PATH");
        String logFile = (String)this.m_upgradeEnv.getContainerProp(parentContainerName, "recovery.log.file");
        if (logFile != null) {
            this.fixPath(topSet, fixPath, logFile);
        }
    }

    static String addToUpgradeMessage(String source, String append) {
        if (source == null) {
            return append;
        }
        if (append == null) {
            return source;
        }
        return source + System.getProperty("line.separator") + append;
    }

    String getProductVersion(String configName) throws Exception {
        String attrs;
        HashMap metaAttributes = this.m_upgradeEnv.dsFileSystem.getMetaAttributes(configName);
        if (metaAttributes != null && (attrs = (String)metaAttributes.get("TOOL_ATTRIBUTES")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(attrs, ";", false);
            while (tokenizer.hasMoreTokens()) {
                String attr = tokenizer.nextToken();
                if (!attr.startsWith("PRODUCT_VERSION")) continue;
                if (this.m_upgradeEnv.isDEBUG()) {
                    System.out.println("ConfigUpgrade.getProductVersion for " + configName + " == " + attr.substring(16));
                }
                return attr.substring(16);
            }
        }
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("ConfigUpgrade.getProductVersion for " + configName + " not found");
        }
        return "";
    }

    Vector getContainerComponents(IDirElement containerConfig) {
        Vector<String> components = new Vector<String>();
        IAttributeSet componentsSet = (IAttributeSet)containerConfig.getAttributes().getAttribute("COMPONENTS");
        for (String key : componentsSet.getAttributes().keySet()) {
            IAttributeSet componentAttrs = (IAttributeSet)componentsSet.getAttribute(key);
            Reference compRef = (Reference)componentAttrs.getAttribute("CONFIG_REF");
            String compName = compRef.getElementName();
            components.add(compName);
        }
        return components;
    }

    public void saveFileContents(File saveHere, String contents) throws IOException {
        FileOutputStream outStream = new FileOutputStream(saveHere);
        outStream.write(contents.getBytes());
        outStream.close();
    }

    public void debug(String printThis) {
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println(printThis);
        }
    }

    public static void copyAll(File fromDir, File toDir) throws IOException {
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        File[] children = fromDir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            int len;
            File child = children[i];
            if (child.isDirectory()) {
                Utils.copyAll(new File(fromDir, child.getName()), new File(toDir, child.getName()));
                continue;
            }
            FileInputStream in = new FileInputStream(new File(fromDir, child.getName()));
            FileOutputStream out = new FileOutputStream(new File(toDir, child.getName()));
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
    }

    public static void recursiveDeleteDirectory(File directory) {
        if (directory.exists()) {
            File[] contents = directory.listFiles();
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isDirectory()) {
                    Utils.recursiveDeleteDirectory(contents[i]);
                }
                contents[i].delete();
                if (!contents[i].exists()) continue;
                contents[i].deleteOnExit();
            }
            directory.delete();
            if (directory.exists()) {
                directory.deleteOnExit();
            }
        }
    }

    public static String replaceBackSlashes(String withSlashes) {
        String strConverted = withSlashes;
        if (strConverted.indexOf("\\") > -1) {
            strConverted = strConverted.replaceAll("\\\\", "/");
        }
        return strConverted;
    }

    public static ArrayList findContainersForComponent(String componentName, IDirectoryFileSystemService ds) throws Exception {
        Query allContainersQuery = new Query();
        ArrayList<String> inContainers = new ArrayList<String>();
        Object allContainers = null;
        IDirElement[] fsContainers = null;
        Query containerTypeQuery = new Query();
        containerTypeQuery.setFrom(new FromElementType("MF_CONTAINER"));
        fsContainers = ds.getFSElements(containerTypeQuery, false);
        if (allContainers == null && fsContainers == null) {
            throw new Exception("Could not find any containers in the DS!");
        }
        int containerCount = allContainers != null ? (allContainers).length : fsContainers.length;
        for (int i = 0; i < containerCount; ++i) {
            IDirElement container = null;
            String containerName = null;
            container = fsContainers[i];
            containerName = container.getIdentity().getName();
            IAttributeSet components = (IAttributeSet)container.getAttributes().getAttribute("COMPONENTS");
            IAttributeSet componentSet = Utils.findComponent(components, componentName);
            if (componentSet == null) continue;
            inContainers.add(containerName);
        }
        return inContainers;
    }

    private static IAttributeSet findComponent(IAttributeSet componentsSet, String idToFind) {
        HashMap setMap = componentsSet.getAttributes();
        Collection mapValues = setMap.values();
        for (IAttributeSet componentSet : mapValues) {
            Reference compReference = (Reference)componentSet.getAttribute("CONFIG_REF");
            if (compReference.getElementName().toLowerCase().compareTo(idToFind.toLowerCase()) != 0) continue;
            return componentSet;
        }
        return null;
    }

    public static void printError(String title, Exception e, String message) {
        System.err.println();
        System.err.print("*****************************  ");
        System.err.print(title);
        System.err.println(" ****************************");
        System.err.println();
        if (message != null) {
            System.err.println(message);
            System.err.println();
        }
        if (e != null) {
            e.printStackTrace();
            System.err.println();
        }
        System.err.println("******************************************************************************");
    }
}

