/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.view.impl;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryCacheService;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.impl.ElementCreateNotification;
import com.sonicsw.mf.common.config.impl.ElementDeleteNotification;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.FolderCreateNotification;
import com.sonicsw.mf.common.config.impl.FolderDeleteNotification;
import com.sonicsw.mf.common.config.impl.MetaAttributesChangeNotification;
import com.sonicsw.mf.common.config.impl.RenameNotification;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementInPathException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.view.IFolder;
import com.sonicsw.mf.common.view.ILink;
import com.sonicsw.mf.common.view.ILogicalNameSpace;
import com.sonicsw.mf.common.view.INamingListener;
import com.sonicsw.mf.common.view.IView;
import com.sonicsw.mf.common.view.IViewElement;
import com.sonicsw.mf.common.view.ViewException;
import com.sonicsw.mf.common.view.impl.NameReplacer;
import com.sonicsw.mf.common.view.impl.StorageToLogical;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class LogicalNameSpace
implements ILogicalNameSpace {
    public static final String HINT_DIRECTORY_ATT = "HINT_DIRECTORY";
    public static final String HINT_COMPLEX_ATT = "HINT_COMPLEX";
    private static final String INCONSISTENT_ERROR_MESSAGE = "The view was updated by an old (admin. API) client and is now inconsistent.";
    private IView m_view;
    IDirectoryAdminService m_ds;
    private StorageToLogical m_storageToLogical;
    private static final String HINT_SEPARATOR = "_$$_";
    private static int m_counter = 0;
    private static String MISC_DIR_NAME = "/_MFMisc/";
    private IAttributeSet m_hints;
    private NamingNotificationManager m_notificationManager;
    private String m_hintsElementName;
    private String m_hintsAttribute;
    private HashMap m_dirMap;
    private HashMap m_complexMap;
    private HashMap m_tempBlobStorageNames;
    private boolean m_viewIsDirty;
    private boolean m_inconsistent;
    private List m_auditRecords;

    public void storeUpdates() throws DirectoryServiceException {
        if (!this.m_viewIsDirty) {
            return;
        }
        if (this.m_ds == null) {
            return;
        }
        this.m_view = ((IDirectoryCacheService)((Object)this.m_ds)).storeViewInternal(this.m_view);
        this.m_viewIsDirty = false;
        this.m_auditRecords.clear();
    }

    public void init(IView view) throws ViewException {
        this.m_inconsistent = false;
        this.m_view = view;
        this.m_viewIsDirty = false;
        this.m_dirMap = null;
        this.m_notificationManager = new NamingNotificationManager();
        this.m_hints = null;
        this.initStorageDefaults();
        this.m_auditRecords = new LinkedList();
    }

    public void init(IDirectoryAdminService ds, String hintsElementName, String hintsAttribute) {
        this.m_hintsElementName = hintsElementName;
        this.m_hintsAttribute = hintsAttribute;
        this.m_dirMap = null;
        this.m_ds = ds;
        this.m_notificationManager = new NamingNotificationManager();
        this.m_auditRecords = new LinkedList();
        this.reset();
    }

    public void setNotConsistent() {
        if (this.m_ds == null) {
            return;
        }
        this.m_inconsistent = true;
    }

    public HashMap getStorageToLogicalMap() {
        return this.m_storageToLogical.getMap();
    }

    public void reset() {
        try {
            this.m_view = this.m_ds.getView();
            this.m_viewIsDirty = false;
            this.initStorageDefaults();
            this.m_notificationManager.reset();
            this.resetStorageHints();
            this.m_inconsistent = false;
            this.m_auditRecords.clear();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception during reset, see cause", e);
        }
    }

    private void initStorageDefaults() throws ViewException {
        this.m_storageToLogical = new StorageToLogical();
        this.m_tempBlobStorageNames = new HashMap();
        if (this.m_view.hasRootFolder()) {
            this.m_storageToLogical.updateFromView(this.m_view.getRootFolder(), "/");
        }
    }

    public String complexDirForType(String type) {
        this.checkAndCreateDirMap(this.m_complexMap);
        return (String)this.m_complexMap.get(type);
    }

    public ArrayList directoriesForType(String type) {
        this.checkAndCreateDirMap(this.m_dirMap);
        return (ArrayList)this.m_dirMap.get(type);
    }

    private void checkAndCreateDirMap(HashMap m_dirMap) {
        if (m_dirMap == null) {
            this.createTypeDirMap();
        }
    }

    void createTypeDirMap() {
        this.m_dirMap = new HashMap();
        this.m_complexMap = new HashMap();
        if (this.m_hints == null) {
            return;
        }
        for (String hintKey : this.m_hints.getAttributes().keySet()) {
            HintID hintType = new HintID(hintKey);
            ArrayList<Object> dirList = (ArrayList<Object>)this.m_dirMap.get(hintType.m_type);
            if (dirList == null) {
                dirList = new ArrayList<Object>();
                this.m_dirMap.put(hintType.m_type, dirList);
            } else if (dirList.isEmpty()) continue;
            IAttributeSet hint = (IAttributeSet)this.m_hints.getAttribute(hintKey);
            Boolean complex = (Boolean)hint.getAttribute(HINT_COMPLEX_ATT);
            if (complex != null && complex.booleanValue()) {
                this.m_complexMap.put(hintType.m_type, hint.getAttribute(HINT_DIRECTORY_ATT));
                continue;
            }
            dirList.add(hint.getAttribute(HINT_DIRECTORY_ATT));
        }
    }

    private void resetStorageHints() throws DirectoryServiceException {
        if (this.m_hintsElementName == null) {
            return;
        }
        IDirElement storageHints = this.m_ds.getElement(this.m_hintsElementName, false);
        if (storageHints != null) {
            this.resetStorageHints((IAttributeSet)storageHints.getAttributes().getAttribute(this.m_hintsAttribute));
        }
    }

    public void resetStorageHints(IAttributeSet hints) {
        this.m_dirMap = null;
        this.m_hints = hints;
    }

    @Override
    public void createFolder(String path) throws DirectoryServiceException {
        try {
            this.m_view.createFolder(path);
            this.m_viewIsDirty = true;
            String canonicalPath = new EntityName(path).getName();
            this.m_notificationManager.notifyNamingEvent(new FolderCreateNotification(canonicalPath));
            this.m_auditRecords.add(new AuditRecord(1, null, canonicalPath, null));
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    @Override
    public String createElement(String path1, String elementType) throws DirectoryServiceException {
        return this.createElement(path1, elementType, true);
    }

    public String createElement(String path1, String elementType, boolean modView) throws DirectoryServiceException {
        try {
            EntityName pathE = new EntityName(path1);
            if (modView) {
                this.m_notificationManager.notifyNamingEvent(new ElementCreateNotification(pathE.getName()));
            }
            String path = pathE.getName();
            String storageName = null;
            try {
                storageName = this.storageFromLogical(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IViewElement viewElement = null;
            try {
                viewElement = this.m_view.getElement(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (storageName != null && viewElement == null) {
                return storageName;
            }
            if (viewElement != null) {
                throw new ViewException(path + " already exists.");
            }
            String postfix = null;
            String generatedName = this.createUniqueID();
            int postfixIndex = path.lastIndexOf(46);
            if (postfixIndex != -1) {
                postfix = path.substring(postfixIndex + 1).toLowerCase();
            }
            IAttributeSet hint = null;
            if (this.m_hints != null) {
                hint = (IAttributeSet)this.m_hints.getAttribute(LogicalNameSpace.createHintID(elementType, postfix));
            }
            if (hint == null && this.m_hints != null) {
                hint = (IAttributeSet)this.m_hints.getAttribute(elementType);
            }
            if (hint == null) {
                return this.addSimpleEntry(path, MISC_DIR_NAME + generatedName, modView);
            }
            boolean complexHint = false;
            Boolean complex = (Boolean)hint.getAttribute(HINT_COMPLEX_ATT);
            if (complex != null && complex.booleanValue()) {
                complexHint = true;
            }
            if (!complexHint) {
                return this.addSimpleEntry(path, (String)hint.getAttribute(HINT_DIRECTORY_ATT) + '/' + generatedName, modView);
            }
            String complexDir = (String)hint.getAttribute(HINT_DIRECTORY_ATT) + '/' + generatedName;
            EntityName logicalDirE = pathE.getParentEntity();
            String storageBaseName = pathE.getBaseName().equalsIgnoreCase(logicalDirE.getBaseName()) ? generatedName : pathE.getBaseName();
            storageName = complexDir + '/' + storageBaseName;
            String logicalDir = logicalDirE.getName();
            this.m_notificationManager.notifyNamingEvent(new FolderCreateNotification(logicalDir));
            this.m_view.link(logicalDir, storageName, true);
            this.m_viewIsDirty = true;
            this.m_storageToLogical.setComplex(new EntityName(complexDir), this.getCaseSensitiveName(logicalDir));
            return storageName;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    public void addViewLink(String path, String storageName) throws DirectoryServiceException {
        try {
            this.m_view.link(path, storageName, false);
            this.m_viewIsDirty = true;
            this.m_notificationManager.notifyNamingEvent(new ElementCreateNotification(path));
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    private String addSimpleEntry(String path, String storageName, boolean modView) throws ViewException, ConfigException {
        if (modView) {
            this.m_view.link(path, storageName, false);
            this.m_viewIsDirty = true;
            this.m_tempBlobStorageNames.remove(path);
        }
        this.m_storageToLogical.setElement(new EntityName(storageName), this.getCaseSensitiveName(path, modView));
        if (!modView) {
            this.m_tempBlobStorageNames.put(path, storageName);
        }
        return storageName;
    }

    public String tempBlobStorageName(String path) throws ConfigException {
        EntityName eName = new EntityName(path);
        return (String)this.m_tempBlobStorageNames.get(eName.getName());
    }

    public String addSimpleEntry(String path, String storageName) throws ViewException, ConfigException, DirectoryServiceException {
        return this.addSimpleEntry(path, storageName, true);
    }

    @Override
    public String logicalFromStorage(String storagePath) throws DirectoryServiceException {
        if (this.m_inconsistent) {
            throw new DirectoryServiceException(INCONSISTENT_ERROR_MESSAGE);
        }
        try {
            return this.m_storageToLogical.getElementLogicalName(new EntityName(storagePath));
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    @Override
    public String storageFromLogical(String path) throws DirectoryServiceException {
        if (this.m_inconsistent) {
            throw new DirectoryServiceException(INCONSISTENT_ERROR_MESSAGE);
        }
        try {
            return LogicalNameSpace.logicalToStorage(this.m_view, path);
        }
        catch (DirectoryServiceException dirEx) {
            throw dirEx;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteElement(String path) throws DirectoryServiceException {
        this.deleteElement(path, false);
    }

    @Override
    public void deleteElement(String path, boolean elementUnderComplexConfig) throws DirectoryServiceException {
        try {
            this.m_notificationManager.notifyNamingEvent(new ElementDeleteNotification(new EntityName(path).getName()));
            if (!elementUnderComplexConfig) {
                this.delete(path, false);
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteFolder(String path) throws DirectoryServiceException {
        try {
            this.delete(path, true);
            String canonicalPath = new EntityName(path).getName();
            this.m_notificationManager.notifyNamingEvent(new FolderDeleteNotification(canonicalPath));
            this.m_auditRecords.add(new AuditRecord(2, canonicalPath, null, null));
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    @Override
    public String[] list(String folderPath) throws DirectoryServiceException {
        try {
            return this.m_view.list(folderPath);
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString(), e);
        }
    }

    @Override
    public int getNameSpaceType(String path) {
        IViewElement element = null;
        try {
            element = this.m_view.getElement(path);
        }
        catch (Exception e) {
            return 0;
        }
        if (element == null) {
            return 0;
        }
        if (element instanceof IFolder) {
            return 1;
        }
        if (((ILink)element).isComplex()) {
            return 2;
        }
        return 3;
    }

    private void delete(String path, boolean folder) throws ConfigException, ViewException, DirectoryServiceException {
        IViewElement element = this.m_view.getElement(path);
        if (element instanceof IFolder) {
            this.m_storageToLogical.deleteFromView((IFolder)element);
        } else {
            String storageName = ((ILink)element).getLinkedObjectName();
            if (((ILink)element).isComplex()) {
                this.m_storageToLogical.delete(new EntityName(storageName).getParentEntity());
            } else {
                if (folder) {
                    throw new ViewException(path + " is not a folder.");
                }
                this.m_storageToLogical.delete(new EntityName(storageName));
            }
        }
        this.m_view.delete(path);
        this.m_viewIsDirty = true;
    }

    @Override
    public void rename(String oldPath, String newPath) throws DirectoryServiceException {
        try {
            String canonicalOldPath = new EntityName(oldPath).getName();
            String canonicalNewPath = new EntityName(newPath).getName();
            this.m_notificationManager.notifyNamingEvent(new RenameNotification(canonicalOldPath, canonicalNewPath));
            this.m_view.rename(oldPath, newPath);
            this.m_viewIsDirty = true;
            IViewElement renamedElement = this.m_view.getElement(newPath);
            if (renamedElement instanceof IFolder) {
                this.m_storageToLogical.updateFromView((IFolder)renamedElement, newPath);
                this.m_auditRecords.add(new AuditRecord(3, canonicalOldPath, canonicalNewPath, null));
            } else {
                ILink link = (ILink)renamedElement;
                String storageName = link.getLinkedObjectName();
                if (!link.isComplex()) {
                    this.m_storageToLogical.setElement(new EntityName(storageName), newPath);
                } else {
                    this.m_storageToLogical.setComplex(new EntityName(storageName).getParentEntity(), newPath);
                }
                this.m_auditRecords.add(new AuditRecord(3, canonicalOldPath, canonicalNewPath, storageName));
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString(), e);
        }
    }

    @Override
    public String folderToDirectory(String logical) throws DirectoryServiceException {
        try {
            return this.logicalFolderToStorage(logical);
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString(), e);
        }
    }

    private String logicalFolderToStorage(String logical) throws ViewException, ConfigException {
        IFolder currentFolder = this.m_view.getRootFolder();
        EntityName logicalE = new EntityName(logical);
        if (logicalE.isRoot()) {
            return null;
        }
        String[] nameComponents = logicalE.getNameComponents();
        for (int i = 0; i < nameComponents.length; ++i) {
            IViewElement viewElement = currentFolder.getViewElement(nameComponents[i]);
            if (viewElement == null) {
                throw new ViewException(logical + " was not found");
            }
            if (i + 1 == nameComponents.length) {
                if (viewElement instanceof IFolder) {
                    return null;
                }
                ILink link = (ILink)viewElement;
                if (link.isComplex()) {
                    return new EntityName(link.getLinkedObjectName()).getParent();
                }
                throw new ViewException(logical + " is not a folder.");
            }
            if (!(viewElement instanceof IFolder)) {
                ILink link = (ILink)viewElement;
                if (!link.isComplex()) {
                    throw new ViewException(logical + " is not a folder.");
                }
                String subPath = "";
                for (int j = i + 1; j < nameComponents.length; ++j) {
                    subPath = subPath + '/' + nameComponents[j];
                }
                return new EntityName(link.getLinkedObjectName()).getParent() + subPath;
            }
            currentFolder = (IFolder)viewElement;
        }
        throw new Error("logical path " + logical);
    }

    public static String logicalToStorage(IView view, String logical) throws ViewException, ConfigException, ElementInPathException {
        IFolder currentFolder = view.getRootFolder();
        EntityName logicalE = new EntityName(logical);
        String[] nameComponents = logicalE.getNameComponents();
        String searchedPath = "";
        if (nameComponents.length == 0) {
            throw new ViewException("Bad argument: storageFromLogical() or logicalToStorage() was called with the '/' logical name.");
        }
        for (int i = 0; i < nameComponents.length; ++i) {
            IViewElement viewElement = currentFolder.getViewElement(nameComponents[i]);
            searchedPath = searchedPath + "/" + nameComponents[i];
            if (viewElement == null) {
                throw new ViewException(logical + " was not found");
            }
            if (i + 1 == nameComponents.length) {
                if (viewElement instanceof IFolder) {
                    throw new ViewException(logical + " is a folder name");
                }
                ILink link = (ILink)viewElement;
                if (link.isComplex()) {
                    return new EntityName(link.getLinkedObjectName()).getParent();
                }
                return link.getLinkedObjectName();
            }
            if (!(viewElement instanceof IFolder)) {
                ILink link = (ILink)viewElement;
                if (!link.isComplex()) {
                    throw new ElementInPathException(logical + " is not a valid element name.", searchedPath, link.getLinkedObjectName());
                }
                String subPath = "";
                EntityName linkedObjectName = new EntityName(link.getLinkedObjectName());
                for (int j = i + 1; j < nameComponents.length; ++j) {
                    String compName = nameComponents[j];
                    if (j + 1 == nameComponents.length && j > 0 && compName.equalsIgnoreCase(nameComponents[j - 1])) {
                        compName = linkedObjectName.getBaseName();
                    }
                    subPath = subPath + '/' + compName;
                }
                return linkedObjectName.getParent() + subPath;
            }
            currentFolder = (IFolder)viewElement;
        }
        throw new Error("logical path " + logical);
    }

    public String getCaseSensitiveName(String logical) throws ViewException, ConfigException {
        return this.getCaseSensitiveName(logical, true);
    }

    public String getCaseSensitiveName(String logical, boolean alreadyAdded) throws ViewException, ConfigException {
        IFolder currentFolder = this.m_view.getRootFolder();
        EntityName logicalE = new EntityName(logical);
        String[] nameComponents = logicalE.getNameComponents();
        String csLogicalName = "";
        for (int i = 0; i < nameComponents.length; ++i) {
            IViewElement viewElement = null;
            try {
                viewElement = currentFolder.getViewElement(nameComponents[i]);
            }
            catch (ViewException e) {
                if (!alreadyAdded && i + 1 == nameComponents.length) {
                    return csLogicalName + '/' + nameComponents[i];
                }
                throw e;
            }
            if (viewElement == null) {
                throw new ViewException(logical + " was not found");
            }
            if (i + 1 == nameComponents.length) {
                return csLogicalName + '/' + viewElement.getName();
            }
            if (!(viewElement instanceof IFolder)) {
                ILink link = (ILink)viewElement;
                if (!link.isComplex()) {
                    throw new ViewException(logical + " is not a valid element name.");
                }
                csLogicalName = csLogicalName + '/' + viewElement.getName();
                for (int j = i + 1; j < nameComponents.length; ++j) {
                    csLogicalName = csLogicalName + '/' + nameComponents[j];
                }
                return csLogicalName;
            }
            currentFolder = (IFolder)viewElement;
            csLogicalName = csLogicalName + '/' + viewElement.getName();
        }
        if (logical.length() == 1 && logical.charAt(0) == '/') {
            return logical;
        }
        throw new Error("logical path " + logical);
    }

    public static String createHintID(String type, String postfix) {
        String hintID = type;
        if (postfix != null) {
            hintID = hintID + HINT_SEPARATOR + postfix.toLowerCase();
        }
        return hintID;
    }

    String createUniqueID() {
        if (m_counter + 1 == Integer.MAX_VALUE) {
            m_counter = 0;
        }
        return System.currentTimeMillis() + "_" + m_counter++;
    }

    public NameReplacer createNameReplacer(boolean fromLogical) {
        return new NameReplacer(fromLogical, this);
    }

    public void doNotify() {
        this.m_notificationManager.doNotify();
    }

    @Override
    public void subscribe(INamingListener listener) {
        this.m_notificationManager.subscribe(listener);
    }

    @Override
    public void unsubscribe() {
        this.m_notificationManager.unsubscribe();
    }

    @Override
    public void defineFolderMetaAttribute(String attributeName) throws DirectoryServiceException {
        try {
            this.m_view.getFolderAttributeSetType().addAttributeName(attributeName);
            this.m_viewIsDirty = true;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void defineElementMetaAttribute(String attributeName) throws DirectoryServiceException {
        try {
            this.m_view.getLinkAttributeSetType().addAttributeName(attributeName);
            this.m_viewIsDirty = true;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void setMetaAttributes(String elementName, HashMap newAttributes) throws DirectoryServiceException {
        try {
            HashMap newAttributesCopy = (HashMap)newAttributes.clone();
            newAttributesCopy.remove("_ELEMENT_IDENTITY");
            newAttributesCopy.remove("_FOLDER_NAME");
            newAttributesCopy.remove("_IS_COMPLEX");
            IViewElement element = this.m_view.getElement(elementName);
            if (element instanceof ILink && ((ILink)element).isComplex()) {
                ((ILink)element).setComplexAttributes(newAttributesCopy);
            } else {
                for (String key : newAttributesCopy.keySet()) {
                    Object value = newAttributesCopy.get(key);
                    if (!(value instanceof String)) {
                        throw new DirectoryServiceException("Only string attribute are supported " + key + " type is " + value.getClass().getName());
                    }
                    element.getAttributes().setAttribute(key, (String)value);
                }
            }
            this.m_notificationManager.notifyNamingEvent(new MetaAttributesChangeNotification(elementName, newAttributes));
            this.m_viewIsDirty = true;
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString(), e);
        }
        catch (Exception other) {
            throw new DirectoryServiceException(other.getMessage());
        }
    }

    @Override
    public String[] getDefinedFolderMetaAttributes() {
        return this.m_view.getFolderAttributeSetType().getAttributeNames();
    }

    @Override
    public String[] getDefinedElementMetaAttributes() {
        return this.m_view.getLinkAttributeSetType().getAttributeNames();
    }

    @Override
    public HashMap getMetaAttributes(String elementName) throws DirectoryServiceException {
        try {
            IViewElement element = this.m_view.getElement(elementName);
            if (element instanceof ILink && ((ILink)element).isComplex()) {
                return ((ILink)element).getComplexAttributes();
            }
            return element.getAttributes().getAttributes();
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage(), e);
        }
    }

    public List getAuditRecords() {
        return this.m_auditRecords;
    }

    private final class NamingNotificationManager {
        INamingListener m_listener = null;
        ArrayList m_notifications = new ArrayList();

        NamingNotificationManager() {
        }

        void reset() {
            this.m_notifications = new ArrayList();
        }

        void doNotify() {
            if (this.m_listener != null && !this.m_notifications.isEmpty()) {
                this.m_listener.onNotifications(this.m_notifications);
            }
            this.reset();
        }

        void notifyNamingEvent(INamingNotification notification) {
            this.m_notifications.add(notification);
        }

        void notifyNamingEvents(ArrayList notifications) {
            for (int i = 0; i < notifications.size(); ++i) {
                this.m_notifications.add(notifications.get(i));
            }
        }

        void subscribe(INamingListener listener) {
            this.m_listener = listener;
        }

        void unsubscribe() {
            this.m_listener = null;
        }
    }

    private class HintID {
        String m_type;
        String m_postfix = null;

        HintID(String idString) {
            int sepIndex = idString.indexOf(LogicalNameSpace.HINT_SEPARATOR);
            if (sepIndex == -1) {
                this.m_type = idString;
            } else {
                this.m_type = idString.substring(0, sepIndex);
                this.m_postfix = idString.substring(sepIndex + LogicalNameSpace.HINT_SEPARATOR.length());
            }
        }
    }

    public class AuditRecord {
        public static final int CREATE_FOLDER = 1;
        public static final int DELETE_FOLDER = 2;
        public static final int RENAME = 3;
        private int m_action = 0;
        private String m_oldPath = null;
        private String m_newPath = null;
        private String m_storagePath = null;

        private AuditRecord(int action, String oldPath, String newPath, String storagePath) {
            this.m_action = action;
            this.m_oldPath = oldPath;
            this.m_newPath = newPath;
            this.m_storagePath = storagePath;
        }

        public int getAction() {
            return this.m_action;
        }

        public String getOldPath() {
            return this.m_oldPath;
        }

        public String getNewPath() {
            return this.m_newPath;
        }

        public String getStoragePath() {
            return this.m_storagePath;
        }
    }
}

