/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.MergeUtil;
import com.sonicsw.mf.common.config.impl.Identity;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.impl.AttributeMapImpl;
import com.sonicsw.mx.config.impl.ConfigElementPrototype;
import com.sonicsw.mx.config.impl.ConfigPathImpl;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConfigElementImpl
extends AttributeMapImpl
implements IConfigElement {
    protected static final String IDENTITY_ELEMENT_TYPE_STRING = "ConfigElement";
    protected static final String IDENTITY_ELEMENT_RELEASE_VERSION_STRING = "1.0";
    protected static final short LOCAL_STATE = 0;
    protected static final short NEW_STATE = 1;
    protected static final short UNMODIFIED_STATE = 2;
    protected static final short MODIFIED_STATE = 3;
    protected static final short REMOVED_STATE = 4;
    protected static final short DELETED_STATE = 5;
    protected static final String[] STATES_DEBUG = new String[]{"LOCAL", "NEW", "UNMODIFIED", "MODIFIED", "REMOVED", "DELETED"};
    protected String m_name = null;
    protected String m_type = null;
    protected String m_version = null;
    protected InputStream m_blob = null;
    protected long m_creationTime = -1L;
    protected Map m_metaAttributes = null;
    protected boolean m_metaChanged = false;
    protected IConfigPrototype m_configPrototype = null;
    protected String m_dirElementName = null;
    protected short m_state = 1;
    protected String m_annotation = null;

    protected ConfigElementImpl(ConfigServer configServer) {
        super(configServer);
    }

    protected ConfigElementImpl(String name, ConfigServer configServer) throws ConfigServiceException {
        this(name, IDENTITY_ELEMENT_TYPE_STRING, IDENTITY_ELEMENT_RELEASE_VERSION_STRING, configServer);
    }

    protected ConfigElementImpl(String name, String type, String version, ConfigServer configServer) throws ConfigServiceException {
        super(configServer);
        if (configServer == null) {
            throw new ConfigServiceException("ce-init-cs-is-null");
        }
        this.m_name = ConfigElementImpl.validateName(name);
        this.m_type = type;
        this.m_version = version;
        this.m_configServer = configServer;
        this.m_owner = this;
        this.m_instanceOwner = this;
        this.m_configServer.elementCreated(this);
    }

    protected ConfigElementImpl(String name, ConfigElementImpl configElement, boolean isPrototype) throws ConfigServiceException {
        super(configElement);
        this.m_name = ConfigElementImpl.validateName(name);
        this.m_type = configElement.m_type;
        this.m_version = configElement.m_version;
        this.m_configServer = configElement.m_configServer;
        this.setOwner(this);
        this.m_configServer.elementCreated(this);
    }

    protected ConfigElementImpl(IDirElement dsElement, ConfigServer configServer) throws ConfigServiceException {
        super(configServer);
        this.init(dsElement);
    }

    protected final void init(IDirElement dsElement) throws ConfigServiceException {
        this.m_owner = this;
        this.m_instanceOwner = this;
        this.m_name = dsElement.getIdentity().getName();
        this.m_type = dsElement.getIdentity().getType();
        this.m_state = (short)2;
        if (dsElement.getSuperElementName() != null) {
            IConfigElement configElement = this.m_configServer.loadConfigElement(dsElement.getSuperElementName());
            if (configElement instanceof IConfigPrototype) {
                this.m_configPrototype = (IConfigPrototype)configElement;
            } else {
                throw new ConfigServiceException("ce-init-super-is-not-proto");
            }
        }
        this.refreshFromDSElement(dsElement);
        this.m_configServer.elementLoaded(this);
    }

    protected void refreshFromDSElement(IDirElement dsElement) throws ConfigServiceException {
        if (dsElement == null) {
            throw new ConfigServiceException("ce-refresh-from-dse-ce-is-null");
        }
        this.m_configServer.debugPrintln("refreshFromDSElement " + dsElement.getIdentity().getName() + " version=" + dsElement.getIdentity().getVersion());
        try {
            this._clear();
            this.m_metaAttributes = null;
            this.m_version = dsElement.getIdentity().getReleaseVersion();
            this.m_creationTime = dsElement.getIdentity().getCreationTimestamp();
            IAttributeSet mapSet = dsElement.getAttributes();
            HashMap attributes = mapSet.getAttributes();
            for (String key : attributes.keySet()) {
                if (key.equals("_MF_SYSTEM_ATTRIBUTES")) {
                    IAttributeSet systemAttr = (IAttributeSet)attributes.get("_MF_SYSTEM_ATTRIBUTES");
                    String value = (String)systemAttr.getAttribute("TOOL_ANNOTATION");
                    if (value == null) {
                        if (this.m_annotation == null) continue;
                        this.m_annotation = null;
                        continue;
                    }
                    int indx = value.indexOf("<![CDATA[");
                    String annotation = null;
                    if (indx == -1) {
                        annotation = value;
                    } else {
                        annotation = value.substring("<![CDATA[".length());
                        String string = annotation = annotation.length() == "]]>".length() ? "" : annotation.substring(0, annotation.length() - "]]>".length());
                    }
                    if (!annotation.equals(this.m_annotation)) {
                        this.setAnnotation(annotation.trim());
                    }
                }
                if (!(mapSet.getAttribute(key) instanceof IAttributeList) && mapSet.getAttributeMetaData(key).isFromTemplate()) continue;
                this.put(key, mapSet.getAttribute(key), false);
            }
            String[] removedAttributes = mapSet.getDeletedAttributesInThisSubclassed();
            for (int i = 0; i < removedAttributes.length; ++i) {
                this.put(removedAttributes[i], new AttributeMapImpl.RemovedAttribute(), false);
            }
            this.m_configServer.elementRefreshed(this);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigServiceException)((Object)e.getLinkedException());
        }
    }

    @Override
    public Object clone() {
        int idx = this.m_name.lastIndexOf(47);
        String name = this.m_name.substring(0, idx + 1) + ConfigFactory.createGUID();
        return this.clone(this.m_configServer, name);
    }

    protected Object clone(ConfigServer configServer, String name) {
        ConfigElementImpl copy = null;
        try {
            copy = (ConfigElementImpl)super.clone(configServer);
            copy.m_name = name;
            copy.m_state = 1;
            copy.m_blob = null;
            copy.m_configPrototype = null;
            copy.setOwner(copy);
            configServer.elementCreated(copy);
            return copy;
        }
        catch (ConfigServiceException e) {
            if (copy != null) {
                try {
                    configServer.elementRemoved(copy);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            e.printStackTrace(System.err);
            throw new ConfigServiceRuntimeException("ce-clone-failed", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clonePrototypeInstance(String name) {
        if (!this.isPrototypeInstance()) {
            throw new ConfigServiceRuntimeException("ce-clone-pi-not-pi");
        }
        ConfigElementImpl copy = null;
        try {
            ConfigServer configServer = this.m_configServer;
            synchronized (configServer) {
                copy = (ConfigElementImpl)this.getPrototype().newInstance(name);
                for (Object key : this._keySet()) {
                    copy.put(key, this._get(key));
                }
                return copy;
            }
        }
        catch (ConfigServiceException e) {
            if (copy != null) {
                try {
                    this.m_configServer.elementRemoved(copy);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            throw new ConfigServiceRuntimeException("ce-clone-pi-failed", (Exception)((Object)e));
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String className = this.getClass().getName();
        String typeName = className.substring(className.lastIndexOf(".") + 1);
        buffer.append(this.getName() + "  [" + typeName + "] =\n");
        buffer.append("{\n");
        buffer.append(this.toString(1, false));
        buffer.append("}\n");
        return buffer.toString();
    }

    @Override
    public boolean isRemoved() {
        return this.m_state == 4 || this.m_state == 5;
    }

    protected void setRemoved() throws ConfigServiceException {
        if (!this.isRemoved()) {
            this.m_configServer.elementRemoved(this);
        }
    }

    public boolean isDeleted() {
        return this.m_state == 5;
    }

    @Override
    public boolean isModified() {
        return this.m_state == 3 || this.m_state == 1;
    }

    protected void setModified() {
        try {
            this.m_configServer.elementModified(this);
        }
        catch (ConfigServiceException configServiceException) {
            // empty catch block
        }
    }

    @Override
    public boolean isNew() {
        return this.m_state == 1 || this.m_state == 0;
    }

    public boolean isLocal() {
        return this.m_state == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getState() {
        ConfigServer configServer = this.m_configServer;
        synchronized (configServer) {
            return this.m_state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(short state) {
        ConfigServer configServer = this.m_configServer;
        synchronized (configServer) {
            if (ConfigServer.DEBUG && state != this.m_state) {
                this.m_configServer.debugPrintln("setState for " + this.getName() + " from(" + STATES_DEBUG[this.m_state] + ") to(" + STATES_DEBUG[state] + ")");
            }
            this.m_state = state;
        }
    }

    protected String getDirectoryElementName() {
        return this.m_dirElementName;
    }

    protected void setDirectoryElementName(String name) {
        this.m_dirElementName = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) throws ConfigServiceException {
        try {
            ConfigServer configServer = this.m_configServer;
            synchronized (configServer) {
                ConfigElementImpl.validateName(name);
                this.m_configServer.elementRenamed(this.m_name, name, this);
                this.m_name = name;
            }
        }
        catch (Exception e) {
            throw new ConfigServiceException("ce-set-name-failed", e);
        }
    }

    protected void rename(String oldPrefix, String newPrefix) throws ConfigServiceException {
        if (!this.m_name.startsWith(oldPrefix)) {
            throw new ConfigServiceException("");
        }
        String suffix = this.m_name.substring(oldPrefix.length());
        this.m_name = newPrefix + suffix;
    }

    @Override
    public InputStream getInputStream() throws ConfigServiceException {
        IBlob blob;
        this.m_configServer.debugPrintln("ConfigElementImpl::getInputStream(" + this.m_name + ")");
        boolean isReadable = true;
        if (this.m_blob != null) {
            try {
                int size = this.m_blob.available();
                if (this.m_blob.available() == 0) {
                    isReadable = false;
                }
            }
            catch (IOException ie) {
                isReadable = false;
            }
        }
        if (!(this.m_blob != null && isReadable || (blob = this.m_configServer.getBlob(this.m_name)) == null)) {
            this.m_blob = blob.getBlobStream();
        }
        return this.m_blob;
    }

    @Override
    public void setInputStream(InputStream stream) throws ConfigServiceException {
        this.m_configServer.debugPrintln("ConfigElementImpl::setInputStream(" + this.m_name + ")");
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = stream.read(buffer)) >= 0) {
                oStream.write(buffer, 0, len);
            }
            this.m_blob = new ByteArrayInputStream(oStream.toByteArray());
            oStream.close();
            this.setModified();
        }
        catch (Exception e) {
            throw new ConfigServiceException("ce-set-input-stream-failed", e);
        }
    }

    @Override
    public IConfigPath[] getReferences() throws ConfigServiceException {
        return this.m_configServer.getReferences(this.m_name);
    }

    @Override
    public boolean isMetaAttributesModified() {
        return this.m_metaChanged;
    }

    @Override
    public HashMap getMetaAttributes() throws ConfigServiceException {
        if (this.m_metaAttributes == null) {
            this.m_metaAttributes = Util.splitToolMetaAttributes(this.m_configServer.getMetaAttributes(this.m_name));
        }
        return this.m_metaAttributes != null ? Util.mapToHashMap(this.m_metaAttributes) : null;
    }

    @Override
    public void setMetaAttributes(HashMap attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        this.m_metaAttributes = attributes;
        this.m_metaChanged = true;
        this.setModified();
    }

    @Override
    public IConfigPrototype getPrototype() {
        return this.m_configPrototype;
    }

    @Override
    public boolean isPrototypeInstance() {
        return this.m_configPrototype != null;
    }

    @Override
    protected IAttributeMap getProtoMap() {
        return this.m_configPrototype;
    }

    @Override
    public void unshare() throws ConfigServiceException {
        if (!this.isPrototypeInstance()) {
            throw new ConfigServiceException("ce-unshare-failed");
        }
        this.m_configServer.unshareConfigElement(this);
    }

    @Override
    public IConfigPrototype createPrototype(String name) throws ConfigServiceException {
        return new ConfigElementPrototype(name, this);
    }

    protected IBasicElement doneUpdate() throws ConfigServiceException {
        IBasicElement storeThis = null;
        if (this.m_name == null || this.m_name.length() == 0) {
            throw new ConfigServiceException("ce-done-update-no-name");
        }
        if (this.isNew()) {
            boolean isPrototype = this instanceof IConfigPrototype;
            IDirElement localDirElement = null;
            boolean overlay = false;
            if (this.isPrototypeInstance()) {
                localDirElement = ElementFactory.createInstanceElement((String)this.m_dirElementName, (String)this.m_type, (String)this.m_version, (String)this.getPrototype().getName());
                ((ConfigElementImpl)((Object)this.getPrototype())).toAttributeSet(localDirElement.getAttributes());
                overlay = true;
            } else {
                localDirElement = ElementFactory.createElement((String)this.m_dirElementName, (String)this.m_type, (String)this.m_version, (boolean)isPrototype);
            }
            this.toAttributeSet(localDirElement.getAttributes(), overlay);
            try {
                if (this.m_annotation != null && (this.isPrototypeInstance() || this instanceof IConfigPrototype)) {
                    throw new ConfigServiceException("ce-done-update-failed", new Object[]{this.m_name}, new Exception("Annotation are not supported for template and instances"));
                }
                this.addAnnotationToElement(localDirElement);
                storeThis = localDirElement.doneUpdate();
            }
            catch (Exception e) {
                throw new ConfigServiceException("ce-done-update-failed", new Object[]{this.m_name}, e);
            }
        }
        IDirElement loadedDirElement = this.m_configServer.loadDirElement(this.m_dirElementName);
        if (loadedDirElement == null) {
            throw new ConfigServiceException("ce-done-update-element-removed", new Object[]{this.m_name});
        }
        ((Identity)loadedDirElement.getIdentity()).setName(this.m_name);
        IDirElement localDirElement = ElementFactory.createElement(null, null, null);
        boolean isInstance = this.isPrototypeInstance();
        this.toAttributeSet(localDirElement.getAttributes());
        try {
            MergeUtil.mergeModifications((IDirElement)loadedDirElement, (IDirElement)localDirElement, (boolean)isInstance);
            if (this.m_annotation != null && (this.isPrototypeInstance() || this instanceof IConfigPrototype)) {
                throw new ConfigServiceException("ce-done-update-failed", new Object[]{this.m_name}, new Exception("Annotations are not supported for template and instances"));
            }
            this.addAnnotationToElement(loadedDirElement);
            storeThis = loadedDirElement.doneUpdate();
        }
        catch (Exception e) {
            throw new ConfigServiceException("ce-done-update-failed", new Object[]{this.m_name}, e);
        }
        return storeThis;
    }

    @Override
    public void refresh() throws ConfigServiceException {
        try {
            this.m_configServer.refreshElement(this);
            this.m_blob = null;
        }
        catch (ConfigServiceException e) {
            if (e.getErrorKey().equals("ce-refresh-from-dse-ce-is-null")) {
                this.setRemoved();
            }
            throw e;
        }
    }

    public Set getSubElements() throws ConfigServiceException {
        HashSet<IConfigPrototype> subElements = new HashSet<IConfigPrototype>();
        super.getSubElements(subElements);
        if (this.m_configPrototype != null) {
            subElements.add(this.m_configPrototype);
            subElements.addAll(((ConfigElementImpl)((Object)this.m_configPrototype)).getSubElements());
        }
        return subElements;
    }

    public String getDSDirectory() {
        return this.m_name != null ? this.m_name.substring(0, this.m_name.lastIndexOf("/") + 1) : null;
    }

    @Override
    public IConfigServer getConfigServer() {
        return this.m_configServer;
    }

    protected static String validateName(String name) throws ConfigServiceException {
        String error = null;
        if (name == null || name.length() <= 0) {
            error = "Cannot be an empty string";
        } else {
            if (name.charAt(0) != '/') {
                error = "Name does not begin with a '/'";
            }
            if (name.indexOf("$") == 0) {
                error = "Cannot contain '$'";
            }
            if (name.indexOf("\\") >= 0) {
                error = "Cannot contain '\\'";
            }
            if (name.indexOf("::") >= 0) {
                error = "Cannot contain '::'";
            }
            if (name.indexOf(".*.") >= 0) {
                error = "Cannot contain '.*.'";
            }
            if (name.indexOf(".#.") >= 0) {
                error = "Cannot contain '.#.'";
            }
            if (name.indexOf("<") >= 0) {
                error = "Cannot contain '<'";
            }
            if (name.indexOf(">") >= 0) {
                error = "Cannot contain '>'";
            }
            if (name.indexOf("&") >= 0) {
                error = "Cannot contain '&'";
            }
        }
        if (error != null) {
            throw new ConfigServiceException("Name is invalid: " + error);
        }
        return name;
    }

    @Override
    public IConfigPath getAttributeName() {
        return new ConfigPathImpl(this.m_name);
    }

    @Override
    public long getCreationTime() {
        return this.m_creationTime;
    }

    @Override
    public void setAnnotation(String value) {
        this.m_annotation = value;
        if (this.getState() == 1) {
            return;
        }
        this.setModified();
    }

    @Override
    public String getAnnotation() {
        return this.m_annotation;
    }

    private void addAnnotationToElement(IDirElement element) throws ConfigException {
        IAttributeSet systemAttributes = (IAttributeSet)element.getAttributes().getAttribute("_MF_SYSTEM_ATTRIBUTES");
        if (systemAttributes == null) {
            systemAttributes = element.getAttributes().createAttributeSet("_MF_SYSTEM_ATTRIBUTES");
        }
        if (this.m_annotation == null) {
            systemAttributes.deleteAttribute("TOOL_ANNOTATION");
        } else {
            systemAttributes.setStringAttribute("TOOL_ANNOTATION", "<![CDATA[" + this.m_annotation + "]]>");
        }
    }
}

