/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigPathImpl
extends Vector
implements IConfigPath {
    public static final char DEFAULT_SEPARATOR = '.';
    private static final String SUBSTITUTE = "%SUB%";
    private static final String ILL_ARG = "Component of an IConfigPath must be a String.";
    protected String[] m_path;
    protected char m_separator;
    private String m_buffer;

    public ConfigPathImpl() {
    }

    public ConfigPathImpl(IConfigPath path) {
        super((Collection)((Object)path));
    }

    public ConfigPathImpl(String[] path) {
        this.addPathElements(path);
    }

    private void addPathElements(String[] path) {
        for (int i = 0; i < path.length; ++i) {
            super.add(path[i]);
        }
    }

    public ConfigPathImpl(String path) {
        String[] components = ConfigPathImpl.split(path == null ? "" : path);
        this.addPathElements(components);
    }

    public ConfigPathImpl(AttributeName attributeName) {
        this.preparePathImpl(attributeName);
    }

    private void preparePathImpl(AttributeName attributeName) {
        super.add(attributeName.getElementName());
        for (int i = 0; i < attributeName.getComponentCount(); ++i) {
            Object obj = attributeName.getComponent(i);
            if (obj instanceof Integer) {
                super.add(((Integer)obj).toString());
                continue;
            }
            if (!(obj instanceof String)) continue;
            super.add(obj);
        }
    }

    protected ConfigPathImpl(Collection path) {
        super(path);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public IConfigPath append(String[] path) {
        for (int i = 0; i < path.length; ++i) {
            super.add(path[i]);
        }
        return this;
    }

    @Override
    public IConfigPath append(String path) {
        return this.append(ConfigPathImpl.split(path));
    }

    @Override
    public IConfigPath append(IConfigPath path) {
        this.addAll((Collection)((Object)path));
        return this;
    }

    @Override
    public IConfigPath appendPlaceholder() {
        return this.append(SUBSTITUTE);
    }

    @Override
    public IConfigPath insert(int index, String path) {
        return this.insert(index, ConfigPathImpl.split(path));
    }

    @Override
    public IConfigPath insert(int index, String[] path) {
        for (int i = 0; i < path.length; ++i) {
            super.add(index++, path[i]);
        }
        return this;
    }

    @Override
    public IConfigPath insert(int index, IConfigPath path) {
        this.addAll(index, (Collection)((Object)path));
        return this;
    }

    @Override
    public String getFirstComponent() {
        return (String)this.firstElement();
    }

    @Override
    public String getComponent(int index) {
        return (String)this.get(index);
    }

    @Override
    public void setComponent(int index, String component) {
        this.setElementAt(component, index);
    }

    @Override
    public void insertComponent(int index, String component) {
        super.insertElementAt(component, index);
    }

    @Override
    public void removeComponent(int index) {
        super.removeElementAt(index);
    }

    @Override
    public String getLastComponent() {
        return (String)this.lastElement();
    }

    @Override
    public IConfigPath substitute(String component) {
        return this.substitute(ConfigPathImpl.split(component));
    }

    @Override
    public IConfigPath substitute(String[] components) {
        ConfigPathImpl res = null;
        try {
            res = (ConfigPathImpl)this.clone();
            int j = 0;
            for (int i = 0; i < res.size(); ++i) {
                if (!res.getComponent(i).equals(SUBSTITUTE) || j >= components.length) continue;
                res.setComponent(i, components[j++]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public IConfigPath subPath(int beginIndex) {
        return new ConfigPathImpl((Collection)this.subList(beginIndex, this.size()));
    }

    @Override
    public IConfigPath subPath(int beginIndex, int endIndex) {
        return new ConfigPathImpl((Collection)this.subList(beginIndex, endIndex));
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator strings = this.iterator();
        if (strings.hasNext()) {
            buffer.append((String)strings.next());
        }
        while (strings.hasNext()) {
            buffer.append('.' + (String)strings.next());
        }
        return buffer.toString();
    }

    @Override
    public void add(int index, Object element) {
        super.add(index, this.validate(element));
    }

    @Override
    public synchronized boolean add(Object o) {
        return super.add(this.validate(o));
    }

    @Override
    public synchronized boolean addAll(Collection c) {
        Iterator components = c.iterator();
        while (components.hasNext()) {
            super.add(this.validate(components.next()));
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) {
        Iterator components = c.iterator();
        while (components.hasNext()) {
            super.add(index++, this.validate(components.next()));
        }
        return true;
    }

    public synchronized void addElement(Object obj) {
        super.addElement(this.validate(obj));
    }

    public synchronized void insertElementAt(Object obj, int index) {
        super.insertElementAt(this.validate(obj), index);
    }

    @Override
    public synchronized Object set(int index, Object element) {
        return super.set(index, this.validate(element));
    }

    public synchronized void setElementAt(Object obj, int index) {
        super.setElementAt(this.validate(obj), index);
    }

    public static final String[] split(String path) {
        StringTokenizer st = new StringTokenizer(path, new String(new char[]{'.'}));
        String[] component = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            component[i++] = st.nextToken().trim();
        }
        return component;
    }

    public AttributeName toAttributeName() {
        return this.toAttributeName(null);
    }

    AttributeName toAttributeName(IConfigElement element) {
        AttributeName attributeName = new AttributeName();
        boolean convertToNumber = false;
        for (int i = 0; i < this.size(); ++i) {
            IConfigPath subPath;
            Object value;
            String component = (String)this.elementAt(i);
            boolean nextConvert = false;
            if (element != null && (value = element.getAttribute(subPath = this.subPath(0, i))) instanceof IAttributeList) {
                nextConvert = true;
            }
            if (convertToNumber) {
                try {
                    int index = Integer.parseInt(component);
                    attributeName.setNextComponent(index);
                    convertToNumber = nextConvert;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            attributeName.setNextComponent(component);
            convertToNumber = nextConvert;
        }
        if (element != null) {
            attributeName.setElementName(element.getName());
        }
        return attributeName;
    }

    private Object validate(Object obj) {
        if (obj instanceof String) {
            return obj;
        }
        throw new IllegalArgumentException(ILL_ARG);
    }
}

