/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.impl.DSTransaction;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.EqualExpression;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.FromFolder;
import com.sonicsw.mf.common.config.query.NotEqualExpression;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.Where;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.impl.ConfigElementImpl;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.SubTxnConfigServer;
import com.sonicsw.mx.config.impl.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class TxnConfigServer
extends ConfigServer {
    protected List m_localElements = new ArrayList();
    protected List m_newElements = new ArrayList();
    protected List m_unmodifiedElements = new ArrayList();
    protected List m_modifiedElements = new ArrayList();
    protected List m_removedElements = new ArrayList();
    protected DSTransaction m_txn = (DSTransaction)this.m_ds.createTransaction();

    public TxnConfigServer(IDirectoryFileSystemService ds) throws ConfigServiceException {
        super(ds, true, false);
    }

    @Override
    public void close() throws ConfigServiceException {
        super.close();
        if (this.m_localElements != null) {
            this.m_localElements.clear();
            this.m_localElements = null;
        }
        if (this.m_newElements != null) {
            this.m_newElements.clear();
            this.m_newElements = null;
        }
        if (this.m_unmodifiedElements != null) {
            this.m_unmodifiedElements.clear();
            this.m_unmodifiedElements = null;
        }
        if (this.m_modifiedElements != null) {
            this.m_modifiedElements.clear();
            this.m_modifiedElements = null;
        }
        if (this.m_removedElements != null) {
            this.m_removedElements.clear();
            this.m_removedElements = null;
        }
        if (this.m_txn != null) {
            if (this.m_txn.getActions() != null) {
                this.m_txn.getActions().clear();
            }
            this.m_txn = null;
        }
    }

    @Override
    public boolean isTransacted() {
        return true;
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    private Set loadLocalConfigElements(Query query) throws ConfigServiceException {
        Set cache = this.m_elementCache.getObjects();
        HashSet<IConfigElement> res = new HashSet<IConfigElement>();
        From from = query.getFrom();
        Where where = query.getWhere();
        HashSet<IConfigElement> fromSet = new HashSet<IConfigElement>();
        if (from instanceof FromFolder) {
            String fromFolder = ((FromFolder)from).getFolderName();
            if (!fromFolder.endsWith("/")) {
                fromFolder = fromFolder + '/';
            }
            for (IConfigElement eCache : cache) {
                String subString;
                if (!eCache.getName().startsWith(fromFolder) || (subString = eCache.getName().substring(fromFolder.length())).indexOf(47) != -1) continue;
                fromSet.add(eCache);
            }
        } else if (from instanceof FromElementType) {
            String type = ((FromElementType)from).getType();
            for (IConfigElement eCache : cache) {
                if (!(eCache instanceof IConfigBean) || !((IConfigBean)eCache).getConfigType().getName().equals(type)) continue;
                fromSet.add(eCache);
            }
        } else {
            throw new ConfigServiceException("TxnConfigServer doesn't support the '" + from.getClass().getName() + "' query construct");
        }
        for (IConfigElement eCache : fromSet) {
            if (!this.isLocalWhere(eCache, where)) continue;
            this.debugPrintln("Local Query Matched = " + eCache.getName());
            res.add(eCache);
        }
        return res;
    }

    private boolean isLocalWhere(IConfigElement element, Where where) throws ConfigServiceException {
        boolean res = false;
        if (where != null) {
            res = true;
            BooleanExpression[] exp = where.getAndChain();
            for (int i = 0; i < exp.length; ++i) {
                if (exp[i] instanceof EqualExpression) {
                    if (this.evaluateEqualExpression((EqualExpression)exp[i], element, false)) continue;
                    res = false;
                    break;
                }
                if (exp[i] instanceof NotEqualExpression) {
                    if (this.evaluateEqualExpression((EqualExpression)exp[i], element, true)) continue;
                    res = false;
                    break;
                }
                throw new ConfigServiceException("TxnConfigServer doesn't support the '" + where.getClass().getName() + "' query construct");
            }
        }
        return res;
    }

    protected boolean evaluateEqualExpression(EqualExpression expression, IConfigElement element, boolean negate) {
        IConfigPath path = ConfigFactory.createConfigPath(expression.getFirstOperand().toString());
        Object wValue = expression.getSecondOperand();
        Object oValue = element.getAttribute(path);
        if (oValue == null || oValue.getClass() != wValue.getClass() || oValue.getClass().isArray()) {
            return false;
        }
        this.debugPrintln("Local Query Compare '" + element.getName() + "', path=" + path + ", " + wValue + " = " + oValue);
        boolean res = oValue.equals(wValue);
        if (!negate && !res) {
            return false;
        }
        if (negate && res) {
            return false;
        }
        return !negate;
    }

    @Override
    public synchronized Set loadConfigElements(Query query) throws ConfigServiceException {
        HashSet res = null;
        try {
            res = super.loadConfigElements(query);
        }
        catch (Exception e) {
            this.debugPrintln("loadConfigElements failed on remote query: " + e.getMessage());
            res = new HashSet();
        }
        res.addAll(this.loadLocalConfigElements(query));
        return res;
    }

    @Override
    public Set listConfigElements(Query query) throws ConfigServiceException {
        HashSet<String> res = null;
        try {
            res = super.listConfigElements(query);
        }
        catch (Exception e) {
            this.debugPrintln("listConfigElements failed on remote query: " + e.getMessage());
            res = new HashSet<String>();
        }
        Iterator i = this.loadLocalConfigElements(query).iterator();
        while (i.hasNext()) {
            res.add(((IConfigElement)i.next()).getName());
        }
        return res;
    }

    @Override
    public void createPath(String path) throws ConfigServiceException {
        this.createFolder(path, null, true, false);
    }

    @Override
    public void createPath(String path, boolean existingOK) throws ConfigServiceException {
        this.createFolder(path, null, true, existingOK);
    }

    @Override
    public void createFolder(String folderName) throws ConfigServiceException {
        this.createFolder(folderName, null, true, true);
    }

    @Override
    public void createFolder(String path, Map metaAttributes, boolean createParentFolders) throws ConfigServiceException {
        this.createFolder(path, metaAttributes, createParentFolders, true);
    }

    protected void createFolder(String path, Map metaAttributes, boolean createParentFolders, boolean existingOK) throws ConfigServiceException {
        if (path.charAt(0) != '/') {
            throw new ConfigServiceException("cs-create-path-invalid-path", new Object[]{path});
        }
        try {
            StringTokenizer st = new StringTokenizer(path, String.valueOf('/'));
            StringBuffer buffer = new StringBuffer();
            while (st.hasMoreTokens()) {
                String subPath;
                boolean exist;
                buffer.append('/');
                buffer.append(st.nextToken());
                boolean bl = exist = st.hasMoreTokens() ? true : existingOK;
                if (!createParentFolders && st.hasMoreTokens() || !this.isCreateFolderAllowed(this.m_txn, subPath = buffer.toString(), exist)) continue;
                this.m_txn.addCreateFolder(subPath, exist);
            }
            if (metaAttributes != null && !metaAttributes.isEmpty()) {
                this.setMetaAttributes(path, metaAttributes);
            }
        }
        catch (NoSuchElementException e) {
            throw new ConfigServiceException("cs-create-path-failed", new Object[]{path}, e);
        }
    }

    @Override
    public void deleteFolder(String folderName) throws ConfigServiceException {
        this.m_txn.addDeleteFolder(folderName);
    }

    @Override
    public void storeConfigElement(IConfigElement configElement) throws ConfigServiceException {
        if (((ConfigElementImpl)configElement).m_configServer != this) {
            throw new ConfigServiceException("cs-store-ces-wrong-cs", new Object[]{configElement.getName()});
        }
        if (((ConfigElementImpl)configElement).getState() == 0) {
            this.elementAddedToTxn((ConfigElementImpl)configElement);
        }
        Set subElements = ((ConfigElementImpl)configElement).getSubElements();
        for (ConfigElementImpl subElement : subElements) {
            if (subElement.getState() != 0) continue;
            this.elementAddedToTxn(subElement);
        }
    }

    @Override
    public void storeConfigElements(IConfigElement[] configElements, String[] deleteElements) throws ConfigServiceException {
        int i;
        for (i = 0; i < configElements.length; ++i) {
            this.storeConfigElement(configElements[i]);
        }
        if (deleteElements != null) {
            for (i = 0; i < deleteElements.length; ++i) {
                this.removeConfigElement(deleteElements[i]);
            }
        }
    }

    @Override
    public void removeConfigElement(String configElementName) throws ConfigServiceException {
        this.elementRemoved(configElementName);
    }

    @Override
    public void removeConfigElements(String[] configElementNames) throws ConfigServiceException {
        for (int i = 0; i < configElementNames.length; ++i) {
            this.elementRemoved(configElementNames[i]);
        }
    }

    @Override
    public void rename(String oldName, String newName) throws ConfigServiceException {
        ConfigElementImpl configElement = (ConfigElementImpl)this.getElementCache().lookup(oldName, "");
        if (configElement != null) {
            configElement.setName(newName);
        } else {
            this.m_txn.addRename(oldName, newName);
            this.renameCacheElements(oldName, newName);
        }
    }

    @Override
    public void setMetaAttributes(String path, Map metaAttributes) throws ConfigServiceException {
        if (metaAttributes == null) {
            throw new ConfigServiceException("tcs-set-meta-attrs-is-null", new Object[]{path});
        }
        this.m_txn.addSetAttributes(path, Util.mapToHashMap(Util.combineToolMetaAttributes(metaAttributes)));
    }

    void insertCreateElement(String name, IDirElement delta, Map meta, InputStream blob, boolean isInstance) throws ConfigServiceException {
        try {
            ArrayList actions = this.m_txn.getActions();
            for (int i = 0; i < actions.size(); ++i) {
                DSTransaction.Action action = (DSTransaction.Action)actions.get(i);
                if ((!(action instanceof DSTransaction.CreateElement) || !((DSTransaction.CreateElement)action).m_element.getIdentity().getName().equals(name)) && (!(action instanceof DSTransaction.AttachBlob) || !((DSTransaction.AttachBlob)action).m_element.getIdentity().getName().equals(name))) continue;
                if (blob != null) {
                    actions.set(i, this.m_txn.createAttachBlob((IBasicElement)delta, blob));
                } else {
                    actions.set(i, this.m_txn.createCreateElement(delta));
                }
                if (meta != null) {
                    this.m_txn.addSetAttributes(delta.getIdentity().getName(), Util.mapToHashMap(Util.combineToolMetaAttributes(meta)));
                }
                return;
            }
        }
        catch (Exception e) {
            throw new ConfigServiceException("tcs-insert-create-element-failed", e);
        }
        throw new ConfigServiceException("tcs-insert-create-element-failed");
    }

    @Override
    public synchronized void commit() throws ConfigServiceException {
        this.printLists();
        try {
            int i;
            Iterator it = null;
            for (ConfigElementImpl configElement : this.m_newElements) {
                configElement.validateComplete();
                InputStream blob = configElement.m_blob != null ? configElement.m_blob : null;
                IDirElement delta = (IDirElement)configElement.doneUpdate();
                HashMap meta = configElement.isMetaAttributesModified() ? configElement.getMetaAttributes() : null;
                this.insertCreateElement(delta.getIdentity().getName(), delta, meta, blob, configElement.isPrototypeInstance());
            }
            it = this.m_modifiedElements.iterator();
            while (it.hasNext()) {
                this.addToTxn((ConfigElementImpl)it.next());
            }
            DSTransaction txn = this.adjustOrdering(this.m_txn);
            this.debugTxn(txn);
            this.m_ds.executeTransaction((IDSTransaction)txn);
            Object[] objs = this.m_newElements.toArray();
            for (i = 0; i < objs.length; ++i) {
                this.elementStored((ConfigElementImpl)objs[i]);
            }
            objs = this.m_modifiedElements.toArray();
            for (i = 0; i < objs.length; ++i) {
                this.elementStored((ConfigElementImpl)objs[i]);
            }
            objs = this.m_removedElements.toArray();
            for (i = 0; i < objs.length; ++i) {
                this.elementDeleted((ConfigElementImpl)objs[i]);
            }
            this.m_txn = (DSTransaction)this.m_ds.createTransaction();
        }
        catch (Exception e) {
            try {
                this.rollback();
            }
            catch (ConfigServiceException configServiceException) {
                // empty catch block
            }
            throw new ConfigServiceException("tcs-commit-failed", e);
        }
    }

    private void addToTxn(ConfigElementImpl configElement) throws ConfigServiceException, IOException {
        configElement.validateComplete();
        IDeltaDirElement delta = (IDeltaDirElement)configElement.doneUpdate();
        if (configElement.m_blob != null) {
            this.m_txn.addAttachBlob((IBasicElement)delta, configElement.m_blob);
        } else {
            this.m_txn.addUpdateElement(delta, true);
        }
        if (configElement.isMetaAttributesModified()) {
            Map metaAttributes = Util.combineToolMetaAttributes((Map)configElement.getMetaAttributes());
            this.m_txn.addSetAttributes(configElement.getName(), Util.mapToHashMap(metaAttributes));
        }
    }

    @Override
    public synchronized void rollback() throws ConfigServiceException {
        int i;
        Exception ex = null;
        Object[] objs = this.m_localElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            this.elementDeleted((ConfigElementImpl)objs[i]);
        }
        objs = this.m_newElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            this.elementDeleted((ConfigElementImpl)objs[i]);
        }
        objs = this.m_modifiedElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            try {
                ((ConfigElementImpl)objs[i]).refresh();
                continue;
            }
            catch (Exception e) {
                ex = e;
            }
        }
        objs = this.m_unmodifiedElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            try {
                ((ConfigElementImpl)objs[i]).refresh();
                continue;
            }
            catch (Exception e) {
                ex = e;
            }
        }
        objs = this.m_removedElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            ConfigElementImpl configElement = (ConfigElementImpl)objs[i];
            this.getElementCache().add(configElement.getName(), "", configElement);
            try {
                configElement.refresh();
                continue;
            }
            catch (Exception e) {
                ex = e;
            }
        }
        this.m_txn = (DSTransaction)this.m_ds.createTransaction();
        if (ex != null) {
            throw new ConfigServiceException("tcs-rollback-failed", ex);
        }
    }

    @Override
    public synchronized void flush() throws ConfigServiceException {
        int i;
        Object[] objs = this.m_localElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            this.elementDeleted((ConfigElementImpl)objs[i]);
        }
        objs = this.m_newElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            this.elementDeleted((ConfigElementImpl)objs[i]);
        }
        objs = this.m_modifiedElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            this.elementDeleted((ConfigElementImpl)objs[i]);
        }
        objs = this.m_unmodifiedElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            this.elementDeleted((ConfigElementImpl)objs[i]);
        }
        objs = this.m_removedElements.toArray();
        for (i = 0; i < objs.length; ++i) {
            this.elementDeleted((ConfigElementImpl)objs[i]);
        }
        this.m_txn = (DSTransaction)this.m_ds.createTransaction();
    }

    @Override
    public IConfigServer subtransaction() throws ConfigServiceException {
        return new SubTxnConfigServer(this);
    }

    @Override
    protected void elementCreated(ConfigElementImpl configElement) throws ConfigServiceException {
        this.getElementCache().add(configElement.getName(), "", configElement);
        configElement.setDirectoryElementName(configElement.getName());
        this.removeElementFromLists(configElement);
        this.m_localElements.add(configElement);
        configElement.setState((short)0);
    }

    protected void elementAddedToTxn(ConfigElementImpl configElement) throws ConfigServiceException {
        configElement.setDirectoryElementName(configElement.getName());
        this.m_txn.addCreateElement((IDirElement)configElement.doneUpdate());
        this.removeElementFromLists(configElement);
        this.m_newElements.add(configElement);
        configElement.setState((short)1);
    }

    @Override
    protected void elementLoaded(ConfigElementImpl configElement) throws ConfigServiceException {
        this.getElementCache().add(configElement.getName(), "", configElement);
        this.removeElementFromLists(configElement);
        this.m_unmodifiedElements.add(configElement);
        configElement.setDirectoryElementName(configElement.getName());
        configElement.setState((short)2);
    }

    @Override
    protected void elementStored(ConfigElementImpl configElement) throws ConfigServiceException {
        this.removeElementFromLists(configElement);
        configElement.setState((short)2);
        configElement.setDirectoryElementName(configElement.getName());
        this.m_unmodifiedElements.add(configElement);
    }

    @Override
    protected void elementRefreshed(ConfigElementImpl configElement) throws ConfigServiceException {
        this.removeElementFromLists(configElement);
        configElement.setState((short)2);
        this.m_unmodifiedElements.add(configElement);
    }

    @Override
    protected void elementModified(ConfigElementImpl configElement) throws ConfigServiceException {
        if (!configElement.isNew()) {
            this.removeElementFromLists(configElement);
            configElement.setState((short)3);
            this.m_modifiedElements.add(configElement);
        }
    }

    @Override
    protected void elementRenamed(String oldName, String newName, ConfigElementImpl configElement) throws ConfigServiceException {
        try {
            this.getElementCache().add(newName, "", configElement);
            this.getElementCache().remove(oldName, "");
            if (!configElement.isNew()) {
                this.removeElementFromLists(configElement);
                configElement.setState((short)3);
                this.m_modifiedElements.add(configElement);
                this.m_txn.addRename(oldName, newName);
            } else if (configElement.getState() == 1) {
                this.m_txn.addRename(oldName, newName);
            }
        }
        catch (Exception e) {
            throw new ConfigServiceException("tcs-element-renamed-failed", e);
        }
    }

    @Override
    protected void elementRemoved(ConfigElementImpl configElement) throws ConfigServiceException {
        this.removeElementFromLists(configElement);
        this.getElementCache().remove(configElement.getName(), "");
        configElement.setState((short)4);
        this.m_removedElements.add(configElement);
        this.m_txn.addDeleteElement(configElement.getName());
    }

    @Override
    protected void elementRemoved(String configElementName) throws ConfigServiceException {
        ConfigElementImpl configElement = (ConfigElementImpl)this.getElementCache().lookup(configElementName, "");
        if (configElement != null) {
            this.removeElementFromLists(configElement);
            this.getElementCache().remove(configElementName, "");
            configElement.setState((short)4);
            this.m_removedElements.add(configElement);
        }
        this.m_txn.addDeleteElement(configElementName);
    }

    protected void elementDeleted(String configElementName) throws ConfigServiceException {
        ConfigElementImpl configElement = (ConfigElementImpl)this.getElementCache().lookup(configElementName, "");
        if (configElement != null) {
            this.removeElementFromLists(configElement);
            this.getElementCache().remove(configElementName, "");
            configElement.setState((short)5);
        }
    }

    protected void elementDeleted(ConfigElementImpl configElement) throws ConfigServiceException {
        this.removeElementFromLists(configElement);
        this.getElementCache().remove(configElement.getName(), "");
        configElement.setState((short)5);
    }

    void removeElementFromLists(ConfigElementImpl configElement) {
        this.m_localElements.remove(configElement);
        this.m_newElements.remove(configElement);
        this.m_modifiedElements.remove(configElement);
        this.m_unmodifiedElements.remove(configElement);
        this.m_removedElements.remove(configElement);
    }

    private void debugTxn(DSTransaction txn) {
        if (!DEBUG) {
            return;
        }
        ArrayList list = txn.getActions();
        for (int i = 0; i < list.size(); ++i) {
            DSTransaction.Action action = (DSTransaction.Action)list.get(i);
            System.err.println(this.getActionString(action));
        }
    }

    private boolean isCreateFolderAllowed(DSTransaction txn, String folder, boolean okIfExisting) {
        ArrayList list = txn.getActions();
        for (int i = list.size() - 1; i >= 0; --i) {
            DSTransaction.Action action = (DSTransaction.Action)list.get(i);
            if (action instanceof DSTransaction.DeleteFolder && ((DSTransaction.DeleteFolder)action).m_folderName.equals(folder)) {
                return true;
            }
            if (action instanceof DSTransaction.CreateFolder && ((DSTransaction.CreateFolder)action).m_folderName.equals(folder)) {
                return !okIfExisting;
            }
            if (!(action instanceof DSTransaction.Rename)) continue;
            if (((DSTransaction.Rename)action).m_oldName.equals(folder)) {
                return true;
            }
            if (!((DSTransaction.Rename)action).m_newName.equals(folder)) continue;
            return !okIfExisting;
        }
        return true;
    }

    private String getActionString(DSTransaction.Action action) {
        StringBuffer sb = new StringBuffer();
        if (action instanceof DSTransaction.CreateElement) {
            DSTransaction.CreateElement a = (DSTransaction.CreateElement)action;
            sb.append("CREATE").append("(");
            sb.append(a.m_element.getIdentity().getName());
            sb.append(")");
            sb.append(".").append(a.m_element.getIdentity().getVersion());
        } else if (action instanceof DSTransaction.DeleteElement) {
            DSTransaction.DeleteElement a = (DSTransaction.DeleteElement)action;
            sb.append("DELETE").append("(");
            sb.append(a.m_elementName);
            sb.append(")");
        } else if (action instanceof DSTransaction.AttachBlob) {
            DSTransaction.AttachBlob a = (DSTransaction.AttachBlob)action;
            sb.append("ATTACH").append("(");
            sb.append(a.m_element.getIdentity().getName());
            sb.append(")");
            sb.append(".").append(a.m_element.getIdentity().getVersion());
        } else if (action instanceof DSTransaction.DetachBlob) {
            DSTransaction.DetachBlob a = (DSTransaction.DetachBlob)action;
            sb.append("DETACH").append("(");
            sb.append(a.m_delta.getIdentity().getName());
            sb.append(")");
            sb.append(".").append(a.m_delta.getIdentity().getVersion());
        } else if (action instanceof DSTransaction.UpdateElement) {
            DSTransaction.UpdateElement a = (DSTransaction.UpdateElement)action;
            sb.append("UPDATE").append("(");
            sb.append(a.m_element.getIdentity().getName());
            sb.append(")");
            sb.append(".").append(a.m_element.getIdentity().getVersion());
        } else if (action instanceof DSTransaction.CreateFolder) {
            DSTransaction.CreateFolder a = (DSTransaction.CreateFolder)action;
            sb.append("CREATE_FOLDER").append("(");
            sb.append(a.m_folderName);
            sb.append(", existingOk = ").append(a.m_existingOk);
            sb.append(")");
        } else if (action instanceof DSTransaction.DeleteFolder) {
            DSTransaction.DeleteFolder a = (DSTransaction.DeleteFolder)action;
            sb.append("DELETE_FOLDER").append("(");
            sb.append(a.m_folderName);
            sb.append(")");
        } else if (action instanceof DSTransaction.Rename) {
            DSTransaction.Rename a = (DSTransaction.Rename)action;
            sb.append("RENAME").append("(");
            sb.append(a.m_oldName).append(" > ").append(a.m_newName);
            sb.append(")");
        } else if (action instanceof DSTransaction.SetAttributes) {
            DSTransaction.SetAttributes a = (DSTransaction.SetAttributes)action;
            sb.append("SET_ATTRIBUTES").append("(").append(a.m_name).append(")");
        } else if (action instanceof DSTransaction.SubclassElement) {
            DSTransaction.SubclassElement a = (DSTransaction.SubclassElement)action;
            sb.append("SUBCLASS").append("(");
            sb.append(a.m_delta.getIdentity().getName());
            sb.append(")");
            sb.append(".").append(a.m_delta.getIdentity().getVersion());
        }
        return sb.toString();
    }

    private void printLists() {
        ConfigElementImpl ce;
        PrintStream out = System.err;
        if (!DEBUG) {
            return;
        }
        out.println("-- TRANSACTED SERVER STATE ------------------------------");
        Iterator it = this.m_localElements.iterator();
        if (it.hasNext()) {
            out.println("LOCAL:");
        }
        while (it.hasNext()) {
            ce = (ConfigElementImpl)it.next();
            out.println("    " + ce.getName());
        }
        it = this.m_newElements.iterator();
        if (it.hasNext()) {
            out.println("NEW:");
        }
        while (it.hasNext()) {
            ce = (ConfigElementImpl)it.next();
            out.println("    " + ce.getName());
        }
        it = this.m_modifiedElements.iterator();
        if (it.hasNext()) {
            out.println("MODIFIED:");
        }
        while (it.hasNext()) {
            ce = (ConfigElementImpl)it.next();
            out.println("    " + ce.getName());
        }
        it = this.m_removedElements.iterator();
        if (it.hasNext()) {
            out.println("REMOVED:");
        }
        while (it.hasNext()) {
            ce = (ConfigElementImpl)it.next();
            out.println("    " + ce.getName());
        }
        out.println("---------------------------------------------------------");
    }

    private DSTransaction adjustOrdering(DSTransaction txn) throws Exception {
        DSTransaction res = (DSTransaction)this.m_ds.createTransaction();
        ArrayList actions = txn.getActions();
        try {
            while (!actions.isEmpty()) {
                DSTransaction.Action action = (DSTransaction.Action)actions.remove(0);
                if (action instanceof DSTransaction.UpdateElement) {
                    DSTransaction.UpdateElement a = (DSTransaction.UpdateElement)action;
                    IConfigBean aBean = this.loadConfigBean(a.m_element.getIdentity().getName(), true);
                    int i = -1;
                    if (aBean != null && aBean.isPrototypeInstance()) {
                        i = this.getPrototypeIndex(res.getActions(), aBean.getPrototype().getName());
                    }
                    if (i == -1) {
                        res.addAction(action);
                        continue;
                    }
                    this.debugPrintln("TXN: adjusting instance '" + (aBean == null ? null : aBean.getName()) + "' order to " + i);
                    res.addAction(i, action);
                    continue;
                }
                res.addAction(action);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private int getPrototypeIndex(List list, String prototypeName) {
        for (int i = 0; i < list.size(); ++i) {
            DSTransaction.Action action = (DSTransaction.Action)list.get(i);
            if (!(action instanceof DSTransaction.UpdateElement)) continue;
            DSTransaction.UpdateElement a = (DSTransaction.UpdateElement)action;
            if (!a.m_element.getIdentity().getName().equals(prototypeName)) continue;
            return i;
        }
        return -1;
    }

    private DSTransaction adjustVersioning(DSTransaction txn) throws Exception {
        DSTransaction res = (DSTransaction)this.m_ds.createTransaction();
        for (DSTransaction.Action action : txn.getActions()) {
            IElementIdentity ei;
            IConfigBean bean;
            DSTransaction.UpdateElement a;
            if (action instanceof DSTransaction.UpdateElement) {
                a = (DSTransaction.UpdateElement)action;
                bean = this.loadConfigBean(a.m_element.getIdentity().getName(), true);
                if (bean.isPrototypeInstance() && this.getPrototypeIndex(this.m_txn.getActions(), bean.getPrototype().getName()) != -1 && bean.getPrototype().isModified()) {
                    ei = a.m_element.getIdentity();
                    ((ElementIdentity)ei).setVersion(((ElementIdentity)ei).getVersion() + 1L);
                }
            } else if (action instanceof DSTransaction.AttachBlob) {
                a = (DSTransaction.AttachBlob)action;
                bean = this.loadConfigBean(a.m_element.getIdentity().getName(), true);
                if (bean.isPrototypeInstance() && this.getPrototypeIndex(this.m_txn.getActions(), bean.getPrototype().getName()) != -1 && bean.getPrototype().isModified()) {
                    ei = a.m_element.getIdentity();
                    ((ElementIdentity)ei).setVersion(((ElementIdentity)ei).getVersion() + 1L);
                }
            }
            res.addAction(action);
        }
        return res;
    }
}

