/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.tools.admin;

import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFProxyException;
import com.sonicsw.mf.common.MFProxyRuntimeException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.Version;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigType;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public final class ConfigCommandLine {
    private static final String OVERRIDE = "override";
    private static final String DEFAULT_URL = "localhost";
    private static final String DEFAULT_USER = "Administrator";
    private static final String DEFAULT_PASSWORD = "Administrator";
    private static final String DEFAULT_DOMAIN = "Domain1";
    private static final String HELP_STRING = "help";
    private static final String PROMPT_WORD = "ConfigAdmin> ";
    private static volatile String[] m_arguments;
    private static boolean m_echo;
    private static boolean m_debug;
    private static volatile ConfigServerUtility m_csu;
    private Method m_commandMethod;
    private String m_inputCommand;
    private int m_argumentCount;
    private boolean m_bye = false;
    private boolean m_help = false;
    private Method m_newCommandMethod;
    private Hashtable m_commands = new Hashtable();
    private Class m_clClass = ConfigCommandLine.class;

    public ConfigCommandLine() {
        try {
            this.m_commands.put("exit", this.m_clClass.getDeclaredMethod("exit", new Class[0]));
            this.m_commands.put("bye", this.m_clClass.getDeclaredMethod("exit", new Class[0]));
            this.m_commands.put(HELP_STRING, this.m_clClass.getDeclaredMethod(HELP_STRING, new Class[0]));
            this.m_commands.put("?", this.m_clClass.getDeclaredMethod(HELP_STRING, new Class[0]));
            this.m_commands.put("connect", this.m_clClass.getDeclaredMethod("connect", new Class[0]));
            this.m_commands.put("direct-connect", this.m_clClass.getDeclaredMethod("directConnect", new Class[0]));
            this.m_commands.put("disconnect", this.m_clClass.getDeclaredMethod("disconnect", new Class[0]));
            this.m_commands.put("import-bean", this.m_clClass.getDeclaredMethod("importBean", new Class[0]));
            this.m_commands.put("import-beans", this.m_clClass.getDeclaredMethod("importBeans", new Class[0]));
            this.m_commands.put("export-bean", this.m_clClass.getDeclaredMethod("exportBean", new Class[0]));
            this.m_commands.put("export-beans", this.m_clClass.getDeclaredMethod("exportBeans", new Class[0]));
            this.m_commands.put("delete-bean", this.m_clClass.getDeclaredMethod("deleteBean", new Class[0]));
            this.m_commands.put("delete-beans", this.m_clClass.getDeclaredMethod("deleteBeans", new Class[0]));
            this.m_commands.put("list", this.m_clClass.getDeclaredMethod("list", new Class[0]));
            this.m_commands.put("import-type", this.m_clClass.getDeclaredMethod("importType", new Class[0]));
            this.m_commands.put("import-type-properties", this.m_clClass.getDeclaredMethod("importTypeProperties", new Class[0]));
            this.m_commands.put("import-ivalues", this.m_clClass.getDeclaredMethod("importInitialValues", new Class[0]));
            this.m_commands.put("delete-type", this.m_clClass.getDeclaredMethod("deleteType", new Class[0]));
            this.m_commands.put("dump-ds", this.m_clClass.getDeclaredMethod("dumpDS", new Class[0]));
            this.m_commands.put("seed-ds", this.m_clClass.getDeclaredMethod("seedDS", new Class[0]));
            this.m_commands.put("set-workspace", this.m_clClass.getDeclaredMethod("setWorkspace", new Class[0]));
            this.m_commands.put("import-file", this.m_clClass.getDeclaredMethod("importFile", new Class[0]));
            this.m_commands.put("copy-files", this.m_clClass.getDeclaredMethod("copyFiles", new Class[0]));
            this.m_commands.put("import-files", this.m_clClass.getDeclaredMethod("importFiles", new Class[0]));
            this.m_commands.put("create-folder", this.m_clClass.getDeclaredMethod("createFolder", new Class[0]));
            this.m_commands.put("delete-files", this.m_clClass.getDeclaredMethod("deleteFiles", new Class[0]));
            this.m_commands.put("echo", this.m_clClass.getDeclaredMethod("echo", new Class[0]));
            this.m_commands.put("debug", this.m_clClass.getDeclaredMethod("debug", new Class[0]));
            this.m_commands.put("rename-folder", this.m_clClass.getDeclaredMethod("renameFolder", new Class[0]));
            this.m_commands.put("rename-file", this.m_clClass.getDeclaredMethod("renameFile", new Class[0]));
            this.m_commands.put("copy-ds-files-to-container-caches", this.m_clClass.getDeclaredMethod("copyDSFilesToContainerCaches", new Class[0]));
            this.m_commands.put("modify-archive-search-path", this.m_clClass.getDeclaredMethod("modifyArchivesSearchPath", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            System.err.println(e.getMessage());
        }
    }

    public void setArguments(String[] arguments) {
        m_arguments = arguments;
    }

    public void getCommand() {
        this.getCommand(new BufferedReader(new InputStreamReader(System.in)));
    }

    public void getCommand(BufferedReader reader) {
        this.m_bye = false;
        while (!this.m_bye) {
            this.cleanInput();
            ConfigCommandLine.prompt();
            try {
                String line = reader.readLine();
                if (line == null || line.equals("exit") || line.equals("bye")) {
                    this.m_bye = true;
                    ConfigCommandLine.exit();
                }
                if (m_echo) {
                    System.out.println(line);
                    System.out.flush();
                }
                String spaceDelims = " \n\t\r";
                StringTokenizer inputTokenizer = new StringTokenizer(line, spaceDelims, true);
                boolean unbalancedQuote = false;
                while (inputTokenizer.hasMoreElements() && !this.m_help && !unbalancedQuote) {
                    String token = inputTokenizer.nextToken(spaceDelims);
                    if (spaceDelims.indexOf(token) != -1) continue;
                    int lastIndex = token.indexOf("\"");
                    if (lastIndex != -1) {
                        int countDoubleQuotes = 1;
                        while ((lastIndex = token.indexOf("\"", lastIndex + 1)) != -1) {
                            ++countDoubleQuotes;
                        }
                        if (countDoubleQuotes % 2 != 0) {
                            if (inputTokenizer.hasMoreTokens()) {
                                token = token + inputTokenizer.nextToken("\"");
                                if (inputTokenizer.hasMoreTokens() && inputTokenizer.nextToken().equals("\"")) {
                                    token = token + "\"";
                                } else {
                                    unbalancedQuote = true;
                                }
                            } else {
                                unbalancedQuote = true;
                            }
                        }
                    }
                    try {
                        if (unbalancedQuote || this.dealWithInput(token)) continue;
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        System.err.println(e.getMessage());
                    }
                }
                if (unbalancedQuote) {
                    System.err.println("UNBALANCED_QUOTES");
                    continue;
                }
                if (this.m_commandMethod == null) continue;
                try {
                    this.m_commandMethod.invoke((Object)this.m_clClass, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    this.showError(e.getTargetException());
                }
                catch (Exception e) {
                    this.showError(e);
                }
            }
            catch (IOException e) {
                System.err.println("cannot process the command " + e.getMessage());
                ConfigCommandLine.exit();
            }
        }
    }

    private boolean dealWithInput(String token) throws NoSuchMethodException {
        boolean ret = true;
        this.m_inputCommand = this.m_inputCommand == null || this.m_inputCommand.equals("") ? token : this.m_inputCommand + " " + token;
        if (this.m_argumentCount == 0) {
            this.m_newCommandMethod = (Method)this.m_commands.get(this.m_inputCommand.toLowerCase());
            if (this.m_newCommandMethod == null) {
                if (this.m_commandMethod != null) {
                    this.parseArgument(token);
                } else {
                    System.err.println("Unknown command : " + this.m_inputCommand);
                    System.err.println("  Type 'help' to view the list of available commands");
                    ret = false;
                }
            } else {
                this.m_commandMethod = this.m_newCommandMethod;
            }
        } else {
            this.parseArgument(token);
        }
        if (this.m_commandMethod == null && token.compareTo(HELP_STRING) == 0) {
            this.m_commandMethod = this.m_clClass.getDeclaredMethod(HELP_STRING, new Class[0]);
            this.m_inputCommand = this.m_inputCommand.compareTo(HELP_STRING) == 0 ? "" : this.m_inputCommand.substring(0, this.m_inputCommand.length() - 2);
            this.m_help = true;
        }
        return ret;
    }

    private void parseArgument(String token) {
        StringTokenizer firstArgTokenizer = new StringTokenizer(token, ",\"\t ", true);
        while (firstArgTokenizer.hasMoreTokens()) {
            String arg = "";
            boolean inDoubleQuotes = false;
            boolean completeToken = false;
            while (!completeToken) {
                String subToken = firstArgTokenizer.nextToken();
                if (subToken.compareTo(",") == 0) {
                    if (inDoubleQuotes) {
                        arg = arg + subToken;
                    } else {
                        completeToken = true;
                    }
                } else if (subToken.compareTo("\"") == 0) {
                    inDoubleQuotes = !inDoubleQuotes;
                    arg = arg + subToken;
                } else {
                    arg = arg + subToken;
                }
                if (firstArgTokenizer.hasMoreTokens()) continue;
                completeToken = true;
            }
            if (arg.length() <= 0) continue;
            if (arg.charAt(0) == '\"' && arg.charAt(arg.length() - 1) == '\"') {
                arg = arg.length() == 2 ? "" : arg.substring(1, arg.length() - 1);
            }
            ConfigCommandLine.m_arguments[this.m_argumentCount++] = arg;
        }
    }

    private void cleanInput() {
        m_arguments = new String[75];
        this.m_argumentCount = 0;
        this.m_commandMethod = null;
        this.m_newCommandMethod = null;
        this.m_inputCommand = "";
    }

    public static void exit() {
        System.err.println("Shutting down...");
        System.exit(0);
    }

    private void showError(Throwable e) {
        String msg = null;
        msg = e instanceof ProxyRuntimeException ? ((ProxyRuntimeException)e).getTargetException().getMessage() : e.getMessage();
        if (m_debug) {
            ConfigCommandLine.printExceptionInfo(e);
        }
        System.err.println("Error: " + msg);
    }

    private static void checkNotConnected() throws Exception {
        if (m_csu != null) {
            throw new Exception("Already connected to a domain.");
        }
    }

    private static void checkConnected() throws Exception {
        if (m_csu == null) {
            throw new Exception("Not connected to a domain.");
        }
    }

    public static void directConnect() throws Exception {
        ConfigCommandLine.checkNotConnected();
        String url = m_arguments[0];
        String domain = m_arguments[1];
        String user = m_arguments[2];
        String password = m_arguments[3];
        String timeoutStr = m_arguments[4];
        if (url == null) {
            url = "ds.xml";
        }
        if (domain == null) {
            domain = DEFAULT_DOMAIN;
        }
        System.out.println("Connecting to domain " + domain + " on " + url + " ...");
        try {
            m_csu = new ConfigServerUtility();
            if (timeoutStr != null) {
                m_csu.setRequestTimeout(new Integer(timeoutStr).intValue());
            }
            m_csu.connect(domain, url, user, password, true);
            System.out.println("    Connected to Configuration Server for domain " + domain + " on " + url);
        }
        catch (Exception e) {
            m_csu = null;
            throw e;
        }
    }

    public static void connect() throws Exception {
        ConfigCommandLine.checkNotConnected();
        String url = m_arguments[0];
        String user = m_arguments[1];
        String password = m_arguments[2];
        String domain = m_arguments[3];
        if (url == null) {
            url = DEFAULT_URL;
        }
        if (user == null) {
            user = "Administrator";
        }
        if (password == null) {
            password = "Administrator";
        }
        if (domain == null) {
            domain = DEFAULT_DOMAIN;
        }
        System.out.println("Connecting to domain " + domain + " on " + url + " ...");
        try {
            m_csu = new ConfigServerUtility();
            m_csu.connect(domain, url, user, password, true);
            System.out.println("    Connected to Configuration Server for domain " + domain + " on " + url);
        }
        catch (Exception e) {
            m_csu = null;
            throw e;
        }
    }

    public static void disconnect() throws Exception {
        ConfigCommandLine.checkConnected();
        System.out.println("Disconnecting from domain ...");
        m_csu.disconnect();
        m_csu = null;
        System.out.println("    Done");
    }

    public static void importBean() throws Exception {
        ConfigCommandLine.checkConnected();
        String filename = m_arguments[0];
        if (filename == null || filename.length() == 0) {
            throw new Exception("Filename is not specified");
        }
        boolean overwrite = false;
        if (m_arguments[1] != null && m_arguments[1].equalsIgnoreCase(OVERRIDE)) {
            overwrite = true;
        }
        IConfigBean bean = m_csu.importBean(filename, overwrite);
        System.out.println("Imported Bean ...");
        System.out.println("    name    = " + bean.getName());
        System.out.println("    type    = " + bean.getConfigType().getName());
        System.out.println("    version = " + bean.getConfigType().getVersion());
    }

    public static void importBeans() throws Exception {
        ConfigCommandLine.checkConnected();
        String fileRoot = m_arguments[0];
        if (fileRoot == null || fileRoot.length() == 0) {
            throw new Exception("File root is not specified");
        }
        boolean overwrite = false;
        if (m_arguments[1] != null && m_arguments[1].equalsIgnoreCase(OVERRIDE)) {
            overwrite = true;
        }
        m_csu.importBeanPath(fileRoot, overwrite);
        System.out.println("Checking and fixing any broken bean references...");
        m_csu.repairDanglingBeanReferences();
        System.out.println("Imported Beans...");
        System.out.println("    file root = " + fileRoot);
    }

    public static void exportBean() throws Exception {
        ConfigCommandLine.checkConnected();
        String beanName = m_arguments[0];
        if (beanName == null || beanName.length() == 0) {
            throw new Exception("Bean name is not specified");
        }
        String filename = m_arguments[1];
        if (filename == null || filename.length() == 0) {
            throw new Exception("Filename is not specified");
        }
        String xml = m_csu.exportBean(beanName, filename);
        System.out.println("Exported Bean ...");
        System.out.println("    bean name = " + beanName);
        System.out.println("    filename  = " + filename);
    }

    public static void exportBeans() throws Exception {
        ConfigCommandLine.checkConnected();
        String beanPath = m_arguments[0];
        if (beanPath == null || beanPath.length() == 0) {
            throw new Exception("Bean path is not specified");
        }
        String fileRoot = m_arguments[1];
        if (fileRoot == null || fileRoot.length() == 0) {
            throw new Exception("File root is not specified");
        }
        m_csu.exportBeanPath(beanPath, fileRoot);
        System.out.println("Exported Beans...");
        System.out.println("    bean path = " + beanPath);
        System.out.println("    file root = " + fileRoot);
    }

    public static void deleteBean() throws Exception {
        ConfigCommandLine.checkConnected();
        String beanName = m_arguments[0];
        if (beanName == null || beanName.length() == 0) {
            throw new Exception("Bean name is not specified");
        }
        m_csu.deleteBean(beanName);
        System.out.println("Deleted Bean ...");
        System.out.println("    name = " + beanName);
    }

    public static void deleteBeans() throws Exception {
        ConfigCommandLine.checkConnected();
        String beanRoot = m_arguments[0];
        if (beanRoot == null || beanRoot.length() == 0) {
            throw new Exception("Bean root is not specified");
        }
        m_csu.deleteBeanPath(beanRoot);
        System.out.println("Deleted Beans...");
        System.out.println("    bean root = " + beanRoot);
    }

    public static void importType() throws Exception {
        ConfigCommandLine.checkConnected();
        String documentURL = m_arguments[0];
        String namespaceURI = m_arguments[1];
        if (documentURL == null || documentURL.length() == 0) {
            throw new Exception("Document URL is not specified");
        }
        if (namespaceURI == null || namespaceURI.length() == 0) {
            throw new Exception("Namespace URI is not specified");
        }
        boolean overwrite = false;
        if (m_arguments[2] != null && m_arguments[2].equalsIgnoreCase(OVERRIDE)) {
            overwrite = true;
        }
        IConfigType[] types = m_csu.importType(documentURL, namespaceURI, overwrite);
        System.out.println("Imported Type ...");
        for (int i = 0; i < types.length; ++i) {
            System.out.println("    type = " + types[i].getName() + " version = " + types[i].getVersion());
        }
    }

    public static void importTypeProperties() throws Exception {
        ConfigCommandLine.checkConnected();
        String documentURL = m_arguments[0];
        String namespaceURI = m_arguments[1];
        String path = m_arguments[2];
        if (documentURL == null || documentURL.length() == 0) {
            throw new Exception("Document URL is not specified");
        }
        if (namespaceURI == null || namespaceURI.length() == 0) {
            throw new Exception("Namespace URI is not specified");
        }
        if (path == null || path.length() == 0) {
            throw new Exception("Path is not specified");
        }
        m_csu.importTypeProperties(documentURL, namespaceURI, path);
    }

    public static void importInitialValues() throws Exception {
        ConfigCommandLine.checkConnected();
        String documentURL = m_arguments[0];
        if (documentURL == null || documentURL.length() == 0) {
            throw new Exception("Document URL is not specified");
        }
        IConfigType type = m_csu.importInitialValues(documentURL);
        System.out.println("Imported initial values for '" + type.getName() + "', v" + type.getVersion());
    }

    public static void list() throws Exception {
        ConfigCommandLine.checkConnected();
        String path = m_arguments[0];
        if (path == null || path.length() == 0) {
            path = "/";
        }
        String[] ret = m_csu.listConfigElements(path);
        System.out.println("Listing for path " + path + " ...");
        for (int i = 0; i < ret.length; ++i) {
            System.out.println("    " + ret[i]);
        }
    }

    public static void deleteType() throws Exception {
        ConfigCommandLine.checkConnected();
        String name = m_arguments[0];
        String version = m_arguments[1];
        if (name == null || name.length() == 0) {
            throw new Exception("Name is not specified");
        }
        if (version == null || version.length() == 0) {
            throw new Exception("Version is not specified");
        }
        m_csu.deleteType(name, version);
        System.out.println("Deleted Type ...");
        System.out.println("    type    = " + name);
        System.out.println("    version = " + version);
    }

    public static void dumpDS() throws Exception {
        ConfigCommandLine.checkConnected();
        String path = m_arguments[0];
        if (path == null || path.length() == 0) {
            throw new Exception("Path is not specified");
        }
        String output = m_arguments[1];
        if (output == null || output.length() == 0) {
            throw new Exception("Output location is not specified");
        }
        m_csu.dumpDirectoryService(path, output);
        System.out.println("Dump DS complete...");
        System.out.println("    path   = " + path);
        System.out.println("    output = " + output);
    }

    public static void seedDS() throws Exception {
        ConfigCommandLine.checkConnected();
        String file = m_arguments[0];
        if (file == null || file.length() == 0) {
            throw new Exception("File is not specified");
        }
        m_csu.seedDirectoryService(file);
        System.out.println("Seed DS complete...");
        System.out.println("    file = " + file);
    }

    public static void setWorkspace() throws Exception {
        ConfigCommandLine.checkConnected();
        String path = m_arguments[0];
        if (path == null || path.length() == 0) {
            throw new Exception("Path is not specified");
        }
        m_csu.setDSHandlerWorkspace(path);
        System.out.println("Workspace location set to: " + path);
    }

    public static void deletePlugin() throws Exception {
        ConfigCommandLine.checkConnected();
        String name = m_arguments[0];
        if (name == null || name.length() == 0) {
            throw new Exception("Name is not specified");
        }
        m_csu.deletePlugin(name);
    }

    public static void importFile() throws Exception {
        ConfigCommandLine.checkConnected();
        String path = m_arguments[0];
        if (path == null || path.length() == 0) {
            throw new Exception("Path is not specified");
        }
        String filename = m_arguments[1];
        if (filename == null || filename.length() == 0) {
            throw new Exception("Filename is not specified");
        }
        m_csu.importFile(path, filename, true);
        System.out.println("Import file complete...");
        System.out.println("    path     = " + path);
        System.out.println("    filename = " + filename);
    }

    public static void renameFolder() throws Exception {
        ConfigCommandLine.checkConnected();
        String oldPath = m_arguments[0];
        String newPath = m_arguments[1];
        m_csu.renameFolder(oldPath, newPath);
        System.out.println("Rename-folder complete...");
        System.out.println("    Old path     = " + oldPath);
        System.out.println("    New  path = " + newPath);
    }

    public static void copyDSFilesToContainerCaches() throws Exception {
        ConfigCommandLine.checkConnected();
        String dsPath = m_arguments[0];
        String allContainersOrListFile = m_arguments[1];
        String exclude = m_arguments[2];
        if (dsPath == null || dsPath.length() == 0) {
            throw new Exception("Directory Service path was not specified");
        }
        if (allContainersOrListFile == null || allContainersOrListFile.length() == 0) {
            throw new Exception("A container list file or the 'all-containers' phrase were not specified");
        }
        boolean allContainers = allContainersOrListFile.equalsIgnoreCase("all-containers");
        boolean excludeContainers = false;
        if (exclude != null && exclude.equalsIgnoreCase("exclude")) {
            excludeContainers = true;
        }
        m_csu.copyDSFilesToContainerCaches(dsPath, allContainers, excludeContainers, allContainers ? "" : allContainersOrListFile);
        System.out.println("Copy ds files to container caches complete...");
        System.out.println("    Directory Service path     = " + dsPath);
        System.out.println("    All the containers     = " + allContainers);
        System.out.println("    Exclude containers     = " + excludeContainers);
        if (!allContainers) {
            System.out.println("    Containers list file     = " + allContainersOrListFile);
        }
    }

    public static void modifyArchivesSearchPath() throws Exception {
        ConfigCommandLine.checkConnected();
        String newSearchPath = m_arguments[0];
        String allContainersOrListFile = m_arguments[1];
        String exclude = m_arguments[2];
        if (newSearchPath == null || newSearchPath.length() == 0) {
            throw new Exception("A new search path was not specified");
        }
        if (allContainersOrListFile == null || allContainersOrListFile.length() == 0) {
            throw new Exception("A container list file or the 'all-containers' phrase were not specified");
        }
        boolean allContainers = allContainersOrListFile.equalsIgnoreCase("all-containers");
        boolean excludeContainers = false;
        if (exclude != null && exclude.equalsIgnoreCase("exclude")) {
            excludeContainers = true;
        }
        m_csu.modifyArchivesSearchPath(newSearchPath, allContainers, excludeContainers, allContainers ? "" : allContainersOrListFile);
        System.out.println("Archives search path modification complete...");
        System.out.println("    New search path     = " + newSearchPath);
        System.out.println("    All the containers     = " + allContainers);
        System.out.println("    Exclude containers     = " + excludeContainers);
        if (!allContainers) {
            System.out.println("    Containers list file     = " + allContainersOrListFile);
        }
    }

    public static void renameFile() throws Exception {
        ConfigCommandLine.checkConnected();
        String oldPath = m_arguments[0];
        String newPath = m_arguments[1];
        m_csu.renameFile(oldPath, newPath);
        System.out.println("Rename-file complete...");
        System.out.println("    Old path     = " + oldPath);
        System.out.println("    New  path = " + newPath);
    }

    public static void createFolder() throws Exception {
        ConfigCommandLine.checkConnected();
        String folderPath = m_arguments[0];
        if (folderPath == null || folderPath.length() == 0) {
            throw new Exception("Folder path is not specified");
        }
        m_csu.createFolder(folderPath);
        System.out.println("Folder creation complete...");
        System.out.println("    Folder path     = " + folderPath);
    }

    public static void deleteFiles() throws Exception {
        ConfigCommandLine.checkConnected();
        String path = m_arguments[0];
        if (path == null || path.length() == 0) {
            throw new Exception("Path is not specified");
        }
        m_csu.deleteFiles(path);
        System.out.println("Files deletion complete...");
        System.out.println("    Path     = " + path);
    }

    public static void copyFiles() throws Exception {
        ConfigCommandLine.checkConnected();
        String fromPath = m_arguments[0];
        if (fromPath == null || fromPath.length() == 0) {
            throw new Exception("Source path is not specified");
        }
        String toPath = m_arguments[1];
        if (toPath == null || toPath.length() == 0) {
            throw new Exception("Destination path is not specified");
        }
        m_csu.copyFiles(fromPath, toPath);
        System.out.println("Files copy complete...");
        System.out.println("    Source path     = " + fromPath);
        System.out.println("    Destination path = " + toPath);
    }

    public static void importFiles() throws Exception {
        ConfigCommandLine.checkConnected();
        String fromFSPath = m_arguments[0];
        if (fromFSPath == null || fromFSPath.length() == 0) {
            throw new Exception("File system source path is not specified");
        }
        String toDSPath = m_arguments[1];
        if (toDSPath == null || toDSPath.length() == 0) {
            throw new Exception("Directory Service destination path is not specified");
        }
        m_csu.importFiles(fromFSPath, toDSPath);
        System.out.println("Files import complete...");
        System.out.println("    File System Source path     = " + fromFSPath);
        System.out.println("    Directory Service destination path = " + toDSPath);
    }

    private static void prompt() {
        System.out.print(PROMPT_WORD);
        System.out.flush();
    }

    public static void help() {
        System.out.println("ConfigAdmin (" + Version.getVersionText() + ")");
        System.out.println("Available commands:");
        System.out.println("Connect/disconnect commands:");
        System.out.println("  connect <url> [username] [password] [domain] [request-timeout-seconds]");
        System.out.println("  disconnect");
        System.out.println("");
        System.out.println("Configuration commands:");
        System.out.println("  list <path>");
        System.out.println("  import-bean  <filename> [override]");
        System.out.println("  import-beans <fileRoot> [override]");
        System.out.println("  export-bean  <beanName> <filename>");
        System.out.println("  export-beans <beanPath> <fileRoot>");
        System.out.println("  delete-bean  <beanName>");
        System.out.println("  delete-beans <beanPath>");
        System.out.println("  import-type <filename> <namespaceURI> [override]");
        System.out.println("  import-type-properties <schema-filename> <namespaceURI> <path>");
        System.out.println("  import-ivalues <path>");
        System.out.println("  delete-type <typeName> <typeVersion>");
        System.out.println("  dump-ds <path> <filename>");
        System.out.println("  seed-ds <filename>");
        System.out.println("  set-workspace <path>");
        System.out.println("");
        System.out.println("Centralized Install and file manipulation commands:");
        System.out.println("  import-files <fromFSPath> <toDSPath>");
        System.out.println("  copy-files <fromDSPath> <toDSPath>");
        System.out.println("  create-folder <folderPath>");
        System.out.println("  delete-files <dsPath>");
        System.out.println("  rename-folder <oldPath> <newPath>");
        System.out.println("  rename-file <oldPath> <newPath>");
        System.out.println("");
        System.out.println("  copy-ds-files-to-container-caches <ds-path> <container-list-file>|all-containers [exclude]");
        System.out.println("  modify-archive-search-path <new-path> <container-list-file>|all-containers [exclude]");
        System.out.println("  Note: If the 'exclude' phrase is specified then the list of containers is used as an exclusion list");
        System.out.println("  Note: Each line of the container-list-file should contain a single container path");
        System.out.println("");
        System.out.println("Misc commands:");
        System.out.println("  debug <ON | OFF>");
        System.out.println("  echo  <ON | OFF>");
        System.out.println("  help");
        System.out.println("  exit | bye");
        System.out.println("");
        System.out.println("Deprecated commands:");
        System.out.println("  import-file <dsPath> <fsPath>");
        System.out.println();
        System.out.println("NOTE:");
        System.out.println("To use the import-type command ensure that the current working");
        System.out.println("directory is the schema root directory (e.g. <sonic install>/schema)");
    }

    public static void echo() {
        m_echo = !m_echo;
        System.out.println(m_echo ? "echo ON" : "echo OFF");
    }

    public static void debug() {
        m_debug = !m_debug;
        System.out.println(m_debug ? "debug ON" : "debug OFF");
    }

    public static void main(String[] argv) {
        ConfigCommandLine command = new ConfigCommandLine();
        int argc = argv.length;
        while (argc-- > 0) {
            if (!argv[argc].startsWith("-s")) continue;
            try {
                command.getCommand(new BufferedReader(new InputStreamReader(new FileInputStream(argv[argc + 1]))));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        command.getCommand();
    }

    private static void printExceptionInfo(Throwable e) {
        PrintWriter pw = new PrintWriter(System.err);
        ConfigCommandLine.printExceptionInfo(e, pw, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printExceptionInfo(Throwable e, PrintWriter pw, boolean isCause) {
        if (e instanceof MFProxyException && ((MFProxyException)e).getActualException() != null) {
            e = ((MFProxyException)e).getActualException();
        } else if (e instanceof MFProxyRuntimeException && ((MFProxyRuntimeException)e).getActualException() != null) {
            e = ((MFProxyRuntimeException)e).getActualException();
        } else if (e instanceof ProxyRuntimeException && ((ProxyRuntimeException)e).getTargetException() != null) {
            e = ((ProxyRuntimeException)e).getTargetException();
        }
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            if (isCause) {
                pw.print("Caused by: ");
            }
            pw.println(e);
            StackTraceElement[] trace = e.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                pw.println("\tat " + trace[i]);
            }
            pw.flush();
        }
        if (e instanceof ConfigServiceException && ((ConfigServiceException)((Object)e)).getLinkedException() != null) {
            ConfigCommandLine.printExceptionInfo(((ConfigServiceException)((Object)e)).getLinkedException(), pw, true);
        } else if (e instanceof MFProxyException && ((MFProxyException)e).getActualException() != null) {
            ConfigCommandLine.printExceptionInfo(((MFProxyException)e).getActualException(), pw, true);
        } else if (e instanceof MFException && ((MFException)e).getLinkedException() != null) {
            ConfigCommandLine.printExceptionInfo(((MFException)e).getLinkedException(), pw, true);
        } else if (e instanceof MFRuntimeException && ((MFRuntimeException)e).getLinkedException() != null) {
            ConfigCommandLine.printExceptionInfo(((MFRuntimeException)e).getLinkedException(), pw, true);
        } else if (e instanceof ReflectionException) {
            ConfigCommandLine.printExceptionInfo(((ReflectionException)e).getTargetException(), pw, true);
        } else if (e instanceof MBeanException) {
            ConfigCommandLine.printExceptionInfo(((MBeanException)e).getTargetException(), pw, true);
        } else if (e instanceof InvocationTargetException) {
            ConfigCommandLine.printExceptionInfo(((InvocationTargetException)e).getTargetException(), pw, true);
        } else if (e instanceof RuntimeOperationsException) {
            ConfigCommandLine.printExceptionInfo(((RuntimeOperationsException)e).getTargetException(), pw, true);
        } else if (e instanceof RuntimeMBeanException) {
            ConfigCommandLine.printExceptionInfo(((RuntimeMBeanException)e).getTargetException(), pw, true);
        } else if (e instanceof RuntimeErrorException) {
            ConfigCommandLine.printExceptionInfo(((RuntimeErrorException)e).getTargetError(), pw, true);
        } else if (e.getCause() != null) {
            ConfigCommandLine.printExceptionInfo(e.getCause(), pw, true);
        }
    }

    static {
        m_echo = false;
        m_debug = false;
        m_csu = null;
    }
}

