/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class MessageFormatter {
    protected static HashMap s_messageFormatters = new HashMap();
    protected Locale m_locale = null;
    protected ResourceBundle m_resourceBundle = null;
    protected boolean m_loadFailed = false;

    public MessageFormatter(Locale locale, String resourceBaseName) {
        try {
            if (locale != null) {
                this.m_resourceBundle = PropertyResourceBundle.getBundle(resourceBaseName, locale);
                this.m_locale = locale;
            }
            if (this.m_resourceBundle == null) {
                this.m_resourceBundle = PropertyResourceBundle.getBundle(resourceBaseName);
            }
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            this.m_loadFailed = true;
        }
    }

    public String format(String key, Object[] arguments) {
        String msg = null;
        if (!this.m_loadFailed) {
            try {
                msg = this.m_resourceBundle.getString(key);
                if (arguments != null) {
                    try {
                        msg = MessageFormat.format(msg, arguments);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (msg == null) {
            msg = key;
            if (arguments != null && arguments.length > 0) {
                StringBuffer str = new StringBuffer(msg);
                str.append('?');
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        str.append('&');
                    }
                    str.append(String.valueOf(arguments[i]));
                }
            }
        }
        return msg;
    }

    public static String formatMessage(String resourceBundle, String key, Object[] arguments) throws IllegalArgumentException {
        return MessageFormatter.formatMessage(null, resourceBundle, key, arguments);
    }

    public static String formatMessage(Locale locale, String resourceBundle, String key, Object[] arguments) throws IllegalArgumentException {
        if (resourceBundle == null) {
            return "";
        }
        if (key == null) {
            return "";
        }
        String bundleKey = null;
        bundleKey = locale == null ? resourceBundle : resourceBundle + locale.toString();
        MessageFormatter messageFormatter = (MessageFormatter)s_messageFormatters.get(bundleKey);
        if (messageFormatter == null) {
            messageFormatter = new MessageFormatter(locale, resourceBundle);
            s_messageFormatters.put(bundleKey, messageFormatter);
        }
        return messageFormatter.format(key, arguments);
    }
}

