/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mx.config.ConfigAttributeException;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IAttributeMetaData;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.impl.AttributeDescriptionImpl;
import com.sonicsw.mx.config.impl.AttributeMapImpl;
import com.sonicsw.mx.config.impl.AttributeMetaData;
import com.sonicsw.mx.config.impl.ConfigBeanImpl;
import com.sonicsw.mx.config.impl.ConfigElementImpl;
import com.sonicsw.mx.config.impl.ConfigPathImpl;
import com.sonicsw.mx.config.impl.ConfigReference;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.IdentityHashMap;
import com.sonicsw.mx.config.impl.IdentityOnlyConfigBeanImpl;
import com.sonicsw.mx.config.impl.Util;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AttributeListImpl
extends ArrayList
implements IAttributeList {
    protected Object m_identity = new Object();
    protected IConfigElement m_owner = null;
    protected Object m_parent = null;
    protected String m_attributeName = null;
    protected HashSet m_lists = new HashSet();
    protected HashSet m_maps = new HashSet();
    protected IdentityHashMap m_refs = new IdentityHashMap();
    protected IAttributeDescription m_attrDescription = null;
    protected ConfigServer m_configServer = null;

    protected AttributeListImpl(ConfigServer configServer) throws ConfigServiceRuntimeException {
        this.m_configServer = configServer;
    }

    protected AttributeListImpl(IAttributeDescription attrDescription) throws ConfigServiceRuntimeException {
        this.m_attrDescription = attrDescription;
        this.m_configServer = ((AttributeDescriptionImpl)attrDescription).m_configServer;
    }

    protected AttributeListImpl(com.sonicsw.mf.common.config.IAttributeList dsList, ConfigServer configServer) throws ConfigServiceRuntimeException {
        this(dsList, null, configServer);
    }

    protected AttributeListImpl(com.sonicsw.mf.common.config.IAttributeList dsList, IAttributeDescription attrDescription, ConfigServer configServer) throws ConfigServiceRuntimeException {
        this.m_attrDescription = attrDescription;
        this.m_configServer = configServer;
        int count = dsList.getCount();
        for (int i = 0; i < count; ++i) {
            Object value = dsList.getItem(i);
            this.add(i, value);
        }
    }

    public void toDSAttributeList(com.sonicsw.mf.common.config.IAttributeList dsList) throws ConfigAttributeException {
        for (int i = 0; i < this.size(); ++i) {
            this.addDSListItem(this._get(i), dsList);
        }
    }

    private void addDSListItem(Object attribute, com.sonicsw.mf.common.config.IAttributeList dsList) throws ConfigAttributeException {
        try {
            if (attribute instanceof IAttributeMap) {
                ((AttributeMapImpl)attribute).toAttributeSet(dsList.addNewAttributeSetItem());
            } else if (attribute instanceof IAttributeList) {
                ((AttributeListImpl)attribute).toDSAttributeList(dsList.addNewAttributeListItem());
            } else if (attribute instanceof String) {
                dsList.addStringItem((String)attribute);
            } else if (attribute instanceof Integer) {
                dsList.addIntegerItem((Integer)attribute);
            } else if (attribute instanceof Long) {
                dsList.addLongItem((Long)attribute);
            } else if (attribute instanceof BigDecimal) {
                dsList.addDecimalItem((BigDecimal)attribute);
            } else if (attribute instanceof Date) {
                dsList.addDateItem((Date)attribute);
            } else if (attribute instanceof Boolean) {
                dsList.addBooleanItem((Boolean)attribute);
            } else if (attribute instanceof ConfigReference) {
                dsList.addReferenceItem(new Reference(((ConfigReference)((Object)attribute)).getElementName()));
            } else if (attribute instanceof byte[]) {
                dsList.addBytesItem((byte[])attribute);
            }
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName().append(String.valueOf(this.size())), "al-add-ds-list-item-failed", e);
        }
    }

    @Override
    public Object clone() throws ConfigServiceRuntimeException {
        return this.clone(this.m_configServer);
    }

    protected Object clone(ConfigServer configServer) throws ConfigServiceRuntimeException {
        AttributeListImpl copy = (AttributeListImpl)super.clone();
        copy.m_configServer = configServer;
        copy.m_identity = new Object();
        copy.m_owner = null;
        copy.m_lists = new HashSet();
        copy.m_maps = new HashSet();
        copy.m_refs = new IdentityHashMap();
        for (int i = 0; i < this.size(); ++i) {
            copy.set(i, this._get(i));
        }
        return copy;
    }

    @Override
    public void validateComplete() throws ConfigAttributeException {
        if (this.m_attrDescription != null) {
            Iterator iterator = null;
            iterator = this.m_maps.iterator();
            while (iterator.hasNext()) {
                ((IAttributeMap)iterator.next()).validateComplete();
            }
            iterator = this.m_lists.iterator();
            while (iterator.hasNext()) {
                ((IAttributeList)iterator.next()).validateComplete();
            }
            iterator = this.m_attrDescription.getAttributeDescriptionNames().iterator();
            if (!iterator.hasNext()) {
                throw new ConfigAttributeException(this.getAttributeName(), "al-validate-complete-invalid-config-type");
            }
            String attrName = (String)iterator.next();
            IAttributeDescription attrDesc = this.m_attrDescription.getAttributeDescription(attrName);
            Object tmp = attrDesc.getProperty("mx.config.minOccurs");
            if (tmp != null && tmp instanceof Long) {
                long min = (Long)tmp;
                if ((long)this.size() < min) {
                    throw new ConfigAttributeException(this.getAttributeName(), "al-validate-complete-min-entries", new Object[]{new Integer(this.size()), new Long(min)});
                }
            }
            if ((tmp = attrDesc.getProperty("mx.config.maxOccurs")) != null && tmp instanceof Long) {
                long max = (Long)tmp;
                if (!tmp.equals(IAttributeDescription.LENGTH_UNBOUNDED) && (long)this.size() > max) {
                    throw new ConfigAttributeException(this.getAttributeName(), "al-validate-complete-max-entries", new Object[]{new Integer(this.size()), new Long(max)});
                }
            }
        }
    }

    @Override
    public void addAttribute(Object attribute) throws ConfigAttributeException {
        try {
            this.add(attribute);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public void addAttribute(int index, Object attribute) throws ConfigAttributeException {
        try {
            this.add(index, attribute);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public void setAttribute(int index, Object attribute) throws ConfigAttributeException {
        try {
            this.set(index, attribute);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(IConfigPath path, Object attribute) throws ConfigAttributeException {
        try {
            int index2;
            switch (path.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    int index2;
                    try {
                        index2 = Integer.parseInt(path.getFirstComponent());
                    }
                    catch (NumberFormatException e) {
                        throw new ConfigAttributeException(this.getAttributeName().append(path), "al-set-attr-cp-invalid-index", new Object[]{path.getFirstComponent(), this.getAttributeName()});
                    }
                    this.setAttribute(index2, attribute);
                    return;
                }
            }
            try {
                index2 = Integer.parseInt(path.getFirstComponent());
            }
            catch (NumberFormatException e) {
                throw new ConfigAttributeException(this.getAttributeName().append(path), "al-set-attr-cp-invalid-index", new Object[]{path.getFirstComponent(), this.getAttributeName()});
            }
            Object tmp = this.getAttribute(index2);
            if (tmp == null) throw new ConfigAttributeException(this.getAttributeName().append(path), "al-set-attr-cp-path-cmpnt-does-not-exist", new Object[]{this.getAttributeName().append(path.getFirstComponent())});
            if (tmp instanceof IAttributeMap) {
                ((AttributeMapImpl)tmp).setAttribute(path.subPath(1), attribute);
                return;
            } else {
                if (!(tmp instanceof IAttributeList)) throw new ConfigAttributeException(this.getAttributeName().append(path), "al-set-attr-cp-path-cmpnt-not-collection", new Object[]{this.getAttributeName().append(path.getFirstComponent())});
                ((AttributeListImpl)tmp).setAttribute(path.subPath(1), attribute);
            }
            return;
        }
        catch (ConfigAttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName().append(path), "al-set-attr-cp-failed", new Object[]{this.getAttributeName().append(path.getFirstComponent())}, e);
        }
    }

    @Override
    public Object getAttribute(int index) {
        return this.get(index);
    }

    @Override
    public IAttributeMetaData getAttributeMetaData(int index) {
        if (this.m_parent instanceof IConfigPrototype) {
            return AttributeMetaData.s_isFromPrototype;
        }
        return AttributeMetaData.s_isFromConfigBean;
    }

    @Override
    public Object getAttribute(IConfigPath path) {
        int index2;
        switch (path.size()) {
            case 0: {
                return null;
            }
            case 1: {
                int index2;
                try {
                    index2 = Integer.parseInt(path.getFirstComponent());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                return this.getAttribute(index2);
            }
        }
        try {
            index2 = Integer.parseInt(path.getFirstComponent());
        }
        catch (NumberFormatException e) {
            return null;
        }
        Object tmp = this.getAttribute(index2);
        if (tmp != null) {
            if (tmp instanceof IAttributeMap) {
                return ((AttributeMapImpl)tmp).getAttribute(path.subPath(1));
            }
            if (tmp instanceof IAttributeList) {
                return ((AttributeListImpl)tmp).getAttribute(path.subPath(1));
            }
        }
        return null;
    }

    @Override
    public IAttributeMetaData getAttributeMetaData(IConfigPath path) {
        switch (path.size()) {
            case 0: {
                return null;
            }
            case 1: {
                int index;
                try {
                    index = Integer.parseInt(path.getLastComponent());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                return this.getAttributeMetaData(index);
            }
        }
        Object tmp = this.getAttribute(path.subPath(0, path.size() - 1));
        if (tmp != null) {
            if (tmp instanceof IAttributeMap) {
                return ((AttributeMapImpl)tmp).getAttributeMetaData(path.getLastComponent());
            }
            if (tmp instanceof IAttributeList) {
                int index;
                try {
                    index = Integer.parseInt(path.getLastComponent());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                return ((AttributeListImpl)tmp).getAttributeMetaData(index);
            }
        }
        return null;
    }

    @Override
    public Object removeAttribute(int index) throws ConfigAttributeException {
        try {
            return this.remove(index);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public Object removeAttribute(IConfigPath path) throws ConfigAttributeException {
        try {
            int index;
            switch (path.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    try {
                        index = Integer.parseInt(path.getFirstComponent());
                    }
                    catch (NumberFormatException e) {
                        throw new ConfigAttributeException(this.getAttributeName().append(path), "al-remove-attr-cp-invalid-index", new Object[]{path.getFirstComponent(), this.getAttributeName()});
                    }
                    this.removeAttribute(index);
                }
            }
            try {
                index = Integer.parseInt(path.getFirstComponent());
            }
            catch (NumberFormatException e) {
                throw new ConfigAttributeException(this.getAttributeName().append(path), "al-remove-attr-cp-invalid-index", new Object[]{path.getFirstComponent(), this.getAttributeName()});
            }
            Object tmp = this.get(index);
            if (tmp != null) {
                if (tmp instanceof IAttributeMap) {
                    return ((AttributeMapImpl)tmp).removeAttribute(path.subPath(1));
                }
                if (tmp instanceof IAttributeList) {
                    return ((AttributeListImpl)tmp).removeAttribute(path.subPath(1));
                }
            } else {
                throw new ConfigAttributeException(this.getAttributeName().append(path), "al-remove-attr-cp-path-cmpnt-does-not-exist", new Object[]{this.getAttributeName().append(path.getFirstComponent())});
            }
            return null;
        }
        catch (ConfigAttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName().append(path), "al-remove-attr-cp-failed", new Object[]{this.getAttributeName().append(path.getFirstComponent())}, e);
        }
    }

    @Override
    public boolean removeAttribute(Object attribute) throws ConfigAttributeException {
        try {
            return this.remove(attribute);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public void addAttributes(IAttributeList attributes) throws ConfigAttributeException {
        try {
            this.addAll((Collection)attributes);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public void addAttributes(int index, IAttributeList attributes) throws ConfigAttributeException {
        try {
            this.addAll(index, (Collection)attributes);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public boolean removeAttributes(IAttributeList attributes) throws ConfigAttributeException {
        try {
            return this.removeAll((Collection)attributes);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public IAttributeDescription getAttributeDescription() {
        return this.m_attrDescription;
    }

    @Override
    public IAttributeMap createAttributeMap(String name) throws ConfigAttributeException {
        try {
            if (this.m_attrDescription != null) {
                if (name == null) {
                    throw new ConfigAttributeException(this.getAttributeName(), "al-create-am-is-null", new Object[]{name});
                }
                IAttributeDescription attrDesc = this.m_attrDescription.getAttributeDescription(name);
                if (attrDesc == null) {
                    throw new ConfigAttributeException(this.getAttributeName(), "al-create-am-not-defined", new Object[]{name});
                }
                if (attrDesc.getType() != IAttributeMap.class) {
                    throw new ConfigAttributeException(this.getAttributeName(), "al-create-am-not-map", new Object[]{name});
                }
                return new AttributeMapImpl(attrDesc);
            }
            return new AttributeMapImpl(this.m_configServer);
        }
        catch (ConfigAttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName(), "al-create-am-failed", new Object[]{name}, e);
        }
    }

    @Override
    public IAttributeList createAttributeList(String name) throws ConfigAttributeException {
        try {
            if (this.m_attrDescription != null) {
                if (name == null) {
                    throw new ConfigAttributeException(this.getAttributeName(), "al-create-al-is-null", new Object[]{name});
                }
                IAttributeDescription attrDesc = this.m_attrDescription.getAttributeDescription(name);
                if (attrDesc == null) {
                    throw new ConfigAttributeException(this.getAttributeName(), "al-create-al-not-defined", new Object[]{name});
                }
                if (attrDesc.getType() != IAttributeList.class) {
                    throw new ConfigAttributeException(this.getAttributeName(), "al-create-al-not-list", new Object[]{name});
                }
                return new AttributeListImpl(attrDesc);
            }
            return new AttributeListImpl(this.m_configServer);
        }
        catch (ConfigAttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName(), "al-create-al-failed", new Object[]{name}, e);
        }
    }

    @Override
    public final void add(int index, Object element) throws ConfigServiceRuntimeException {
        try {
            element = Util.validateAttributeValue(this.getAttributeName().append(String.valueOf(index)), element, this.m_configServer, this.m_attrDescription);
            this.setOwnership(element);
            super.add(index, element);
            if (this.m_owner != null) {
                ((ConfigElementImpl)this.m_owner).setModified();
            }
        }
        catch (ConfigAttributeException e) {
            throw new ConfigServiceRuntimeException(e);
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append(String.valueOf(index)), "al-add-failed", e));
        }
    }

    @Override
    public boolean add(Object element) throws ConfigServiceRuntimeException {
        this.add(this.size(), element);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection collection) throws ConfigServiceRuntimeException {
        Iterator values = collection.iterator();
        while (values.hasNext()) {
            this.add(index++, values.next());
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) throws ConfigServiceRuntimeException {
        Iterator values = collection.iterator();
        while (values.hasNext()) {
            this.add(values.next());
        }
        return true;
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.remove(0);
        }
    }

    public Object _get(IConfigPath path) {
        int index2;
        switch (path.size()) {
            case 0: {
                return null;
            }
            case 1: {
                int index2;
                try {
                    index2 = Integer.parseInt(path.getFirstComponent());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                return this._get(index2);
            }
        }
        try {
            index2 = Integer.parseInt(path.getFirstComponent());
        }
        catch (NumberFormatException e) {
            return null;
        }
        Object tmp = this._get(index2);
        if (tmp != null) {
            if (tmp instanceof IAttributeMap) {
                return ((AttributeMapImpl)tmp)._get(path.subPath(1));
            }
            if (tmp instanceof IAttributeList) {
                return ((AttributeListImpl)tmp)._get(path.subPath(1));
            }
        }
        return null;
    }

    public Object _get(int index) {
        return super.get(index);
    }

    @Override
    public Object get(int index) {
        try {
            Object obj = super.get(index);
            if (obj instanceof ConfigReference) {
                try {
                    obj = ((ConfigReference)((Object)obj)).getConfigElement();
                }
                catch (ConfigServiceException e) {
                    obj = e.getLinkedException() instanceof ManagementPermissionDeniedException ? IdentityOnlyConfigBeanImpl.createIdentityOnlyConfigBean(this.m_configServer, (ConfigReference)((Object)obj)) : null;
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append(String.valueOf(index)), "al-get-failed", e));
        }
    }

    @Override
    public Iterator iterator() {
        final Iterator iterator = super.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                try {
                    Object obj = iterator.next();
                    if (obj instanceof ConfigReference) {
                        try {
                            obj = ((ConfigReference)((Object)obj)).getConfigElement();
                        }
                        catch (ConfigServiceException e) {
                            obj = e.getLinkedException() instanceof ManagementPermissionDeniedException ? IdentityOnlyConfigBeanImpl.createIdentityOnlyConfigBean(AttributeListImpl.this.m_configServer, (ConfigReference)((Object)obj)) : null;
                        }
                    }
                    return obj;
                }
                catch (Exception e) {
                    throw new ConfigServiceRuntimeException(new ConfigAttributeException(AttributeListImpl.this.getAttributeName(), "al-get-failed", e));
                }
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                Object item = this.get(i);
                if (item == null || !item.equals(elem)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!this.get(i).equals(elem)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object remove(int index) throws ConfigServiceRuntimeException {
        try {
            Object obj = super.remove(index);
            this.removeOwnership(obj);
            if (this.m_owner != null) {
                ((ConfigElementImpl)this.m_owner).setModified();
            }
            if (obj instanceof ConfigReference) {
                obj = ((ConfigReference)((Object)obj)).getConfigElement();
            }
            return obj;
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append(String.valueOf(index)), "al-remove-failed", e));
        }
    }

    @Override
    public boolean remove(Object obj) {
        int index = this.indexOf(obj);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        Iterator objs = c.iterator();
        while (objs.hasNext()) {
            this.remove(objs.next());
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object set(int index, Object element) throws ConfigServiceRuntimeException {
        try {
            element = Util.validateAttributeValue(this.getAttributeName().append(String.valueOf(index)), element, this.m_configServer, this.m_attrDescription);
            this.setOwnership(element);
            Object obj = super.set(index, element);
            this.removeOwnership(obj);
            if (this.m_owner != null) {
                ((ConfigElementImpl)this.m_owner).setModified();
            }
            return obj;
        }
        catch (ConfigAttributeException e) {
            throw new ConfigServiceRuntimeException(e);
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append(String.valueOf(index)), "al-set-failed", e));
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        for (int i = 0; i < this.size(); ++i) {
            a[i] = this.get(i);
        }
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            return this.m_identity == ((AttributeListImpl)obj).m_identity;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_identity.hashCode();
    }

    protected void getSubElements(Set subElements) throws ConfigServiceException {
        for (ConfigReference ref : this.m_refs.keySet()) {
            IConfigElement element = ref.getLocalConfigElement();
            if (element == null || subElements.contains(element)) continue;
            subElements.add(element);
            ((ConfigElementImpl)element).getSubElements(subElements);
        }
        for (AttributeMapImpl map : this.m_maps) {
            map.getSubElements(subElements);
        }
        for (AttributeListImpl list : this.m_lists) {
            list.getSubElements(subElements);
        }
    }

    public Object getParent() {
        return this.m_parent;
    }

    protected void setParent(String attributeName, Object parent) throws ConfigServiceException {
        if (parent != null && !(parent instanceof AttributeMapImpl) && !(parent instanceof AttributeListImpl)) {
            throw new ConfigAttributeException(this.getAttributeName().append(attributeName), "al-set-parent-failed");
        }
        if (parent == this) {
            this.m_parent = null;
        } else {
            this.m_parent = parent;
            this.m_attributeName = attributeName;
        }
    }

    public IConfigElement getOwner() {
        return this.m_owner;
    }

    protected void setOwner(IConfigElement configElement) throws ConfigServiceException {
        if (this.m_owner != null && configElement != null) {
            new ConfigServiceException("al-set-owner-already-owned", new Object[]{configElement.getName(), this.m_owner.getName()});
        }
        for (AttributeMapImpl map : this.m_maps) {
            map.setOwner(configElement);
        }
        for (AttributeListImpl list : this.m_lists) {
            list.setOwner(configElement);
        }
        for (ConfigReference ref : this.m_refs.keySet()) {
            ref.setOwner(configElement);
        }
        this.m_owner = configElement;
    }

    private void setOwnership(Object obj) throws ConfigServiceException {
        if (obj instanceof AttributeMapImpl) {
            ((AttributeMapImpl)obj).setOwner(this.m_owner);
            ((AttributeMapImpl)obj).setParent("", this);
            this.m_maps.add(obj);
        } else if (obj instanceof AttributeListImpl) {
            ((AttributeListImpl)obj).setOwner(this.m_owner);
            ((AttributeListImpl)obj).setParent("", this);
            this.m_lists.add(obj);
        } else if (obj instanceof ConfigReference) {
            ((ConfigReference)((Object)obj)).setOwner(this.m_owner);
            this.m_refs.put(obj, obj);
        }
    }

    private void removeOwnership(Object obj) throws ConfigServiceException {
        if (obj instanceof AttributeMapImpl) {
            ((AttributeMapImpl)obj).setOwner(null);
            ((AttributeMapImpl)obj).setParent("", null);
            this.m_maps.remove(obj);
        } else if (obj instanceof AttributeListImpl) {
            ((AttributeListImpl)obj).setOwner(null);
            ((AttributeListImpl)obj).setParent("", null);
            this.m_lists.remove(obj);
        } else if (obj instanceof ConfigReference) {
            ((ConfigReference)((Object)obj)).setOwner(null);
            this.m_refs.remove(obj);
        }
    }

    @Override
    public String toString() {
        return this.toString(0, false);
    }

    public String toString(int indent, boolean isFromPrototype) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer indentBuf = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            indentBuf.append("    ");
        }
        String indentStr = indentBuf.toString();
        for (int i = 0; i < this.size(); ++i) {
            Object attrValue = this._get(i);
            String attrSource = null;
            attrSource = isFromPrototype ? ":P" : ":B";
            String className = attrValue.getClass().getName();
            String typeName = className.substring(className.lastIndexOf(".") + 1);
            if (attrValue instanceof IAttributeMap) {
                buffer.append(indentStr).append(i + "  [" + typeName + attrSource + "] =\n");
                buffer.append(indentStr).append("{\n");
                buffer.append(((AttributeMapImpl)attrValue).toString(indent + 1, isFromPrototype));
                buffer.append(indentStr).append("}\n");
                continue;
            }
            if (attrValue instanceof IAttributeList) {
                buffer.append(indentStr).append(i + "  [" + typeName + attrSource + "] =\n");
                buffer.append(indentStr).append("{\n");
                buffer.append(((AttributeListImpl)attrValue).toString(indent + 1, isFromPrototype));
                buffer.append(indentStr).append("}\n");
                continue;
            }
            buffer.append(indentStr).append(i + "  [" + typeName + attrSource + "] = " + Util.toString(attrValue) + "\n");
        }
        return buffer.toString();
    }

    @Override
    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        Iterator descIter = this.m_attrDescription.getAttributeDescriptionNames().iterator();
        if (descIter == null || !descIter.hasNext()) {
            return null;
        }
        String description = (String)descIter.next();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            String content = this.elementToString(description, iter.next());
            if (content == null) continue;
            buffer.append(content);
        }
        return buffer.toString();
    }

    private String elementToString(String name, Object value) {
        String header = "<" + name + ">";
        String footer = "</" + name + ">\r\n";
        String content = null;
        boolean crContent = false;
        if (value instanceof ConfigBeanImpl) {
            content = Util.name2Url(((ConfigBeanImpl)value).getName());
        } else if (value instanceof AttributeMapImpl) {
            content = ((AttributeMapImpl)value).toXML();
            crContent = true;
        } else if (value instanceof AttributeListImpl) {
            content = ((AttributeListImpl)value).toXML();
            crContent = true;
        } else if (!Util.isDefaultValue(name, value, this.m_attrDescription)) {
            content = Util.toString(value);
        }
        String ret = null;
        if (content != null && content.length() > 0) {
            ret = crContent ? header + "\r\n" + content + footer : header + content + footer;
        }
        return ret;
    }

    public IConfigPath getAttributeName() {
        IConfigPath attributeName = null;
        if (this.m_parent != null) {
            if (this.m_parent instanceof AttributeMapImpl) {
                attributeName = ((AttributeMapImpl)this.m_parent).getAttributeName();
                attributeName.append(this.m_attributeName);
            } else {
                attributeName = ((AttributeListImpl)this.m_parent).getAttributeName();
                int index = ((AttributeListImpl)this.m_parent).indexOf(this);
                attributeName.append(String.valueOf(index));
            }
        } else {
            attributeName = new ConfigPathImpl();
        }
        return attributeName;
    }
}

