/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mx.config.AttributeChangeFilter;
import com.sonicsw.mx.config.ConfigAttributeException;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IAttributeMetaData;
import com.sonicsw.mx.config.IConfigChangeListener;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.impl.AttributeDescriptionImpl;
import com.sonicsw.mx.config.impl.AttributeListImpl;
import com.sonicsw.mx.config.impl.AttributeMetaData;
import com.sonicsw.mx.config.impl.ConfigBeanImpl;
import com.sonicsw.mx.config.impl.ConfigElementImpl;
import com.sonicsw.mx.config.impl.ConfigPathImpl;
import com.sonicsw.mx.config.impl.ConfigReference;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.IdentityHashMap;
import com.sonicsw.mx.config.impl.IdentityOnlyConfigBeanImpl;
import com.sonicsw.mx.config.impl.Util;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AttributeMapImpl
extends HashMap
implements IAttributeMap {
    protected Object m_identity = new Object();
    protected IConfigElement m_owner = null;
    protected IConfigElement m_instanceOwner = null;
    protected Object m_parent = null;
    protected String m_attributeName = null;
    protected HashSet m_lists = new HashSet();
    protected HashSet m_maps = new HashSet();
    protected boolean m_override = false;
    protected IdentityHashMap m_refs = new IdentityHashMap();
    protected IAttributeDescription m_attrDescription = null;
    protected ConfigServer m_configServer = null;
    Values m_values = null;

    protected AttributeMapImpl(ConfigServer configServer) throws ConfigServiceRuntimeException {
        this.m_configServer = configServer;
    }

    protected AttributeMapImpl(IAttributeDescription attrDescription) throws ConfigServiceRuntimeException {
        this.m_attrDescription = attrDescription;
        this.m_configServer = ((AttributeDescriptionImpl)attrDescription).m_configServer;
    }

    protected AttributeMapImpl(IAttributeSet attrSet, ConfigServer configServer) throws ConfigServiceRuntimeException {
        this(attrSet, null, configServer, true);
    }

    protected AttributeMapImpl(IAttributeSet attrSet, IAttributeDescription attrDescription, ConfigServer configServer, boolean filterDefaults) throws ConfigServiceRuntimeException {
        this.m_attrDescription = attrDescription;
        this.m_configServer = configServer;
        HashMap attrs = attrSet.getAttributes();
        for (String key : attrs.keySet()) {
            if (attrSet.getAttributeMetaData(key).isFromTemplate()) continue;
            this.put(key, attrs.get(key), true, filterDefaults);
        }
        String[] removedAttributes = attrSet.getDeletedAttributesInThisSubclassed();
        if (removedAttributes != null) {
            for (int i = 0; i < removedAttributes.length; ++i) {
                this.put(removedAttributes[i], new RemovedAttribute(), true, true);
            }
        }
    }

    protected AttributeMapImpl(AttributeMapImpl attrMap) throws ConfigServiceRuntimeException {
        this.m_configServer = attrMap.m_configServer;
        this.putAll((Map)attrMap);
    }

    public void toAttributeSet(IAttributeSet set) throws ConfigAttributeException {
        this.toAttributeSet(set, false);
    }

    public void toAttributeSet(IAttributeSet set, boolean overlay) throws ConfigAttributeException {
        String key = null;
        Iterator it = super.keySet().iterator();
        try {
            while (it.hasNext()) {
                key = (String)it.next();
                Object value = this._get(key);
                this.setDSAttribute(key, value, set, overlay);
            }
        }
        catch (ConfigAttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName().append(key), "am-to-attr-set-failed", e);
        }
    }

    private void setDSAttribute(String key, Object value, IAttributeSet dsSet, boolean overlay) throws ConfigAttributeException {
        block17: {
            if (value == null) {
                throw new ConfigAttributeException(this.getAttributeName().append(key), "am-set-ds-attr-is-null");
            }
            try {
                if (value instanceof IAttributeMap) {
                    Object tmp = dsSet.getAttribute(key);
                    if (tmp != null && tmp instanceof IAttributeSet && overlay) {
                        ((AttributeMapImpl)value).toAttributeSet((IAttributeSet)tmp, true);
                    } else {
                        ((AttributeMapImpl)value).toAttributeSet(dsSet.createAttributeSet(key));
                    }
                    break block17;
                }
                if (value instanceof IAttributeList) {
                    ((AttributeListImpl)value).toDSAttributeList(dsSet.createAttributeList(key));
                    break block17;
                }
                if (value instanceof String) {
                    dsSet.setStringAttribute(key, (String)value);
                    break block17;
                }
                if (value instanceof Integer) {
                    dsSet.setIntegerAttribute(key, (Integer)value);
                    break block17;
                }
                if (value instanceof Long) {
                    dsSet.setLongAttribute(key, (Long)value);
                    break block17;
                }
                if (value instanceof BigDecimal) {
                    dsSet.setDecimalAttribute(key, new BigDecimal(value.toString()));
                    break block17;
                }
                if (value instanceof Date) {
                    dsSet.setDateAttribute(key, (Date)value);
                    break block17;
                }
                if (value instanceof Boolean) {
                    dsSet.setBooleanAttribute(key, (Boolean)value);
                    break block17;
                }
                if (value instanceof ConfigReference) {
                    dsSet.setReferenceAttribute(key, new Reference(((ConfigReference)((Object)value)).getElementName()));
                    break block17;
                }
                if (value instanceof byte[]) {
                    dsSet.setBytesAttribute(key, (byte[])value);
                    break block17;
                }
                if (value instanceof RemovedAttribute) {
                    dsSet.mergeUtilHint_markAttributeDeleted(key);
                    break block17;
                }
                throw new ConfigAttributeException(this.getAttributeName().append(key), "am-set-ds-attr-invalid-value", new Object[]{value.getClass().getName()});
            }
            catch (ConfigAttributeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigAttributeException(this.getAttributeName().append(key), "am-set-ds-attr-failed", e);
            }
        }
    }

    @Override
    public Object clone() throws ConfigServiceRuntimeException {
        return this.clone(this.m_configServer);
    }

    protected Object clone(ConfigServer configServer) throws ConfigServiceRuntimeException {
        AttributeMapImpl copy = (AttributeMapImpl)super.clone();
        copy._clearMap();
        try {
            copy.m_configServer = configServer;
            copy.m_identity = new Object();
            copy.m_owner = null;
            copy.m_instanceOwner = this.m_owner;
            copy.m_lists = new HashSet();
            copy.m_maps = new HashSet();
            copy.m_refs = new IdentityHashMap();
            for (String iKey : this._keySet()) {
                copy.put(iKey, this._get(iKey));
            }
        }
        catch (Exception e) {
            ConfigServiceRuntimeException we = new ConfigServiceRuntimeException("Failed to clone");
            we.setLinkedException(e);
            throw we;
        }
        return copy;
    }

    @Override
    public final void validateComplete() throws ConfigAttributeException {
        if (this.m_attrDescription != null) {
            Iterator iterator = null;
            iterator = this.m_maps.iterator();
            while (iterator.hasNext()) {
                ((IAttributeMap)iterator.next()).validateComplete();
            }
            iterator = this.m_lists.iterator();
            while (iterator.hasNext()) {
                ((IAttributeList)iterator.next()).validateComplete();
            }
            if (this.m_attrDescription.getProperty("mx.config.unenumMap") == null) {
                for (String attrName : this.m_attrDescription.getAttributeDescriptionNames()) {
                    Object tmp;
                    IAttributeDescription attrDesc = this.m_attrDescription.getAttributeDescription(attrName);
                    Object attrValue = super.get(attrName);
                    if (attrValue == null && this.getProtoMap() != null) {
                        attrValue = ((AttributeMapImpl)this.getProtoMap())._get(attrName);
                    }
                    if (attrValue != null && !(attrValue instanceof RemovedAttribute) || (tmp = attrDesc.getProperty("mx.config.minOccurs")) == null || !(tmp instanceof Long) || (Long)tmp <= 0L) continue;
                    if (attrDesc.getType() == IAttributeMap.class) {
                        IAttributeMap attrMap = this.createAttributeMap(attrName);
                        this.setAttribute(attrName, (Object)attrMap);
                        attrMap = (IAttributeMap)this._get(attrName);
                        attrMap.validateComplete();
                        continue;
                    }
                    if (attrDesc.getType() == IAttributeList.class) {
                        IAttributeList attrList = this.createAttributeList(attrName);
                        this.setAttribute(attrName, (Object)attrList);
                        attrList = (IAttributeList)this._get(attrName);
                        attrList.validateComplete();
                        continue;
                    }
                    tmp = attrDesc.getProperty("mx.config.fixed");
                    if (tmp != null) {
                        this.setAttribute(attrName, tmp);
                        continue;
                    }
                    tmp = attrDesc.getProperty("mx.config.default");
                    if (tmp != null) continue;
                    throw new ConfigAttributeException(this.getAttributeName(), "am-validate-complete-req-attr-missing", new Object[]{attrName});
                }
            } else {
                iterator = this.m_attrDescription.getAttributeDescriptionNames().iterator();
                if (!iterator.hasNext()) {
                    throw new ConfigAttributeException(this.getAttributeName(), "am-validate-complete-invalid-config-type");
                }
                String attrName = (String)iterator.next();
                IAttributeDescription attrDesc = this.m_attrDescription.getAttributeDescription(attrName);
                Object tmp = attrDesc.getProperty("mx.config.minOccurs");
                if (tmp != null && tmp instanceof Long) {
                    long min = (Long)tmp;
                    if ((long)this.size() < min) {
                        throw new ConfigAttributeException(this.getAttributeName(), "am-validate-complete-min-entries", new Object[]{new Integer(this.size()), new Long(min)});
                    }
                }
                if ((tmp = attrDesc.getProperty("mx.config.maxOccurs")) != null && tmp instanceof Long) {
                    long max = (Long)tmp;
                    if (!tmp.equals(IAttributeDescription.LENGTH_UNBOUNDED) && (long)this.size() > max) {
                        throw new ConfigAttributeException(this.getAttributeName(), "am-validate-complete-max-entries", new Object[]{new Integer(this.size()), new Long(max)});
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return this.toString(0, false);
    }

    public String toString(int indent, boolean isFromPrototype) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer indentBuf = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            indentBuf.append("    ");
        }
        String indentStr = indentBuf.toString();
        for (String attrName : this.getAllAttributeNames()) {
            Object attrValue = this.getInternal(attrName);
            if (attrValue == null) continue;
            String attrSource = null;
            boolean attributeIsFromPrototype = false;
            if (isFromPrototype) {
                attrSource = ":P";
                attributeIsFromPrototype = true;
            } else {
                IAttributeMetaData metaData = this.getAttributeMetaData(attrName);
                if (metaData.isFromConfigBean()) {
                    attrSource = ":B";
                } else if (metaData.isFromPrototype()) {
                    attrSource = ":P";
                    attributeIsFromPrototype = true;
                } else {
                    attrSource = ":T";
                }
            }
            String className = attrValue.getClass().getName();
            String typeName = className.substring(className.lastIndexOf(".") + 1);
            if (attrValue instanceof IAttributeMap) {
                buffer.append(indentStr).append(attrName + "  [" + typeName + attrSource + "] =\n");
                buffer.append(indentStr).append("{\n");
                buffer.append(((AttributeMapImpl)attrValue).toString(indent + 1, attributeIsFromPrototype));
                buffer.append(indentStr).append("}\n");
                continue;
            }
            if (attrValue instanceof IAttributeList) {
                buffer.append(indentStr).append(attrName + "  [" + typeName + attrSource + "] =\n");
                buffer.append(indentStr).append("{\n");
                buffer.append(((AttributeListImpl)attrValue).toString(indent + 1, attributeIsFromPrototype));
                buffer.append(indentStr).append("}\n");
                continue;
            }
            buffer.append(indentStr).append(attrName + "  [" + typeName + attrSource + "] = " + Util.toString(attrValue) + "\n");
        }
        return buffer.toString();
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.get(attributeName);
    }

    @Override
    public IAttributeMetaData getAttributeMetaData(String attributeName) {
        if (this._get(attributeName) != null) {
            return AttributeMetaData.s_isFromConfigBean;
        }
        if (this.getProtoMap() != null && ((AttributeMapImpl)this.getProtoMap())._get(attributeName) != null) {
            return AttributeMetaData.s_isFromPrototype;
        }
        if (this.get(attributeName) != null) {
            return AttributeMetaData.s_isFromConfigType;
        }
        return null;
    }

    @Override
    public Object getAttribute(IConfigPath attributeName) {
        switch (attributeName.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.get(attributeName.getLastComponent());
            }
        }
        Object tmp = this.getFromInstanceOrTypeOnly(attributeName.getFirstComponent());
        if (tmp != null) {
            if (tmp instanceof IAttributeMap) {
                return ((AttributeMapImpl)tmp).getAttribute(attributeName.subPath(1));
            }
            if (tmp instanceof IAttributeList) {
                return ((AttributeListImpl)tmp).getAttribute(attributeName.subPath(1));
            }
        }
        return null;
    }

    @Override
    public IAttributeMetaData getAttributeMetaData(IConfigPath path) {
        switch (path.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getAttributeMetaData(path.getLastComponent());
            }
        }
        Object tmp = null;
        IAttributeMetaData metaData = this.getAttributeMetaData(path.getFirstComponent());
        if (metaData == null) {
            return null;
        }
        if (metaData.isFromPrototype()) {
            tmp = this.getAttribute(path);
            if (tmp == null) {
                return null;
            }
            return AttributeMetaData.s_isFromPrototype;
        }
        if (metaData.isFromConfigType()) {
            tmp = this.getAttribute(path);
            if (tmp == null) {
                return null;
            }
            return AttributeMetaData.s_isFromConfigType;
        }
        tmp = this.getAttribute(path.getFirstComponent());
        if (tmp != null) {
            if (tmp instanceof IAttributeMap) {
                return ((AttributeMapImpl)tmp).getAttributeMetaData(path.subPath(1));
            }
            if (tmp instanceof IAttributeList) {
                return ((AttributeListImpl)tmp).getAttributeMetaData(path.subPath(1));
            }
        }
        return null;
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) throws ConfigAttributeException {
        this.setAttribute(attributeName, attributeValue, true);
    }

    protected void setAttribute(String attributeName, Object attributeValue, boolean modify) throws ConfigAttributeException {
        try {
            this.put(attributeName, attributeValue, modify);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void setAttribute(IConfigPath attributeName, Object attributeValue) throws ConfigAttributeException {
        try {
            switch (attributeName.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.setAttribute(attributeName.getLastComponent(), attributeValue);
                    return;
                }
            }
            Object tmp = this.getFromInstanceOrTypeOnly(attributeName.getFirstComponent());
            if (tmp == null) throw new ConfigAttributeException(this.getAttributeName().append(attributeName), "am-set-attr-cp-path-cmpnt-does-not-exist", new Object[]{this.getAttributeName().append(attributeName.getFirstComponent())});
            if (tmp instanceof IAttributeMap) {
                ((AttributeMapImpl)tmp).setAttribute(attributeName.subPath(1), attributeValue);
                return;
            } else {
                if (!(tmp instanceof IAttributeList)) throw new ConfigAttributeException(this.getAttributeName().append(attributeName), "am-set-attr-cp-path-cmpnt-not-collection", new Object[]{this.getAttributeName().append(attributeName.getFirstComponent())});
                ((AttributeListImpl)tmp).setAttribute(attributeName.subPath(1), attributeValue);
            }
            return;
        }
        catch (ConfigAttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName().append(attributeName), "am-set-attr-cp-failed", new Object[]{this.getAttributeName().append(attributeName.getFirstComponent())}, e);
        }
    }

    @Override
    public Object removeAttribute(String attributeName) throws ConfigAttributeException {
        try {
            return this.remove(attributeName);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public Object removeAttribute(IConfigPath attributeName) throws ConfigAttributeException {
        try {
            switch (attributeName.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.removeAttribute(attributeName.getLastComponent());
                }
            }
            Object tmp = this.getAttribute(attributeName.getFirstComponent());
            if (tmp != null) {
                if (tmp instanceof IAttributeMap) {
                    return ((AttributeMapImpl)tmp).removeAttribute(attributeName.subPath(1));
                }
                if (tmp instanceof IAttributeList) {
                    return ((AttributeListImpl)tmp).removeAttribute(attributeName.subPath(1));
                }
            }
            return null;
        }
        catch (ConfigAttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName().append(attributeName), "am-remove-attr-cp-failed", new Object[]{this.getAttributeName().append(attributeName.getFirstComponent())}, e);
        }
    }

    @Override
    public IAttributeMap getAttributes(Set attributeNames) {
        AttributeMapImpl map = new AttributeMapImpl(this.m_configServer);
        for (String name : attributeNames) {
            map.put(name, this.get(name));
        }
        return map;
    }

    @Override
    public void setAttributes(IAttributeMap attributes) throws ConfigAttributeException {
        try {
            this.putAll((Map)attributes);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public IAttributeMap removeAttributes(Set attributeNames) throws ConfigAttributeException {
        try {
            AttributeMapImpl map = new AttributeMapImpl(this.m_configServer);
            for (String name : attributeNames) {
                Object attribute = this.remove(name);
                map.put(name, attribute);
            }
            return map;
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    @Override
    public Set getAttributeNames() {
        HashSet names = new HashSet();
        if (this.getProtoMap() != null) {
            names.addAll(this.getProtoMap().keySet());
        }
        for (Object key : super.keySet()) {
            if (this._get(key) instanceof RemovedAttribute) {
                names.remove(key);
                continue;
            }
            names.add(key);
        }
        return new NamesSet(names);
    }

    public Set getAllAttributeNames() {
        HashSet names = new HashSet();
        if (this.getProtoMap() != null) {
            names.addAll(this.getProtoMap().keySet());
        }
        for (Object key : super.keySet()) {
            names.add(key);
        }
        if (this.m_attrDescription != null) {
            names.addAll(this.m_attrDescription.getAttributeDescriptionNames());
        }
        return new NamesSet(names);
    }

    @Override
    public IAttributeDescription getAttributeDescription() {
        return this.m_attrDescription;
    }

    @Override
    public IAttributeMap createAttributeMap(String name) throws ConfigAttributeException {
        try {
            if (this.m_attrDescription != null) {
                IAttributeDescription attrDesc = null;
                if (this.m_attrDescription.getProperty("mx.config.unenumMap") != null) {
                    Iterator iterator = this.m_attrDescription.getAttributeDescriptionNames().iterator();
                    if (!iterator.hasNext()) {
                        throw new ConfigAttributeException(this.getAttributeName(), "am-create-am-not-defined", new Object[]{name});
                    }
                    String attrName = (String)iterator.next();
                    attrDesc = this.m_attrDescription.getAttributeDescription(attrName);
                } else {
                    if (name == null) {
                        throw new ConfigAttributeException(this.getAttributeName(), "am-create-am-is-null", new Object[]{name});
                    }
                    attrDesc = this.m_attrDescription.getAttributeDescription(name);
                }
                if (attrDesc == null) {
                    throw new ConfigAttributeException(this.getAttributeName(), "am-create-am-not-defined", new Object[]{name});
                }
                if (attrDesc.getType() != IAttributeMap.class) {
                    throw new ConfigAttributeException(this.getAttributeName(), "am-create-am-not-map", new Object[]{name});
                }
                return new AttributeMapImpl(attrDesc);
            }
            return new AttributeMapImpl(this.m_configServer);
        }
        catch (ConfigAttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName(), "am-create-am-failed", new Object[]{name}, e);
        }
    }

    private IAttributeList createAttributeList(String name, IAttributeList list, boolean modify) throws ConfigAttributeException {
        IAttributeList newList = this.createAttributeList(name);
        short oldState = this.m_owner != null ? (short)((ConfigElementImpl)this.m_owner).getState() : (short)-1;
        newList.addAttributes(list);
        if (modify && oldState > -1 && this.m_owner != null) {
            ((ConfigElementImpl)this.m_owner).setState(oldState);
        }
        return newList;
    }

    @Override
    public IAttributeList createAttributeList(String name) throws ConfigAttributeException {
        try {
            if (this.m_attrDescription != null) {
                if (name == null) {
                    throw new ConfigAttributeException(this.getAttributeName(), "am-create-al-is-null", new Object[]{name});
                }
                IAttributeDescription attrDesc = this.m_attrDescription.getAttributeDescription(name);
                if (attrDesc == null) {
                    throw new ConfigAttributeException(this.getAttributeName(), "am-create-al-not-defined", new Object[]{name});
                }
                if (attrDesc.getType() != IAttributeList.class) {
                    throw new ConfigAttributeException(this.getAttributeName(), "am-create-al-not-list", new Object[]{name});
                }
                return new AttributeListImpl(attrDesc);
            }
            return new AttributeListImpl(this.m_configServer);
        }
        catch (ConfigAttributeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(this.getAttributeName(), "am-create-al-failed", new Object[]{name}, e);
        }
    }

    public Object _get(Object key) {
        return super.get(key);
    }

    public Object _get(IConfigPath attributeName) {
        switch (attributeName.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this._get(attributeName.getLastComponent());
            }
        }
        Object tmp = this._get(attributeName.getFirstComponent());
        if (tmp != null) {
            if (tmp instanceof IAttributeMap) {
                return ((AttributeMapImpl)tmp)._get(attributeName.subPath(1));
            }
            if (tmp instanceof IAttributeList) {
                return ((AttributeListImpl)tmp)._get(attributeName.subPath(1));
            }
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        try {
            Object tmp;
            block8: {
                tmp = this.getInternal(key);
                if (tmp instanceof ConfigReference) {
                    try {
                        tmp = ((ConfigReference)((Object)tmp)).getConfigElement();
                    }
                    catch (ConfigServiceException e) {
                        if (e.getLinkedException() instanceof ManagementPermissionDeniedException) {
                            tmp = IdentityOnlyConfigBeanImpl.createIdentityOnlyConfigBean(this.m_configServer, (ConfigReference)((Object)tmp));
                            break block8;
                        }
                        tmp = null;
                    }
                } else if (tmp instanceof RemovedAttribute) {
                    tmp = null;
                }
            }
            return tmp;
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-get-failed", e));
        }
    }

    public Object getInternal(Object key) {
        try {
            Object tmp = super.get(key);
            if (tmp == null) {
                tmp = this.getFromPrototype(key);
            }
            if (tmp == null) {
                tmp = this.getFromType(key);
            }
            return tmp;
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-get-failed", e));
        }
    }

    protected Object getFromInstanceOrTypeOnly(Object key) {
        Object tmp = super.get(key);
        if (tmp == null) {
            tmp = this.getFromType(key);
        }
        if (tmp == null) {
            tmp = this.getFromPrototype(key);
            if (tmp instanceof IAttributeMap) {
                return tmp;
            }
            if (tmp instanceof IAttributeList) {
                return tmp;
            }
            tmp = null;
        }
        if (tmp instanceof ConfigReference) {
            try {
                tmp = ((ConfigReference)((Object)tmp)).getConfigElement();
            }
            catch (ConfigServiceException e) {
                tmp = null;
            }
        } else if (tmp instanceof RemovedAttribute) {
            tmp = null;
        }
        return tmp;
    }

    protected Object getFromPrototype(Object key) {
        try {
            Object tmp = null;
            if (this.getProtoMap() != null) {
                tmp = ((AttributeMapImpl)this.getProtoMap())._get(key);
            }
            if (tmp instanceof IAttributeMap) {
                try {
                    IAttributeMap map = this.createAttributeMap((String)key);
                    ((AttributeMapImpl)map).m_override = true;
                    this.setAttribute((String)key, map, false);
                    map = (IAttributeMap)this._get((String)key);
                    ((AttributeMapImpl)map).m_instanceOwner = this.m_instanceOwner;
                    return map;
                }
                catch (ConfigServiceException e) {
                    new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-get-failed", (Exception)((Object)e)));
                }
            } else if (tmp instanceof IAttributeList) {
                try {
                    IAttributeList list = this.createAttributeList((String)key, (IAttributeList)tmp, false);
                    this.setAttribute((String)key, list, false);
                    list = (IAttributeList)this._get((String)key);
                    return list;
                }
                catch (ConfigServiceException e) {
                    new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-get-failed", (Exception)((Object)e)));
                }
            }
            return tmp;
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-get-failed", e));
        }
    }

    protected Object getFromType(Object key) {
        try {
            IAttributeDescription attrDesc;
            Object tmp = null;
            if (key instanceof String && this.m_attrDescription != null && this.m_attrDescription.getProperty("mx.config.unenumMap") == null && (attrDesc = this.m_attrDescription.getAttributeDescription((String)key)) != null) {
                tmp = attrDesc.getProperty("mx.config.minOccurs");
                if (tmp != null && tmp instanceof Long && (Long)tmp < 1L) {
                    return null;
                }
                if (attrDesc.getType() == IAttributeMap.class) {
                    try {
                        IAttributeMap map = this.createAttributeMap((String)key);
                        this.setAttribute((String)key, map, false);
                        map = (IAttributeMap)this._get((String)key);
                        return map;
                    }
                    catch (ConfigServiceException e) {
                        new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-get-failed", (Exception)((Object)e)));
                    }
                } else if (attrDesc.getType() == IAttributeList.class) {
                    try {
                        IAttributeList list = this.createAttributeList((String)key);
                        this.setAttribute((String)key, list, false);
                        list = (IAttributeList)this._get((String)key);
                        return list;
                    }
                    catch (ConfigServiceException e) {
                        new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-get-failed", (Exception)((Object)e)));
                    }
                }
                tmp = attrDesc.getProperty("mx.config.fixed");
                if (tmp != null) {
                    return tmp;
                }
                tmp = attrDesc.getProperty("mx.config.default");
                if (tmp != null) {
                    return tmp;
                }
            }
            return tmp;
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-get-failed", e));
        }
    }

    @Override
    public void clear() {
        boolean isInstance = this.m_instanceOwner == null ? false : this.m_instanceOwner.isPrototypeInstance();
        Object[] objs = super.keySet().toArray();
        for (int i = 0; i < objs.length; ++i) {
            if (isInstance && this._get(objs[i]) instanceof RemovedAttribute) continue;
            this.remove(objs[i], isInstance);
        }
    }

    public void _clear() {
        Object[] objs = super.keySet().toArray();
        for (int i = 0; i < objs.length; ++i) {
            this.remove(objs[i], false);
        }
    }

    private void _clearMap() {
        super.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator values = this.values().iterator();
        if (value == null) {
            while (values.hasNext()) {
                if (values.next() != null) continue;
                return true;
            }
        } else {
            while (values.hasNext()) {
                Object obj = values.next();
                if (obj == null || !obj.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object put(Object key, Object value) throws ConfigServiceRuntimeException {
        return this.put(key, value, true);
    }

    protected Object put(Object key, Object value, boolean modify) throws ConfigServiceRuntimeException {
        boolean isInstance = this.m_instanceOwner != null ? this.m_instanceOwner.isPrototypeInstance() : false;
        return this.put(key, value, modify, !isInstance);
    }

    private Object put(Object key, Object value, boolean modify, boolean filterDefaults) throws ConfigServiceRuntimeException {
        try {
            Util.validateAttributeName(key);
            value = Util.validateAttributeValue(this.getAttributeName().append((String)key), value, this.m_configServer, this.m_attrDescription, filterDefaults);
            if (filterDefaults && this.m_configServer.m_filterDefaults && Util.isDefaultValue((String)key, value, this.m_attrDescription)) {
                this.removeAttribute((String)key);
                return value;
            }
            this.setOwnership((String)key, value);
            Object obj = super.put(key, value);
            this.removeOwnership(obj);
            if (this.m_owner != null && modify) {
                ((ConfigElementImpl)this.m_owner).setModified();
            }
            return obj;
        }
        catch (ConfigAttributeException e) {
            throw new ConfigServiceRuntimeException(e);
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-put-failed", e));
        }
    }

    @Override
    public final void putAll(Map mappings) throws ConfigServiceRuntimeException {
        for (Map.Entry entry : mappings.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) throws ConfigServiceRuntimeException {
        return this.remove(key, true);
    }

    protected Object remove(Object key, boolean populateRemovedAttributes) throws ConfigServiceRuntimeException {
        try {
            Object obj = null;
            obj = this.m_instanceOwner != null && this.m_instanceOwner.isPrototypeInstance() && populateRemovedAttributes ? super.put(key, new RemovedAttribute()) : (Object)super.remove(key);
            this.removeOwnership(obj);
            if (obj instanceof ConfigReference) {
                obj = ((ConfigReference)((Object)obj)).getConfigElement();
            }
            if (this.m_owner != null) {
                ((ConfigElementImpl)this.m_owner).setModified();
            }
            return obj;
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException(this.getAttributeName().append((String)key), "am-remove-failed", e));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            return this.m_identity == ((AttributeMapImpl)obj).m_identity;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_identity.hashCode();
    }

    @Override
    public Set keySet() {
        return this.getAttributeNames();
    }

    protected Set _keySet() {
        return super.keySet();
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    public int _size() {
        return super.size();
    }

    @Override
    public Collection values() {
        Values vs = this.m_values;
        return vs != null ? vs : (this.m_values = new Values());
    }

    public Object getParent() {
        return this.m_parent;
    }

    protected void setParent(String attributeName, Object parent) throws ConfigAttributeException {
        if (parent != null && !(parent instanceof AttributeMapImpl) && !(parent instanceof AttributeListImpl)) {
            throw new ConfigAttributeException(this.getAttributeName().append(attributeName), "am-set-parent-failed");
        }
        if (parent == this) {
            this.m_parent = null;
        } else {
            this.m_parent = parent;
            this.m_attributeName = attributeName;
        }
    }

    protected IAttributeMap getProtoMap() {
        IConfigPrototype prototype;
        IAttributeMap map = null;
        if (this.m_instanceOwner != null && (prototype = this.m_instanceOwner.getPrototype()) != null) {
            try {
                if (this.getAttributeName().size() == 0) {
                    return null;
                }
                map = (IAttributeMap)prototype.getAttribute(this.getAttributeName().subPath(1));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public IConfigElement getOwner() {
        return this.m_owner;
    }

    public IConfigElement getInstanceOwner() {
        return this.m_instanceOwner;
    }

    protected void getSubElements(Set subElements) throws ConfigServiceException {
        for (ConfigReference ref : this.m_refs.keySet()) {
            IConfigElement element = ref.getLocalConfigElement();
            if (element == null || subElements.contains(element)) continue;
            subElements.add(element);
            ((ConfigElementImpl)element).getSubElements(subElements);
        }
        for (AttributeMapImpl map : this.m_maps) {
            map.getSubElements(subElements);
        }
        for (AttributeListImpl list : this.m_lists) {
            list.getSubElements(subElements);
        }
    }

    protected final void setOwner(IConfigElement configElement) throws ConfigServiceException {
        if (this.m_owner != null && configElement != null) {
            new ConfigServiceException("am-set-owner-already-owned", new Object[]{configElement.getName(), this.m_owner.getName()});
        }
        for (AttributeMapImpl map : this.m_maps) {
            map.setOwner(configElement);
        }
        for (AttributeListImpl list : this.m_lists) {
            list.setOwner(configElement);
        }
        for (ConfigReference ref : this.m_refs.keySet()) {
            ref.setOwner(configElement);
        }
        this.m_owner = configElement;
        if (this.m_owner != null && this.m_owner != this.m_instanceOwner) {
            this.m_instanceOwner = this.m_owner;
        }
    }

    private void setOwnership(String attributeName, Object obj) throws ConfigServiceException {
        if (obj instanceof AttributeMapImpl) {
            ((AttributeMapImpl)obj).setOwner(this.m_owner);
            ((AttributeMapImpl)obj).setParent(attributeName, this);
            this.m_maps.add(obj);
        } else if (obj instanceof AttributeListImpl) {
            ((AttributeListImpl)obj).setOwner(this.m_owner);
            ((AttributeListImpl)obj).setParent(attributeName, this);
            this.m_lists.add(obj);
        } else if (obj instanceof ConfigReference) {
            ((ConfigReference)((Object)obj)).setOwner(this.m_owner);
            this.m_refs.put(obj, obj);
        }
    }

    private void removeOwnership(Object obj) throws ConfigServiceException {
        if (obj instanceof AttributeMapImpl) {
            if (((AttributeMapImpl)obj).m_override) {
                return;
            }
            ((AttributeMapImpl)obj).setOwner(null);
            ((AttributeMapImpl)obj).setParent(null, null);
            this.m_maps.remove(obj);
        } else if (obj instanceof AttributeListImpl) {
            ((AttributeListImpl)obj).setOwner(null);
            ((AttributeListImpl)obj).setParent(null, null);
            this.m_lists.remove(obj);
        } else if (obj instanceof ConfigReference) {
            ((ConfigReference)((Object)obj)).setOwner(null);
            this.m_refs.remove(obj);
        }
    }

    @Override
    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        for (String key : super.keySet()) {
            String content;
            if (key.equals("_MF_SYSTEM_ATTRIBUTES") || key.equals("TOOL_ANNOTATION") || (content = this.elementToString(key, this.get(key))) == null) continue;
            buffer.append(content);
        }
        return buffer.toString();
    }

    private String elementToString(String name, Object value) {
        Set descSet = this.m_attrDescription.getAttributeDescriptionNames();
        String innerName = name;
        String header = null;
        String content = null;
        String footer = null;
        if (descSet.contains(name)) {
            header = "<" + name + ">";
        } else if (descSet.size() == 1) {
            String[] names = descSet.toArray(new String[descSet.size()]);
            innerName = names[0];
            header = "<" + innerName + " name=\"" + name + "\">";
        }
        boolean crContent = false;
        if (value instanceof ConfigBeanImpl) {
            content = Util.name2Url(((ConfigBeanImpl)value).getName());
        } else if (value instanceof AttributeMapImpl) {
            content = ((AttributeMapImpl)value).toXML();
            crContent = true;
        } else if (value instanceof AttributeListImpl) {
            content = ((AttributeListImpl)value).toXML();
            crContent = true;
        } else if (!Util.isDefaultValue(name, value, this.m_attrDescription)) {
            content = Util.toString(value);
        }
        footer = "</" + innerName + ">\r\n";
        String ret = null;
        if (content != null && content.length() > 0) {
            ret = crContent ? header + "\r\n" + content + footer : header + content + footer;
        }
        return ret;
    }

    public IConfigPath getAttributeName() {
        IConfigPath attributeName = null;
        if (this.m_parent != null) {
            if (this.m_parent instanceof AttributeMapImpl) {
                attributeName = ((AttributeMapImpl)this.m_parent).getAttributeName();
                attributeName.append(new String[]{this.m_attributeName});
            } else {
                attributeName = ((AttributeListImpl)this.m_parent).getAttributeName();
                int index = ((AttributeListImpl)this.m_parent).indexOf(this);
                attributeName.append(String.valueOf(index));
            }
        } else {
            attributeName = new ConfigPathImpl();
        }
        return attributeName;
    }

    @Override
    public void addConfigChangeListener(IConfigPath attributeName, IConfigChangeListener listener, Object handback) throws ConfigServiceException {
        if (this.m_owner != null) {
            if (this.m_owner.getName() == null) {
                throw new ConfigServiceException("am-add-listener-name-null");
            }
        } else {
            throw new ConfigServiceException("am-add-listener-not-owned");
        }
        AttributeChangeFilter filter = new AttributeChangeFilter();
        filter.enableAttribute(this.getAttributeName().subPath(1).append(attributeName));
        this.m_owner.getConfigServer().addConfigChangeListener(this.m_owner.getName(), listener, filter, handback);
    }

    @Override
    public void removeConfigChangeListener(IConfigPath attributeName, IConfigChangeListener listener, Object handback) throws ConfigServiceException {
        if (this.m_owner != null) {
            if (this.m_owner.getName() == null) {
                throw new ConfigServiceException("am-remove-listener-name-null");
            }
        } else {
            throw new ConfigServiceException("am-remove-listener-not-owned");
        }
        AttributeChangeFilter filter = new AttributeChangeFilter();
        filter.enableAttribute(this.getAttributeName().subPath(1).append(attributeName));
        this.m_owner.getConfigServer().removeConfigChangeListener(this.m_owner.getName(), listener, filter, handback);
    }

    private class ValueIterator
    extends MapIterator {
        private ValueIterator() {
        }

        public Object next() {
            this.m_current = AttributeMapImpl.this.get(this.m_names.next());
            return this.m_current;
        }
    }

    private abstract class MapIterator
    implements Iterator {
        Iterator m_names = null;
        Object m_current = null;

        MapIterator() {
            this.m_names = AttributeMapImpl.this.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_names.hasNext();
        }

        @Override
        public void remove() {
            if (this.m_current == null) {
                throw new IllegalStateException();
            }
            AttributeMapImpl.this.remove(this.m_current);
            this.m_current = null;
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return AttributeMapImpl.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AttributeMapImpl.this.containsValue(o);
        }

        @Override
        public void clear() {
            AttributeMapImpl.this.clear();
        }
    }

    private class NamesIterator
    implements Iterator {
        private NamesSet m_names = null;
        private Iterator m_iterator = null;
        private Object m_current = null;

        NamesIterator(NamesSet names, Iterator iter) {
            this.m_names = names;
            this.m_iterator = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Object next() {
            this.m_current = this.m_iterator.next();
            return this.m_current;
        }

        @Override
        public void remove() {
            if (this.m_current == null) {
                throw new IllegalStateException();
            }
            this.m_iterator.remove();
            this.m_names.remove(this.m_current);
            this.m_current = null;
        }
    }

    private class NamesSet
    extends HashSet {
        public NamesSet(Set names) {
            super(names);
        }

        @Override
        public Iterator iterator() {
            return new NamesIterator(this, super.iterator());
        }

        @Override
        public boolean remove(Object o) {
            AttributeMapImpl.this.remove(o);
            return super.remove(o);
        }

        @Override
        public void clear() {
            AttributeMapImpl.this.clear();
            super.clear();
        }
    }

    public class RemovedAttribute {
        public String toString() {
            return "REMOVED_ATTRIBUTE";
        }
    }
}

