/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.tools;

import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.tools.XProperties;
import com.sonicsw.mx.config.util.ConfigHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class GenerateBean
extends ConfigServerUtility {
    private static final String DEFAULT_URL = "localhost";
    private static final String DEFAULT_USER = "Administrator";
    private static final String DEFAULT_PASSWORD = "Administrator";
    private static final String DEFAULT_DOMAIN = "Domain1";
    private static final String DEFAULT_PACKAGE = "com.sonicsw.mf.mgmtapi.config";
    private static final String DEFAULT_PREFIX = "MF";
    private ArrayList m_argList = new ArrayList();
    private String m_url = "localhost";
    private String m_user = "Administrator";
    private String m_password = "Administrator";
    private String m_domain = "Domain1";
    private String m_facPrefix = "MF";
    private String m_package = "com.sonicsw.mf.mgmtapi.config";
    private String m_output = null;
    private boolean m_impl = false;
    private boolean m_factory = false;
    private PrintWriter m_acWriter;
    private PrintWriter m_aiWriter;
    private PrintWriter m_ciWriter;
    private PrintWriter m_ucWriter;
    private PrintWriter m_uiWriter;
    private PrintWriter m_fiWriter;
    private ArrayList m_innerClasses = new ArrayList();
    private Set m_writtenConstants = new HashSet();

    public GenerateBean(String[] args) throws Exception {
        try {
            this.parseArgs(args);
        }
        catch (Exception e) {
            this.printUsage();
            throw e;
        }
        System.out.println("ConfigBean Generator");
        System.out.println();
        System.out.println("Output   : " + this.m_output);
        System.out.println("Package  : " + this.m_package);
        if (this.m_facPrefix != null) {
            System.out.println("Factory  : " + this.m_facPrefix + "MgmtBeanFactory");
        }
        System.out.println("Generate : " + (this.m_impl ? "Interfaces & Implementation" : "Interfaces ONLY"));
        System.out.println();
        System.out.println("Connection (Broker URL=" + this.m_url + ", User=" + this.m_user + ", Password=" + this.m_password + ", Domain=" + this.m_domain + ")");
        System.out.println();
        this.connect(this.m_domain, this.m_url, this.m_user, this.m_password, false);
    }

    public void generate() throws Exception {
        if (this.m_factory) {
            String fiFilename = this.m_output + File.separator + "gen" + File.separator + "Abstract" + this.m_facPrefix + "MgmtBeanFactory.java";
            this.m_fiWriter = new PrintWriter(new FileWriter(fiFilename));
            this.generateFactoryInterface();
        }
        for (int i = 0; i < this.m_argList.size(); ++i) {
            this.generate((GenerateArg)this.m_argList.get(i));
            this.m_innerClasses.clear();
            this.m_writtenConstants.clear();
        }
        if (this.m_factory) {
            this.println(this.m_fiWriter, "}");
            this.closeWriter(this.m_fiWriter);
            if (this.m_impl) {
                String fcFilename = this.m_output + File.separator + this.m_facPrefix + "MgmtBeanFactory.java";
                PrintWriter fcWriter = new PrintWriter(new FileWriter(fcFilename));
                this.generateFactoryClass(fcWriter);
                this.closeWriter(fcWriter);
            }
        }
    }

    public void generate(GenerateArg arg) throws Exception {
        IConfigType type;
        System.out.print(arg.getName() + " (" + arg.m_type + ", cV=" + arg.m_cVersion + ", pV=" + arg.m_pVersion);
        if (arg.m_template) {
            System.out.print(", Template");
        }
        if (arg.m_private) {
            System.out.print(", Private");
        }
        System.out.println(")");
        String uiFilename = this.m_output + File.separator + "I" + arg.getClassName() + "Bean.java";
        String ucFilename = this.m_output + File.separator + "impl" + File.separator + arg.getClassName() + "Bean.java";
        String aiFilename = this.m_output + File.separator + "gen" + File.separator + "IAbstract" + arg.getClassName() + "Bean.java";
        String acFilename = this.m_output + File.separator + "gen" + File.separator + "impl" + File.separator + "Abstract" + arg.getClassName() + "Bean.java";
        String ciFilename = this.m_output + File.separator + "constants" + File.separator + "I" + arg.getClassName() + "Constants.java";
        this.m_aiWriter = new PrintWriter(new FileWriter(aiFilename));
        this.m_acWriter = new PrintWriter(new FileWriter(acFilename));
        this.m_ciWriter = new PrintWriter(new FileWriter(ciFilename));
        if (this.m_impl) {
            this.m_ucWriter = new PrintWriter(new FileWriter(ucFilename));
            this.m_uiWriter = new PrintWriter(new FileWriter(uiFilename));
        }
        if ((type = this.getConfigServer().loadConfigType(arg.m_type, arg.m_cVersion)) == null) {
            throw new Exception("Failed to load config type " + arg.m_type + " " + arg.m_cVersion);
        }
        this.generateClass(arg, type);
        this.generateConstants(arg, type);
        if (this.m_factory && this.m_fiWriter != null) {
            this.generateDomain(arg, type, this.m_fiWriter);
        }
        this.closeWriter(this.m_acWriter);
        this.closeWriter(this.m_aiWriter);
        this.closeWriter(this.m_ciWriter);
        this.closeWriter(this.m_ucWriter);
        this.closeWriter(this.m_uiWriter);
    }

    private void generateClass(GenerateArg arg, IConfigType type) throws Exception {
        this.printCopywrite(this.m_aiWriter);
        this.println(this.m_aiWriter, "package " + this.m_package + ".gen;");
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, "import com.sonicsw.ma.mgmtapi.config.*;");
        this.println(this.m_aiWriter, "import " + this.m_package + ".*;");
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, "/**");
        this.println(this.m_aiWriter, " * Configuration Bean representing a '" + arg.getName() + "'");
        if (arg.getClassName().equals("GenericComponent")) {
            this.println(this.m_aiWriter, " * @deprecated");
        }
        this.println(this.m_aiWriter, " */");
        this.println(this.m_aiWriter, "public interface IAbstract" + arg.getClassName() + "Bean extends IMgmtBeanBase");
        this.println(this.m_aiWriter, "{");
        if (this.m_uiWriter != null) {
            this.printCopywrite(this.m_uiWriter);
            this.println(this.m_uiWriter, "package " + this.m_package + ";");
            this.println(this.m_uiWriter);
            this.println(this.m_uiWriter, "import " + this.m_package + ".gen.*;");
            this.println(this.m_uiWriter);
            this.println(this.m_uiWriter, "/**");
            this.println(this.m_uiWriter, " * Configuration Bean representing a '" + arg.getName() + "'");
            if (arg.getClassName().equals("GenericComponent")) {
                this.println(this.m_uiWriter, " * @deprecated");
            }
            this.println(this.m_uiWriter, " */");
            this.println(this.m_uiWriter, "public interface I" + arg.getClassName() + "Bean extends IAbstract" + arg.getClassName() + "Bean");
            this.println(this.m_uiWriter, "{");
        }
        this.printCopywrite(this.m_acWriter);
        this.println(this.m_acWriter, "package " + this.m_package + ".gen.impl;");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, "import com.sonicsw.ma.mgmtapi.config.*;");
        this.println(this.m_acWriter, "import com.sonicsw.ma.mgmtapi.config.impl.*;");
        this.println(this.m_acWriter, "import " + this.m_package + ".*;");
        this.println(this.m_acWriter, "import " + this.m_package + ".impl.*;");
        this.println(this.m_acWriter, "import " + this.m_package + ".constants.*;");
        this.println(this.m_acWriter, "import " + this.m_package + ".gen.*;");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, "public abstract class Abstract" + arg.getClassName() + "Bean");
        this.println(this.m_acWriter, "extends MgmtBeanBase implements I" + arg.getClassName() + "Constants, I" + arg.getClassName() + "Bean");
        this.println(this.m_acWriter, "{");
        this.println(this.m_acWriter, "    public Abstract" + arg.getClassName() + "Bean(MgmtBeanFactory factory)");
        this.println(this.m_acWriter, "    {");
        this.println(this.m_acWriter, "        super(factory);");
        this.println(this.m_acWriter, "    }");
        if (this.m_ucWriter != null) {
            this.printCopywrite(this.m_ucWriter);
            this.println(this.m_ucWriter, "package " + this.m_package + ".impl;");
            this.println(this.m_ucWriter);
            this.println(this.m_ucWriter, "import com.sonicsw.ma.mgmtapi.config.*;");
            this.println(this.m_ucWriter, "import " + this.m_package + ".gen.impl.*;");
            this.println(this.m_ucWriter, "import " + this.m_package + ".*;");
            this.println(this.m_ucWriter);
            this.println(this.m_ucWriter, "public class " + arg.getClassName() + "Bean");
            this.println(this.m_ucWriter, "extends Abstract" + arg.getClassName() + "Bean implements I" + arg.getClassName() + "Bean");
            this.println(this.m_ucWriter, "{");
            this.println(this.m_ucWriter, "    public " + arg.getClassName() + "Bean(MgmtBeanFactory factory)");
            this.println(this.m_ucWriter, "    {");
            this.println(this.m_ucWriter, "        super(factory);");
            this.println(this.m_ucWriter, "    }");
        }
        int indent = 1;
        for (String key : type.getAttributeDescriptionNames()) {
            IAttributeDescription val = type.getAttributeDescription(key);
            this.generateAttribute(arg.getClassName(), indent, key, val);
        }
        while (!this.m_innerClasses.isEmpty()) {
            LocalInnerClass innerClass = (LocalInnerClass)this.m_innerClasses.get(0);
            this.m_innerClasses.remove(0);
            this.generateInnerClass(arg.getClassName(), indent, innerClass.m_name, innerClass.m_type, innerClass.m_desc);
        }
        this.println(this.m_aiWriter, "}");
        this.println(this.m_acWriter, "}");
        if (this.m_uiWriter != null) {
            this.println(this.m_uiWriter, "}");
        }
        if (this.m_ucWriter != null) {
            this.println(this.m_ucWriter, "}");
        }
    }

    private void generateConstants(GenerateArg arg, IConfigType type) throws Exception {
        this.printCopywrite(this.m_ciWriter);
        this.println(this.m_ciWriter, "/**");
        this.println(this.m_ciWriter, " * This generated file contains all constants for the configuration type");
        this.println(this.m_ciWriter, " * " + arg.m_type + " (v" + arg.m_cVersion + ")");
        this.println(this.m_ciWriter, " * This file is automatically generated. Do not edit manually.");
        if (arg.getClassName().equals("GenericComponent")) {
            this.println(this.m_ciWriter, " * @deprecated");
        }
        this.println(this.m_ciWriter, " */");
        this.println(this.m_ciWriter, "package " + this.m_package + ".constants;");
        this.println(this.m_ciWriter);
        this.println(this.m_ciWriter, "public interface I" + arg.getClassName() + "Constants");
        this.println(this.m_ciWriter, "{");
        this.println(this.m_ciWriter, 1, "public static final String DS_TYPE      = \"" + arg.m_type + "\";");
        this.println(this.m_ciWriter, 1, "public static final String DS_C_VERSION = \"" + arg.m_cVersion + "\";");
        this.println(this.m_ciWriter, 1, "public static final String DS_P_VERSION = \"" + arg.m_pVersion + "\";");
        this.println(this.m_ciWriter);
        for (String key : type.getAttributeDescriptionNames()) {
            IAttributeDescription val = type.getAttributeDescription(key);
            this.generateAttributeNameConstant(key, val);
        }
        this.println(this.m_ciWriter, "}");
    }

    private void generateDomain(GenerateArg arg, IConfigType type, PrintWriter cWriter) throws Exception {
        this.println(cWriter, 1, "// -----------------------------------------------------------------------");
        this.println(cWriter, 1, "// Domain methods for " + arg.getClassName() + "Bean");
        this.println(cWriter, 1, "//");
        this.println(cWriter, 1, "private void register" + arg.getClassName() + "Bean()");
        this.println(cWriter, 1, "{");
        this.println(cWriter, 1, "    HashMap map = new HashMap();");
        this.println(cWriter);
        this.println(cWriter, 1, "    map.put(IMgmtBeanBase.TYPE_PROPERTY,      " + arg.getClassName() + "Bean.DS_TYPE);");
        this.println(cWriter, 1, "    map.put(IMgmtBeanBase.C_VERSION_PROPERTY, " + arg.getClassName() + "Bean.DS_C_VERSION);");
        this.println(cWriter, 1, "    map.put(IMgmtBeanBase.P_VERSION_PROPERTY, " + arg.getClassName() + "Bean.DS_P_VERSION);");
        this.println(cWriter, 1, "    map.put(IMgmtBeanBase.CLASS_PROPERTY,     " + arg.getClassName() + "Bean.class);");
        this.println(cWriter, 1, "    map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  " + this.booleanObjectString(arg.m_template) + ");");
        this.println(cWriter);
        this.println(cWriter, 1, "    registerBean(map);");
        this.println(cWriter, 1, "}");
        this.println(cWriter);
        if (!arg.m_private) {
            this.println(cWriter, 1, "/**");
            this.println(cWriter, 1, " * Get the names of all beans of type I" + arg.getClassName());
            this.println(cWriter, 1, " * @return an array of bean names");
            if (arg.getClassName().equals("GenericComponent")) {
                this.println(cWriter, 1, " * @deprecated");
            }
            this.println(cWriter, 1, " */");
            this.println(cWriter, 1, "public List get" + arg.getClassName() + "BeanNames() throws MgmtException");
            this.println(cWriter, 1, "{");
            this.println(cWriter, 1, "    return listConfigElements(" + arg.getClassName() + "Bean.DS_TYPE);");
            this.println(cWriter, 1, "}");
            this.println(cWriter);
            this.println(cWriter, 1, "/**");
            this.println(cWriter, 1, " * Get the '" + arg.getName() + "' bean with the specified name");
            this.println(cWriter, 1, " * @param name The name of the bean");
            this.println(cWriter, 1, " * @return a bean of type I" + arg.getClassName());
            if (arg.getClassName().equals("GenericComponent")) {
                this.println(cWriter, 1, " * @deprecated");
            }
            this.println(cWriter, 1, " */");
            this.println(cWriter, 1, "public I" + arg.getClassName() + "Bean get" + arg.getClassName() + "Bean(String name) throws MgmtException");
            this.println(cWriter, 1, "{");
            this.println(cWriter, 1, "    " + arg.getClassName() + "Bean bean = new " + arg.getClassName() + "Bean(this);");
            this.println(cWriter);
            this.println(cWriter, 1, "    bean.loadBean(name, " + arg.getClassName() + "Bean.DS_TYPE);");
            this.println(cWriter);
            this.println(cWriter, 1, "    return bean;");
            this.println(cWriter, 1, "}");
            this.println(cWriter);
            this.println(cWriter, 1, "/**");
            this.println(cWriter, 1, " * Create a " + arg.getName() + " bean with the specified name");
            this.println(cWriter, 1, " * @param name the name of the new bean");
            this.println(cWriter, 1, " * @return a new " + arg.getName() + " bean");
            if (arg.getClassName().equals("GenericComponent")) {
                this.println(cWriter, 1, " * @deprecated");
            }
            this.println(cWriter, 1, " */");
            this.println(cWriter, 1, "public I" + arg.getClassName() + "Bean create" + arg.getClassName() + "Bean(String name) throws MgmtException");
            this.println(cWriter, 1, "{");
            this.println(cWriter, 1, "    " + arg.getClassName() + "Bean bean = new " + arg.getClassName() + "Bean(this);");
            this.println(cWriter);
            this.println(cWriter, 1, "    bean.createBean(name, " + arg.getClassName() + "Bean.DS_TYPE, " + arg.getClassName() + "Bean.DS_C_VERSION, " + arg.getClassName() + "Bean.DS_P_VERSION);");
            this.println(cWriter);
            this.println(cWriter, 1, "    return bean;");
            this.println(cWriter, 1, "}");
            this.println(cWriter);
            this.println(cWriter, 1, "/**");
            this.println(cWriter, 1, " * Save the specified " + arg.getName() + " bean");
            this.println(cWriter, 1, " * @param bean the " + arg.getName() + " bean to save");
            if (arg.getClassName().equals("GenericComponent")) {
                this.println(cWriter, 1, " * @deprecated");
            }
            this.println(cWriter, 1, " */");
            this.println(cWriter, 1, "public void save" + arg.getClassName() + "Bean(I" + arg.getClassName() + "Bean bean) throws MgmtException");
            this.println(cWriter, 1, "{");
            this.println(cWriter, 1, "    saveBean(bean);");
            this.println(cWriter, 1, "}");
            this.println(cWriter);
            this.println(cWriter, 1, "/**");
            this.println(cWriter, 1, " * Delete the specified " + arg.getName() + " bean");
            this.println(cWriter, 1, " * @param bean the " + arg.getName() + " bean to delete");
            if (arg.getClassName().equals("GenericComponent")) {
                this.println(cWriter, 1, " * @deprecated");
            }
            this.println(cWriter, 1, " */");
            this.println(cWriter, 1, "public void delete" + arg.getClassName() + "Bean(I" + arg.getClassName() + "Bean bean) throws MgmtException");
            this.println(cWriter, 1, "{");
            this.println(cWriter, 1, "    deleteBean(bean);");
            this.println(cWriter, 1, "}");
        }
        this.println(cWriter);
    }

    private void generateInnerClassNameConstants(String name, String type, IAttributeDescription desc) throws Exception {
        Set names = desc.getAttributeDescriptionNames();
        if (!names.isEmpty()) {
            this.println(this.m_ciWriter);
            this.println(this.m_ciWriter, 1, "// " + name + " attribute set/list constants and defaults");
        }
        for (String key : names) {
            IAttributeDescription val = desc.getAttributeDescription(key);
            this.generateAttributeNameConstant(key, val);
        }
        if (!names.isEmpty()) {
            this.println(this.m_ciWriter);
        }
    }

    private void generateInnerClass(String outer, int indent, String name, String type, IAttributeDescription desc) throws Exception {
        boolean unenumMap = false;
        boolean list = false;
        if (desc.getProperty("mx.config.unenumMap") != null) {
            unenumMap = true;
        }
        if (desc.getType() == IAttributeList.class) {
            list = true;
        }
        this.println(this.m_aiWriter);
        if (this.m_uiWriter != null) {
            this.println(this.m_uiWriter);
        }
        if (unenumMap) {
            this.println(this.m_aiWriter, indent, "/**");
            this.println(this.m_aiWriter, indent, " * Inner class representing " + type);
            this.println(this.m_aiWriter, indent, " * This inner class contains inner data items that are keyed off");
            this.println(this.m_aiWriter, indent, " * a name. This class extends IMgmtMapBase");
            this.println(this.m_aiWriter, indent, " */");
            this.println(this.m_aiWriter, indent, "public interface IAbstract" + type + " extends IMgmtMapBase");
            if (this.m_uiWriter != null) {
                this.println(this.m_uiWriter, indent, "/**");
                this.println(this.m_uiWriter, indent, " * Inner class representing " + type);
                this.println(this.m_uiWriter, indent, " * This inner class contains inner data items that are keyed off");
                this.println(this.m_uiWriter, indent, " * a name. This class extends IAbstract" + type);
                this.println(this.m_uiWriter, indent, " */");
                this.println(this.m_uiWriter, indent, "public interface I" + type + " extends IAbstract" + type);
            }
        } else if (list) {
            this.println(this.m_aiWriter, indent, "/**");
            this.println(this.m_aiWriter, indent, " * Inner class representing " + type);
            this.println(this.m_aiWriter, indent, " * This inner class contains inner data items that have a zero based");
            this.println(this.m_aiWriter, indent, " * index. This class extends IMgmtListBase");
            this.println(this.m_aiWriter, indent, " */");
            this.println(this.m_aiWriter, indent, "public interface IAbstract" + type + " extends IMgmtListBase");
            if (this.m_uiWriter != null) {
                this.println(this.m_uiWriter, indent, "/**");
                this.println(this.m_uiWriter, indent, " * Inner class representing " + type);
                this.println(this.m_uiWriter, indent, " * This inner class contains inner data items that have a zero based");
                this.println(this.m_uiWriter, indent, " * index. This class extends IAbstract" + type);
                this.println(this.m_uiWriter, indent, " */");
                this.println(this.m_uiWriter, indent, "public interface I" + type + " extends IAbstract" + type);
            }
        } else {
            this.println(this.m_aiWriter, indent, "/**");
            this.println(this.m_aiWriter, indent, " * Inner class representing " + type);
            this.println(this.m_aiWriter, indent, " * This class extends IMgmtListBase");
            this.println(this.m_aiWriter, indent, " */");
            this.println(this.m_aiWriter, indent, "public interface IAbstract" + type + " extends IMgmtSubBeanBase");
            if (this.m_uiWriter != null) {
                this.println(this.m_uiWriter, indent, "/**");
                this.println(this.m_uiWriter, indent, " * Inner class representing " + type);
                this.println(this.m_uiWriter, indent, " * This class extends IAbstract" + type);
                this.println(this.m_uiWriter, indent, " */");
                this.println(this.m_uiWriter, indent, "public interface I" + type + " extends IAbstract" + type);
            }
        }
        this.println(this.m_aiWriter, indent, "{");
        if (this.m_uiWriter != null) {
            this.println(this.m_uiWriter, indent, "{");
            this.println(this.m_uiWriter, indent, "}");
        }
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public static class Abstract" + type);
        if (unenumMap) {
            this.println(this.m_acWriter, indent, "extends MgmtMapBase implements IAbstract" + type);
        } else if (list) {
            this.println(this.m_acWriter, indent, "extends MgmtListBase implements IAbstract" + type);
        } else {
            this.println(this.m_acWriter, indent, "extends MgmtSubBeanBase implements IAbstract" + type);
        }
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    public Abstract" + type + "(IMgmtBase parent, String name, boolean isNew)");
        this.println(this.m_acWriter, indent, "    throws MgmtException");
        this.println(this.m_acWriter, indent, "    {");
        this.println(this.m_acWriter, indent, "        super(parent, name, isNew);");
        this.println(this.m_acWriter, indent, "    }");
        if (this.m_ucWriter != null) {
            this.println(this.m_ucWriter);
            this.println(this.m_ucWriter, indent, "public static class " + type);
            if (unenumMap) {
                this.println(this.m_ucWriter, indent, "extends Abstract" + type + " implements I" + type);
            } else if (list) {
                this.println(this.m_ucWriter, indent, "extends Abstract" + type + " implements I" + type);
            } else {
                this.println(this.m_ucWriter, indent, "extends Abstract" + type + " implements I" + type);
            }
            this.println(this.m_ucWriter, indent, "{");
            this.println(this.m_ucWriter, indent, "    public " + type + "(IMgmtBase parent, String name, boolean isNew)");
            this.println(this.m_ucWriter, indent, "    throws MgmtException");
            this.println(this.m_ucWriter, indent, "    {");
            this.println(this.m_ucWriter, indent, "        super(parent, name, isNew);");
            this.println(this.m_ucWriter, indent, "    }");
            this.println(this.m_ucWriter, indent, "}");
        }
        Set names = desc.getAttributeDescriptionNames();
        for (String key : names) {
            IAttributeDescription val = desc.getAttributeDescription(key);
            if (unenumMap) {
                this.generateUnenumMapAttribute(outer, indent + 1, key, val);
                continue;
            }
            if (list) {
                this.generateListAttribute(outer, indent + 1, key, val);
                continue;
            }
            this.generateAttribute(outer, indent + 1, key, val);
        }
        this.println(this.m_aiWriter, indent, "}");
        this.println(this.m_acWriter, indent, "}");
    }

    private void generateAttributeNameConstant(String key, IAttributeDescription desc) throws Exception {
        if (key.startsWith("_GUI")) {
            return;
        }
        String constantDefinition = "public static final String " + key.toUpperCase() + "_ATTR = " + '\"' + key + "\";";
        String defaultDefinition = this.generateDefaultDefinition(key, desc);
        String fixedDefinition = this.generateFixedDefinition(key, desc);
        if (this.m_writtenConstants.contains(constantDefinition)) {
            this.println(this.m_ciWriter, 1, "// " + constantDefinition);
            if (defaultDefinition != null) {
                this.println(this.m_ciWriter, 1, "// " + defaultDefinition);
            }
            if (fixedDefinition != null) {
                this.println(this.m_ciWriter, 1, "// " + fixedDefinition);
            }
        } else {
            this.println(this.m_ciWriter, 1, constantDefinition);
            if (defaultDefinition != null) {
                this.println(this.m_ciWriter, 1, defaultDefinition);
            }
            if (fixedDefinition != null) {
                this.println(this.m_ciWriter, 1, fixedDefinition);
            }
            this.m_writtenConstants.add(constantDefinition);
            this.generateEnumDefinition(1, key, desc);
        }
        if (desc.getType() == IAttributeMap.class || desc.getType() == IAttributeList.class) {
            String schemaName = (String)desc.getProperty("mx.config.schemaTypeName");
            if (schemaName == null) {
                throw new Exception("SCHEMA_TYPE_NAME not available for " + key);
            }
            String type = ConfigHelper.generateName(schemaName);
            if (type == null) {
                return;
            }
            LocalInnerClass innerClass = new LocalInnerClass(key, type, desc);
            this.generateInnerClassNameConstants(innerClass.m_name, innerClass.m_type, innerClass.m_desc);
        }
    }

    private void generateAttribute(String outer, int indent, String key, IAttributeDescription desc) throws Exception {
        String useName = ConfigHelper.generateName(key);
        String classDesc = this.classToDescription(desc.getType());
        String classType = this.classToType(desc.getType());
        if (key.startsWith("_GUI") || this.isHidden(desc)) {
            return;
        }
        if (desc.getType() == IAttributeMap.class) {
            this.generateMapAttribute(outer, indent, key, useName, desc);
        } else if (desc.getType() == IAttributeList.class) {
            this.generateMapAttribute(outer, indent, key, useName, desc);
        } else if (classDesc != null && classType != null) {
            this.generateSimpleAttribute(indent, key, useName, desc, classDesc, classType);
        } else {
            throw new Exception("Failed to generate code for Attribute " + key + " of type " + desc.getType().getName());
        }
    }

    private void generateSimpleAttribute(int indent, String key, String useName, IAttributeDescription desc, String method, String type) {
        boolean optional = this.isOptional(desc);
        boolean settable = this.isSettable(desc);
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Get the attribute for " + key + " as a " + type + " value.");
        String annotation = (String)desc.getProperty("mx.config.schemaAnnotation");
        if (annotation != null) {
            this.printAnnotation(indent, annotation);
        }
        if (optional) {
            this.println(this.m_aiWriter, indent, " * This is an optional attribute and a MgmtException will be");
            this.println(this.m_aiWriter, indent, " * thrown if the attribute does not exist.");
        }
        this.println(this.m_aiWriter, indent, " * @return The " + type + " value for this attribute");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown when this attribute doesn't exist or");
        this.println(this.m_aiWriter, indent, " * if there is some problem obtaining this attribute");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public " + type + " get" + useName + "() throws MgmtException;");
        if (optional) {
            this.println(this.m_aiWriter);
            this.println(this.m_aiWriter, indent, "/**");
            this.println(this.m_aiWriter, indent, " * Get the attribute for " + key + " as a " + type + " value.");
            if (annotation != null) {
                this.printAnnotation(indent, annotation);
            }
            this.println(this.m_aiWriter, indent, " * If the attribute doesn't exist then return the specified default value.");
            this.println(this.m_aiWriter, indent, " * @param defValue The default value to return if this attribute doesn't exist");
            this.println(this.m_aiWriter, indent, " * @return The " + type + " value for this attribute");
            this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown when this attribute doesn't exist or");
            this.println(this.m_aiWriter, indent, " * if there is some problem obtaining this attribute");
            this.println(this.m_aiWriter, indent, " */");
            this.println(this.m_aiWriter, indent, "public " + type + " get" + useName + "(" + type + " defValue) throws MgmtException;");
        }
        if (settable) {
            this.println(this.m_aiWriter);
            this.println(this.m_aiWriter, indent, "/**");
            this.println(this.m_aiWriter, indent, " * Set the attribute for " + key + " to the specified " + type + " value.");
            if (annotation != null) {
                this.printAnnotation(indent, annotation);
            }
            this.println(this.m_aiWriter, indent, " * @param value The " + type + " value for this attribute");
            this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem setting this attribute");
            this.println(this.m_aiWriter, indent, " */");
            this.println(this.m_aiWriter, indent, "public void set" + useName + "(" + type + " value) throws MgmtException;");
        }
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Get the attribute metadata for " + key + ".");
        if (annotation != null) {
            this.printAnnotation(indent, annotation);
        }
        this.println(this.m_aiWriter, indent, " * @return The IMgmtAttributeMetaData value for this attribute");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown when this attribute doesn't exist or");
        this.println(this.m_aiWriter, indent, " * if there is some problem obtaining this attribute's metadata");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public IMgmtAttributeMetaData get" + useName + "MetaData() throws MgmtException;");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public " + type + " get" + useName + "() throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    return get" + method + "Attribute(" + key.toUpperCase() + "_ATTR);");
        this.println(this.m_acWriter, indent, "}");
        if (optional) {
            this.println(this.m_acWriter);
            this.println(this.m_acWriter, indent, "public " + type + " get" + useName + "(" + type + " defValue) throws MgmtException");
            this.println(this.m_acWriter, indent, "{");
            this.println(this.m_acWriter, indent, "    try");
            this.println(this.m_acWriter, indent, "    {");
            this.println(this.m_acWriter, indent, "        return get" + method + "Attribute(" + key.toUpperCase() + "_ATTR);");
            this.println(this.m_acWriter, indent, "    }");
            this.println(this.m_acWriter, indent, "    catch(AttributeNotFoundException e)");
            this.println(this.m_acWriter, indent, "    {");
            this.println(this.m_acWriter, indent, "        return defValue;");
            this.println(this.m_acWriter, indent, "    }");
            this.println(this.m_acWriter, indent, "}");
        }
        if (settable) {
            this.println(this.m_acWriter);
            this.println(this.m_acWriter, indent, "public void set" + useName + "(" + type + " value) throws MgmtException");
            this.println(this.m_acWriter, indent, "{");
            this.println(this.m_acWriter, indent, "    set" + method + "Attribute(" + key.toUpperCase() + "_ATTR, value);");
            this.println(this.m_acWriter, indent, "}");
        }
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public IMgmtAttributeMetaData get" + useName + "MetaData() throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    return getAttributeMetaData(" + key.toUpperCase() + "_ATTR);");
        this.println(this.m_acWriter, indent, "}");
    }

    private void generateMapAttribute(String outer, int indent, String key, String useName, IAttributeDescription desc) throws Exception {
        String schemaName = (String)desc.getProperty("mx.config.schemaTypeName");
        if (schemaName == null) {
            throw new Exception("SCHEMA_TYPE_NAME not available for " + key);
        }
        String type = ConfigHelper.generateName(schemaName);
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Get the attribute for " + key + ".");
        String annotation = (String)desc.getProperty("mx.config.schemaAnnotation");
        if (annotation != null) {
            this.printAnnotation(indent, annotation);
        }
        this.println(this.m_aiWriter, indent, " * @return The I" + type + " value for this attribute");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown when this attribute doesn't exist or");
        this.println(this.m_aiWriter, indent, " * if there is some problem obtaining this attribute");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public I" + outer + "Bean.I" + type + " get" + useName + "() throws MgmtException;");
        if (this.isSettable(desc)) {
            this.println(this.m_aiWriter);
            this.println(this.m_aiWriter, indent, "/**");
            this.println(this.m_aiWriter, indent, " * Set the attribute for " + key + " to the specified I" + type + " value.");
            annotation = (String)desc.getProperty("mx.config.schemaAnnotation");
            if (annotation != null) {
                this.printAnnotation(indent, annotation);
            }
            this.println(this.m_aiWriter, indent, " * @param value The I" + type + " value for this attribute");
            this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem setting this attribute");
            this.println(this.m_aiWriter, indent, " */");
            this.println(this.m_aiWriter, indent, "public void set" + useName + "(I" + outer + "Bean.I" + type + " value) throws MgmtException;");
            this.println(this.m_aiWriter);
            this.println(this.m_aiWriter, indent, "/**");
            this.println(this.m_aiWriter, indent, " * Create an instance of an I" + type + " attribute. This new instance");
            this.println(this.m_aiWriter, indent, " * is not currently part of the configuration. Once it has been configured");
            this.println(this.m_aiWriter, indent, " * it should be set into the configuration using the set" + useName + " method.");
            this.println(this.m_aiWriter, indent, " * @return The new I" + type + " bean");
            this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem creating this object");
            this.println(this.m_aiWriter, indent, " */");
            this.println(this.m_aiWriter, indent, "public I" + outer + "Bean.I" + type + " create" + useName + "() throws MgmtException;");
        }
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Get the attribute metadata for " + key + ".");
        this.println(this.m_aiWriter, indent, " * @return The IMgmtAttributeMetaData value for this attribute");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown when this attribute metadata doesn't exist or");
        this.println(this.m_aiWriter, indent, " * if there is some problem obtaining this attribute metadata");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public IMgmtAttributeMetaData get" + useName + "MetaData() throws MgmtException;");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public I" + outer + "Bean.I" + type + " get" + useName + "() throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    return new " + outer + "Bean." + type + "(this, " + key.toUpperCase() + "_ATTR, false);");
        this.println(this.m_acWriter, indent, "}");
        if (this.isSettable(desc)) {
            this.println(this.m_acWriter);
            this.println(this.m_acWriter, indent, "public void set" + useName + "(I" + outer + "Bean.I" + type + " value) throws MgmtException");
            this.println(this.m_acWriter, indent, "{");
            this.println(this.m_acWriter, indent, "    super.setAttribute(" + key.toUpperCase() + "_ATTR, value);");
            this.println(this.m_acWriter, indent, "}");
            this.println(this.m_acWriter);
            this.println(this.m_acWriter, indent, "public I" + outer + "Bean.I" + type + " create" + useName + "() throws MgmtException");
            this.println(this.m_acWriter, indent, "{");
            this.println(this.m_acWriter, indent, "    return new " + outer + "Bean." + type + "(this, " + key.toUpperCase() + "_ATTR, true);");
            this.println(this.m_acWriter, indent, "}");
        }
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public IMgmtAttributeMetaData get" + useName + "MetaData() throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    return getAttributeMetaData(" + key.toUpperCase() + "_ATTR);");
        this.println(this.m_acWriter, indent, "}");
        this.addInnerClass(key, type, desc);
    }

    private void generateListAttribute(String outer, int indent, String key, IAttributeDescription desc) throws Exception {
        String schemaName = (String)desc.getProperty("mx.config.schemaTypeName");
        if (schemaName == null) {
            throw new Exception("SCHEMA_TYPE_NAME not available for " + key);
        }
        String internalType = null;
        String type = null;
        if ((String)desc.getProperty("mx.config.simpleTypeName") != null) {
            type = null;
            internalType = this.classToType(desc.getType());
        } else {
            type = ConfigHelper.generateName(schemaName);
            internalType = "I" + outer + "Bean.I" + type;
        }
        String useName = ConfigHelper.generateName(key);
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Get the " + internalType + " atribute from the list at the");
        this.println(this.m_aiWriter, indent, " * specified index");
        this.println(this.m_aiWriter, indent, " * @param index The index of the " + useName + " in the list.");
        this.println(this.m_aiWriter, indent, " * @return The " + internalType + " value for this attribute");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown when this attribute doesn't exist or");
        this.println(this.m_aiWriter, indent, " * if there is some problem obtaining this attribute");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public " + internalType + " get" + useName + "(int index) throws MgmtException;");
        if (type != null) {
            this.println(this.m_aiWriter);
            this.println(this.m_aiWriter, indent, "/**");
            this.println(this.m_aiWriter, indent, " * Create an instance of an " + internalType + " attribute. This new instance");
            this.println(this.m_aiWriter, indent, " * is not currently part of the configuration. Once it has been configured");
            this.println(this.m_aiWriter, indent, " * it should be set into the configuration using either the add" + useName);
            this.println(this.m_aiWriter, indent, " * or insert" + useName + " methods");
            this.println(this.m_aiWriter, indent, " * @return The new " + internalType + " bean");
            this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem creating this object");
            this.println(this.m_aiWriter, indent, " */");
            this.println(this.m_aiWriter, indent, "public " + internalType + " create" + useName + "() throws MgmtException;");
        }
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Add the new " + useName + " of type " + internalType + " into this list at");
        this.println(this.m_aiWriter, indent, " * the end of the list");
        this.println(this.m_aiWriter, indent, " * @param value The " + internalType + " value to add to the list");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem adding this item to the list");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public void add" + useName + "(" + internalType + " value) throws MgmtException;");
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Insert the new " + useName + " of type " + internalType + " into this list at");
        this.println(this.m_aiWriter, indent, " * the specified location");
        this.println(this.m_aiWriter, indent, " * @param index The location in the list to add the new item");
        this.println(this.m_aiWriter, indent, " * @param value The " + internalType + " value to add to the list");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem inserting this item into the list");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public void insert" + useName + "(int index, " + internalType + " value) throws MgmtException;");
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Delete the item at the specified index from the list");
        this.println(this.m_aiWriter, indent, " * @param index The index of the item to delete");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem deleting this item from the list");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public void delete" + useName + "(int index) throws MgmtException;");
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Get the attribute metadata for " + key + ".");
        this.println(this.m_aiWriter, indent, " * @return The IMgmtAttributeMetaData value for this attribute");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown when this attribute metadata doesn't exist or");
        this.println(this.m_aiWriter, indent, " * if there is some problem obtaining this attribute metadata");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public IMgmtAttributeMetaData get" + useName + "MetaData() throws MgmtException;");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public " + internalType + " get" + useName + "(int index) throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        if (type == null) {
            this.println(this.m_acWriter, indent, "    return (" + internalType + ")super.getAttribute(Integer.toString(index));");
        } else {
            this.println(this.m_acWriter, indent, "    return new " + outer + "Bean." + type + "(this, Integer.toString(index), false);");
        }
        this.println(this.m_acWriter, indent, "}");
        if (type != null) {
            this.println(this.m_acWriter);
            this.println(this.m_acWriter, indent, "public " + internalType + " create" + useName + "() throws MgmtException");
            this.println(this.m_acWriter, indent, "{");
            this.println(this.m_acWriter, indent, "    return new " + outer + "Bean." + type + "(this, " + key.toUpperCase() + "_ATTR, true);");
            this.println(this.m_acWriter, indent, "}");
        }
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public void add" + useName + "(" + internalType + " value) throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    super.add(value);");
        this.println(this.m_acWriter, indent, "}");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public void insert" + useName + "(int index, " + internalType + " value) throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    super.insert(index, value);");
        this.println(this.m_acWriter, indent, "}");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public void delete" + useName + "(int index) throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    super.delete(index);");
        this.println(this.m_acWriter, indent, "}");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public IMgmtAttributeMetaData get" + useName + "MetaData() throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    return getAttributeMetaData(" + key.toUpperCase() + "_ATTR);");
        this.println(this.m_acWriter, indent, "}");
        this.addInnerClass(key, type, desc);
    }

    private void generateUnenumMapAttribute(String outer, int indent, String key, IAttributeDescription desc) throws Exception {
        String schemaName = (String)desc.getProperty("mx.config.schemaTypeName");
        if (schemaName == null) {
            throw new Exception("SCHEMA_TYPE_NAME not available for " + key);
        }
        String internalType = null;
        String type = null;
        if ((String)desc.getProperty("mx.config.simpleTypeName") != null) {
            type = null;
            internalType = this.classToType(desc.getType());
        } else {
            type = ConfigHelper.generateName(schemaName);
            internalType = "I" + outer + "Bean.I" + type;
        }
        String useName = ConfigHelper.generateName(key);
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Get the " + internalType + " atribute from the map with the specified key name");
        this.println(this.m_aiWriter, indent, " * @param name The key name for this " + useName + " within the Map");
        this.println(this.m_aiWriter, indent, " * @return The " + internalType + " value for this attribute");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown when this attribute doesn't exist or");
        this.println(this.m_aiWriter, indent, " * if there is some problem obtaining this attribute");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public " + internalType + " get" + useName + "(String name) throws MgmtException;");
        if (type != null) {
            this.println(this.m_aiWriter);
            this.println(this.m_aiWriter, indent, "/**");
            this.println(this.m_aiWriter, indent, " * Create an instance of an " + internalType + " attribute. This new instance");
            this.println(this.m_aiWriter, indent, " * is not currently part of the configuration. Once it has been configured");
            this.println(this.m_aiWriter, indent, " * it should be set into the configuration using either the add" + useName);
            this.println(this.m_aiWriter, indent, " * or insert" + useName + " methods");
            this.println(this.m_aiWriter, indent, " * @return The new " + internalType + " bean");
            this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem creating this object");
            this.println(this.m_aiWriter, indent, " */");
            this.println(this.m_aiWriter, indent, "public " + internalType + " create" + useName + "() throws MgmtException;");
        }
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Add the new " + useName + " of type " + internalType + " into this map keyed");
        this.println(this.m_aiWriter, indent, " * off the specified key name");
        this.println(this.m_aiWriter, indent, " * @param name The key name for this " + useName + " in the map");
        this.println(this.m_aiWriter, indent, " * @param value The " + internalType + " value to add to the map");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem adding this item to the map");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public void add" + useName + "(String name, " + internalType + " value) throws MgmtException;");
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Delete the item with the specified name from this map");
        this.println(this.m_aiWriter, indent, " * @param name The key name for the item in the map");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown if there is some problem deleting this item from the map");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public void delete" + useName + "(String name) throws MgmtException;");
        this.println(this.m_aiWriter);
        this.println(this.m_aiWriter, indent, "/**");
        this.println(this.m_aiWriter, indent, " * Get the attribute metadata for " + key + ".");
        this.println(this.m_aiWriter, indent, " * @return The IMgmtAttributeMetaData value for this attribute");
        this.println(this.m_aiWriter, indent, " * @throws MgmtException Thrown when this attribute metadata doesn't exist or");
        this.println(this.m_aiWriter, indent, " * if there is some problem obtaining this attribute metadata");
        this.println(this.m_aiWriter, indent, " */");
        this.println(this.m_aiWriter, indent, "public IMgmtAttributeMetaData get" + useName + "MetaData() throws MgmtException;");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public " + internalType + " get" + useName + "(String name) throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        if (type == null) {
            this.println(this.m_acWriter, indent, "    return (" + internalType + ")super.getAttribute(name);");
        } else {
            this.println(this.m_acWriter, indent, "    return new " + outer + "Bean." + type + "(this, name, false);");
        }
        this.println(this.m_acWriter, indent, "}");
        if (type != null) {
            this.println(this.m_acWriter);
            this.println(this.m_acWriter, indent, "public " + internalType + " create" + useName + "() throws MgmtException");
            this.println(this.m_acWriter, indent, "{");
            this.println(this.m_acWriter, indent, "    return new " + outer + "Bean." + type + "(this, " + key.toUpperCase() + "_ATTR, true);");
            this.println(this.m_acWriter, indent, "}");
        }
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public void add" + useName + "(String name, " + internalType + " value) throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    super.add(name, value);");
        this.println(this.m_acWriter, indent, "}");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public void delete" + useName + "(String name) throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    super.delete(name);");
        this.println(this.m_acWriter, indent, "}");
        this.println(this.m_acWriter);
        this.println(this.m_acWriter, indent, "public IMgmtAttributeMetaData get" + useName + "MetaData() throws MgmtException");
        this.println(this.m_acWriter, indent, "{");
        this.println(this.m_acWriter, indent, "    return getAttributeMetaData(" + key.toUpperCase() + "_ATTR);");
        this.println(this.m_acWriter, indent, "}");
        this.addInnerClass(key, type, desc);
    }

    private String generateDefaultDefinition(String key, IAttributeDescription desc) throws Exception {
        Object def = this.getDefaultValue(desc);
        if (def == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("public static final ");
        buffer.append(this.classToType(def.getClass()));
        buffer.append(" ");
        buffer.append(key.toUpperCase());
        buffer.append("_DEFAULT = ");
        if (def instanceof String) {
            buffer.append('\"');
            buffer.append(def.toString());
            buffer.append('\"');
        } else if (def instanceof BigDecimal) {
            buffer.append("new java.math.BigDecimal(");
            buffer.append(def.toString());
            buffer.append(")");
        } else {
            buffer.append(def.toString());
        }
        buffer.append(';');
        return buffer.toString();
    }

    private String generateFixedDefinition(String key, IAttributeDescription desc) throws Exception {
        Object fixed = this.getFixedValue(desc);
        if (fixed == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("public static final ");
        buffer.append(this.classToType(fixed.getClass()));
        buffer.append(" ");
        buffer.append(key.toUpperCase());
        buffer.append("_FIXED = ");
        if (fixed instanceof String) {
            buffer.append('\"');
            buffer.append(fixed.toString());
            buffer.append('\"');
        } else if (fixed instanceof BigDecimal) {
            buffer.append("new java.math.BigDecimal(");
            buffer.append(fixed.toString());
            buffer.append(")");
        } else {
            buffer.append(fixed.toString());
        }
        buffer.append(';');
        return buffer.toString();
    }

    private void generateEnumDefinition(int indent, String key, IAttributeDescription desc) throws Exception {
        Object obj = desc.getProperty("mx.config.enumeration");
        if (obj != null && obj instanceof IAttributeList) {
            IAttributeList list = (IAttributeList)obj;
            for (int i = 0; i < list.size(); ++i) {
                String facet = (String)list.getAttribute(i);
                String value = "public static final String " + key.toUpperCase() + "_" + this.convertSpaces(facet) + " = \"" + facet + "\";";
                this.println(this.m_ciWriter, indent, value);
            }
        }
    }

    private String convertSpaces(String val) {
        String res = val;
        res = res.replace('.', '_');
        res = res.replace(' ', '_');
        return res;
    }

    private void generateFactoryInterface() throws Exception {
        this.printCopywrite(this.m_fiWriter);
        this.println(this.m_fiWriter, "package " + this.m_package + ".gen;");
        this.println(this.m_fiWriter);
        this.println(this.m_fiWriter, "import java.util.*;");
        this.println(this.m_fiWriter, "import com.sonicsw.ma.mgmtapi.config.*;");
        this.println(this.m_fiWriter, "import " + this.m_package + ".*;");
        this.println(this.m_fiWriter, "import " + this.m_package + ".impl.*;");
        this.println(this.m_fiWriter);
        this.println(this.m_fiWriter, "public class Abstract" + this.m_facPrefix + "MgmtBeanFactory extends MgmtBeanFactory");
        this.println(this.m_fiWriter, "{");
        this.println(this.m_fiWriter, "    public Abstract" + this.m_facPrefix + "MgmtBeanFactory()");
        this.println(this.m_fiWriter, "    {");
        this.println(this.m_fiWriter, "        super();");
        this.println(this.m_fiWriter);
        for (int i = 0; i < this.m_argList.size(); ++i) {
            GenerateArg arg = (GenerateArg)this.m_argList.get(i);
            this.println(this.m_fiWriter, "        register" + arg.getClassName() + "Bean();");
        }
        this.println(this.m_fiWriter, "    }");
        this.println(this.m_fiWriter);
    }

    private void generateFactoryClass(PrintWriter fcWriter) throws Exception {
        this.printCopywrite(fcWriter);
        this.println(fcWriter, "package " + this.m_package + ";");
        this.println(fcWriter);
        this.println(fcWriter, "import com.sonicsw.ma.mgmtapi.config.*;");
        this.println(fcWriter, "import " + this.m_package + ".gen.*;");
        this.println(fcWriter);
        this.println(fcWriter, "public class " + this.m_facPrefix + "MgmtBeanFactory extends Abstract" + this.m_facPrefix + "MgmtBeanFactory");
        this.println(fcWriter, "{");
        this.println(fcWriter, "    public " + this.m_facPrefix + "MgmtBeanFactory()");
        this.println(fcWriter, "    {");
        this.println(fcWriter, "        super();");
        this.println(fcWriter, "    }");
        this.println(fcWriter, "}");
    }

    private String classToDescription(Class cls) throws Exception {
        if (cls == String.class) {
            return "String";
        }
        if (cls == Integer.class) {
            return "Integer";
        }
        if (cls == Boolean.class) {
            return "Boolean";
        }
        if (cls == Long.class) {
            return "Long";
        }
        if (cls == BigDecimal.class) {
            return "BigDecimal";
        }
        if (cls == byte[].class) {
            return "ByteArray";
        }
        if (cls == IConfigElement.class) {
            return "Reference";
        }
        return null;
    }

    private String classToType(Class cls) throws Exception {
        if (cls == String.class) {
            return "String";
        }
        if (cls == Integer.class) {
            return "int";
        }
        if (cls == Boolean.class) {
            return "boolean";
        }
        if (cls == Long.class) {
            return "long";
        }
        if (cls == BigDecimal.class) {
            return "java.math.BigDecimal";
        }
        if (cls == byte[].class) {
            return "byte[]";
        }
        if (cls == IConfigElement.class) {
            return "IMgmtBeanBase";
        }
        return null;
    }

    private void addInnerClass(String key, String type, IAttributeDescription desc) {
        if (type == null) {
            return;
        }
        for (int i = 0; i < this.m_innerClasses.size(); ++i) {
            LocalInnerClass temp = (LocalInnerClass)this.m_innerClasses.get(i);
            if (!temp.m_type.equals(type)) continue;
            return;
        }
        this.m_innerClasses.add(new LocalInnerClass(key, type, desc));
    }

    private void println(PrintWriter writer) {
        writer.println();
    }

    private void println(PrintWriter writer, String text) {
        writer.println(text);
    }

    private void println(PrintWriter writer, int indent, String text) {
        for (int i = 0; i < indent; ++i) {
            writer.print("    ");
        }
        writer.println(text);
    }

    private void printCopywrite(PrintWriter writer) {
        writer.println("/**");
        writer.println(" * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.");
        writer.println(" *");
        writer.println(" * This software is the confidential and proprietary information of Sonic");
        writer.println(" * Software Corpoation. (Confidential Information).  You shall not");
        writer.println(" * disclose such Confidential Information and shall use it only in");
        writer.println(" * accordance with the terms of the license agreement you entered into");
        writer.println(" * with Sonic.");
        writer.println(" *");
        writer.println(" * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE");
        writer.println(" * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE");
        writer.println(" * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR");
        writer.println(" * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES");
        writer.println(" * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING");
        writer.println(" * THIS SOFTWARE OR ITS DERIVATIVES.");
        writer.println(" *");
        writer.println(" * CopyrightVersion 1.0");
        writer.println(" */");
        writer.println();
    }

    private Object getDefaultValue(IAttributeDescription desc) {
        return desc.getProperty("mx.config.default");
    }

    private Object getFixedValue(IAttributeDescription desc) {
        return desc.getProperty("mx.config.fixed");
    }

    private boolean isSettable(IAttributeDescription desc) {
        String val = (String)desc.getProperty("mx.config.fixed");
        if (val != null) {
            return Boolean.valueOf(val);
        }
        Long min = (Long)desc.getProperty("mx.config.minOccurs");
        Long max = (Long)desc.getProperty("mx.config.maxOccurs");
        return desc.getType() != IAttributeMap.class && desc.getType() != IAttributeList.class || min == null || max == null || min != 1L || max != 1L;
    }

    private boolean isOptional(IAttributeDescription desc) {
        Long min = (Long)desc.getProperty("mx.config.minOccurs");
        return min != null && min == 0L;
    }

    private boolean isHidden(IAttributeDescription desc) {
        Boolean val = (Boolean)desc.getProperty("mx.config.hidden");
        if (val != null) {
            return val;
        }
        return false;
    }

    private String booleanObjectString(boolean value) {
        return value ? "Boolean.TRUE" : "Boolean.FALSE";
    }

    private void parseArgs(String[] args) throws Exception {
        GenerateArg arg = new GenerateArg();
        int i = 0;
        while (i < args.length) {
            if (args[i].trim().length() == 0) {
                ++i;
                continue;
            }
            if (args[i].equals("-url")) {
                this.m_url = args[++i];
            } else if (args[i].equals("-user")) {
                this.m_user = args[++i];
            } else if (args[i].equals("-password")) {
                this.m_password = args[++i];
            } else if (args[i].equals("-domain")) {
                this.m_domain = args[++i];
            } else if (args[i].equals("-factory")) {
                this.m_factory = new Boolean(args[++i]);
            } else if (args[i].equals("-factory-prefix")) {
                this.m_facPrefix = args[++i];
            } else if (args[i].equals("-package")) {
                this.m_package = args[++i];
            } else if (args[i].equals("-output")) {
                this.m_output = args[++i];
            } else if (args[i].equals("-type")) {
                arg.m_type = args[++i];
            } else if (args[i].equals("-cVersion")) {
                arg.m_cVersion = args[++i];
            } else if (args[i].equals("-pVersion")) {
                arg.m_pVersion = args[++i];
            } else if (args[i].equals("-name")) {
                arg.setName(args[++i]);
            } else if (args[i].equals("-implementation") || args[i].equals("-impl")) {
                this.m_impl = new Boolean(args[++i]);
            } else if (args[i].equals("-private")) {
                arg.m_private = new Boolean(args[++i]);
            } else if (args[i].equals("-template")) {
                arg.m_template = new Boolean(args[++i]);
            } else if (args[i].equals("-property")) {
                arg = null;
                String pFile = args[++i];
                try {
                    XProperties prop = new XProperties();
                    FileInputStream is = new FileInputStream(pFile);
                    prop.load(is);
                    this.m_url = prop.getProperty("url", this.m_url);
                    this.m_user = prop.getProperty("user", this.m_user);
                    this.m_password = prop.getProperty("password", this.m_password);
                    this.m_domain = prop.getProperty("domain", this.m_domain);
                    this.m_facPrefix = this.handleFactoryPrefixCase(prop.getProperty("factory-prefix", this.m_facPrefix));
                    this.m_factory = prop.getBooleanProperty("factory", this.m_factory);
                    this.m_package = prop.getProperty("package", this.m_package);
                    this.m_output = prop.getProperty("output", this.m_output);
                    this.m_impl = prop.getBooleanProperty("implementation", this.m_impl);
                    String[] list = prop.getStringArrayProperty("generate");
                    for (int j = 0; j < list.length; ++j) {
                        this.parseProperties(prop, list[j]);
                    }
                }
                catch (Exception e) {
                    throw new Exception("Failed to load properties " + pFile + " - " + e.getMessage());
                }
            } else {
                throw new Exception("Unsupported argument " + args[i]);
            }
            ++i;
        }
        if (this.m_output == null) {
            throw new Exception("'output' is not specified");
        }
        if (arg != null) {
            arg.validate();
            this.m_argList.add(arg);
        }
    }

    private String handleFactoryPrefixCase(String prefix) {
        if (prefix.length() <= 3) {
            return prefix.toUpperCase();
        }
        String subString = prefix.substring(0, 1);
        return subString.toUpperCase() + prefix.substring(1).toLowerCase();
    }

    private void parseProperties(XProperties prop, String type) throws Exception {
        GenerateArg arg = new GenerateArg();
        arg.m_type = type;
        arg.setName(prop.getProperty(type + "." + "name"));
        arg.m_cVersion = prop.getProperty(type + "." + "cVersion");
        arg.m_pVersion = prop.getProperty(type + "." + "pVersion");
        arg.m_private = prop.getBooleanProperty(type + "." + "private");
        arg.m_template = prop.getBooleanProperty(type + "." + "template");
        arg.validate();
        this.m_argList.add(arg);
    }

    private void printAnnotation(int indent, String annotation) {
        this.println(this.m_aiWriter, indent, " * ");
        StringTokenizer token = new StringTokenizer(annotation, "\n");
        while (token.hasMoreTokens()) {
            this.println(this.m_aiWriter, indent, " * " + token.nextToken());
        }
        this.println(this.m_aiWriter, indent, " * ");
    }

    private void printUsage() {
        System.out.println("com.sonicsw.mf.gui.config.api.GenerateBean");
        System.out.println("    [-url <DS URL>]                     (Default = localhost)");
        System.out.println("    [-user <DS user name>]              (Default = Administrator)");
        System.out.println("    [-password <DS password>]           (Default = Administrator)");
        System.out.println("    [-domain <DS domain>]               (Default = Domain1)");
        System.out.println("    [-type <config type name>]          (Default = None)");
        System.out.println("    [-cVersion <config version>]        (Default = None)");
        System.out.println("    [-pVersion <product version>]       (Default = None)");
        System.out.println("    [-package <generated package>]      (Default = com.sonicsw.mf.mgmtapi.config)");
        System.out.println("    [-name <generated name>]            (Default = None)");
        System.out.println("    [-impl <true or false>]             (Default = false)");
        System.out.println("    [-private <true or false>]          (Default = false)");
        System.out.println("    [-template <true or false>]         (Default = true)");
        System.out.println("    [-factoryPrefix <factory prefix>]   (Default = MF)");
        System.out.println("    [-factory <true or false>]          (Default = false)");
        System.out.println("    [-output <generated file location>] (Default = None)");
        System.out.println("    [-property <property file location>] (Default = None)");
    }

    private void closeWriter(Writer writer) throws IOException {
        if (writer != null) {
            writer.flush();
            writer.close();
        }
    }

    public static void main(String[] args) {
        try {
            GenerateBean bean = new GenerateBean(args);
            bean.generate();
            bean.disconnect();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            while (e != null && e instanceof ConfigServiceException) {
                if ((e = ((ConfigServiceException)((Object)e)).getLinkedException()) == null) continue;
                System.out.println(e.getMessage());
            }
            System.exit(-1);
        }
        System.exit(0);
    }

    private class LocalInnerClass {
        public String m_name;
        public String m_type;
        public IAttributeDescription m_desc;

        public LocalInnerClass(String name, String type, IAttributeDescription desc) {
            this.m_name = name;
            this.m_type = type;
            this.m_desc = desc;
        }
    }

    private class GenerateArg {
        String m_type = null;
        String m_cVersion = null;
        String m_pVersion = null;
        private String m_name = null;
        private String m_className = null;
        boolean m_private = false;
        boolean m_template = false;

        private GenerateArg() {
        }

        public void validate() throws Exception {
            if (this.m_type == null) {
                throw new Exception("'type' is not specified");
            }
            if (this.m_cVersion == null) {
                throw new Exception("'cVersion' is not specified");
            }
            if (this.m_pVersion == null) {
                throw new Exception("'pVersion' is not specified");
            }
            if (this.m_name == null) {
                throw new Exception("'name' is not specified");
            }
            if (this.m_className == null) {
                throw new Exception("'className' is not specified");
            }
        }

        public void setName(String name) {
            this.m_name = name;
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(name, " _");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (Character.isUpperCase(token.charAt(0))) {
                    sb.append(token);
                    continue;
                }
                sb.append(Character.toUpperCase(token.charAt(0)));
                sb.append(token.substring(1));
            }
            this.m_className = sb.toString();
        }

        public String getName() {
            return this.m_name;
        }

        public String getClassName() {
            return this.m_className;
        }
    }
}

