/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.util;

import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFProxyException;
import com.sonicsw.mf.common.MFProxyRuntimeException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.EqualExpression;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromFolder;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.Where;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.impl.Util;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class ConfigHelper {
    public static final String MA_SYSTEM = "SYSTEM";
    public static final String FOLDER_SYSTEM = "/System";

    public static IConfigBean createBean(IConfigServer server, String newName, String type, String configVersion, String productVersion) throws ConfigServiceException {
        return ConfigHelper.createBean(server, newName, type, configVersion, productVersion, false);
    }

    public static IConfigBean createBean(IConfigServer server, String newName, String type, String configVersion, String productVersion, boolean isTemplate) throws ConfigServiceException {
        IConfigBean bean = server.createConfigBean(newName, type, configVersion, isTemplate);
        HashMap<String, String> metaMap = new HashMap<String, String>();
        metaMap.put("TYPE", type);
        metaMap.put("PRODUCT_VERSION", productVersion);
        metaMap.put("CONFIG_VERSION", configVersion);
        if (isTemplate) {
            metaMap.put("TEMPLATE_TYPE", "prototype");
        }
        bean.setMetaAttributes(metaMap);
        return bean;
    }

    public static IConfigBean createPrototypeBean(IConfigBean regularBean, String newName) throws ConfigServiceException {
        IConfigBean prototypeBean = (IConfigBean)((Object)regularBean.createPrototype(newName));
        HashMap metaMap = regularBean.getMetaAttributes();
        metaMap.put("TEMPLATE_TYPE", "prototype");
        prototypeBean.setMetaAttributes(Util.mapToHashMap(metaMap));
        return prototypeBean;
    }

    public static IConfigBean createInstanceBean(IConfigPrototype prototypeBean, String newName) throws ConfigServiceException {
        IConfigBean instanceBean = (IConfigBean)prototypeBean.newInstance(newName);
        HashMap metaMap = ((IConfigBean)((Object)prototypeBean)).getMetaAttributes();
        metaMap.put("TEMPLATE_TYPE", "instance");
        instanceBean.setMetaAttributes(Util.mapToHashMap(metaMap));
        return instanceBean;
    }

    public static IConfigBean copyBean(IConfigBean inBean, String newName) throws ConfigServiceException {
        IConfigBean outBean = null;
        if (inBean.isPrototypeInstance()) {
            outBean = (IConfigBean)inBean.clonePrototypeInstance(newName);
        } else {
            outBean = (IConfigBean)inBean.clone();
            outBean.setName(newName);
        }
        HashMap metaMap = inBean.getMetaAttributes();
        outBean.setMetaAttributes(Util.mapToHashMap(metaMap));
        return outBean;
    }

    public static String buildPath(String base, String name) {
        StringBuffer sb = new StringBuffer(base);
        if (!base.endsWith("/")) {
            sb.append("/");
        }
        return sb.append(name).toString();
    }

    public static Object createChild(IAttributeMap top, IConfigPath childPath) {
        Cloneable child = null;
        try {
            IAttributeMap parent;
            IAttributeDescription ad = top.getAttributeDescription().getAttributeDescription(childPath);
            IConfigPath parentPath = ConfigFactory.createConfigPath(childPath);
            parentPath.removeComponent(childPath.size() - 1);
            IAttributeMap iAttributeMap = parent = parentPath.size() == 0 ? top : (IAttributeMap)top.getAttribute(parentPath);
            if (ad.getType().equals(IAttributeMap.class)) {
                child = parent.createAttributeMap(childPath.getLastComponent());
            } else if (ad.getType().equals(IAttributeList.class)) {
                child = parent.createAttributeList(childPath.getLastComponent());
            }
        }
        catch (ConfigServiceException e) {
            e.printStackTrace();
        }
        return child;
    }

    public static void throwConfigServiceException(String message, Exception e) throws ConfigServiceException {
        if (e instanceof ConfigServiceException) {
            throw (ConfigServiceException)((Object)e);
        }
        throw new ConfigServiceException(message, e);
    }

    public static String generateName(String name) {
        if (!name.equals(name.toUpperCase())) {
            StringBuffer token = new StringBuffer(name);
            token.setCharAt(0, Character.toUpperCase(token.charAt(0)));
            return token.toString();
        }
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(name, "_");
        while (st.hasMoreTokens()) {
            StringBuffer token = new StringBuffer(st.nextToken().toLowerCase());
            token.setCharAt(0, Character.toUpperCase(token.charAt(0)));
            buffer.append(token);
        }
        return buffer.toString();
    }

    public static boolean isEqual(IAttributeMap data1, IAttributeMap data2) {
        for (String attributeName : data1.keySet()) {
            if (attributeName.startsWith("_MF")) continue;
            Object obj1 = null;
            Object obj2 = null;
            try {
                obj1 = data1.get(attributeName);
            }
            catch (ConfigServiceRuntimeException e) {
                // empty catch block
            }
            try {
                obj2 = data2.get(attributeName);
            }
            catch (ConfigServiceRuntimeException e) {
                // empty catch block
            }
            if (ConfigHelper.doIsEqual(obj1, obj2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(IAttributeList data1, IAttributeList data2) {
        for (int i = 0; i < data1.size(); ++i) {
            Object obj1 = null;
            Object obj2 = null;
            try {
                obj1 = data1.get(i);
            }
            catch (ConfigServiceRuntimeException e) {
                // empty catch block
            }
            try {
                obj2 = data2.get(i);
            }
            catch (ConfigServiceRuntimeException e) {
                // empty catch block
            }
            if (ConfigHelper.doIsEqual(obj1, obj2)) continue;
            return false;
        }
        return true;
    }

    protected static boolean doIsEqual(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (!(obj1 instanceof IConfigElement && obj2 instanceof IConfigElement || obj1 instanceof IConfigPrototype && obj2 instanceof IConfigPrototype || obj1.getClass().equals(obj2.getClass()))) {
            return false;
        }
        return !(obj1 instanceof IAttributeMap ? !ConfigHelper.isEqual((IAttributeMap)obj1, (IAttributeMap)obj2) : (obj1 instanceof IAttributeList ? !ConfigHelper.isEqual((IAttributeList)obj1, (IAttributeList)obj2) : !obj1.equals(obj2)));
    }

    public static boolean isInstanceOf(IConfigBean instance, IConfigBean prototype) {
        if (!instance.isPrototypeInstance()) {
            return false;
        }
        return instance.getPrototype() == prototype;
    }

    private static final List getInstancesList(IConfigPrototype prototype) throws ConfigServiceException {
        ArrayList list = new ArrayList();
        for (Object instance : prototype.getPrototypeInstances()) {
            if (instance == null) continue;
            list.add(instance);
        }
        return list;
    }

    public static final IConfigElement[] getInstancesOf(IConfigPrototype prototype) throws ConfigServiceException {
        List iList = ConfigHelper.getInstancesList(prototype);
        return iList.toArray(new IConfigElement[iList.size()]);
    }

    public static final IConfigBean[] getBeanInstancesOf(IConfigPrototype prototype) throws ConfigServiceException {
        List iList = ConfigHelper.getInstancesList(prototype);
        return iList.toArray(new IConfigBean[iList.size()]);
    }

    public static final IConfigBean loadConfigBean(IConfigServer server, IConfigBean bean) throws ConfigServiceException {
        return (IConfigBean)server.loadConfigElement(bean.getName());
    }

    public static final IConfigBean[] loadConfigBean(IConfigServer server, IConfigBean[] bean) throws ConfigServiceException {
        IConfigBean[] res = new IConfigBean[bean.length];
        for (int i = 0; i < bean.length; ++i) {
            res[i] = (IConfigBean)server.loadConfigElement(bean[i].getName());
        }
        return res;
    }

    public static Iterator getAttributeIterator(Object attribute) {
        if (attribute instanceof IAttributeList) {
            return ((IAttributeList)attribute).listIterator();
        }
        if (attribute instanceof IAttributeMap) {
            return ((IAttributeMap)attribute).keySet().iterator();
        }
        return new EmptyIterator();
    }

    public static Object getNextAttribute(Object attribute, Iterator i) {
        Object nextAttribute = i.next();
        if (attribute instanceof IAttributeList) {
            return nextAttribute;
        }
        if (attribute instanceof IAttributeMap) {
            return ((IAttributeMap)attribute).getAttribute((String)nextAttribute);
        }
        return null;
    }

    public static Object deleteAttribute(Object attribute, Object delObject) {
        Object res;
        block3: {
            block2: {
                res = null;
                if (!(attribute instanceof IAttributeList)) break block2;
                if (!((IAttributeList)attribute).remove(delObject)) break block3;
                res = delObject;
                break block3;
            }
            if (attribute instanceof IAttributeMap) {
                for (String key : ((IAttributeMap)attribute).keySet()) {
                    Object entry = ((IAttributeMap)attribute).getAttribute(key);
                    if (entry != delObject) continue;
                    res = ((IAttributeMap)attribute).remove(key);
                    break;
                }
            }
        }
        return res;
    }

    public static void addAttribute(Object attribute, Object addObject) throws ConfigServiceException {
        if (attribute instanceof IAttributeList) {
            ((IAttributeList)attribute).addAttribute(addObject);
        } else if (attribute instanceof IAttributeMap) {
            ((IAttributeMap)attribute).setAttribute(ConfigFactory.createGUID(), addObject);
        }
    }

    public static void setAttribute(Object parent, Object key, Object value) throws ConfigServiceException {
        if (parent instanceof IAttributeList) {
            if (key != null) {
                if (!(key instanceof Integer)) {
                    throw new ConfigServiceException("setAttribute on an AttributeList needs integer key: key was " + key.getClass().getName());
                }
                Integer index = (Integer)key;
                if (index >= 0) {
                    ((IAttributeList)parent).setAttribute(index, value);
                } else {
                    ((IAttributeList)parent).addAttribute(value);
                }
            } else {
                ((IAttributeList)parent).addAttribute(value);
            }
        } else if (parent instanceof IAttributeMap) {
            if (key != null) {
                ((IAttributeMap)parent).setAttribute(key.toString(), value);
            } else {
                ((IAttributeMap)parent).setAttribute(ConfigFactory.createGUID(), value);
            }
        }
    }

    public static Object getAttributeKey(Object parent, Object child) {
        block3: {
            block2: {
                if (!(parent instanceof IAttributeMap)) break block2;
                IAttributeMap map = (IAttributeMap)parent;
                for (String mapKey : map.keySet()) {
                    Object mapValue = map.getAttribute(mapKey);
                    if (mapValue == null || mapValue != child) continue;
                    return mapKey;
                }
                break block3;
            }
            if (!(parent instanceof IAttributeList)) break block3;
            IAttributeList list = (IAttributeList)parent;
            for (int i = 0; i < list.size(); ++i) {
                Object listValue = list.getAttribute(i);
                if (listValue == null || listValue != child) continue;
                return new Integer(i);
            }
        }
        return null;
    }

    public static void createFile(IConfigServer configServer, String dsPath, String user) throws ConfigServiceException {
        try {
            IConfigElement element = configServer.loadConfigElement(dsPath);
            if (element != null) {
                if (!(element instanceof IConfigBeanFile)) {
                    throw new ConfigServiceException("csu-import-file-exists", new Object[]{dsPath});
                }
            } else {
                String parent = dsPath.substring(0, dsPath.lastIndexOf(47));
                if (parent != null && parent.length() > 0) {
                    configServer.createPath(parent, true);
                }
                element = configServer.createConfigBeanFile(dsPath, user);
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("TYPE", "MF_FILE");
                element.setMetaAttributes(meta);
            }
            configServer.storeConfigElement(element);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-import-file-failed", new Object[]{"na"}, e);
        }
    }

    public static void importFile(IConfigServer configServer, String dsPath, String fsPath, String user, boolean overwrite) throws ConfigServiceException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(fsPath);
            IConfigElement element = configServer.loadConfigElement(dsPath);
            if (element != null) {
                if (!(element instanceof IConfigBeanFile) || !overwrite) {
                    throw new ConfigServiceException("csu-import-file-exists", new Object[]{dsPath});
                }
            } else {
                String parent = dsPath.substring(0, dsPath.lastIndexOf(47));
                if (parent != null && parent.length() > 0) {
                    configServer.createPath(parent, true);
                }
                element = configServer.createConfigBeanFile(dsPath, user);
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("TYPE", "MF_FILE");
                element.setMetaAttributes(meta);
            }
            ((IConfigBeanFile)element).setContents(stream);
            configServer.storeConfigElement(element);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-import-file-failed", new Object[]{fsPath}, e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static String[] getOrderedFolders(String path) {
        ArrayList<String> res = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, "/", false);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append('/');
            sb.append(st.nextToken());
            res.add(sb.toString());
        }
        return res.toArray(new String[res.size()]);
    }

    public static void setMetaAttribute(IConfigServer server, String path, String key, String value) throws ConfigServiceException {
        HashMap<String, String> map = null;
        try {
            map = server.getMetaAttributes(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            map = new HashMap<String, String>();
        }
        map.put(key, value);
        server.setMetaAttributes(path, map);
    }

    public static boolean isAttrValueUniqueWithinFolder(IConfigServer configServer, String logicalPath, IConfigPath attrKey, String attrValue) throws ConfigServiceException {
        return ConfigHelper.isAttrValueUniqueWithinFolder(configServer, logicalPath, attrKey.toString(), attrValue);
    }

    public static boolean isAttrValueUniqueWithinFolder(IConfigServer configServer, String logicalPath, String attrKey, String attrValue) throws ConfigServiceException {
        try {
            EqualExpression ee = new EqualExpression(new AttributeName(attrKey), attrValue);
            Where w = new Where(new BooleanExpression[]{ee});
            Query query = new Query().setFrom((From)new FromFolder(logicalPath)).setWhere(w);
            Set set = configServer.listConfigElements(query);
            return set.isEmpty();
        }
        catch (Exception e) {
            ConfigServiceException ee = new ConfigServiceException("isAttrValueUniqueWithinFolder(" + logicalPath + ", " + attrKey + " = " + attrValue + ")");
            ee.setLinkedException(e);
            throw ee;
        }
    }

    public static boolean isAttrsValuesUniqueWithinFolder(IConfigServer configServer, String logicalPath, String beanName, String[] attrKeys, String[] attrValues) throws ConfigServiceException {
        try {
            ArrayList<EqualExpression> booleanExpression = new ArrayList<EqualExpression>(attrKeys.length);
            for (int i = 0; i < attrKeys.length; ++i) {
                booleanExpression.add(new EqualExpression(new AttributeName(attrKeys[i]), attrValues[i]));
            }
            Where w = new Where(booleanExpression.toArray(new BooleanExpression[attrKeys.length]));
            Query query = new Query().setFrom((From)new FromFolder(logicalPath)).setWhere(w);
            Set set = configServer.listConfigElements(query);
            if (beanName != null && set.contains(beanName)) {
                set.remove(beanName);
            }
            return set.isEmpty();
        }
        catch (Exception e) {
            ConfigServiceException ee = new ConfigServiceException("isAttrsValuesUniqueWithinFolder(" + logicalPath + ")");
            ee.setLinkedException(e);
            throw ee;
        }
    }

    public static String[] buildGroupNamesList(IConfigServer server, String path, String initialValue) {
        ArrayList<String> list = new ArrayList<String>();
        Query query = new Query().setFrom((From)new FromFolder(path));
        try {
            Set set = server.listConfigElements(query);
            if (initialValue != null) {
                list.add("<None>");
            }
            for (String name : set) {
                list.add(name.substring(name.lastIndexOf(47) + 1));
            }
        }
        catch (ConfigServiceException ce) {
            ce.printStackTrace();
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    public static void printExceptionInfo(Throwable e) {
        PrintWriter pw = new PrintWriter(System.err);
        ConfigHelper.printExceptionInfo(e, pw, false);
    }

    public static void printExceptionInfo(Throwable e, PrintWriter pw) {
        ConfigHelper.printExceptionInfo(e, pw, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printExceptionInfo(Throwable e, PrintWriter pw, boolean isCause) {
        if (e instanceof MFProxyException && ((MFProxyException)e).getActualException() != null) {
            e = ((MFProxyException)e).getActualException();
        } else if (e instanceof MFProxyRuntimeException && ((MFProxyRuntimeException)e).getActualException() != null) {
            e = ((MFProxyRuntimeException)e).getActualException();
        } else if (e instanceof ProxyRuntimeException && ((ProxyRuntimeException)e).getTargetException() != null) {
            e = ((ProxyRuntimeException)e).getTargetException();
        }
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            if (isCause) {
                pw.print("Caused by: ");
            }
            pw.println(e);
            StackTraceElement[] trace = e.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                pw.println("\tat " + trace[i]);
            }
            pw.flush();
        }
        if (e instanceof MgmtException && ((MgmtException)e).getLinkedException() != null) {
            ConfigHelper.printExceptionInfo(((MgmtException)e).getLinkedException(), pw, true);
        } else if (e instanceof ConfigServiceException && ((ConfigServiceException)((Object)e)).getLinkedException() != null) {
            ConfigHelper.printExceptionInfo(((ConfigServiceException)((Object)e)).getLinkedException(), pw, true);
        } else if (e instanceof MFException && ((MFException)e).getLinkedException() != null) {
            ConfigHelper.printExceptionInfo(((MFException)e).getLinkedException(), pw, true);
        } else if (e instanceof MFRuntimeException && ((MFRuntimeException)e).getLinkedException() != null) {
            ConfigHelper.printExceptionInfo(((MFRuntimeException)e).getLinkedException(), pw, true);
        } else if (e instanceof ReflectionException) {
            ConfigHelper.printExceptionInfo(((ReflectionException)e).getTargetException(), pw, true);
        } else if (e instanceof MBeanException) {
            ConfigHelper.printExceptionInfo(((MBeanException)e).getTargetException(), pw, true);
        } else if (e instanceof InvocationTargetException) {
            ConfigHelper.printExceptionInfo(((InvocationTargetException)e).getTargetException(), pw, true);
        } else if (e instanceof RuntimeOperationsException) {
            ConfigHelper.printExceptionInfo(((RuntimeOperationsException)e).getTargetException(), pw, true);
        } else if (e instanceof RuntimeMBeanException) {
            ConfigHelper.printExceptionInfo(((RuntimeMBeanException)e).getTargetException(), pw, true);
        } else if (e instanceof RuntimeErrorException) {
            ConfigHelper.printExceptionInfo(((RuntimeErrorException)e).getTargetError(), pw, true);
        } else if (e.getCause() != null) {
            ConfigHelper.printExceptionInfo(e.getCause(), pw, true);
        }
    }

    static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

