/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.impl.ConfigBeanImpl;
import com.sonicsw.mx.config.impl.ConfigServer;
import java.io.InputStream;

public class ConfigBeanFile
extends ConfigBeanImpl
implements IConfigBeanFile {
    public static final String CONFIG_TYPE = "MF_FILE";
    public static final String CONFIG_VERSION = "100";
    public static final String PRODUCT_VERSION = "2.1";
    public static final IConfigPath CREATION_TIME = ConfigFactory.createConfigPath("CREATION_TIME");
    public static final IConfigPath LAST_MODIFIED_TIME = ConfigFactory.createConfigPath("LAST_MODIFIED_TIME");
    public static final IConfigPath SIZE = ConfigFactory.createConfigPath("SIZE");
    public static final IConfigPath CREATED_BY = ConfigFactory.createConfigPath("CREATED_BY");
    public static final IConfigPath PERMISSIONS = ConfigFactory.createConfigPath("PERMISSIONS");
    public static final IConfigPath HIDDEN = ConfigFactory.createConfigPath("HIDDEN");
    public static final String IDENTITY_ELEMENT_TYPE_STRING = "MF_FILE";

    protected ConfigBeanFile(IDirElement dsBeanElement, ConfigServer cs) throws ConfigServiceException {
        super(dsBeanElement, cs);
    }

    protected ConfigBeanFile(String name, String user, ConfigServer configServer) throws ConfigServiceException {
        super(name, "MF_FILE", CONFIG_VERSION, configServer);
        Long timeNow = new Long(System.currentTimeMillis());
        this.setAttribute(CREATION_TIME, (Object)timeNow);
        this.setAttribute(LAST_MODIFIED_TIME, (Object)timeNow);
        this.setAttribute(SIZE, (Object)new Integer(0));
        this.setAttribute(CREATED_BY, (Object)(user != null ? user : ""));
        this.setAttribute(PERMISSIONS, (Object)"");
        this.setAttribute(HIDDEN, (Object)Boolean.FALSE);
    }

    @Override
    public IConfigPrototype createPrototype(String name) throws ConfigServiceException {
        throw new ConfigServiceException("cbf-create-proto-not-supported");
    }

    @Override
    public long getCreationTime() {
        return (Long)this.getAttribute(CREATION_TIME);
    }

    @Override
    public long getLastModifiedTime() {
        return (Long)this.getAttribute(LAST_MODIFIED_TIME);
    }

    @Override
    public String getCreateBy() {
        return (String)this.getAttribute(CREATED_BY);
    }

    @Override
    public int getFileSize() {
        return (Integer)this.getAttribute(SIZE);
    }

    @Override
    public void setContents(InputStream contents) throws ConfigServiceException {
        try {
            int size = contents.available();
            this.setInputStream(contents);
            this.setAttribute(SIZE, (Object)new Integer(size));
            this.setAttribute(LAST_MODIFIED_TIME, (Object)new Long(System.currentTimeMillis()));
        }
        catch (Exception e) {
            throw new ConfigServiceException("cbf-set-contents-failed", e);
        }
    }

    @Override
    public InputStream getContents() throws ConfigServiceException {
        return this.getInputStream();
    }
}

