/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.Select;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.directory.DirectoryServiceFactory;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mx.config.ConfigServerFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.IFileExistHandler;
import com.sonicsw.mx.config.IInitialValues;
import com.sonicsw.mx.config.impl.ConfigBeanDocument;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.ConfigTypeDocument;
import com.sonicsw.mx.config.impl.ConfigTypeImpl;
import com.sonicsw.mx.config.impl.InitialValuesImpl;
import com.sonicsw.mx.config.impl.Util;
import com.sonicsw.mx.config.util.ConfigHelper;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public class ConfigServerUtility {
    public static final String EXCLUDE_CONTAINERS_PROP = "exclude_containers";
    public static final String NEW_SEARCH_PATH_PROP = "new_search_path";
    public static final String CONTAINER_LIST_PROP = "container_list";
    public static final String TYPE = "TYPE";
    public static final String CONFIG_VERSION = "CONFIG_VERSION";
    public static final String PRODUCT_VERSION = "PRODUCT_VERSION";
    public static final String TEMPLATE_TYPE = "TEMPLATE_TYPE";
    public static final String EXCLUDE_TEMPLATE_TYPE = "EXCLUDE_TEMPLATE_TYPE";
    public static final String DEFAULT_SUFFIX = "_Default";
    public static final String DOMAIN_DESCRIPTOR_SUFFIX = "_MFDomainDescriptor";
    public static final String POLICY_DESCRIPTOR_SUFFIX = "_MQPolicyDescriptor";
    public static final String TEMPLATE_TYPE_PROTOTYPE = "prototype";
    public static final String TEMPLATE_TYPE_INSTANCE = "instance";
    protected IConfigServer m_configServer = null;
    protected IRemoteMBeanServer m_server = null;
    protected IDirectoryFileSystemService m_dfs = null;
    protected boolean m_isLocalDS = false;
    protected boolean m_isOwnedDS = false;
    protected String m_user = null;
    protected long m_connectTimeout = -1L;
    protected long m_requestTimeout = -1L;
    protected boolean m_loadBalancing = true;
    protected boolean m_enableCompression = false;
    protected boolean m_useDRA = false;
    protected String m_managementNode = null;
    protected String m_requiredVersion = null;
    private int m_socketConnectTimeout;

    public long getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setConnectTimeout(long seconds) {
        this.m_connectTimeout = seconds;
    }

    public long getRequestTimeout() {
        return this.m_requestTimeout;
    }

    public void setRequestTimeout(long seconds) {
        this.m_requestTimeout = seconds;
    }

    public boolean isLoadBalancing() {
        return this.m_loadBalancing;
    }

    public void setLoadBalancing(boolean loadBalancing) {
        this.m_loadBalancing = loadBalancing;
    }

    public boolean isEnableCompression() {
        return this.m_enableCompression;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.m_enableCompression = enableCompression;
    }

    public boolean isUseDRA() {
        return this.m_useDRA;
    }

    public void setUseDRA(boolean useDRA) {
        this.m_useDRA = useDRA;
    }

    public String getManagementNode() {
        return this.m_managementNode;
    }

    public void setManagementNode(String managementNode) {
        this.m_managementNode = managementNode;
    }

    public void setRequiredVersion(String version) {
        this.m_requiredVersion = version;
    }

    public String getRequiredVersion() {
        return this.m_requiredVersion;
    }

    public boolean isLocal() {
        return this.m_isLocalDS;
    }

    public final void connect(String domain, String url, String user, String password, boolean forUpdate) throws ConfigServiceException {
        this.m_user = user;
        try {
            if (url.endsWith(".xml")) {
                this.connect(this.createDSConnection(url, password), forUpdate);
            } else {
                this.m_server = this.createMBeanServerConnection(url, user, password);
                this.connect(this.createDSConnection(this.m_server, domain), forUpdate);
            }
            this.m_isOwnedDS = true;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigServerUtility.createCsuConnectFailedError(e);
        }
    }

    public void connect(IDirectoryFileSystemService ds, boolean forUpdate) throws ConfigServiceException {
        try {
            this.pingDirectoryService(ds);
            this.checkForRequiredVersion(ds);
            this.m_dfs = ds;
            this.m_configServer = this.createConfigServer(ds, forUpdate);
            this.m_isLocalDS = !(ds instanceof DirectoryServiceProxy);
            this.m_isOwnedDS = false;
            ((ConfigServer)this.m_configServer).setFilterDefaults(true);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigServerUtility.createCsuConnectFailedError(e);
        }
    }

    private static ConfigServiceException createCsuConnectFailedError(Exception e) {
        ConfigServiceException cse = new ConfigServiceException("csu-connect-failed-error", e);
        cse.setErrorArgs(new String[]{e.getMessage()});
        return cse;
    }

    private void checkForRequiredVersion(IDirectoryFileSystemService ds) throws ConfigServiceException {
        if (this.m_requiredVersion == null) {
            return;
        }
        String version = null;
        try {
            version = ((IDirectoryAdminService)ds).getDirectoryServiceReleaseVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (version == null || !version.startsWith(this.m_requiredVersion)) {
            throw new ConfigServiceException("csu-invalid-ds-version");
        }
    }

    protected IConfigServer createConfigServer(IDirectoryFileSystemService ds, boolean forUpdate) throws ConfigServiceException {
        return ConfigServerFactory.connectConfigServer(ds, forUpdate);
    }

    public IRemoteMBeanServer createMBeanServerConnection(String url, String user, String password) throws Exception {
        long connectTimeout;
        JMSConnectorClient server = new JMSConnectorClient();
        if (this.getRequestTimeout() != -1L) {
            server.setRequestTimeout(this.getRequestTimeout() * 1000L);
        }
        if (this.getSocketConnectTimeout() != -1) {
            long socketConnectTimeout = this.getSocketConnectTimeout() * 1000;
            server.setSocketConnectTimeout(socketConnectTimeout);
        }
        long initialConnectTimeout = connectTimeout = 10000L;
        if (this.getConnectTimeout() != -1L) {
            connectTimeout = this.getConnectTimeout() * 1000L;
            server.setConnectTimeout(connectTimeout);
        }
        server.setFailWhenDisconnected(true);
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("ConnectionURLs", url);
        if (user != null) {
            env.put("DefaultUser", user);
        }
        if (password != null) {
            env.put("DefaultPassword", password);
        }
        env.put("LoadBalancingBoolean", new Boolean(this.isLoadBalancing()));
        env.put("EnableCompressionBoolean", new Boolean(this.isEnableCompression()));
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        String managementNode = this.getManagementNode();
        if (this.isUseDRA() && managementNode != null && managementNode.length() > 0) {
            address.setManagementNode(managementNode);
        }
        server.connect(address, initialConnectTimeout);
        return server;
    }

    private IDirectoryFileSystemService createDSConnection(IRemoteMBeanServer server, String domain) throws Exception {
        this.m_isLocalDS = false;
        return new DirectoryServiceProxy(server, new ObjectName(domain + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE"));
    }

    private IDirectoryFileSystemService createDSConnection(String filename, String decryptPasswordParam) throws Exception {
        IDirElement dsConfig;
        String decryptPassword = decryptPasswordParam;
        if (decryptPassword != null && decryptPassword.length() == 0) {
            decryptPassword = null;
        }
        if ((dsConfig = ContainerUtil.importConfiguration((File)new File(filename), (String)decryptPassword, (String)"MF_DIRECTORY_SERVICE")) == null) {
            dsConfig = ContainerUtil.importConfiguration((File)new File(filename), (String)decryptPassword, (String)"MF_BACKUP_DIRECTORY_SERVICE");
        }
        IAttributeSet dsAttributes = dsConfig.getAttributes();
        String hostDir = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
        String domainName = (String)dsAttributes.getAttribute("DOMAIN_NAME");
        Object tmp = dsAttributes.getAttribute("FILE_SYSTEM_STORAGE");
        if (domainName == null) {
            domainName = "Domain1";
        }
        if (tmp == null) {
            throw new Exception("Bad Directory Service Configuration - must contain DOMAIN_NAME and FILE_SYSTEM_STORAGE.");
        }
        if (!(tmp instanceof IAttributeSet)) {
            throw new Exception("Bad Directory Service Configuration - FILE_SYSTEM_STORAGE must be an attribute set.");
        }
        IAttributeSet fsStorage = (IAttributeSet)tmp;
        String hostDirDepricated = (String)fsStorage.getAttribute("HOST_DIRECTORY");
        String password = (String)fsStorage.getAttribute("PASSWORD");
        Hashtable<String, String> directoryEnv = new Hashtable<String, String>();
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        if (hostDirDepricated != null) {
            hostDirDepricated = ConfigServerUtility.convertToAbsolute(hostDirDepricated, filename);
            directoryEnv.put("FS_HOST_DIRECTORY_ATTRIBUTE", hostDirDepricated);
        }
        if (hostDir != null) {
            hostDir = ConfigServerUtility.convertToAbsolute(hostDir, filename);
            directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", hostDir);
        }
        if (password != null && password.length() != 0) {
            directoryEnv.put("PASSWORD", password);
        }
        this.m_isLocalDS = true;
        return new DirectoryServiceFactory(directoryEnv).createDirectoryService(domainName);
    }

    private static String convertToAbsolute(String hostDir, String referenceFile) throws IOException {
        File hostDirFile = new File(hostDir);
        if (!hostDirFile.isAbsolute()) {
            File ref = new File(referenceFile);
            return new File(ref.getAbsoluteFile().getParentFile(), hostDir).getCanonicalPath();
        }
        return hostDir;
    }

    private int pingDirectoryService(IDirectoryFileSystemService ds) throws ConfigServiceException {
        try {
            return ds.getDirectoryServiceVersion();
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-ping-failed", new Object[]{ds.getDomain()}, e);
        }
    }

    public final void disconnect() throws ConfigServiceException {
        if (this.m_dfs != null) {
            try {
                if (this.m_isLocalDS && this.m_isOwnedDS) {
                    ((IDirectoryService)this.m_dfs).close();
                }
            }
            catch (Exception e) {
                throw new ConfigServiceException("csu-disconnect-failed", e);
            }
        }
        this.m_dfs = null;
        if (this.m_configServer != null) {
            this.m_configServer.close();
            this.m_configServer = null;
        }
        if (this.m_server != null) {
            this.m_server.disconnect();
            this.m_server = null;
        }
    }

    public IConfigServer getConfigServer() {
        return this.m_configServer;
    }

    public IRemoteMBeanServer getMBeanServer() {
        return this.m_server;
    }

    public String getDomain() {
        return this.m_dfs.getDomain();
    }

    public IDirectoryFileSystemService getDirectoryService() {
        return this.m_dfs;
    }

    public final void repairDanglingBeanReferences() throws ConfigServiceException {
        this.checkConnected();
        try {
            String[] exclusions = new String[]{"/mx", "/_MF", "/_MQQoPs", "/_MQACLs"};
            this.m_dfs.repairReferences(exclusions);
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-repair-references-failed", e);
        }
    }

    public IConfigBean importBean(String beanURL, boolean overwrite) throws ConfigServiceException {
        this.checkConnected();
        try {
            String url = Util.name2Url(beanURL);
            ConfigBeanDocument.ConfigBeanIdentity id = ConfigBeanDocument.parseIdentity(url);
            IConfigBean bean = this._importBean(url, id, false, overwrite);
            this.commitTransaction();
            return bean;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-import-bean-failed", new Object[]{beanURL}, e);
        }
    }

    public IConfigBean importBeanContent(String content, boolean overwrite) throws ConfigServiceException {
        this.checkConnected();
        try {
            ConfigBeanDocument.ConfigBeanIdentity id = ConfigBeanDocument.parseIdentityContent(content);
            IConfigBean bean = this._importBean(content, id, true, overwrite);
            this.commitTransaction();
            return bean;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-import-bean-content-failed", e);
        }
    }

    private final IConfigBean _importBean(String urlOrContent, ConfigBeanDocument.ConfigBeanIdentity id, boolean content, boolean overwrite) throws Exception {
        String parentFolder;
        String name = id.m_name;
        String type = id.m_typeName;
        String version = id.m_version;
        boolean folderElement = false;
        boolean complexType = false;
        boolean complexTypeChild = false;
        if (type.startsWith("MF_AUTHENTICATION") && !type.equals("MF_AUTHENTICATION_SPI") || type.startsWith("MQ_AUTHORIZATION") || type.startsWith("PIM_PARTNER")) {
            complexType = true;
        } else if (name.endsWith(DEFAULT_SUFFIX) && !type.equals("MF_FILE")) {
            folderElement = true;
        }
        if (type.equals("MF_AUTHENTICATION_GROUP") || type.equals("MF_AUTHENTICATION_USER") || type.equals("MQ_AUTHORIZATION_ACL") || type.equals("MQ_AUTHORIZATION_QOP") || type.equals("PIM_PARTNER")) {
            complexTypeChild = true;
        }
        if ((parentFolder = name.substring(0, name.lastIndexOf(47))).length() == 0) {
            parentFolder = "/";
        }
        String realParentFolder = new String(parentFolder);
        if (complexType) {
            parentFolder = parentFolder.substring(0, parentFolder.lastIndexOf(47));
        }
        if ((!complexType || complexType && !complexTypeChild) && !this.m_configServer.pathExists(parentFolder) && parentFolder != null && parentFolder.length() > 0) {
            this.m_configServer.createPath(parentFolder, true);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TYPE, type);
        map.put(CONFIG_VERSION, version);
        if (id.m_productVersion != null) {
            map.put(PRODUCT_VERSION, id.m_productVersion);
        }
        IConfigBean bean = null;
        bean = content ? ConfigBeanDocument.parseContent(urlOrContent, this.m_configServer, overwrite) : ConfigBeanDocument.parse(urlOrContent, this.m_configServer, overwrite);
        if (!complexType) {
            bean.setMetaAttributes(map);
        }
        this.m_configServer.storeConfigElement(bean);
        if (complexType && !complexTypeChild || folderElement) {
            this.m_configServer.setMetaAttributes(realParentFolder, map);
        }
        return bean;
    }

    public final void importBeanPath(String path, boolean overwrite) throws ConfigServiceException {
        this.checkConnected();
        try {
            ArrayList list = new ArrayList();
            this._getBeanPathIdentities(path, list);
            for (int i = 0; i < list.size(); ++i) {
                Object[] item = (Object[])list.get(i);
                this._importBean((String)item[1], (ConfigBeanDocument.ConfigBeanIdentity)item[0], false, overwrite);
            }
            this.commitTransaction();
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-import-bean-failed", new Object[]{path}, e);
        }
    }

    private void _getBeanPathIdentities(String path, List result) throws Exception {
        File[] fileArray;
        File file = new File(path);
        if (!file.exists()) {
            throw new ConfigServiceException("csu-import-bean-file-not-found", new Object[]{path});
        }
        if (file.isDirectory()) {
            fileArray = file.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        File[] list = fileArray;
        if (list != null) {
            int i;
            for (i = 0; i < list.length; ++i) {
                if (!list[i].isFile() || !list[i].toString().endsWith(".xml")) continue;
                String url = Util.name2Url(list[i].toString());
                try {
                    ConfigBeanDocument.ConfigBeanIdentity id = ConfigBeanDocument.parseIdentity(url);
                    result.add(new Object[]{id, url});
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (i = 0; i < list.length; ++i) {
                if (!list[i].isDirectory()) continue;
                this._getBeanPathIdentities(list[i].toString(), result);
            }
        }
    }

    public String exportBean(String beanName) throws ConfigServiceException {
        this.checkConnected();
        Util.validateConfigBeanName(beanName);
        IConfigBean bean = null;
        try {
            IConfigElement element = this.m_configServer.loadConfigElement(beanName);
            if (element instanceof IConfigBean) {
                bean = (IConfigBean)element;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bean == null || bean instanceof IConfigBeanFile) {
            return null;
        }
        return this.m_configServer.exportConfigBean(bean);
    }

    public void setSocketConnectTimeout(int seconds) {
        this.m_socketConnectTimeout = seconds;
    }

    public int getSocketConnectTimeout() {
        return this.m_socketConnectTimeout;
    }

    public String exportBean(String beanName, String filename) throws ConfigServiceException {
        ExportControl control = new ExportControl();
        control.doFile = false;
        control.doConfig = true;
        return this.exportBean(beanName, filename, null, control);
    }

    private String exportBean(String beanName, String filenameParam, IFileExistHandler handler, ExportControl control) throws ConfigServiceException {
        String filename = filenameParam;
        String xmlRes = null;
        if (filename == null || filename.length() == 0) {
            throw new ConfigServiceException("csu-export-filename-invalid", new Object[]{beanName, filename});
        }
        Util.validateConfigBeanName(beanName);
        InputStream is = null;
        try {
            IConfigElement element = this.m_configServer.loadConfigElement(beanName);
            if (control.doFile && element instanceof IConfigBeanFile) {
                IConfigBeanFile beanFile = (IConfigBeanFile)element;
                is = beanFile.getInputStream();
                if (is == null) {
                    is = new ByteArrayInputStream(new byte[0]);
                }
            } else if (control.doConfig && element instanceof IConfigBean) {
                filename = filename + ".xml";
                IConfigBean beanConfig = (IConfigBean)element;
                xmlRes = this.m_configServer.exportConfigBean(beanConfig);
                if (xmlRes != null) {
                    is = new StringBufferInputStream(xmlRes);
                }
            }
        }
        catch (Exception element) {
            // empty catch block
        }
        if (is == null) {
            return null;
        }
        try {
            File parent;
            File file = new File(filename);
            if (file.exists() && handler != null && !control.replaceAll) {
                int res = handler.fileExists(file, !control.single);
                switch (res) {
                    case 0: {
                        control.cancel = true;
                        return null;
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        control.replaceAll = true;
                        break;
                    }
                }
            }
            if (!(parent = file.getParentFile()).exists()) {
                parent.mkdirs();
            }
            this.writeToFile(is, file);
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-export-cant-write-file", new Object[]{beanName, filename}, e);
        }
        return xmlRes;
    }

    public final void exportBeanPath(String path, String outputDir) throws ConfigServiceException {
        this.exportBeanPath(path, outputDir, null, true, false);
    }

    public void exportBeanPath(String path, String outputDir, IFileExistHandler handler, boolean doConfig, boolean doFile) throws ConfigServiceException {
        ExportControl control = new ExportControl();
        control.doConfig = doConfig;
        control.doFile = doFile;
        this.exportBeanPath(new String[]{path}, outputDir, handler, doConfig, doFile);
    }

    public void exportBeanPath(String[] path, String outputDir) throws ConfigServiceException {
        this.exportBeanPath(path, outputDir, null, true, false);
    }

    public void exportBeanPath(String[] path, String outputDir, IFileExistHandler handler, boolean doConfig, boolean doFile) throws ConfigServiceException {
        this.checkConnected();
        ExportControl control = new ExportControl();
        control.doConfig = doConfig;
        control.doFile = doFile;
        control.single = path.length == 1 && !this.isFolder(path[0]);
        this.exportBeanPath(path, outputDir, handler, control);
    }

    private void exportBeanPath(String[] path, String outputDir, IFileExistHandler handler, ExportControl control) throws ConfigServiceException {
        for (int i = 0; i < path.length; ++i) {
            if (control.cancel) {
                return;
            }
            Map metaMap = this.m_configServer.getMetaAttributes(path[i]);
            if (metaMap != null && metaMap.get("_ELEMENT_IDENTITY") != null) {
                this.exportBean(path[i], outputDir + path[i], handler, control);
                continue;
            }
            this._exportBeanPath(path[i], outputDir, handler, control);
        }
    }

    private void _exportBeanPath(String path, String outputDir, IFileExistHandler handler, ExportControl control) throws ConfigServiceException {
        try {
            String[] list = this.listConfigElements(path);
            for (int i = 0; i < list.length; ++i) {
                if (control.cancel) {
                    return;
                }
                if (list[i].endsWith("/")) {
                    this.exportBeanPath(new String[]{list[i]}, outputDir, handler, control);
                    continue;
                }
                this.exportBean(list[i], outputDir + list[i], handler, control);
            }
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-export-cant-write-file", new Object[]{path, outputDir}, e);
        }
    }

    private boolean isFolder(String logicalPath) throws ConfigServiceException {
        this.checkConnected();
        if (logicalPath.equals("/")) {
            return true;
        }
        String parentPath = logicalPath.substring(0, logicalPath.lastIndexOf("/") + 1);
        for (String folder : this.m_configServer.listFolders(parentPath)) {
            if (!folder.equals(logicalPath)) continue;
            return true;
        }
        return false;
    }

    private void writeToFile(InputStream is, File file) throws ConfigServiceException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ConfigServiceException("failed to create: " + file);
        }
        try {
            int length;
            byte[] buffer = new byte[4096];
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new ConfigServiceException("failed during write of export file: " + file);
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteBeanPath(String path) throws ConfigServiceException {
        this.checkConnected();
        this.deleteBeanPath(this.m_configServer, path);
        this.commitTransaction();
    }

    public void deleteBeanPath(IConfigServer server, String path) throws ConfigServiceException {
        try {
            this._deleteBeanPath(server, path);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-delete-bean-path-failed", new Object[]{path}, e);
        }
    }

    private final void _deleteBeanPath(IConfigServer server, String path) throws Exception {
        Set set = server.listConfigElements(path);
        String[] names = set.toArray(new String[0]);
        server.removeConfigElements(names);
        set = server.listFolders(path);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            this._deleteBeanPath(server, iter.next().toString());
        }
        server.deleteFolder(path);
    }

    public String exportContainerBootConfiguration(IConfigElement containerConfigElement, String domainName) throws ConfigServiceException {
        this.checkConnected();
        return this.m_configServer.exportContainerBootConfiguration(containerConfigElement, domainName);
    }

    public String exportDSBootConfiguration(IConfigElement configElement) throws ConfigServiceException {
        this.checkConnected();
        return this.m_configServer.exportDSBootConfiguration(configElement);
    }

    public void deleteBean(String beanName) throws ConfigServiceException {
        this.checkConnected();
        Util.validateConfigBeanName(beanName);
        this.m_configServer.removeConfigElement(beanName);
        this.commitTransaction();
    }

    public IConfigType[] importType(String typeURL, String namespace, boolean overwrite) throws ConfigServiceException {
        this.checkConnected();
        try {
            Collection cConfigTypes = ConfigTypeDocument.parse(namespace, typeURL, (ConfigServer)this.m_configServer, null);
            ArrayList<String> cConfigTypeNames = new ArrayList<String>();
            for (IConfigType configType : cConfigTypes) {
                String typeName = configType.getName();
                String version = configType.getVersion();
                cConfigTypeNames.add(overwrite ? ConfigTypeImpl.convertTypeName2DSName(typeName, version) : null);
            }
            IConfigType[] configTypes = cConfigTypes.toArray(new IConfigType[0]);
            String[] configTypeNames = cConfigTypeNames.toArray(new String[0]);
            ((ConfigServer)this.m_configServer).storeConfigTypes(configTypes, configTypeNames);
            return configTypes;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-import-type-failed", new Object[]{typeURL}, e);
        }
    }

    public void importTypeProperties(String typeURL, String namespace, String path) throws ConfigServiceException {
        this.checkConnected();
        try {
            for (IConfigType configType : ConfigTypeDocument.parse(namespace, typeURL, (ConfigServer)this.m_configServer, path)) {
                String typeName = configType.getName();
                String version = configType.getVersion();
                ((ConfigServer)this.m_configServer).storeConfigTypes(new IConfigType[]{configType}, new String[]{ConfigTypeImpl.convertTypeName2DSName(typeName, version)});
            }
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-import-type-failed", new Object[]{typeURL}, e);
        }
    }

    public IConfigType importInitialValues(String url) throws ConfigServiceException {
        IConfigType configType = null;
        this.checkConnected();
        try {
            configType = InitialValuesImpl.attach(this.m_configServer, url);
            String typeName = configType.getName();
            String typeVersion = configType.getVersion();
            ((ConfigServer)this.m_configServer).storeConfigType(configType);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-import-type-failed", new Object[]{url}, e);
        }
        return configType;
    }

    public IInitialValues createInitialValues(String type, String version) throws Exception {
        return new InitialValuesImpl(type, version, this.getConfigServer());
    }

    public IInitialValues loadInitialValues(File file) throws Exception {
        return new InitialValuesImpl(file, this.getConfigServer());
    }

    public void deleteType(String typeName, String version) throws ConfigServiceException {
        this.checkConnected();
        Util.validateConfigTypeName(typeName);
        ((ConfigServer)this.m_configServer).removeConfigType(typeName, version);
    }

    public String[] listConfigElements(String path) throws ConfigServiceException {
        this.checkConnected();
        Util.validateConfigBeanName(path);
        ArrayList<String> result = new ArrayList<String>();
        Set set = this.m_configServer.listFolders(path);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            result.add(iter.next().toString() + "/");
        }
        set = this.m_configServer.listConfigElements(path);
        iter = set.iterator();
        while (iter.hasNext()) {
            result.add(iter.next().toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public void importFile(String path, String filename, boolean overwrite) throws ConfigServiceException {
        ConfigHelper.importFile(this.m_configServer, path, filename, this.m_user, overwrite);
        this.commitTransaction();
    }

    public String dumpDirectoryService(String path) throws ConfigServiceException {
        String dump = null;
        try {
            try {
                dump = ((IDirectoryAdminService)this.m_dfs).exportDirectoryToXML(path);
            }
            catch (Exception e) {
                dump = ((IDirectoryAdminService)this.m_dfs).exportElementToXML(path);
            }
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-dump-ds-failed", new Object[]{path}, e);
        }
        return dump;
    }

    public void dumpDirectoryService(String path, String file) throws ConfigServiceException {
        String dump = this.dumpDirectoryService(path);
        try {
            Writer writer = null;
            writer = file != null ? new FileWriter(file) : new PrintWriter(System.out);
            writer.write(dump);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-dump-ds-failed", new Object[]{path}, e);
        }
    }

    public void seedDirectoryService(String file) throws ConfigServiceException {
        try {
            ((IDirectoryAdminService)this.m_dfs).importFromXML(this.readFile(file));
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-seed-ds-failed", new Object[]{file}, e);
        }
    }

    public void importFiles(String fromFSPath, String toDSPath) throws ConfigServiceException {
        try {
            new SonicFSFileSystem(this.m_dfs, this.m_user).importFiles(fromFSPath, toDSPath);
        }
        catch (Exception e) {
            throw new ConfigServiceException("import-files failed", new Object[]{fromFSPath, toDSPath}, e);
        }
    }

    public void copyDSFilesToContainerCaches(String dsPath, boolean allContainers, boolean excludeContainers, String containerListFilePath) throws ConfigServiceException {
        try {
            String[] fileList = new SonicFSFileSystem(this.m_dfs, this.m_user).list(dsPath, true);
            String[] actionList = this.getContainerList(allContainers, excludeContainers, this.getFileListedContainers(containerListFilePath));
            String domaniName = this.getDomain();
            block6: for (int i = 0; i < actionList.length; ++i) {
                IDirElement containerConfigElement = null;
                try {
                    containerConfigElement = this.m_dfs.getFSElement(actionList[i], false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (containerConfigElement == null) {
                    System.out.println("No configuration was found for \"" + actionList[i] + "\"");
                    continue;
                }
                String containerName = new File(actionList[i]).getName();
                ObjectName containerObjectName = new ObjectName(domaniName + '.' + containerName + ":ID=AGENT");
                for (int j = 0; j < fileList.length; ++j) {
                    if (fileList[j].endsWith("/")) continue;
                    try {
                        System.out.println("Copying \"" + fileList[j] + "\" into the cache of container \"" + actionList[i] + "\"");
                        this.downloadFile(fileList[j], containerObjectName);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Failed to copy file(s) into the cache of container \"" + actionList[i] + "\": " + e.toString());
                        continue block6;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ConfigServiceException("copy-ds-files-to-container-caches failed", new Object[]{dsPath}, e);
        }
    }

    private void downloadFile(String dsFilePath, ObjectName containerObjectName) throws Exception {
        Object[] params = new Object[]{dsFilePath};
        String[] signature = new String[]{"java.lang.String"};
        ((JMSConnectorClient)this.m_server).invoke(containerObjectName, "downloadFile", params, signature);
    }

    public void copyFiles(String fromPath, String toPath) throws ConfigServiceException {
        try {
            this.m_dfs.copyFiles(fromPath, toPath);
        }
        catch (Exception e) {
            throw new ConfigServiceException("copy-files failed", new Object[]{fromPath, toPath}, e);
        }
    }

    public void createFolder(String folderPath) throws ConfigServiceException {
        try {
            String canonicalFolderPath = this.getCanonicalPath(folderPath);
            this.m_dfs.createFolder(canonicalFolderPath);
        }
        catch (Exception e) {
            throw new ConfigServiceException("create-folder failed", new Object[]{folderPath}, e);
        }
    }

    public void deleteFolder(String folderPath) throws ConfigServiceException {
        try {
            String canonicalFolderPath = this.getCanonicalPath(folderPath);
            this.m_dfs.deleteFolder(canonicalFolderPath);
        }
        catch (Exception e) {
            throw new ConfigServiceException("delete-folder failed", new Object[]{folderPath}, e);
        }
    }

    public void modifyArchivesSearchPath(String newSearchPath, boolean allContainers, boolean excludeContainers, String containerListFilePath) throws ConfigServiceException {
        try {
            String[] actionList = this.getContainerList(allContainers, excludeContainers, this.getFileListedContainers(containerListFilePath));
            for (int i = 0; i < actionList.length; ++i) {
                IDirElement containerConfigElement = this.m_dfs.getFSElement(actionList[i], true);
                IAttributeSet containerConfigAtts = containerConfigElement.getAttributes();
                String oldSearchPath = (String)containerConfigAtts.getAttribute("ARCHIVE_SEARCH_PATH");
                if (oldSearchPath.equals(newSearchPath)) continue;
                containerConfigAtts.setStringAttribute("ARCHIVE_SEARCH_PATH", newSearchPath);
                this.m_dfs.updateFSElement((IDeltaDirElement)containerConfigElement.doneUpdate());
            }
        }
        catch (Exception e) {
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)e);
            }
            throw new ConfigServiceException("modify-archive-search-path failed", new Object[]{newSearchPath, new Boolean(allContainers), new Boolean(excludeContainers), containerListFilePath}, e);
        }
    }

    private ArrayList getFileListedContainers(String containerListFilePath) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        if (containerListFilePath != null && containerListFilePath.length() != 0) {
            String srcLine;
            File listFile = new File(containerListFilePath);
            if (!listFile.exists()) {
                throw new ConfigServiceException("\"" + containerListFilePath + "\" does not exist");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(listFile)));
            while ((srcLine = reader.readLine()) != null) {
                String containerPath = srcLine.trim();
                if (containerPath.length() == 0) continue;
                resultList.add(containerPath);
            }
        }
        return resultList;
    }

    private String[] getContainerList(boolean modifyAll, boolean excludeContainers, ArrayList specifiedList) throws Exception {
        int i;
        if (!excludeContainers && !modifyAll) {
            return specifiedList.toArray(new String[0]);
        }
        if (excludeContainers && modifyAll) {
            return new String[0];
        }
        Query findContainersQuery = new Query();
        findContainersQuery.setFrom((From)new FromElementType("MF_CONTAINER"));
        findContainersQuery.setSelect(new Select(new AttributeName[0]));
        IDirElement[] containerConfigs = this.m_dfs.getFSElements(findContainersQuery, false);
        HashSet<String> allContainers = new HashSet<String>();
        for (i = 0; i < containerConfigs.length; ++i) {
            allContainers.add(containerConfigs[i].getIdentity().getName());
        }
        if (excludeContainers) {
            for (i = 0; i < specifiedList.size(); ++i) {
                allContainers.remove(specifiedList.get(i));
            }
        }
        String[] result = new String[allContainers.size()];
        Iterator iterator = allContainers.iterator();
        int i2 = 0;
        while (iterator.hasNext()) {
            result[i2] = (String)iterator.next();
            ++i2;
        }
        return result;
    }

    public void deleteFiles(String path) throws ConfigServiceException {
        try {
            new SonicFSFileSystem(this.m_dfs, this.m_user).deleteFiles(path);
        }
        catch (Exception e) {
            throw new ConfigServiceException("delete-files failed", new Object[]{path}, e);
        }
    }

    public void renameFolder(String oldPath, String newPath) throws Exception {
        this.rename(oldPath, newPath, true);
    }

    public void renameFile(String oldPath, String newPath) throws Exception {
        this.rename(oldPath, newPath, false);
    }

    private void rename(String oldPath0, String newPath0, boolean folder) throws Exception {
        if (oldPath0 == null || oldPath0.length() == 0) {
            throw new ConfigServiceException("rename failed: Cannot rename( >>> blank <<<, " + newPath0 + ")");
        }
        if (newPath0 == null || newPath0.length() == 0) {
            throw new ConfigServiceException("rename failed: Cannot rename(" + oldPath0 + ", >>> blank <<<)");
        }
        try {
            String oldPath = this.getCanonicalPath(oldPath0);
            String newPath = this.getCanonicalPath(newPath0);
            if (oldPath.equals("/")) {
                throw new Exception("Cannot rename the root folder");
            }
            if (oldPath.equals(newPath)) {
                throw new Exception("Cannot rename : oldPath and newPath are identical");
            }
            if (folder) {
                this.m_dfs.renameFolder(oldPath, newPath);
            } else {
                this.m_dfs.renameFile(oldPath, newPath);
            }
        }
        catch (Exception e) {
            throw new ConfigServiceException("rename failed ", new Object[]{oldPath0, newPath0}, e);
        }
    }

    private String getCanonicalPath(String path) throws Exception {
        if (!path.startsWith("/")) {
            throw new Exception("\"" + path + "\" does not start with /");
        }
        StringBuffer sb = new StringBuffer();
        int pathLength = path.length();
        boolean prevWasSeparator = false;
        for (int i = 0; i < pathLength; ++i) {
            char c = path.charAt(i);
            if (prevWasSeparator && c == '/') continue;
            sb.append(c);
            prevWasSeparator = c == '/';
        }
        String canonical = sb.toString();
        int canonicalLength = canonical.length();
        if (canonicalLength > 1 && canonical.charAt(canonicalLength - 1) == '/') {
            return canonical.substring(0, canonicalLength - 1);
        }
        return canonical;
    }

    private String readFile(String file) throws Exception {
        BufferedReader in = null;
        StringWriter out = null;
        try {
            in = new BufferedReader(new FileReader(file));
            out = new StringWriter();
            char[] buffer = new char[1024];
            int read = in.read(buffer, 0, 1024);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = in.read(buffer, 0, 1024);
            }
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            throw new Exception("Error reading file: " + file + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setDSHandlerWorkspace(String path) throws ConfigServiceException {
        try {
            IDirElement handlerMap = ElementFactory.createElement((String)"/workspace/mapping/EclipseMap", (String)"Eclipse_Map", (String)"1.0");
            IAttributeSet topSet = handlerMap.getAttributes();
            topSet.setStringAttribute("ECLIPSE_WORKSPACE_DISK_LOCATION", path);
            this.m_dfs.createFSElement(handlerMap);
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-set-workspace-failed", new Object[]{path}, e);
        }
    }

    public void addPlugin(String name, String config, String runtime, String classpath) throws ConfigServiceException {
        try {
            String path = "/_MFLibrary/plugins/" + name;
            IDirElement element = ElementFactory.createElement((String)path, (String)"MF_PLUGIN", (String)"1.0", (boolean)false);
            IAttributeSet attributes = element.getAttributes();
            if (config != null) {
                attributes.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", config);
            }
            if (runtime != null) {
                attributes.setStringAttribute("RUNTIME_PLUGIN_FACTORY_CLASS", runtime);
            }
            if (classpath != null) {
                attributes.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", classpath);
            }
            ((IDirectoryAdminService)this.m_dfs).setElements(new IBasicElement[]{element.doneUpdate()}, new String[]{path}, null);
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-add-plugin-failed", new Object[]{name}, e);
        }
    }

    public void deletePlugin(String name) throws ConfigServiceException {
        try {
            String path = "/_MFLibrary/plugins/" + name;
            ((IDirectoryAdminService)this.m_dfs).deleteElement(path, null);
        }
        catch (Exception e) {
            throw new ConfigServiceException("csu-delete-plugin-failed", new Object[]{name}, e);
        }
    }

    private void checkConnected() throws ConfigServiceException {
        if (this.m_configServer == null) {
            throw new ConfigServiceException("csu-not-connected");
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    protected void commitTransaction() throws ConfigServiceException {
    }

    private class ExportControl {
        boolean doConfig = true;
        boolean doFile = false;
        boolean replaceAll = false;
        boolean cancel = false;
        boolean single = false;

        private ExportControl() {
        }
    }
}

