/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.impl.ConfigElementImpl;
import com.sonicsw.mx.config.impl.ConfigReference;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.DispatcherModule;
import java.util.HashMap;
import java.util.Iterator;

public class ReferenceDispatcherModule
extends DispatcherModule {
    public ReferenceDispatcherModule(ConfigServer cs) {
        super(cs);
    }

    @Override
    public boolean processConfigChange(ConfigChange configChange) {
        switch (configChange.getChangeType()) {
            case 6: {
                try {
                    IConfigPath[] references = this.m_cs.getReferences(configChange.getNewName());
                    HashMap<String, ConfigChange> configChanges = new HashMap<String, ConfigChange>();
                    for (int i = 0; i < references.length; ++i) {
                        String name = references[i].getFirstComponent();
                        ConfigElementImpl referringElement = (ConfigElementImpl)this.m_cs.getElementCache().lookup(name, "");
                        if (referringElement == null) continue;
                        references[i].removeComponent(0);
                        ConfigReference reference = (ConfigReference)((Object)referringElement._get(references[i]));
                        if (!reference.getElementName().equals(configChange.getName())) continue;
                        referringElement.setAttribute(references[i], (Object)new ConfigReference(configChange.getNewName(), this.m_cs));
                        ConfigChange referringElementConfigChange = (ConfigChange)configChanges.get(name);
                        if (referringElementConfigChange == null) {
                            referringElementConfigChange = new ConfigChange(name, -1L, 1);
                            configChanges.put(name, referringElementConfigChange);
                        }
                        referringElementConfigChange.getModifiedAttributeNames().add(references[i]);
                    }
                    Iterator it = configChanges.values().iterator();
                    while (it.hasNext()) {
                        this.m_cs.sendConfigChange((ConfigChange)it.next());
                    }
                    break;
                }
                catch (ConfigServiceException configServiceException) {
                    break;
                }
            }
        }
        return true;
    }
}

