/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.tools.admin;

import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.management.ObjectName;

public class DSDumper {
    private static final String DEFAULT_URL = "localhost";
    private static final String DEFAULT_USER = "Administrator";
    private static final String DEFAULT_PASSWORD = "Administrator";
    private static final String DEFAULT_DOMAIN = "Domain1";
    private static final String DEFAULT_DIRECTORY = "/";
    private String m_url = "localhost";
    private String m_user = "Administrator";
    private String m_password = "Administrator";
    private String m_domain = "Domain1";
    private String m_directory = "/";
    private String m_file = null;

    public DSDumper(String[] args) throws Exception {
        this.parseArgs(args);
        System.out.println("Dump the contents of a DS directory:");
        System.out.println("    Broker URL  = " + this.m_url);
        System.out.println("    User        = " + this.m_user);
        System.out.println("    Password    = " + this.m_password);
        System.out.println("    Domain      = " + this.m_domain);
        System.out.println("    Directory   = " + this.m_directory);
        System.out.println("    Output File = " + (this.m_file == null ? "System.out" : this.m_file));
        JMSConnectorClient connector = new JMSConnectorClient();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", this.m_url);
        env.put("DefaultUser", this.m_user);
        env.put("DefaultPassword", this.m_password);
        connector.connect(new JMSConnectorAddress(env));
        DirectoryServiceProxy dsProxy = new DirectoryServiceProxy((IRemoteMBeanServer)connector, new ObjectName(this.m_domain + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE"));
        String dump = null;
        try {
            dump = dsProxy.exportDirectoryToXML(this.m_directory);
        }
        catch (Exception e) {
            dump = dsProxy.exportElementToXML(this.m_directory);
        }
        Writer writer = null;
        writer = this.m_file != null ? new FileWriter(this.m_file) : new PrintWriter(System.out);
        writer.write(dump);
        writer.flush();
        writer.close();
    }

    private void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-url")) {
                this.m_url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                this.m_user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                this.m_password = args[++i];
                continue;
            }
            if (args[i].equals("-domain")) {
                this.m_domain = args[++i];
                continue;
            }
            if (args[i].equals("-directory")) {
                this.m_directory = args[++i];
                continue;
            }
            if (args[i].equals("-file")) {
                this.m_file = args[++i];
                continue;
            }
            throw new Exception("Invalid argument " + args[i]);
        }
    }

    private static void printUsage() {
        System.out.println("com.sonicsw.mx.config.tools.admin.DSDumper ");
        System.out.println("    [-url url]             (Default = localhost)");
        System.out.println("    [-user user]           (Default = Administrator)");
        System.out.println("    [-password password]   (Default = Administrator)");
        System.out.println("    [-domain domain]       (Default = Domain1)");
        System.out.println("    [-directory directory] (Default = /)");
        System.out.println("    [-file filename]       (Default = System.out)");
    }

    public static void main(String[] args) {
        try {
            new DSDumper(args);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            DSDumper.printUsage();
        }
        System.exit(0);
    }
}

