/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config;

import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.impl.ConfigPathImpl;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ConfigFactory {
    private static long s_lastTime;
    private static int s_lastIndex;
    private static String s_ipAddr;
    private static String s_unique;
    private static Object s_lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createGUID() {
        Object object = s_lock;
        synchronized (object) {
            ConfigFactory.populateIpAddressAndUnique();
            return ConfigFactory.createBufferUpdateLastTimeIndex();
        }
    }

    private static void populateIpAddressAndUnique() {
        if (s_ipAddr == null) {
            try {
                StringBuffer ipBuffer = new StringBuffer();
                byte[] addr = InetAddress.getLocalHost().getAddress();
                for (int iAddr = 0; iAddr < addr.length; ++iAddr) {
                    int x = addr[iAddr] & 0xFF;
                    if (x < 16) {
                        ipBuffer.append("0");
                    }
                    ipBuffer.append(Integer.toString(x, 16).toUpperCase());
                }
                s_ipAddr = ipBuffer.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            s_unique = Integer.toString(new SecureRandom().nextInt(65535), 16);
        }
    }

    private static String createBufferUpdateLastTimeIndex() {
        StringBuffer buffer = new StringBuffer(s_ipAddr).append(s_unique);
        long time = System.currentTimeMillis();
        buffer.append(Long.toString(time, 16));
        if (time == s_lastTime) {
            ++s_lastIndex;
        } else {
            s_lastTime = time;
            s_lastIndex = 0;
        }
        buffer.append(s_lastIndex);
        return buffer.toString();
    }

    public static String generateDSName(String format) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> ids = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(format, "{}");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                int num = Integer.parseInt(token);
                if (num == ids.size()) {
                    String newID = ConfigFactory.createGUID();
                    ids.add(newID);
                    buffer.append(newID);
                    continue;
                }
                if (num < ids.size()) {
                    buffer.append(ids.get(num));
                    continue;
                }
                System.out.println("ConfigFactory::generateDSName value " + num + " is out of sequence");
                return null;
            }
            catch (NumberFormatException e) {
                buffer.append(token);
            }
        }
        return buffer.toString();
    }

    public static IConfigPath createConfigPath() {
        return new ConfigPathImpl();
    }

    public static IConfigPath createConfigPath(IConfigPath path) {
        return new ConfigPathImpl(path);
    }

    public static IConfigPath createConfigPath(String path) {
        return new ConfigPathImpl(path);
    }

    static {
        s_lock = new Object();
    }
}

