/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.impl.AttributeListImpl;
import com.sonicsw.mx.config.impl.AttributeMapImpl;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.NameSetImpl;
import com.sonicsw.mx.config.impl.Util;
import java.util.Map;
import java.util.Set;

public class PropertyMapImpl
extends AttributeMapImpl {
    public PropertyMapImpl(ConfigServer configServer) {
        super(configServer);
    }

    public PropertyMapImpl(IAttributeSet propSet, ConfigServer configServer) {
        super(propSet, configServer);
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer indentBuf = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            indentBuf.append("    ");
        }
        String indentStr = indentBuf.toString();
        for (String propertyName : this.keySet()) {
            Object propertyValue = this.getProperty(propertyName);
            String className = propertyValue.getClass().getName();
            String typeName = className.substring(className.lastIndexOf(".") + 1);
            if (propertyValue instanceof IAttributeMap) {
                buffer.append(indentStr).append(propertyName + "  [" + typeName + "] =\n");
                buffer.append(indentStr).append("{\n");
                buffer.append(((AttributeMapImpl)propertyValue).toString(indent + 1, false));
                buffer.append(indentStr).append("}\n");
                continue;
            }
            if (propertyValue instanceof IAttributeList) {
                buffer.append(indentStr).append(propertyName + "  [" + typeName + "] =\n");
                buffer.append(indentStr).append("{\n");
                buffer.append(((AttributeListImpl)propertyValue).toString(indent + 1, false));
                buffer.append(indentStr).append("}\n");
                continue;
            }
            buffer.append(indentStr).append(propertyName + "  [" + typeName + "] = " + Util.toString(propertyValue) + "\n");
        }
        return buffer.toString();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public Object getProperty(String propertyName) {
        return this.getAttribute(propertyName);
    }

    public void setProperty(String propertyName, Object propertyValue) throws ConfigServiceException {
        this.setAttribute(propertyName, propertyValue);
    }

    public Object removeProperty(String propertyName) throws ConfigServiceException {
        return this.removeAttribute(propertyName);
    }

    public Map getProperties(Set propertyNames) {
        PropertyMapImpl map = new PropertyMapImpl(this.m_configServer);
        for (String name : propertyNames) {
            map.put(name, this._get(name));
        }
        return map;
    }

    public void setProperties(PropertyMapImpl properties) throws ConfigServiceException {
        this.setAttributes(properties);
    }

    public Map removeProperties(Set propertyNames) throws ConfigServiceException {
        PropertyMapImpl map = new PropertyMapImpl(this.m_configServer);
        for (String name : propertyNames) {
            Object attribute = this.remove(name);
            this.removeAttribute(name);
            map.put(name, attribute);
        }
        return map;
    }

    public Set getPropertyNames() {
        return (NameSetImpl)this.getAttributeNames();
    }

    @Override
    public Object get(Object key) {
        return super._get(key);
    }
}

