/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigServiceException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Cache {
    private HashMap m_map = new HashMap();
    private ReferenceQueue m_refQueue = new ReferenceQueue();

    public Set getObjects() {
        this.scavange();
        HashSet set = new HashSet();
        for (CacheRef ref : this.m_map.values()) {
            if (ref.get() == null) continue;
            set.add(ref.get());
        }
        return set;
    }

    public Object lookup(String path, String version) {
        Object value;
        this.scavange();
        CacheKey key = new CacheKey(path, version);
        CacheRef ref = (CacheRef)this.m_map.get(key);
        Object v0 = value = ref != null ? ref.get() : null;
        if (value == null) {
            this.m_map.remove(key);
        }
        return value;
    }

    public Object[] lookup(String path) {
        this.scavange();
        ArrayList list = new ArrayList();
        for (CacheKey key : this.m_map.keySet()) {
            Object obj;
            if (!key.getName().startsWith(path) || (obj = this.m_map.get(key)) == null) continue;
            list.add(((CacheRef)obj).get());
        }
        return list.toArray();
    }

    public void add(String path, String version, Object obj) throws ConfigServiceException {
        this.scavange();
        CacheKey key = new CacheKey(path, version);
        CacheRef tmp = this.m_map.put(key, new CacheRef(key, obj, this.m_refQueue));
        if (tmp != null) {
            this.m_map.put(key, tmp);
            throw new ConfigServiceException("Named instance of config objects already exists");
        }
    }

    public void remove(String path, String version) {
        this.scavange();
        this.m_map.remove(new CacheKey(path, version));
    }

    public int size() {
        return this.m_map.size();
    }

    private void scavange() {
        Reference ref = null;
        while ((ref = this.m_refQueue.poll()) != null) {
            this.m_map.remove(((CacheRef)ref).getKey());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String className = this.getClass().getName();
        String typeName = className.substring(className.lastIndexOf(".") + 1);
        buffer.append("[" + typeName + "] =\n");
        buffer.append("{\n");
        Iterator it = this.m_map.keySet().iterator();
        while (it.hasNext()) {
            buffer.append("  ").append(it.next().toString()).append("\n");
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    static class CacheRef
    extends WeakReference {
        private CacheKey m_key;

        public CacheRef(CacheKey key, Object referent) {
            super(referent);
            this.m_key = key;
        }

        public CacheRef(CacheKey key, Object referent, ReferenceQueue queue) {
            super(referent, queue);
            this.m_key = key;
        }

        public CacheKey getKey() {
            return this.m_key;
        }
    }

    static class CacheKey {
        private String m_name;
        private String m_version;

        public CacheKey(String name, String version) {
            this.m_name = name == null ? "" : name;
            this.m_version = version == null ? "" : version;
        }

        public String getName() {
            return this.m_name;
        }

        public String getVersion() {
            return this.m_version;
        }

        public boolean equals(Object obj) {
            if (obj != null && this.getClass() == obj.getClass()) {
                CacheKey key = (CacheKey)obj;
                if (this.m_name.equals(key.m_name) && this.m_version.equals(key.m_version)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }

        public String toString() {
            return "(" + this.m_name + "," + this.m_version + ")";
        }
    }
}

