/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.util;

import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mx.config.util.SonicFSFile;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import java.util.Hashtable;

public class SonicFSTest {
    private static final String TEST_FOLDER = "/SonicFSTest";
    private static final String TEST_FILE1 = "/SonicFSTest/Test1.txt";
    private static final String TEST_CONTENT1 = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffff";
    private static final String TEST_CONTENT2 = "aaaaaaaaaa";
    private JMSConnectorClient m_connector = null;
    private SonicFSFileSystem m_fs = null;

    public SonicFSTest() {
        try {
            this.connect();
            this.m_fs.createDirectory(TEST_FOLDER);
            this.testListDetails();
            this.testUpdateFile();
            this.testListDetails();
            this.testList("/");
            this.testList("/Brokers");
            this.testListFolders("/");
            this.testListFolders("/Brokers");
            this.testListAllFolders();
            this.testListAllFolderDetails();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.disconnect();
        }
    }

    public final void connect() throws Exception {
        String url = "localhost";
        String domain = "Domain1";
        String user = "Administrator";
        String password = "Administrator";
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", url);
        env.put("DefaultUser", user);
        env.put("DefaultPassword", password);
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        this.m_connector = new JMSConnectorClient();
        this.m_connector.connect(address);
        this.m_fs = new SonicFSFileSystem(this.m_connector, "foo", user);
    }

    public final void disconnect() {
        if (this.m_connector != null) {
            this.m_connector.disconnect();
        }
    }

    private void testListDetails() throws Exception {
        SonicFSFile[] details = this.m_fs.listDetails(TEST_FOLDER);
        System.out.println("Listing of '/SonicFSTest' count = " + details.length);
        for (int i = 0; i < details.length; ++i) {
            this.printDetails(details[i]);
        }
    }

    private void testList(String folder) throws Exception {
        System.out.println("list(" + folder + ")");
        String[] res = this.m_fs.list(folder);
        for (int i = 0; i < res.length; ++i) {
            System.out.println("    " + res[i]);
        }
    }

    private void testListFolders(String folder) throws Exception {
        System.out.println("listFolders(" + folder + ")");
        String[] res = this.m_fs.listFolders(folder);
        for (int i = 0; i < res.length; ++i) {
            System.out.println("    " + res[i]);
        }
    }

    private void testListAllFolders() throws Exception {
        System.out.println("listAllFolders()");
        String[] res = this.m_fs.listAllFolders();
        for (int i = 0; i < res.length; ++i) {
            System.out.println("    " + res[i]);
        }
    }

    private void testListAllFolderDetails() throws Exception {
        System.out.println("listAllFolderDetails()");
        SonicFSFile[] res = this.m_fs.listAllFolderDetails();
        for (int i = 0; i < res.length; ++i) {
            System.out.println("    " + res[i]);
        }
    }

    private void testCreateFile() throws Exception {
        this.m_fs.createFile(TEST_FILE1, TEST_CONTENT1);
    }

    private void testUpdateFile() throws Exception {
        this.m_fs.updateFile(TEST_FILE1, TEST_CONTENT2, true);
    }

    private void printDetails(SonicFSFile file) {
        System.out.println("File details:");
        if (file.isDirectory()) {
            SonicFSTest.printFileDirectoryAndName(file);
        } else {
            SonicFSTest.printFileDirectoryAndName(file);
            System.out.println("    Size = " + file.getSize());
            System.out.println("    Creation Time = " + file.getCreationTimestamp());
            System.out.println("    Last Modified Time = " + file.getLastModified());
            System.out.println("    Created By = " + file.getCreatedBy());
        }
    }

    private static void printFileDirectoryAndName(SonicFSFile file) {
        System.out.println("    Directory = " + file.isDirectory());
        System.out.println("    Name = " + file.getName());
        System.out.println("    Fullname = " + file.getFullName());
    }

    public static void main(String[] args) {
        new SonicFSTest();
    }
}

