/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigTypeException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.impl.AttributeDescriptionImpl;
import com.sonicsw.mx.config.impl.AttributeDescriptionMapImpl;
import com.sonicsw.mx.config.impl.AttributeListImpl;
import com.sonicsw.mx.config.impl.AttributeMapImpl;
import com.sonicsw.mx.config.impl.ConfigBeanDocument;
import com.sonicsw.mx.config.impl.ConfigPathImpl;
import com.sonicsw.mx.config.impl.ConfigReference;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.ConfigTypeImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class ConfigTypeDocument {
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String CONFIG_BEAN_ELEMENT_NAME = "config-bean";
    private static final String ANY_TYPE_NAME = "anyType";
    private static final String ATTRIBUTE_MAP_TYPE_NAME = "attributeMap";
    private static final String ATTRIBUTE_LIST_TYPE_NAME = "attributeList";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String INV_CFG_TYPE = "Invalid configuration type: ";
    private static final String INV_CFG_TYPE_SIMPLE_CONTENT = " : simple content: configuration bean element can not contain text.";
    private static final String INV_CFG_TYPE_MIXED_CONTENT = " : mixed content: configuration bean element can not contain text.";
    private static final String INV_CFG_TYPE_UNKNOWN_CONTENT = " : unknown content type.";
    private static final String INV_CFG_TYPE_SIMPLE_TYPE = " : simple type: configuration bean element can not contain text.";
    private static final String INV_ATTR_MAP = "Invalid attribute map type: ";
    private static final String INV_ATTR_MAP_RPT_ELMT = " : repeated element: attribute element can occur in attribute map at most once.";
    private static final String INV_ATTR_MAP_OPTRPT_GRP = " : optional or repeated all group: a group of attribute elements must occur in attribute map exactly once.";
    private static final String INV_ATTR_MAP_SEQ_GRP = " : sequence group: attribute elements of an attribute map must be specified within a choice group.";
    private static final String INV_ATTR_MAP_WILD_CARD = " : wild card: an attribute map can not contain a wild card element.";
    private static final String INV_ATTR_MAP_CHC_GRP = " : choice group: attribute elements of an attribute map must be specified within a choice group.";
    private static final String INV_ATTR_MAP_EMPT_GRP = " : empty group.";
    private static final String INV_ATTR_MAP_UNK_GRP = " : unknown group type.";
    private static final String INV_ATTR = "Invalid attribute type: ";
    private static final String INV_ATTR_MIXED_CONTENT = " : mixed content: attribute element can not contain both text and child elements.";
    private static final String INV_ATTR_UNK_CONTENT = " : unknown content type.";
    private static final String INV_ATTR_LIST_TYPE = " : list simple type: list simple types for attribute values are not supported";
    private static final String INV_ATTR_UNION_TYPE = " : union simple type: union simple types for attribute values are not supported";
    private static final String INV_ATTR_WILDCARD_TYPE = " : wildcard simple type: wildcard simple types for attribute values are not supported";
    private static final String INV_ATTR_UNK_TYPE = " : unknown simple type.";
    private static final String INV_ATTR_WILDCARD_CONTENT = " : wild card: an attribute map can not contain a wild card element.";
    private static final String INV_ATTR_CHOICE_CONTENT = " : choice group: attribute elements of an attribute map must be specified within an all group.";
    private static final String INV_ATTR_EMPTY_CONTENT = " : empty group.";
    private static final String INV_ATTR_UNKNOWN_CONTENT = " : unknown group type.";
    private static final String INV_ATTR_PROPERTY_NOT_FIXED = " : no fixed value: user defined attribute properties must have a fixed value.";
    private static final String INV_ATTR_DESCRIPTION_NOT_STRING = " : description not a string: attribute description must be a string.";
    private static final String INV_ATTR_UNSUPPORTED_PRIM_TYPE = "unsupported primitive type";
    private static final String INV_ATTR_INVALID_PRIM_TYPE = "invalid primitive type";
    private static final String INV_ATTR_LIST = "Invalid attribute list type: ";
    private static final String INV_ATTR_LIST_MULT_ELEMS = " : multiple element types: attribute lists can only contain a single type of element.";
    protected static final BigDecimal MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    protected static final BigDecimal MIN_INT = BigDecimal.valueOf(Integer.MIN_VALUE);
    protected static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    protected static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    protected static volatile ConfigServer s_configServer = null;
    static final ValidationContext s_noFacetContext = new ValidationContext(){

        public boolean useNamespaces() {
            return false;
        }

        public boolean needFacetChecking() {
            return false;
        }

        public boolean needExtraChecking() {
            return false;
        }

        public boolean needToNormalize() {
            return true;
        }

        public boolean isEntityDeclared(String name) {
            return false;
        }

        public boolean isEntityUnparsed(String name) {
            return false;
        }

        public boolean isIdDeclared(String name) {
            return false;
        }

        public void addId(String name) {
        }

        public void addIdRef(String name) {
        }

        public String getSymbol(String symbol) {
            return null;
        }

        public String getURI(String prefix) {
            return null;
        }
    };

    private static ConfigSchema parseSchema(String namespaceURIParam, String schemaDocURLParam) throws ConfigServiceException {
        String schemaDocURL = schemaDocURLParam;
        String namespaceURI = namespaceURIParam;
        SymbolTable symbolTable = new SymbolTable();
        namespaceURI = symbolTable.addSymbol(namespaceURI);
        schemaDocURL = symbolTable.addSymbol(schemaDocURL);
        XMLGrammarPreparser preparser = new XMLGrammarPreparser(symbolTable);
        preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        XMLGrammarPoolImpl grammarPool = new XMLGrammarPoolImpl();
        XMLEntityManager entityResolver = new XMLEntityManager();
        preparser.setErrorHandler((XMLErrorHandler)new ErrorHandler());
        preparser.setEntityResolver((XMLEntityResolver)entityResolver);
        preparser.setProperty(GRAMMAR_POOL, (Object)grammarPool);
        preparser.setFeature(NAMESPACES_FEATURE_ID, true);
        preparser.setFeature(VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, false);
        String locationHint = schemaDocURL;
        String version = ConfigBeanDocument.parseVersion(schemaDocURL);
        XMLInputSource xmlInputSource = null;
        try {
            if (!schemaDocURL.startsWith("file:")) {
                schemaDocURL = "file:" + schemaDocURL;
            }
            URL url = new URL(schemaDocURL);
            xmlInputSource = new XMLInputSource(null, schemaDocURL, null, url.openStream(), null);
        }
        catch (IOException e) {
            throw new ConfigServiceException("cant-open-schema-document", new Object[]{schemaDocURL}, e);
        }
        SchemaGrammar schemaGrammar = null;
        try {
            schemaGrammar = (SchemaGrammar)preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", xmlInputSource);
        }
        catch (IOException e) {
            throw new ConfigServiceException("parse-failed", new Object[]{schemaDocURL}, e);
        }
        if (schemaGrammar != null) {
            return new ConfigSchema(schemaGrammar, version, locationHint);
        }
        return null;
    }

    private static boolean isConfigBeanDecl(XSElementDeclaration elementParam) {
        XSElementDeclaration element = elementParam;
        for (element = element.getSubstitutionGroupAffiliation(); element != null && !element.getName().equals(CONFIG_BEAN_ELEMENT_NAME); element = element.getSubstitutionGroupAffiliation()) {
        }
        return element != null;
    }

    private static boolean isAttributeMapDecl(XSElementDeclaration element) {
        XSTypeDefinition baseType = element.getTypeDefinition().getBaseType();
        while (!baseType.getName().equals(ANY_TYPE_NAME)) {
            if (baseType.getName().equals(ATTRIBUTE_MAP_TYPE_NAME)) {
                return true;
            }
            baseType = baseType.getBaseType();
        }
        return false;
    }

    public static void buildConfigType(ConfigTypeImpl configType, XSElementDeclaration configTypeDeclaration) throws ConfigServiceException {
        configType.setType(IAttributeMap.class);
        configType.setProperty("mx.config.nillable", new Boolean(configTypeDeclaration.getNillable()));
        if (configTypeDeclaration.getConstraintType() == 2) {
            configType.setProperty("mx.config.fixed", ConfigTypeDocument.convertValue(((XSElementDecl)configTypeDeclaration).fDefault.actualValue, configTypeDeclaration.getTypeDefinition()));
        }
        if (configTypeDeclaration.getConstraintType() == 1) {
            Object obj = ConfigTypeDocument.convertValue(((XSElementDecl)configTypeDeclaration).fDefault.actualValue, configTypeDeclaration.getTypeDefinition());
            System.err.println("ConfigType: name = " + configTypeDeclaration.getName() + ": " + "mx.config.default" + " = " + obj);
            configType.setProperty("mx.config.default", obj);
        }
        configType.setProperty("mx.config.schemaTypeName", configTypeDeclaration.getTypeDefinition().getName());
        configType.setProperty("mx.config.schemaNamespace", configTypeDeclaration.getNamespace());
        if (configTypeDeclaration.getTypeDefinition().getTypeCategory() == 16) {
            throw new ConfigServiceException(INV_CFG_TYPE_SIMPLE_CONTENT + configTypeDeclaration.getName() + INV_CFG_TYPE_SIMPLE_TYPE);
        }
        XSComplexTypeDefinition type = (XSComplexTypeDefinition)configTypeDeclaration.getTypeDefinition();
        if (!(type.getParticle().getTerm() instanceof XSModelGroup)) {
            throw new ConfigServiceException(INV_CFG_TYPE + configTypeDeclaration.getName() + ": the element declaring this config type does not contain model group: the item in a config type must be declared within a model group.");
        }
        XSModelGroup modelGroup = (XSModelGroup)type.getParticle().getTerm();
        if (modelGroup.getCompositor() != 3) {
            throw new ConfigServiceException(INV_CFG_TYPE + configTypeDeclaration.getName() + ": the element declaring this config type does not contain sequence model group: the items in a config type must be declared within an all model group.");
        }
        ConfigTypeDocument.buildAttributeMapDescription(configType.getAttributeDescriptions(), modelGroup);
    }

    private static void buildAttributeMapDescription(AttributeDescriptionMapImpl mapDescription, XSModelGroup modelGroup) throws ConfigServiceException {
        if (modelGroup.getCompositor() != 3) {
            throw new ConfigServiceException("Invalid attribute list type: : element declaration's type does not contain sequence model group: the items in an attribute map type must be declared within an all model group.");
        }
        ConfigTypeDocument._buildAttributeMapDescription(mapDescription, modelGroup, true);
    }

    private static void buildUnenumAttributeMapDescription(AttributeDescriptionMapImpl mapDescription, XSModelGroup modelGroup) throws ConfigServiceException {
        if (modelGroup.getCompositor() != 2) {
            throw new ConfigServiceException("Invalid attribute list type: : element declaration's type does not contain sequence model group: the items in an attribute map type must be declared within an all model group.");
        }
        ConfigTypeDocument._buildAttributeMapDescription(mapDescription, modelGroup, false);
    }

    private static void _buildAttributeMapDescription(AttributeDescriptionMapImpl mapDescription, XSModelGroup modelGroup, boolean enumeratedMap) throws ConfigServiceException {
        XSObjectList particles = modelGroup.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            if (enumeratedMap && particle.getMaxOccurs() > 1) {
                throw new ConfigServiceException("Invalid attribute map type:  : repeated element: attribute element can occur in attribute map at most once.");
            }
            if (!(particle.getTerm() instanceof XSElementDeclaration)) {
                throw new ConfigServiceException("Invalid attribute list type: : model group contains non-element particle: the items in an attribute map type must be declared as elements directly within an all model group.");
            }
            XSElementDeclaration mapItemDeclaration = (XSElementDeclaration)particle.getTerm();
            AttributeDescriptionImpl mapItemDescription = ConfigTypeDocument.createAttributeDescriptionImpl(mapItemDeclaration, particle);
            mapDescription.setAttributeDescription(mapItemDeclaration.getName(), (IAttributeDescription)mapItemDescription);
        }
    }

    private static void buildAttributeDescription(AttributeDescriptionImpl attributeDescription, XSElementDeclaration attributeDeclaration) throws ConfigServiceException {
        if (attributeDeclaration.getTypeDefinition().getTypeCategory() == 15) {
            XSComplexTypeDefinition type = (XSComplexTypeDefinition)attributeDeclaration.getTypeDefinition();
            switch (type.getContentType()) {
                case 1: {
                    ConfigTypeDocument.buildAtomicAttributeDescription(attributeDescription, attributeDeclaration);
                    break;
                }
                case 2: {
                    ConfigTypeDocument.buildCompositeAttributeDescription(attributeDescription, attributeDeclaration);
                    break;
                }
                case 0: {
                    ConfigTypeDocument.buildEmptyAttributeDescription(attributeDescription, attributeDeclaration);
                    break;
                }
                case 3: {
                    throw new ConfigServiceException(INV_ATTR + attributeDeclaration.getName() + INV_ATTR_MIXED_CONTENT);
                }
                default: {
                    throw new ConfigServiceException(INV_ATTR + attributeDeclaration.getName() + " : unknown content type.");
                }
            }
        } else {
            XSTypeDefinition xsType = attributeDeclaration.getTypeDefinition();
            XSSimpleTypeDefinition type = (XSSimpleTypeDefinition)attributeDeclaration.getTypeDefinition();
            ConfigTypeDocument.buildAtomicAttributeDescription(attributeDescription, type);
        }
        ConfigTypeDocument.addElementProperties(attributeDescription, attributeDeclaration);
    }

    private static void addElementProperties(IAttributeDescription attributeDescription, XSElementDeclaration attributeDeclaration) throws ConfigServiceException {
        ((AttributeDescriptionImpl)attributeDescription).setProperty("mx.config.nillable", new Boolean(attributeDeclaration.getNillable()));
        if (attributeDeclaration.getConstraintType() == 2) {
            ((AttributeDescriptionImpl)attributeDescription).setProperty("mx.config.fixed", ConfigTypeDocument.convertValue(((XSElementDecl)attributeDeclaration).fDefault.actualValue, attributeDeclaration.getTypeDefinition()));
        } else if (attributeDeclaration.getConstraintType() == 1) {
            Object obj = ConfigTypeDocument.convertValue(((XSElementDecl)attributeDeclaration).fDefault.actualValue, attributeDeclaration.getTypeDefinition());
            ((AttributeDescriptionImpl)attributeDescription).setProperty("mx.config.default", obj);
        }
        ((AttributeDescriptionImpl)attributeDescription).setProperty("mx.config.schemaTypeName", attributeDeclaration.getTypeDefinition().getName());
        ((AttributeDescriptionImpl)attributeDescription).setProperty("mx.config.schemaNamespace", attributeDeclaration.getTypeDefinition().getNamespace());
    }

    private static void addUserDefinedAttributeProperties(AttributeDescriptionImpl attributeDescription, XSElementDeclaration attributeDeclaration) throws ConfigServiceException {
        XSComplexTypeDefinition type = (XSComplexTypeDefinition)attributeDeclaration.getTypeDefinition();
        XSObjectList attrUses = type.getAttributeUses();
        for (int i = 0; i < attrUses.getLength(); ++i) {
            XSAttributeUse attrUse = (XSAttributeUse)attrUses.item(i);
            XSAttributeDeclaration attrDecl = attrUse.getAttrDeclaration();
            Object value = null;
            if (attrUse.getConstraintType() == 2) {
                value = ConfigTypeDocument.convertValue(((XSAttributeUseImpl)attrUse).fDefault.actualValue, (XSTypeDefinition)attrDecl.getTypeDefinition());
            } else {
                if (attrDecl.getConstraintType() != 2) continue;
                value = ConfigTypeDocument.convertValue(((XSAttributeDecl)attrDecl).getValInfo().actualValue, (XSTypeDefinition)attrDecl.getTypeDefinition());
            }
            if (attrDecl.getName().equals(DESCRIPTION_ATTRIBUTE)) {
                if (!(value instanceof String)) {
                    throw new ConfigServiceException(INV_ATTR + attributeDeclaration.getName() + INV_ATTR_DESCRIPTION_NOT_STRING);
                }
                attributeDescription.setDescription((String)value);
                continue;
            }
            attributeDescription.setProperty(attrDecl.getName(), value);
        }
    }

    private static void buildEmptyAttributeDescription(AttributeDescriptionImpl attributeDescription, XSElementDeclaration attributeDeclaration) throws ConfigServiceException {
        if (ConfigTypeDocument.isAttributeMapDecl(attributeDeclaration)) {
            attributeDescription.setType(IAttributeMap.class);
        } else {
            attributeDescription.setType(IAttributeList.class);
        }
        ConfigTypeDocument.addUserDefinedAttributeProperties(attributeDescription, attributeDeclaration);
    }

    private static void buildAtomicAttributeDescription(AttributeDescriptionImpl attributeDescription, XSElementDeclaration attributeDeclaration) throws ConfigServiceException {
        XSComplexTypeDefinition type = (XSComplexTypeDefinition)attributeDeclaration.getTypeDefinition();
        switch (type.getSimpleType().getVariety()) {
            case 1: {
                ConfigTypeDocument.buildAtomicAttributeDescription(attributeDescription, type.getSimpleType());
                break;
            }
            case 2: {
                throw new ConfigServiceException(INV_ATTR + type.getName() + INV_ATTR_LIST_TYPE);
            }
            case 3: {
                throw new ConfigServiceException(INV_ATTR + type.getName() + INV_ATTR_UNION_TYPE);
            }
            case 0: {
                throw new ConfigServiceException(INV_ATTR + type.getName() + INV_ATTR_WILDCARD_TYPE);
            }
            default: {
                throw new Error(INV_ATTR + type.getName() + INV_ATTR_UNK_TYPE);
            }
        }
        ConfigTypeDocument.addUserDefinedAttributeProperties(attributeDescription, attributeDeclaration);
    }

    private static void buildAtomicAttributeDescription(AttributeDescriptionImpl attributeDescription, XSSimpleTypeDefinition attributeType) throws ConfigServiceException {
        Object obj;
        String content;
        StringList pattern;
        attributeDescription.setType(ConfigTypeDocument.getAtomicClassType(attributeType));
        attributeDescription.setProperty("mx.config.simpleTypeName", ConfigTypeDocument.getSimpleTypeName(((XSSimpleType)attributeType).getPrimitiveKind()));
        if ((attributeType.getDefinedFacets() & 0x10) != 0) {
            try {
                attributeDescription.setProperty("mx.config.whiteSpace", new Long(((XSSimpleType)attributeType).getWhitespace()));
            }
            catch (DatatypeException e) {
                throw new ConfigTypeException(e.getKey(), e.getArgs(), (Exception)((Object)e));
            }
        }
        if ((attributeType.getDefinedFacets() & 1) != 0) {
            attributeDescription.setProperty("mx.config.length", new Long(attributeType.getLexicalFacetValue((short)1) == null ? "0" : attributeType.getLexicalFacetValue((short)1)));
        }
        if ((attributeType.getDefinedFacets() & 2) != 0) {
            attributeDescription.setProperty("mx.config.minLength", new Long(attributeType.getLexicalFacetValue((short)2) == null ? "0" : attributeType.getLexicalFacetValue((short)2)));
        }
        if ((attributeType.getDefinedFacets() & 4) != 0) {
            attributeDescription.setProperty("mx.config.maxLength", new Long(attributeType.getLexicalFacetValue((short)4) == null ? "0" : attributeType.getLexicalFacetValue((short)4)));
        }
        if ((attributeType.getDefinedFacets() & 0x200) != 0) {
            attributeDescription.setProperty("mx.config.totalDigits", new Long(attributeType.getLexicalFacetValue((short)512) == null ? "0" : attributeType.getLexicalFacetValue((short)512)));
        }
        if ((attributeType.getDefinedFacets() & 0x400) != 0) {
            attributeDescription.setProperty("mx.config.fractionDigits", new Long(attributeType.getLexicalFacetValue((short)1024) == null ? "0" : attributeType.getLexicalFacetValue((short)1024)));
        }
        if ((attributeType.getDefinedFacets() & 8) != 0 && (pattern = attributeType.getLexicalPattern()).getLength() > 0) {
            attributeDescription.setProperty("mx.config.pattern", ConfigTypeDocument.buildPatternDescription(pattern));
        }
        if ((attributeType.getDefinedFacets() & 0x800) != 0) {
            attributeDescription.setProperty("mx.config.enumeration", ConfigTypeDocument.buildEnumerationDescription(attributeType.getLexicalEnumeration()));
        }
        if ((attributeType.getDefinedFacets() & 0x20) != 0) {
            try {
                content = attributeType.getLexicalFacetValue((short)32);
                obj = ((XSSimpleType)attributeType).validate(content, s_noFacetContext, null);
                obj = ConfigTypeDocument.convertValue(obj, (XSTypeDefinition)attributeType);
                attributeDescription.setProperty("mx.config.maxInclusive", obj);
            }
            catch (DatatypeException e) {
                throw new ConfigTypeException(e.getKey(), e.getArgs(), (Exception)((Object)e));
            }
        }
        if ((attributeType.getDefinedFacets() & 0x40) != 0) {
            try {
                content = attributeType.getLexicalFacetValue((short)64);
                obj = ((XSSimpleType)attributeType).validate(content, s_noFacetContext, null);
                obj = ConfigTypeDocument.convertValue(obj, (XSTypeDefinition)attributeType);
                attributeDescription.setProperty("mx.config.maxExclusive", obj);
            }
            catch (DatatypeException e) {
                throw new ConfigTypeException(e.getKey(), e.getArgs(), (Exception)((Object)e));
            }
        }
        if ((attributeType.getDefinedFacets() & 0x80) != 0) {
            try {
                content = attributeType.getLexicalFacetValue((short)128);
                obj = ((XSSimpleType)attributeType).validate(content, s_noFacetContext, null);
                obj = ConfigTypeDocument.convertValue(obj, (XSTypeDefinition)attributeType);
                attributeDescription.setProperty("mx.config.minExclusive", obj);
            }
            catch (DatatypeException e) {
                throw new ConfigTypeException(e.getKey(), e.getArgs(), (Exception)((Object)e));
            }
        }
        if ((attributeType.getDefinedFacets() & 0x100) != 0) {
            try {
                content = attributeType.getLexicalFacetValue((short)256);
                obj = ((XSSimpleType)attributeType).validate(content, s_noFacetContext, null);
                obj = ConfigTypeDocument.convertValue(obj, (XSTypeDefinition)attributeType);
                attributeDescription.setProperty("mx.config.minInclusive", obj);
            }
            catch (DatatypeException e) {
                throw new ConfigTypeException(e.getKey(), e.getArgs(), (Exception)((Object)e));
            }
        }
    }

    private static void buildAttributeListDescription(AttributeDescriptionMapImpl listDescription, XSModelGroup modelGroup) throws ConfigServiceException {
        if (modelGroup.getCompositor() != 1) {
            throw new ConfigServiceException("Invalid attribute list type: : element declaration's type does not contain sequence model group: the item in an attribute list must be declared within a sequence model group.");
        }
        if (modelGroup.getParticles().getLength() != 1) {
            throw new ConfigServiceException("Invalid attribute list type: : element declaration's type does not contain single particle : an attribute list type must be declared with a single list item.");
        }
        XSParticle listItemParticle = (XSParticle)modelGroup.getParticles().item(0);
        if (!(listItemParticle.getTerm() instanceof XSElementDeclaration)) {
            throw new ConfigServiceException("Invalid attribute list type: : element declaration's type does not contain element declaration : the type of list item in an attribute list must be declared using a single element declaration.");
        }
        XSElementDeclaration listItemDeclaration = (XSElementDeclaration)listItemParticle.getTerm();
        AttributeDescriptionImpl listItemDescription = ConfigTypeDocument.createAttributeDescriptionImpl(listItemDeclaration, listItemParticle);
        listDescription.setAttributeDescription(listItemDeclaration.getName(), (IAttributeDescription)listItemDescription);
    }

    private static AttributeDescriptionImpl createAttributeDescriptionImpl(XSElementDeclaration listItemDeclaration, XSParticle listItemParticle) throws ConfigServiceException {
        AttributeDescriptionImpl listItemDescription = new AttributeDescriptionImpl(s_configServer);
        ConfigTypeDocument.buildAttributeDescription(listItemDescription, listItemDeclaration);
        listItemDescription.setProperty("mx.config.minOccurs", new Long(listItemParticle.getMinOccurs()));
        listItemDescription.setProperty("mx.config.maxOccurs", new Long(listItemParticle.getMaxOccurs()));
        return listItemDescription;
    }

    private static void buildCompositeAttributeDescription(AttributeDescriptionImpl compositeAttributeDescription, XSElementDeclaration compositeAttributeDeclaration) throws ConfigServiceException {
        if (compositeAttributeDeclaration.getTypeDefinition().getTypeCategory() == 16) {
            throw new ConfigServiceException(INV_ATTR + compositeAttributeDeclaration.getName() + ": element declaration is a simple type: composite attribute type must be declared using a complex element type.");
        }
        XSComplexTypeDefinition type = (XSComplexTypeDefinition)compositeAttributeDeclaration.getTypeDefinition();
        if (!(type.getParticle().getTerm() instanceof XSModelGroup)) {
            throw new ConfigServiceException(INV_ATTR + compositeAttributeDeclaration.getName() + ": element declaration's type does not contain model group: the item in a composite attribute type must be declared within a model group.");
        }
        XSModelGroup modelGroup = (XSModelGroup)type.getParticle().getTerm();
        switch (modelGroup.getCompositor()) {
            case 3: {
                compositeAttributeDescription.setType(IAttributeMap.class);
                AttributeDescriptionMapImpl mapDescription = compositeAttributeDescription.getAttributeDescriptions();
                ConfigTypeDocument.buildAttributeMapDescription(mapDescription, modelGroup);
                break;
            }
            case 2: {
                compositeAttributeDescription.setType(IAttributeMap.class);
                AttributeDescriptionMapImpl mapDescription = compositeAttributeDescription.getAttributeDescriptions();
                ConfigTypeDocument.buildUnenumAttributeMapDescription(mapDescription, modelGroup);
                compositeAttributeDescription.setProperty("mx.config.unenumMap", new Boolean(true));
                break;
            }
            case 1: {
                compositeAttributeDescription.setType(IAttributeList.class);
                AttributeDescriptionMapImpl listDescription = compositeAttributeDescription.getAttributeDescriptions();
                ConfigTypeDocument.buildAttributeListDescription(listDescription, modelGroup);
                break;
            }
            default: {
                throw new ConfigServiceException(INV_ATTR_LIST + compositeAttributeDeclaration.getName() + ": element declaration's type contains unknown model group type: the item in a composite attribute type must be declared within a model group.");
            }
        }
        ConfigTypeDocument.addUserDefinedAttributeProperties(compositeAttributeDescription, compositeAttributeDeclaration);
    }

    private static AttributeListImpl buildEnumerationDescription(StringList enumeration) throws ConfigServiceException {
        AttributeListImpl enumerationDesc = new AttributeListImpl(s_configServer);
        for (int i = 0; i < enumeration.getLength(); ++i) {
            enumerationDesc.addAttribute(enumeration.item(i));
        }
        return enumerationDesc;
    }

    private static AttributeListImpl buildPatternDescription(StringList pattern) throws ConfigServiceException {
        AttributeListImpl patternDesc = new AttributeListImpl(s_configServer);
        for (int i = 0; i < pattern.getLength(); ++i) {
            RegularExpression regex = new RegularExpression(pattern.item(i));
            AttributeMapImpl regexDesc = ConfigTypeDocument.buildRegexDescription(regex);
            patternDesc.addAttribute(regexDesc);
        }
        return patternDesc;
    }

    private static AttributeMapImpl buildRegexDescription(RegularExpression regex) throws ConfigServiceException {
        AttributeMapImpl regexDesc = null;
        regexDesc = new AttributeMapImpl(s_configServer);
        regexDesc.setAttribute("mx.config.regex.pattern", (Object)regex.getPattern());
        regexDesc.setAttribute("mx.config.regex.options", (Object)regex.getOptions());
        return regexDesc;
    }

    private static Class getAtomicClassType(XSSimpleTypeDefinition simpleType) throws ConfigServiceException {
        switch (((XSSimpleType)simpleType).getPrimitiveKind()) {
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                if (ConfigTypeDocument.isIntType((XSTypeDefinition)simpleType)) {
                    return Integer.class;
                }
                if (ConfigTypeDocument.isLongType((XSTypeDefinition)simpleType)) {
                    return Long.class;
                }
                return BigDecimal.class;
            }
            case 7: {
                return Date.class;
            }
            case 15: {
                return byte[].class;
            }
            case 17: {
                return IConfigElement.class;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                throw new ConfigServiceException("Invalid attribute type: unsupported primitive type");
            }
        }
        throw new Error("Invalid attribute type: invalid primitive type");
    }

    private static String getSimpleTypeName(short typeCode) throws ConfigServiceException {
        switch (typeCode) {
            case 1: {
                return "string";
            }
            case 2: {
                return "boolean";
            }
            case 3: {
                return "decimal";
            }
            case 5: {
                return "double";
            }
            case 7: {
                return "dateTime";
            }
            case 15: {
                return "hexBinary";
            }
            case 17: {
                return "anyURI";
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                throw new ConfigServiceException("Invalid attribute type: unsupported primitive type");
            }
        }
        throw new Error("Invalid attribute type: invalid primitive type");
    }

    private static Object convertValue(Object obj, XSTypeDefinition type) {
        if (ConfigTypeDocument.isIntType(type)) {
            return ConfigTypeDocument.convert2Integer(obj);
        }
        if (ConfigTypeDocument.isLongType(type)) {
            return ConfigTypeDocument.convert2Long(obj);
        }
        if (ConfigTypeDocument.isReferenceType(type)) {
            String converted = obj.toString();
            return new ConfigReference(converted, s_configServer);
        }
        if (ConfigTypeDocument.isByteArrayType(type)) {
            String converted = obj.toString();
            return converted.getBytes();
        }
        return obj;
    }

    private static Integer convert2Integer(Object value) {
        BigDecimal converted = new BigDecimal(value.toString());
        BigDecimal tmp = MAX_INT.min(converted);
        tmp = MIN_INT.max(tmp);
        return new Integer(tmp.intValue());
    }

    private static Long convert2Long(Object value) {
        BigDecimal converted = new BigDecimal(value.toString());
        BigDecimal tmp = MAX_LONG.min(converted);
        tmp = MIN_LONG.max(tmp);
        return new Long(tmp.longValue());
    }

    static boolean isIntType(XSTypeDefinition simpleType) {
        for (XSTypeDefinition type = simpleType; type != null; type = type.getBaseType()) {
            if (type.getName() == null) continue;
            if (type.getName().equals(ANY_TYPE_NAME)) break;
            if (!type.getName().equals("int") && !type.getName().equals("unsignedInt")) continue;
            return true;
        }
        return false;
    }

    static boolean isLongType(XSTypeDefinition simpleType) {
        for (XSTypeDefinition type = simpleType; type != null; type = type.getBaseType()) {
            if (type.getName() == null) continue;
            if (type.getName().equals(ANY_TYPE_NAME)) break;
            if (!type.getName().equals("integer")) continue;
            return true;
        }
        return false;
    }

    static boolean isReferenceType(XSTypeDefinition simpleType) {
        for (XSTypeDefinition type = simpleType; type != null; type = type.getBaseType()) {
            if (type.getName() == null) continue;
            if (type.getName().equals(ANY_TYPE_NAME)) break;
            if (!type.getName().equals("anyURI")) continue;
            return true;
        }
        return false;
    }

    static boolean isByteArrayType(XSTypeDefinition simpleType) {
        for (XSTypeDefinition type = simpleType; type != null; type = type.getBaseType()) {
            if (type.getName() == null) continue;
            if (type.getName().equals(ANY_TYPE_NAME)) break;
            if (!type.getName().equals("hexBinary")) continue;
            return true;
        }
        return false;
    }

    static boolean isDecimalType(XSTypeDefinition simpleType) {
        for (XSTypeDefinition type = simpleType; type != null; type = type.getBaseType()) {
            if (type.getName() == null) continue;
            if (type.getName().equals(ANY_TYPE_NAME)) break;
            if (!type.getName().equals("decimal")) continue;
            return true;
        }
        return false;
    }

    private ConfigTypeDocument() {
    }

    public static Collection parse(String namespaceURI, String schemaDocURL, ConfigServer configServer, String path) throws ConfigServiceException {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI is null");
        }
        if (schemaDocURL == null) {
            throw new IllegalArgumentException("schemaDocURL is null");
        }
        if (configServer == null) {
            throw new IllegalArgumentException("configServer is null");
        }
        s_configServer = configServer;
        ArrayList<ConfigTypeImpl> configTypes = new ArrayList<ConfigTypeImpl>();
        try {
            ConfigSchema configSchema = ConfigTypeDocument.parseSchema(namespaceURI, schemaDocURL);
            if (configSchema != null) {
                Iterator i;
                Collection globalElemDecls = ConfigTypeDocument.orderElements(ConfigTypeDocument.stripNonBeanDecl(configSchema.getGlobalElemDecls()));
                Iterator iterator = i = globalElemDecls != null ? globalElemDecls.iterator() : Collections.EMPTY_LIST.iterator();
                while (i.hasNext()) {
                    XSElementDecl elemDecl = (XSElementDecl)i.next();
                    String version = configSchema.getElementVersion(elemDecl.fName);
                    String schemaLocationHint = configSchema.getElementDocumentLocation(elemDecl.fName);
                    if (version == null) {
                        throw new ConfigServiceException("Element declaration '" + elemDecl.fName + "' does not have a version.");
                    }
                    if (configServer.getTypeCache().lookup(elemDecl.fName, version) != null) continue;
                    configServer.debugPrintln("Importing type : " + elemDecl.getName() + " v" + version + ", location = " + schemaLocationHint);
                    ConfigTypeImpl configType = new ConfigTypeImpl(elemDecl.getName(), version, s_configServer);
                    ConfigTypeDocument.buildConfigType(configType, (XSElementDeclaration)elemDecl);
                    if (path != null) {
                        ConfigTypeDocument.buildAnnotations(configType, path);
                    }
                    configType.setProperty("mx.config.schemaLocationHint", schemaLocationHint);
                    configTypes.add(configType);
                }
            }
            return configTypes;
        }
        catch (XNIException e) {
            throw new ConfigServiceException("parse-failed", new Object[]{schemaDocURL}, (Exception)((Object)e));
        }
    }

    private static Collection orderElements(Collection map) {
        ArrayList res = new ArrayList(map);
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                XSElementDecl e1 = (XSElementDecl)o1;
                XSElementDecl e2 = (XSElementDecl)o2;
                if (e2.getSubstitutionGroupAffiliation().getName().equals(e1.getName())) {
                    return -1;
                }
                if (e1.getSubstitutionGroupAffiliation().getName().equals(e2.getName())) {
                    return 1;
                }
                return 1;
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
        Collections.sort(res, c);
        return res;
    }

    private static Collection stripNonBeanDecl(XSNamedMap map) {
        ArrayList<XSElementDecl> res = new ArrayList<XSElementDecl>();
        for (int i = 0; i < map.getLength(); ++i) {
            XSElementDecl elemDecl = (XSElementDecl)map.item(i);
            if (!ConfigTypeDocument.isConfigBeanDecl((XSElementDeclaration)elemDecl)) continue;
            res.add(elemDecl);
        }
        return res;
    }

    private static void buildAnnotations(ConfigTypeImpl configType, String path) {
        Properties data = null;
        String fileName = path + File.separator + configType.getName() + ".properties";
        try {
            FileInputStream in = new FileInputStream(new File(fileName));
            data = new Properties();
            data.load(in);
            in.close();
        }
        catch (Exception e) {
            System.err.println("WARNING: Can't find property file for " + configType.getName() + " type in the specified path " + path);
        }
        if (data == null) {
            return;
        }
        Enumeration<?> names = data.propertyNames();
        System.out.println("Imported javadocs ...");
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            boolean isTooltip = key.endsWith("tooltip");
            key = isTooltip ? key.substring(0, key.lastIndexOf(".")) : key;
            String value = data.getProperty(key);
            ConfigPathImpl configPath = new ConfigPathImpl(key);
            AttributeDescriptionImpl desc = (AttributeDescriptionImpl)configType.getAttributeDescription(configPath);
            try {
                if (desc == null) continue;
                if (isTooltip) {
                    desc.setProperty("mx.config.tooltipAnnotation", value);
                    continue;
                }
                desc.setProperty("mx.config.schemaAnnotation", value);
            }
            catch (ConfigServiceException configServiceException) {}
        }
        System.out.println("    type = " + configType.getName() + " version = " + configType.getVersion());
    }

    static class ErrorHandler
    implements XMLErrorHandler {
        ErrorHandler() {
        }

        public void warning(String domain, String key, XMLParseException ex) throws XNIException {
            this.error(domain, key, ex);
        }

        public void fatalError(String domain, String key, XMLParseException ex) throws XNIException {
            this.error(domain, key, ex);
        }

        public void error(String domain, String key, XMLParseException ex) throws XNIException {
            throw new XNIException(this.stripScheme(ex.getExpandedSystemId()) + ":" + (ex.getLineNumber() + 1) + ":" + ex.getColumnNumber() + ", " + ex.getMessage() + " See W3C Recommendation '" + domain + "'", (Exception)ex);
        }

        private String stripScheme(String uri) {
            int index = uri.indexOf(":");
            return index >= 0 ? uri.substring(index + 1) : uri;
        }
    }

    static class ConfigSchema {
        protected XSModel xsModel = null;
        protected String version = null;
        protected String location = null;

        public ConfigSchema(SchemaGrammar grammar, String version, String locationHint) {
            this.xsModel = grammar.toXSModel();
            this.version = version;
            this.location = locationHint;
        }

        public XSNamedMap getGlobalAttrDecls() {
            return this.xsModel.getComponents((short)1);
        }

        public XSNamedMap getGlobalAttrGrpDecls() {
            return this.xsModel.getComponents((short)5);
        }

        public XSNamedMap getGlobalElemDecls() {
            return this.xsModel.getComponents((short)2);
        }

        public XSNamedMap getGlobalGroupDecls() {
            return this.xsModel.getComponents((short)6);
        }

        public XSNamedMap getGlobalNotationDecls() {
            return this.xsModel.getComponents((short)11);
        }

        public XSNamedMap getGlobalIDConstraintDecls() {
            return this.xsModel.getComponents((short)10);
        }

        public XSNamedMap getGlobalTypeDecls() {
            return this.xsModel.getComponents((short)3);
        }

        public String getElementVersion(String elementTagName) {
            return this.version;
        }

        public String getElementDocumentLocation(String elementTagName) {
            return this.getLocation(elementTagName);
        }

        private String getLocation(String elementTagName) {
            this.location = this.location.replace('\\', '/');
            if (elementTagName.equals("MF_COMPONENT")) {
                if (this.location.indexOf("/mf/") == -1) {
                    return "../mf/Component.xsd";
                }
                return "./Component.xsd";
            }
            if (elementTagName.equals("MF_APPLICATION_COMPONENT")) {
                if (this.location.indexOf("/mf/") == -1) {
                    return "../mf/ApplicationComponent.xsd";
                }
                return "./ApplicationComponent.xsd";
            }
            if (elementTagName.equals("MF_FRAMEWORK_COMPONENT")) {
                if (this.location.indexOf("/mf/") == -1) {
                    return "../mf/FrameworkComponent.xsd";
                }
                return "./FrameworkComponent.xsd";
            }
            return this.location;
        }
    }
}

