/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeList;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementDeleteNotification;
import com.sonicsw.mf.common.config.IFolderCreateNotification;
import com.sonicsw.mf.common.config.IFolderDeleteNotification;
import com.sonicsw.mf.common.config.IMetaAttributesChangeNotification;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.IRenameNotification;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.impl.ConfigPathImpl;
import com.sonicsw.mx.config.impl.Util;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConfigChange
extends EventObject {
    public static final short ELEMENT_ADDED = 0;
    public static final short ELEMENT_UPDATED = 1;
    public static final short ELEMENT_DELETED = 2;
    public static final short ELEMENT_REPLACED = 3;
    public static final short FOLDER_ADDED = 4;
    public static final short FOLDER_DELETED = 5;
    public static final short RENAME = 6;
    public static final short META_ATTRIBUTES_CHANGE = 7;
    protected long m_version = -1L;
    protected short m_type;
    protected Object m_handback = null;
    protected Set m_newAttributeNames = new HashSet();
    protected Set m_modifiedAttributeNames = new HashSet();
    protected Set m_deletedAttributeNames = new HashSet();
    protected Map m_metaAttributes = new HashMap();
    protected String m_newName = null;
    protected boolean m_isReleaseVersion = false;

    public ConfigChange(ConfigChange configChange, Object handback) {
        super(configChange.source);
        this.m_version = configChange.m_version;
        this.m_type = configChange.m_type;
        this.m_newAttributeNames.addAll(configChange.m_newAttributeNames);
        this.m_modifiedAttributeNames.addAll(configChange.m_modifiedAttributeNames);
        this.m_deletedAttributeNames.addAll(configChange.m_deletedAttributeNames);
        this.m_newName = configChange.m_newName;
        this.m_metaAttributes.putAll(configChange.m_metaAttributes);
        this.m_handback = handback;
        this.m_isReleaseVersion = configChange.m_isReleaseVersion;
    }

    public ConfigChange(IElementChange elementChange, Object handback) {
        super(elementChange.getElement().getIdentity().getName());
        this.m_version = elementChange.getElement().getIdentity().getVersion();
        this.m_type = elementChange.getChangeType();
        this.m_handback = handback;
        this.parseElementChange(elementChange);
    }

    public ConfigChange(String name, long version, short type) {
        super(name);
        this.m_version = version;
        this.m_type = type;
    }

    public ConfigChange(INamingNotification namingNotification, Object handback) throws ConfigServiceException {
        super(namingNotification.getName());
        if (namingNotification instanceof IFolderCreateNotification) {
            this.m_type = (short)4;
        } else if (namingNotification instanceof IFolderDeleteNotification) {
            this.m_type = (short)5;
        } else if (namingNotification instanceof IRenameNotification) {
            this.m_type = (short)6;
            this.m_newName = ((IRenameNotification)namingNotification).getNewName();
        } else if (namingNotification instanceof IMetaAttributesChangeNotification) {
            this.m_type = (short)7;
            HashMap ma = ((IMetaAttributesChangeNotification)namingNotification).getAttributes();
            this.m_metaAttributes.putAll(Util.splitToolMetaAttributes((Map)ma));
        } else if (namingNotification instanceof IElementDeleteNotification) {
            this.m_type = (short)2;
        } else {
            throw new ConfigServiceException("cc-init-unknown-type", new Object[]{namingNotification.getClass().getName()});
        }
        this.m_handback = handback;
    }

    protected final void parseElementChange(IElementChange elementChange) {
        IBasicElement element = elementChange.getElement();
        if (element instanceof IDeltaElement) {
            Object obj = ((IDeltaElement)element).getDeltaAttributes();
            if (obj instanceof IDeltaAttributeSet) {
                this.parseDeltaAttributeSet((IDeltaAttributeSet)obj, new ConfigPathImpl());
            } else {
                System.err.println("Delta element contains attribute set.");
                Iterator names = ((IAttributeSet)obj).getAttributes().keySet().iterator();
                while (names.hasNext()) {
                    this.m_modifiedAttributeNames.add(new ConfigPathImpl((String)names.next()));
                }
            }
        }
    }

    protected void parseDeltaAttributeSet(IDeltaAttributeSet attrSet, IConfigPath path) {
        Object attrValue;
        int i;
        String[] attrNames = attrSet.getDeletedAttributesNames();
        for (i = 0; i < attrNames.length; ++i) {
            this.m_deletedAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
        }
        attrNames = attrSet.getNewAttributesNames();
        for (i = 0; i < attrNames.length; ++i) {
            attrValue = null;
            try {
                attrValue = attrSet.getNewValue(attrNames[i]);
            }
            catch (Exception e) {
                continue;
            }
            if (attrValue instanceof IDeltaAttributeSet) {
                this.parseDeltaAttributeSet((IDeltaAttributeSet)attrValue, new ConfigPathImpl(path).append(attrNames[i]));
                continue;
            }
            if (attrValue instanceof IDeltaAttributeList) {
                this.m_newAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
                continue;
            }
            this.checkReleaseVersion(attrValue);
            this.m_newAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
        }
        attrNames = attrSet.getModifiedAttributesNames();
        for (i = 0; i < attrNames.length; ++i) {
            attrValue = null;
            try {
                attrValue = attrSet.getNewValue(attrNames[i]);
            }
            catch (Exception e) {
                continue;
            }
            if (attrValue instanceof IDeltaAttributeSet) {
                this.parseDeltaAttributeSet((IDeltaAttributeSet)attrValue, new ConfigPathImpl(path).append(attrNames[i]));
                continue;
            }
            if (attrValue instanceof IDeltaAttributeList) {
                this.m_modifiedAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
                continue;
            }
            this.checkReleaseVersion(attrValue);
            this.m_modifiedAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
        }
    }

    private void checkReleaseVersion(Object attrValue) {
        HashMap attributes;
        if (attrValue instanceof IAttributeSet && (attributes = ((IAttributeSet)attrValue).getAttributes()).size() == 1 && attributes.get("RELEASE_VERSION") != null) {
            this.m_isReleaseVersion = true;
        }
    }

    public short getChangeType() {
        return this.m_type;
    }

    public String getName() {
        return (String)this.getSource();
    }

    public String getNewName() {
        return this.m_newName;
    }

    public long getVersion() {
        return this.m_version;
    }

    public Set getNewAttributeNames() {
        return this.m_newAttributeNames;
    }

    public Set getModifiedAttributeNames() {
        return this.m_modifiedAttributeNames;
    }

    public Set getDeletedAttributeNames() {
        return this.m_deletedAttributeNames;
    }

    public Object getHandback() {
        return this.m_handback;
    }

    public Map getMetaAttributes() {
        return this.m_metaAttributes;
    }

    public boolean isReleaseVersion() {
        return this.m_isReleaseVersion;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ConfigChange:\n");
        buffer.append("{\n");
        buffer.append("  Config Element Name:" + this.getName() + "\n");
        buffer.append("  New Config Element Name:" + this.getNewName() + "\n");
        buffer.append("  Config Element Version:" + this.getVersion() + "\n");
        buffer.append("  Type:" + this.type2String(this.m_type) + "\n");
        buffer.append("  Handback:" + this.m_handback + "\n");
        buffer.append("  Is Release Version:" + this.m_isReleaseVersion + "\n");
        buffer.append("  NewAttributeNames:\n");
        buffer.append("  {\n");
        Iterator<Object> it = this.m_newAttributeNames.iterator();
        while (it.hasNext()) {
            buffer.append("    ").append(it.next()).append("\n");
        }
        buffer.append("  }\n");
        buffer.append("  ModifiedAttributeNames:\n");
        buffer.append("  {\n");
        it = this.m_modifiedAttributeNames.iterator();
        while (it.hasNext()) {
            buffer.append("    ").append(it.next()).append("\n");
        }
        buffer.append("  }\n");
        buffer.append("  DeletedAttributeNames:\n");
        buffer.append("  {\n");
        it = this.m_deletedAttributeNames.iterator();
        while (it.hasNext()) {
            buffer.append("    ").append(it.next()).append("\n");
        }
        buffer.append("  }\n");
        buffer.append("  MetaAttributes:\n");
        buffer.append("  {\n");
        for (Map.Entry entry : this.m_metaAttributes.entrySet()) {
            buffer.append("    ").append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
        buffer.append("  }\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    private String type2String(short type) {
        switch (type) {
            case 0: {
                return "ELEMENT_ADDED";
            }
            case 1: {
                return "ELEMENT_UPDATED";
            }
            case 2: {
                return "ELEMENT_DELETED";
            }
            case 3: {
                return "ELEMENT_REPLACED";
            }
            case 4: {
                return "FOLDER_ADDED";
            }
            case 5: {
                return "FOLDER_DELETED";
            }
            case 7: {
                return "META_ATTRIBUTES_CHANGE";
            }
            case 6: {
                return "RENAME";
            }
        }
        return "";
    }
}

