/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.impl.DSTransaction;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.impl.ConfigElementImpl;
import com.sonicsw.mx.config.impl.TxnConfigServer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SubTxnConfigServer
extends TxnConfigServer {
    TxnConfigServer m_cs;
    Map m_createElements = new HashMap();

    SubTxnConfigServer(TxnConfigServer cs) throws ConfigServiceException {
        super(cs.m_ds);
        this.m_cs = cs;
    }

    @Override
    public void close() throws ConfigServiceException {
        super.close();
        if (this.m_createElements != null) {
            this.m_createElements.clear();
            this.m_createElements = null;
        }
    }

    @Override
    public IConfigElement loadConfigElement(String configElementName) throws ConfigServiceException {
        try {
            ConfigElementImpl configElement = (ConfigElementImpl)this.getElementCache().lookup(configElementName, "");
            if (configElement != null) {
                return configElement;
            }
            ConfigElementImpl configElementInParent = (ConfigElementImpl)this.m_cs.loadConfigElement(configElementName);
            return this.retrieveConfigElement(configElement, configElementInParent);
        }
        catch (ConfigServiceException e) {
            throw new ConfigServiceException("cs-load-ce-failed", new Object[]{configElementName}, (Exception)((Object)e));
        }
    }

    @Override
    public IConfigElement loadLocalConfigElement(String configElementName) throws ConfigServiceException {
        try {
            ConfigElementImpl configElement = (ConfigElementImpl)this.getElementCache().lookup(configElementName, "");
            if (configElement != null) {
                return configElement;
            }
            ConfigElementImpl configElementInParent = (ConfigElementImpl)this.m_cs.loadLocalConfigElement(configElementName);
            return this.retrieveConfigElement(configElement, configElementInParent);
        }
        catch (ConfigServiceException e) {
            throw new ConfigServiceException("cs-load-ce-failed", new Object[]{configElementName}, (Exception)((Object)e));
        }
    }

    private ConfigElementImpl retrieveConfigElement(ConfigElementImpl configElementParam, ConfigElementImpl configElementInParent) throws ConfigServiceException {
        ConfigElementImpl configElement = configElementParam;
        if (configElementInParent != null) {
            configElement = (ConfigElementImpl)configElementInParent.clone(this, configElementInParent.getName());
            this.setState(configElementInParent.getState(), configElement);
        }
        return configElement;
    }

    @Override
    public Set loadConfigElements(Query query) throws ConfigServiceException {
        try {
            HashSet<ConfigElementImpl> configElements = new HashSet<ConfigElementImpl>();
            Set configElementsInParent = this.m_cs.loadConfigElements(query);
            for (ConfigElementImpl configElementInParent : configElementsInParent) {
                ConfigElementImpl configElement = (ConfigElementImpl)configElementInParent.clone(this, configElementInParent.getName());
                this.setState(configElementInParent.getState(), configElement);
                configElements.add(configElement);
            }
            return configElements;
        }
        catch (ConfigServiceException e) {
            throw new ConfigServiceException("cs-load-ces-failed", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit() throws ConfigServiceException {
        try {
            TxnConfigServer txnConfigServer = this.m_cs;
            synchronized (txnConfigServer) {
                int i;
                for (ConfigElementImpl configElement : this.m_newElements) {
                    configElement.validateComplete();
                }
                for (ConfigElementImpl configElement : this.m_modifiedElements) {
                    configElement.validateComplete();
                }
                for (ConfigElementImpl configElement : this.m_unmodifiedElements) {
                    configElement.validateComplete();
                }
                for (DSTransaction.Action action : this.m_txn.getActions()) {
                    ConfigElementImpl configElement;
                    if (action instanceof DSTransaction.AttachBlob) continue;
                    if (action instanceof DSTransaction.CreateElement) {
                        DSTransaction.CreateElement createElement = (DSTransaction.CreateElement)action;
                        configElement = (ConfigElementImpl)this.m_createElements.get(createElement.m_element.getIdentity().getName());
                        if (configElement == null) continue;
                        ConfigElementImpl parentConfigElement = this.recreateRemovedElement(configElement);
                        this.m_cs.storeConfigElement(parentConfigElement);
                        continue;
                    }
                    if (action instanceof DSTransaction.CreateFolder) {
                        DSTransaction.CreateFolder createFolder = (DSTransaction.CreateFolder)action;
                        this.m_cs.createFolder(createFolder.m_folderName);
                        continue;
                    }
                    if (action instanceof DSTransaction.DeleteElement) {
                        DSTransaction.DeleteElement deleteElement = (DSTransaction.DeleteElement)action;
                        this.m_cs.removeConfigElement(deleteElement.m_elementName);
                        continue;
                    }
                    if (action instanceof DSTransaction.DeleteFolder) {
                        DSTransaction.DeleteFolder deleteFolder = (DSTransaction.DeleteFolder)action;
                        this.m_cs.deleteFolder(deleteFolder.m_folderName);
                        continue;
                    }
                    if (action instanceof DSTransaction.DetachBlob) continue;
                    if (action instanceof DSTransaction.Rename) {
                        DSTransaction.Rename rename = (DSTransaction.Rename)action;
                        configElement = (ConfigElementImpl)this.m_cs.loadConfigElement(rename.m_oldName);
                        if (configElement == null) continue;
                        configElement.setName(rename.m_newName);
                        continue;
                    }
                    if (action instanceof DSTransaction.SetAttributes) {
                        DSTransaction.SetAttributes setAttributes = (DSTransaction.SetAttributes)action;
                        this.m_cs.setMetaAttributes(setAttributes.m_name, setAttributes.m_attributes);
                        continue;
                    }
                    if (!(action instanceof DSTransaction.UpdateElement)) continue;
                }
                Object[] objs = this.m_modifiedElements.toArray();
                for (i = 0; i < objs.length; ++i) {
                    this.transitionModifiedElement(i, objs);
                }
                objs = this.m_unmodifiedElements.toArray();
                for (i = 0; i < objs.length; ++i) {
                    this.transitionModifiedElement(i, objs);
                }
                objs = this.m_newElements.toArray();
                for (i = 0; i < objs.length; ++i) {
                    this.elementStored((ConfigElementImpl)objs[i]);
                }
                objs = this.m_modifiedElements.toArray();
                for (i = 0; i < objs.length; ++i) {
                    this.elementStored((ConfigElementImpl)objs[i]);
                }
                objs = this.m_removedElements.toArray();
                for (i = 0; i < objs.length; ++i) {
                    this.elementDeleted(((ConfigElementImpl)objs[i]).getName());
                }
                this.m_txn = (DSTransaction)this.m_ds.createTransaction();
                this.m_createElements.clear();
            }
        }
        catch (Exception e) {
            try {
                this.rollback();
            }
            catch (ConfigServiceException configServiceException) {
                // empty catch block
            }
            throw new ConfigServiceException("tcs-commit-failed", e);
        }
    }

    private void transitionModifiedElement(int i, Object[] objs) throws ConfigServiceException {
        ConfigElementImpl configElement = (ConfigElementImpl)objs[i];
        ConfigElementImpl configElementInParent = (ConfigElementImpl)this.m_cs.loadConfigElement(configElement.getName());
        if (configElementInParent != null) {
            configElementInParent.clear();
            configElementInParent.putAll((Map)configElement);
        } else {
            ConfigElementImpl configElementImpl = this.recreateRemovedElement(configElement);
        }
    }

    private ConfigElementImpl recreateRemovedElement(ConfigElementImpl configElement) throws ConfigServiceException {
        ConfigElementImpl parentConfigElement = (ConfigElementImpl)configElement.clone(this.m_cs, configElement.getName());
        if (configElement.m_blob != null) {
            parentConfigElement.setInputStream(configElement.m_blob);
        }
        if (configElement.isMetaAttributesModified()) {
            parentConfigElement.setMetaAttributes(configElement.getMetaAttributes());
        }
        return parentConfigElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() throws ConfigServiceException {
        Exception ex = null;
        TxnConfigServer txnConfigServer = this.m_cs;
        synchronized (txnConfigServer) {
            ConfigElementImpl configElement;
            int i;
            Object[] objs = this.m_localElements.toArray();
            for (i = 0; i < objs.length; ++i) {
                this.elementDeleted((ConfigElementImpl)objs[i]);
            }
            objs = this.m_newElements.toArray();
            for (i = 0; i < objs.length; ++i) {
                this.elementDeleted((ConfigElementImpl)objs[i]);
            }
            objs = this.m_modifiedElements.toArray();
            for (i = 0; i < objs.length; ++i) {
                configElement = (ConfigElementImpl)objs[i];
                ex = this.rollbackElementInParent(configElement, ex);
            }
            objs = this.m_unmodifiedElements.toArray();
            for (i = 0; i < objs.length; ++i) {
                configElement = (ConfigElementImpl)objs[i];
                ex = this.rollbackElementInParent(configElement, ex);
            }
            objs = this.m_removedElements.toArray();
            for (i = 0; i < objs.length; ++i) {
                configElement = (ConfigElementImpl)objs[i];
                this.getElementCache().add(configElement.getName(), "", configElement);
                ex = this.rollbackElementInParent(configElement, ex);
            }
        }
        this.m_txn = (DSTransaction)this.m_ds.createTransaction();
        this.m_createElements.clear();
        if (ex != null) {
            throw new ConfigServiceException("tcs-rollback-failed", ex);
        }
    }

    private Exception rollbackElementInParent(ConfigElementImpl configElement, Exception exParam) throws ConfigServiceException {
        Object ex = exParam;
        ConfigElementImpl configElementInParent = null;
        try {
            configElementInParent = (ConfigElementImpl)this.m_cs.loadConfigElement(configElement.getName());
        }
        catch (ConfigServiceException e) {
            ex = e;
        }
        if (configElementInParent != null) {
            configElement.clear();
            configElement.putAll((Map)configElementInParent);
            this.elementRefreshed(configElement);
        } else {
            this.elementDeleted(configElement);
        }
        return ex;
    }

    @Override
    public void flush() throws ConfigServiceException {
        super.flush();
        this.m_createElements.clear();
    }

    @Override
    protected void elementCreated(ConfigElementImpl configElement) throws ConfigServiceException {
        super.elementCreated(configElement);
        this.m_createElements.put(configElement.getDirectoryElementName(), configElement);
    }

    private void setState(short state, ConfigElementImpl configElement) throws ConfigServiceException {
        switch (state) {
            case 1: {
                break;
            }
            case 3: {
                configElement.setState((short)3);
                this.elementModified(configElement);
                break;
            }
            case 2: {
                this.elementRefreshed(configElement);
                break;
            }
            case 4: {
                this.elementRemoved(configElement);
                break;
            }
            case 5: {
                this.elementDeleted(configElement);
                break;
            }
        }
    }
}

