/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.util;

import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mx.config.impl.Util;
import com.sonicsw.mx.config.util.SonicFSException;
import com.sonicsw.mx.config.util.SonicFSFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class SonicFSFileSystem {
    public static final String SCHEME = "sonicfs";
    public static final Comparator<SonicFSFile> COMPARATOR = new AlphaComparator();
    protected static final String CREATION_TIME = "CREATION_TIME";
    protected static final String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";
    protected static final String SIZE = "SIZE";
    protected static final String CREATED_BY = "CREATED_BY";
    protected static final String PERMISSIONS = "PERMISSIONS";
    protected static final String HIDDEN = "HIDDEN";
    protected static final String FILE_TYPE = "MF_FILE";
    protected static final String TOOL_ATTRIBUTES = "TOOL_ATTRIBUTES";
    protected IDirectoryFileSystemService m_dfs;
    protected String m_user;
    public static final char separatorChar = '/';
    public static final String separator = "/";

    public SonicFSFileSystem(IDirectoryFileSystemService dfs, String user) {
        this.m_dfs = dfs;
        this.m_user = user;
    }

    public SonicFSFileSystem(JMSConnectorClient connector, String domain, String user) throws SonicFSException {
        try {
            this.m_dfs = new DirectoryServiceProxy((IRemoteMBeanServer)connector, new ObjectName(domain + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE"));
            this.m_dfs.getDirectoryServiceVersion();
            this.m_user = user;
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to connect to Directory Service", e);
        }
    }

    public void close() throws SonicFSException {
        try {
            this.m_dfs.close();
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to close the DIrectory Service " + e.getMessage(), e);
        }
    }

    public IDirectoryFileSystemService getDirectoryService() {
        return this.m_dfs;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getRoot() {
        return separator;
    }

    public SonicFSFile getRootFile() {
        return SonicFSFile.createDirectory(this.getRoot());
    }

    public String[] list(String path, boolean listSubFolders) throws SonicFSException {
        return this.list(path, listSubFolders, true, null);
    }

    public String[] list(String pathParam, boolean recursive, boolean listFolders, String extension) throws SonicFSException {
        String path = pathParam;
        if (this.isFile(path)) {
            return new String[]{path};
        }
        path = SonicFSFile.getCanonicalDirPath(path);
        if (!recursive) {
            return this.list(path, extension, listFolders);
        }
        ArrayList childrenMaps = new ArrayList();
        ArrayList<String> result = new ArrayList<String>(childrenMaps.size());
        boolean isFile = this.isFile(path);
        if (listFolders || isFile) {
            result.add(path);
        }
        try {
            childrenMaps = this.m_dfs.recursiveList(path, listFolders, true, extension);
        }
        catch (DirectoryServiceException dirE) {
            throw new SonicFSException("Unable to list the contents of folder " + path, dirE);
        }
        for (HashMap map : childrenMaps) {
            String folderName = (String)map.get("_FOLDER_NAME");
            IElementIdentity ID = (IElementIdentity)map.get("_ELEMENT_IDENTITY");
            if (folderName != null && listFolders && this.isRealFolder(map)) {
                result.add(folderName + '/');
                continue;
            }
            String name = this.getValidFileName(map);
            if (name == null) continue;
            result.add(ID.getName());
        }
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public String[] list(String path) throws SonicFSException {
        return this.list(path, null, true);
    }

    private String[] list(String path, String fileExtension, boolean listFolders) throws SonicFSException {
        String usePath = path;
        if (!this.isDirectory(usePath)) {
            if (usePath.equals("/workspace/")) {
                usePath = "/workspace";
            }
            if (!this.isDirectory(usePath)) {
                throw new SonicFSException("'" + path + "' is not a valid directory");
            }
        }
        try {
            String name = null;
            ArrayList<String> result = new ArrayList<String>();
            HashMap[] maps = this.m_dfs.listFSAll(usePath, listFolders, fileExtension);
            for (int i = 0; i < maps.length; ++i) {
                name = (String)maps[i].get("_FOLDER_NAME");
                if (name != null) {
                    if (!this.isRealFolder(maps[i])) continue;
                    result.add(name.substring(name.lastIndexOf(47) + 1) + '/');
                    continue;
                }
                name = this.getValidFileName(maps[i]);
                if (name == null) continue;
                result.add(name.substring(name.lastIndexOf(47) + 1));
            }
            Collections.sort(result);
            return result.toArray(new String[result.size()]);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to list '" + path + "' - " + e.getMessage(), e);
        }
    }

    public SonicFSFile[] listDetails(String path) throws SonicFSException {
        this.checkIsDirectory(path);
        try {
            ArrayList<SonicFSFile> result = new ArrayList<SonicFSFile>();
            Map[] maps = this.m_dfs.listFolders(path);
            this.addSonicFSFiles(maps, result);
            IDirElement[] elements = this.m_dfs.getFSElements(path, false);
            for (int i = 0; i < elements.length; ++i) {
                if (!elements[i].getIdentity().getType().equals(FILE_TYPE)) continue;
                result.add(SonicFSFile.createFile(elements[i]));
            }
            Collections.sort(result, COMPARATOR);
            return result.toArray(new SonicFSFile[result.size()]);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to listDetails '" + path + "' - " + e.getMessage(), e);
        }
    }

    public String[] listFolders(String path) throws SonicFSException {
        this.checkIsDirectory(path);
        try {
            HashMap[] maps = this.m_dfs.listFolders(path);
            ArrayList<String> res = new ArrayList<String>(maps.length);
            for (int i = 0; i < maps.length; ++i) {
                if (!this.isRealFolder(maps[i])) continue;
                res.add((String)maps[i].get("_FOLDER_NAME") + '/');
            }
            Collections.sort(res);
            return res.toArray(new String[res.size()]);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to list '" + path + "' - " + e.getMessage(), e);
        }
    }

    public SonicFSFile[] listFolderDetails(String path) throws SonicFSException {
        this.checkIsDirectory(path);
        try {
            Map[] maps = this.m_dfs.listFolders(path);
            ArrayList<SonicFSFile> res = new ArrayList<SonicFSFile>(maps.length);
            this.addSonicFSFiles(maps, res);
            Collections.sort(res, COMPARATOR);
            return res.toArray(new SonicFSFile[res.size()]);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to listFolderDetails '" + path + "' - " + e.getMessage(), e);
        }
    }

    private void checkIsDirectory(String path) throws SonicFSException {
        if (!this.isDirectory(path)) {
            throw new SonicFSException("'" + path + "' is not a valid directory");
        }
    }

    private void addSonicFSFiles(Map[] maps, List<SonicFSFile> res) {
        for (int i = 0; i < maps.length; ++i) {
            if (!this.isRealFolder(maps[i])) continue;
            res.add(SonicFSFile.createDirectory((String)maps[i].get("_FOLDER_NAME")));
        }
    }

    public SonicFSFile[] listAllFolderDetails() throws SonicFSException {
        try {
            HashMap[] maps = this.m_dfs.listAllFolders();
            ArrayList<SonicFSFile> res = new ArrayList<SonicFSFile>(maps.length);
            ArrayList<String> remove = new ArrayList<String>();
            for (int i = 0; i < maps.length; ++i) {
                String name = (String)maps[i].get("_FOLDER_NAME");
                if (this.isRealFolder(maps[i])) {
                    res.add(SonicFSFile.createDirectory(name));
                    continue;
                }
                remove.add(name);
            }
            this.removeDanglingSubFolders(res, remove);
            Collections.sort(res, COMPARATOR);
            return res.toArray(new SonicFSFile[res.size()]);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to listAllFolderDetails - " + e.getMessage(), e);
        }
    }

    public String[] listAllFolders() throws SonicFSException {
        try {
            HashMap[] maps = this.m_dfs.listAllFolders();
            ArrayList<String> res = new ArrayList<String>();
            ArrayList<String> remove = new ArrayList<String>();
            for (int i = 0; i < maps.length; ++i) {
                String name = (String)maps[i].get("_FOLDER_NAME");
                if (this.isRealFolder(maps[i])) {
                    if (!name.endsWith(separator)) {
                        name = name + '/';
                    }
                    res.add(name);
                    continue;
                }
                remove.add(name);
            }
            this.removeDanglingSubFolders(res, remove);
            Collections.sort(res);
            return res.toArray(new String[res.size()]);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to listAllFolders - " + e.getMessage(), e);
        }
    }

    public SonicFSFile getDetails(String path) throws SonicFSException {
        if (path.length() == 0 || path.length() == 1 && path.charAt(0) == '/') {
            return SonicFSFile.createDirectory(separator);
        }
        try {
            HashMap meta = this.m_dfs.getMetaAttributes(path);
            if (meta == null) {
                throw new Exception("'" + path + "' does not exist");
            }
            if (meta.isEmpty() || meta.get("_FOLDER_NAME") != null) {
                return SonicFSFile.createDirectory(path);
            }
            if (meta.get("_ELEMENT_IDENTITY") == null) {
                throw new Exception("'" + path + "' is not a valid file");
            }
            IDirElement element = this.m_dfs.getFSElement(path, false);
            if (element == null || !element.getIdentity().getType().equals(FILE_TYPE)) {
                throw new Exception("'" + path + "' is not a valid file");
            }
            return SonicFSFile.createFile(element);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to get details for '" + path + "' - " + e.getMessage(), e);
        }
    }

    public SonicFSFile getFileDetails(String path) throws SonicFSException {
        SonicFSFile file = this.getDetails(path);
        if (file.isDirectory()) {
            throw new SonicFSException("'" + path + "' is a directory");
        }
        return file;
    }

    public SonicFSFile[] getDetails(String[] path) throws SonicFSException {
        ArrayList<SonicFSFile> result = new ArrayList<SonicFSFile>();
        for (int i = 0; i < path.length; ++i) {
            result.add(this.getDetails(path[i]));
        }
        return result.toArray(new SonicFSFile[result.size()]);
    }

    public boolean exists(String path) {
        try {
            this.getDetails(path);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isFile(String path) {
        try {
            SonicFSFile file = this.getDetails(path);
            return file.isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDirectory(String path) {
        try {
            SonicFSFile file = this.getDetails(path);
            return file.isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public SonicFSFile createDirectory(String path) throws SonicFSException {
        try {
            this.m_dfs.createFolder(path, true);
            return SonicFSFile.createDirectory(path);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to create directory '" + path + "' - " + e.getMessage(), e);
        }
    }

    public SonicFSFile createDirectory(SonicFSFile baseFolder, String newSubFolderName) throws SonicFSException {
        if (!baseFolder.isDirectory()) {
            throw new SonicFSException("Failed to create folder : baseFolder is not a folder");
        }
        SonicFSFile newFolder = SonicFSFile.createDirectory(baseFolder.getFullName() + separator + newSubFolderName);
        try {
            this.m_dfs.createFolder(newFolder.getFullName(), true);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to create directory '" + newFolder + "' - " + e.getMessage(), e);
        }
        return newFolder;
    }

    public void createDirectoryPath(String path) throws SonicFSException {
        try {
            StringTokenizer st = new StringTokenizer(path, separator);
            StringBuffer buffer = new StringBuffer();
            while (st.hasMoreTokens()) {
                buffer.append(separator).append(st.nextToken());
                this.m_dfs.createFolder(buffer.toString(), true);
            }
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to create directory path '" + path + "' - " + e.getMessage(), e);
        }
    }

    public void deleteDirectory(String path) throws SonicFSException {
        try {
            this.m_dfs.deleteFolder(path);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to delete directory '" + path + "' - " + e.getMessage(), e);
        }
    }

    public void deleteDirectoryPath(String path) throws SonicFSException {
        try {
            String name;
            int i;
            HashMap[] maps = this.m_dfs.listFSElements(path);
            IDSTransaction txn = this.m_dfs.createTransaction();
            for (i = 0; i < maps.length; ++i) {
                name = this.getValidFileName(maps[i]);
                if (name == null) continue;
                txn.addDeleteElement(name);
            }
            this.m_dfs.executeTransaction(txn);
            maps = this.m_dfs.listFolders(path);
            for (i = 0; i < maps.length; ++i) {
                name = (String)maps[i].get("_FOLDER_NAME");
                this.deleteDirectoryPath(name);
            }
            this.m_dfs.deleteFolder(path);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to delete directory path '" + path + "' - " + e.getMessage(), e);
        }
    }

    public void rename(String oldPath, String newPath) throws SonicFSException {
        if (oldPath == null) {
            throw new SonicFSException("Cannot rename( >>> null <<<, " + newPath + ")");
        }
        if (newPath == null) {
            throw new SonicFSException("Cannot rename(" + oldPath + ", >>> null <<<)");
        }
        if (oldPath.equals(this.getRoot())) {
            throw new SonicFSException("Cannot rename the root folder");
        }
        if (oldPath.equals(newPath)) {
            throw new SonicFSException("Cannot rename : oldPath and newPath are identical");
        }
        try {
            this.m_dfs.rename(oldPath, newPath);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to rename '" + oldPath + "' to '" + newPath + "' - " + e.getMessage(), e);
        }
    }

    public SonicFSFile rename(SonicFSFile oldFile, String newName) throws SonicFSException {
        if (oldFile == null) {
            throw new SonicFSException("Cannot rename( >>> null <<<, " + newName + ")");
        }
        if (newName == null) {
            throw new SonicFSException("Cannot rename(" + oldFile + ", >>> null <<<)");
        }
        if (oldFile.equals(this.getRootFile())) {
            throw new SonicFSException("Cannot rename the root folder");
        }
        StringBuilder newFullPath = new StringBuilder(oldFile.getParent());
        if (!newName.startsWith(separator)) {
            newFullPath.append(separator);
        }
        newFullPath.append(newName);
        SonicFSFile newFile = SonicFSFile.createDirectory(newFullPath.toString());
        this.rename(oldFile.getFullName(), newFile.getFullName());
        return newFile;
    }

    public InputStream getInputStream(String path) throws SonicFSException {
        IBlob blob;
        SonicFSFile file = this.getFileDetails(path);
        try {
            blob = this.m_dfs.getFSBlob(path, false);
        }
        catch (DirectoryServiceException e) {
            throw new SonicFSException("Failed to read input stream '" + path + "' - " + e.getMessage(), e);
        }
        if (blob == null) {
            return null;
        }
        return blob.getBlobStream();
    }

    public String getContent(String path) throws SonicFSException {
        SonicFSFile file = this.getFileDetails(path);
        ByteArrayOutputStream os = this.getBlobOutputStream(path);
        if (os == null) {
            return null;
        }
        String content = os.toString();
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    public byte[] getContentBytes(String path) throws SonicFSException {
        SonicFSFile file = this.getFileDetails(path);
        ByteArrayOutputStream os = this.getBlobOutputStream(path);
        if (os == null) {
            return null;
        }
        byte[] content = os.toByteArray();
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    public void deleteFile(String path) throws SonicFSException {
        try {
            IDirElement element = this.m_dfs.getFSElement(path, true);
            if (element == null) {
                throw new Exception("The file '" + path + "' does not exist");
            }
            this.checkIdentityIsFileType(element, path);
            this.m_dfs.detachFSBlob((IDeltaDirElement)element.doneUpdate());
            this.m_dfs.deleteFSElement(path);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to delete file '" + path + "' - " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(String path, File file) throws SonicFSException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (Exception ex) {
            throw new SonicFSException("Unable to create file stream for " + file + ": " + ex.toString(), ex);
        }
        try {
            this.createFile(path, stream, (int)file.length());
        }
        finally {
            SonicFSFileSystem.closeStream(stream);
        }
    }

    public void createFile(String path, String content) throws SonicFSException {
        this.createFile(path, content.getBytes());
    }

    public void createFile(String path, byte[] content) throws SonicFSException {
        if (content != null) {
            this.createFile(path, new ByteArrayInputStream(content), content.length);
        } else {
            this.createFile(path, null, 0);
        }
    }

    public void createFile(String path, InputStream stream, int size) throws SonicFSException {
        try {
            HashMap<String, String> meta = this.m_dfs.getMetaAttributes(path);
            if (meta != null) {
                if (meta.get("_FOLDER_NAME") != null) {
                    throw new Exception("A folder called '" + path + "' already exists");
                }
                throw new Exception("'" + path + "' already exists");
            }
            IDirElement element = ElementFactory.createElement((String)path, (String)FILE_TYPE, (String)"100");
            String user = this.m_user != null ? this.m_user : "";
            Long timeNow = new Long(System.currentTimeMillis());
            IAttributeSet set = element.getAttributes();
            set.setLongAttribute(CREATION_TIME, timeNow);
            set.setStringAttribute(CREATED_BY, user);
            set.setLongAttribute(LAST_MODIFIED_TIME, timeNow);
            set.setIntegerAttribute(SIZE, new Integer(size));
            set.setStringAttribute(PERMISSIONS, "");
            set.setBooleanAttribute(HIDDEN, Boolean.FALSE);
            IDSTransaction txn = this.m_dfs.createTransaction();
            if (stream != null) {
                txn.addAttachBlob(element.doneUpdate(), stream);
            } else {
                txn.addCreateElement(element);
            }
            meta = new HashMap<String, String>();
            meta.put(TOOL_ATTRIBUTES, "TYPE=MF_FILE");
            txn.addSetAttributes(path, meta);
            this.m_dfs.executeTransaction(txn);
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to create file - " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFile(String path, File file, boolean create) throws SonicFSException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (Exception ex) {
            throw new SonicFSException("Unable to create a atream for the new file from " + file + ": " + ex.toString(), ex);
        }
        try {
            this.updateFile(path, stream, create, (int)file.length());
        }
        finally {
            SonicFSFileSystem.closeStream(stream);
        }
    }

    private static void closeStream(FileInputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void updateFile(String path, String content, boolean create) throws SonicFSException {
        this.updateFile(path, content.getBytes(), create);
    }

    public void updateFile(String path, byte[] content, boolean create) throws SonicFSException {
        if (content == null) {
            this.updateFile(path, null, create, 0);
        } else {
            this.updateFile(path, new ByteArrayInputStream(content), create, content.length);
        }
    }

    public void updateFile(String path, InputStream stream, boolean create, int size) throws SonicFSException {
        try {
            IDirElement element = this.m_dfs.getFSElement(path, true);
            if (element != null) {
                this.checkIdentityIsFileType(element, path);
            } else if (!create) {
                throw new Exception("'" + path + "' doesn't exist");
            }
            if (element == null) {
                if (create) {
                    this.createFile(path, stream, size);
                }
            } else {
                Long timeNow = new Long(System.currentTimeMillis());
                IAttributeSet set = element.getAttributes();
                set.setLongAttribute(LAST_MODIFIED_TIME, timeNow);
                set.setIntegerAttribute(SIZE, new Integer(size));
                IDSTransaction txn = this.m_dfs.createTransaction();
                txn.addAttachBlob(element.doneUpdate(), stream);
                this.m_dfs.executeTransaction(txn);
            }
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to update file - " + e.getMessage(), e);
        }
    }

    private void checkIdentityIsFileType(IDirElement element, String path) throws Exception {
        if (!element.getIdentity().getType().equals(FILE_TYPE)) {
            throw new Exception("'" + path + "' is not a valid file");
        }
    }

    public void importFiles(String fsPath, String dsPath) throws SonicFSException {
        try {
            File fsFile;
            if (fsPath == null || fsPath.length() < 1 || dsPath == null || dsPath.length() < 1) {
                throw new SonicFSException("importFiles bad parameter(s) - fsPath and dsPath must be passed");
            }
            if (fsPath.equals(separator)) {
                String[] subList = new File(fsPath).list();
                for (int i = 0; i < subList.length; ++i) {
                    this.importFiles(separator + subList[i], dsPath);
                }
            }
            if (!(fsFile = new File(fsPath)).exists()) {
                throw new SonicFSException("\"" + fsFile.getAbsolutePath() + "\" does not exist");
            }
            if (fsFile.isFile()) {
                this.createPath(dsPath);
                this.createFile(dsPath + (dsPath.equals(separator) ? "" : separator) + fsFile.getName(), fsPath);
                return;
            }
            ArrayList<String> files = SonicFSFileSystem.listFiles(fsFile.getAbsolutePath());
            for (int i = 0; i < files.size(); ++i) {
                String dsFilePath = SonicFSFile.getCanonicalDirPath(dsPath) + files.get(i);
                File fsFilePath = new File(fsFile.getParent(), files.get(i));
                SonicFSFile dsFile = null;
                try {
                    dsFile = this.getDetails(dsFilePath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dsFile != null) {
                    if (dsFile.isFile()) {
                        this.deleteFile(dsFilePath);
                    } else {
                        throw new SonicFSException("Cannot import \"" + fsFilePath.getAbsolutePath() + "\" since \"" + dsFilePath + "\" is a folder");
                    }
                }
                this.createPath(new SonicFSFile(dsFilePath).getParent());
                this.createFile(dsFilePath, fsFilePath);
            }
        }
        catch (Exception e) {
            if (e instanceof SonicFSException) {
                throw (SonicFSException)e;
            }
            throw new SonicFSException(e.toString(), e);
        }
    }

    public void deleteFiles(String path) throws SonicFSException {
        String canonicalPath = SonicFSFile.getCanonicalDirPath(path);
        SonicFSFile file = this.getDetails(canonicalPath);
        if (file.isFile()) {
            this.deleteFile(canonicalPath);
            return;
        }
        SonicFSFile[] list = this.listDetails(canonicalPath);
        for (int i = 0; i < list.length; ++i) {
            this.deleteFiles(list[i].getFullName());
        }
        this.deleteDirectory(canonicalPath);
    }

    public InputStream getFiles(String[] fileNames) throws SonicFSException {
        try {
            IBlob zipBlob = this.m_dfs.getFiles(fileNames);
            return this.retrieveStream(zipBlob);
        }
        catch (DirectoryServiceException dirE) {
            throw new SonicFSException("SonicFSFileSystem.getFiles error ", dirE);
        }
    }

    public InputStream getFiles(String path, boolean recurse, String extension) throws SonicFSException {
        try {
            IBlob zipBlob = this.m_dfs.getFiles(path, recurse, extension);
            return this.retrieveStream(zipBlob);
        }
        catch (DirectoryServiceException dirE) {
            throw new SonicFSException("SonicFSFileSystem.getFiles error ", dirE);
        }
    }

    private InputStream retrieveStream(IBlob zipBlob) {
        if (zipBlob != null) {
            return zipBlob.getBlobStream();
        }
        return null;
    }

    private void createPath(String dsPath) throws Exception {
        SonicFSFile dsDir = null;
        try {
            dsDir = this.getDetails(dsPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dsDir != null) {
            if (dsDir.isDirectory()) {
                return;
            }
            throw new Exception("Cannot create the \"" + dsPath + "\" folder");
        }
        this.createPath(new SonicFSFile(dsPath).getParent());
        this.createDirectory(dsPath);
    }

    private static ArrayList<String> listFiles(String dirPath) throws Exception {
        File directory = new File(dirPath);
        if (!directory.exists() || !directory.isDirectory()) {
            throw new Exception("\"" + dirPath + "\" is not a directory");
        }
        ArrayList<String> resultList = new ArrayList<String>();
        SonicFSFileSystem.listFiles(directory.getParent(), directory.getName(), resultList);
        return resultList;
    }

    private static void listFiles(String rootPath, String currentPath, ArrayList<String> fileList) {
        File currentFile = new File(new File(rootPath), currentPath);
        if (currentFile.isDirectory()) {
            String[] list = currentFile.list();
            for (int i = 0; i < list.length; ++i) {
                SonicFSFileSystem.listFiles(rootPath, currentPath + separator + list[i], fileList);
            }
        } else {
            fileList.add(currentPath);
        }
    }

    private ByteArrayOutputStream getBlobOutputStream(String path) throws SonicFSException {
        try {
            int avail;
            IBlob blob = this.m_dfs.getFSBlob(path, false);
            if (blob == null) {
                return null;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            InputStream is = blob.getBlobStream();
            if (is == null) {
                return os;
            }
            byte[] buffer = new byte[1024];
            while ((avail = is.read(buffer)) != -1) {
                os.write(buffer, 0, avail);
            }
            is.close();
            return os;
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to read input stream '" + path + "' - " + e.getMessage(), e);
        }
    }

    private boolean isRealFolder(Map map) {
        try {
            Map res = Util.splitToolMetaAttributes(map);
            return !res.containsKey("_FOLDER_NAME") || !res.containsKey("TYPE");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private <T> List<T> removeDanglingSubFolders(List<T> folders, List<String> toRemove) {
        for (String delFolder : toRemove) {
            Iterator<T> j = folders.iterator();
            while (j.hasNext()) {
                T aFolder = j.next();
                if (aFolder instanceof String) {
                    if (!((String)aFolder).startsWith(delFolder)) continue;
                    j.remove();
                    continue;
                }
                if (!(aFolder instanceof SonicFSFile) || !((SonicFSFile)aFolder).getFullName().startsWith(delFolder)) continue;
                j.remove();
            }
        }
        return folders;
    }

    private String getValidFileName(Map map) {
        String tool;
        String ret = null;
        IElementIdentity id = (IElementIdentity)map.get("_ELEMENT_IDENTITY");
        if (id != null && (tool = (String)map.get(TOOL_ATTRIBUTES)) != null && tool.indexOf("TYPE=MF_FILE") != -1) {
            ret = id.getName();
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", "tcp://localhost:2506");
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        JMSConnectorClient connector = new JMSConnectorClient();
        connector.connect(address);
        new SonicFSFileSystem(connector, "Domain1", null).importFiles("C:/test/Archives", "/Archives8.0");
    }

    private static class AlphaComparator
    implements Comparator<SonicFSFile> {
        private AlphaComparator() {
        }

        @Override
        public int compare(SonicFSFile o1, SonicFSFile o2) {
            if (o1 instanceof SonicFSFile && o2 instanceof SonicFSFile) {
                String name1 = o1.getFullName();
                String name2 = o2.getFullName();
                if (name1 != null && name2 != null) {
                    return name1.compareTo(name2);
                }
            }
            return -1;
        }
    }
}

