/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.impl.ConfigBeanPrototype;
import com.sonicsw.mx.config.impl.ConfigElementImpl;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.ConfigTypeImpl;
import com.sonicsw.mx.config.impl.Util;
import java.util.Map;

public class ConfigBeanImpl
extends ConfigElementImpl
implements IConfigBean {
    IConfigType m_configType = null;

    protected ConfigBeanImpl(String name, String type, String version, ConfigServer configServer) throws ConfigServiceException {
        this(name, type, version, configServer, false);
    }

    protected ConfigBeanImpl(String name, String type, String version, ConfigServer configServer, boolean isInstance) throws ConfigServiceException {
        super(name, type, version, configServer);
        this.populateTypeAndDescription(type, version, configServer);
        if (!isInstance && ((ConfigTypeImpl)this.m_configType).hasInitialValues()) {
            ((ConfigTypeImpl)this.m_configType).applyInitialValuesTo(this);
        }
    }

    protected ConfigBeanImpl(IDirElement dsBeanElement, ConfigServer cs) throws ConfigServiceException {
        super(cs);
        String typeName = dsBeanElement.getIdentity().getType();
        String typeVersion = dsBeanElement.getIdentity().getReleaseVersion();
        this.populateTypeAndDescription(typeName, typeVersion, cs);
        super.init(dsBeanElement);
        this.validateComplete();
    }

    private void populateTypeAndDescription(String typeName, String typeVersion, ConfigServer cs) throws ConfigServiceException {
        if (typeName == null || typeVersion == null) {
            throw new ConfigServiceException("cb-init-failed-no-ct");
        }
        this.m_configType = cs.loadConfigType(typeName, typeVersion);
        if (this.m_configType == null) {
            throw new ConfigServiceException("cb-init-failed-ct-is-null", new Object[]{typeName, typeVersion});
        }
        this.m_attrDescription = this.m_configType;
    }

    protected ConfigBeanImpl(String name, ConfigBeanImpl configBean, boolean isPrototype) throws ConfigServiceException {
        super(name, configBean, isPrototype);
        this.m_configType = configBean.m_configType;
        this.m_attrDescription = this.m_configType;
    }

    @Override
    protected void refreshFromDSElement(IDirElement dsElement) throws ConfigServiceException {
        if (dsElement == null) {
            throw new ConfigServiceException("cb-refresh-from-dse-ce-is-null", new Object[]{this.m_name});
        }
        try {
            String elementType = dsElement.getIdentity().getType();
            if (!elementType.equals(this.m_type)) {
                throw new ConfigServiceException("cb-refresh-from-dse-ce-type-changed", new Object[]{this.m_name, this.m_type, elementType});
            }
            String typeVersion = dsElement.getIdentity().getReleaseVersion();
            if (!typeVersion.equals(this.m_version)) {
                IConfigType configType = this.m_configServer.loadConfigType(this.m_type, typeVersion);
                if (configType == null) {
                    throw new ConfigServiceException("cb-refresh-from-dse-ct-is-null", new Object[]{this.m_name, this.m_type, typeVersion});
                }
                this.m_configType = configType;
                this.m_attrDescription = this.m_configType;
            }
            super.refreshFromDSElement(dsElement);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigServiceException)((Object)e.getLinkedException());
        }
    }

    @Override
    public IConfigType getConfigType() {
        return this.m_configType;
    }

    @Override
    public IConfigPrototype createPrototype(String name) throws ConfigServiceException {
        return new ConfigBeanPrototype(name, this);
    }

    @Override
    public String toXML() {
        String content;
        StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        String pVersion = null;
        try {
            Map meta = this.m_configServer.getMetaAttributes(this.m_name);
            if (meta != null) {
                pVersion = (String)meta.get("PRODUCT_VERSION");
            }
        }
        catch (Throwable meta) {
            // empty catch block
        }
        buffer.append("<").append(this.m_configType.getName());
        buffer.append(" xmlns=\"" + this.m_configType.getProperty("mx.config.schemaNamespace") + "\"");
        buffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        buffer.append(" xsi:schemaLocation=\"http://www.sonicsw.com/sonicmq " + this.m_configType.getProperty("mx.config.schemaLocationHint") + "\"");
        buffer.append(" name=\"").append(Util.name2Url(this.m_name)).append('\"');
        buffer.append(" version=\"").append(this.m_configType.getVersion()).append('\"');
        if (pVersion != null) {
            buffer.append(" productVersion=\"").append(pVersion).append('\"');
        }
        buffer.append(">\r\n");
        if (this.getAnnotation() != null) {
            buffer.append("<").append("TOOL_ANNOTATION");
            buffer.append(">\r\n");
            buffer.append("<![CDATA[").append(this.getAnnotation());
            buffer.append("]]>").append("\r\n");
            buffer.append("</").append("TOOL_ANNOTATION");
            buffer.append(">\r\n");
        }
        if ((content = super.toXML()) != null && content.length() > 0) {
            buffer.append(content);
        }
        buffer.append("</").append(this.m_configType.getName()).append(">");
        return buffer.toString();
    }
}

