/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.MergeUtil;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.impl.AttributeDescriptionImpl;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.InitialValuesImpl;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class ConfigTypeImpl
extends AttributeDescriptionImpl
implements IConfigType {
    protected String m_name = "";
    protected String m_version = "";
    protected IConfigType m_super = null;
    protected InputStream m_inputStream = null;
    protected boolean m_isRemoved = false;
    protected boolean m_isNew = true;
    protected boolean m_isModified = false;
    protected static final String TYPE_NAME_PREFIX = "/mx/configTypes/";
    protected static final String SUPER_VERSION_ATTRIBUTE = "superVersion";
    protected static final String SUPER_ATTRIBUTE = "super";
    protected static final String IDENTITY_ELEMENT_TYPE_STRING = "MAConfigBeanTypeType";
    protected static final String INITIAL_VALUES = "initialValues";
    protected String m_initialValues = null;

    protected ConfigTypeImpl(String name, String version, ConfigServer configServer) throws ConfigServiceException {
        super(configServer);
        try {
            this.m_name = name;
            this.m_version = version;
            this.addConfigElementCheckingName();
        }
        catch (Exception e) {
            throw new ConfigServiceException("ct-init-failed", e);
        }
    }

    protected ConfigTypeImpl(IDirElement el, ConfigServer configServer) throws ConfigServiceException {
        try {
            this.init(el, configServer);
            this.addConfigElementCheckingName();
        }
        catch (Exception e) {
            throw new ConfigServiceException("ct-init-failed", e);
        }
    }

    private void addConfigElementCheckingName() throws ConfigServiceException {
        if (!this.m_name.equals("")) {
            this.m_configServer.getTypeCache().add(this.m_name, this.m_version, this);
        }
    }

    protected final void init(IDirElement dirElement, ConfigServer configServer) throws ConfigServiceException {
        String superVersion;
        super.init(dirElement.getAttributes(), configServer);
        this.m_isNew = false;
        this.m_isModified = false;
        String dsName = dirElement.getIdentity().getName();
        this.m_version = dirElement.getIdentity().getReleaseVersion();
        this.m_name = ConfigTypeImpl.convertDSName2TypeName(dsName, this.m_version);
        this.m_initialValues = (String)dirElement.getAttributes().getAttribute(INITIAL_VALUES);
        String superName = (String)dirElement.getAttributes().getAttribute(SUPER_ATTRIBUTE);
        if (superName != null && (superVersion = (String)dirElement.getAttributes().getAttribute(SUPER_VERSION_ATTRIBUTE)) != null) {
            this.m_super = configServer.loadConfigType(superName, superVersion);
        }
    }

    void refreshFromDSElement(IDirElement configTypeDSElement, ConfigServer configServer) throws ConfigServiceException {
        if (configTypeDSElement == null) {
            throw new ConfigServiceException("ct-refresh-from-dse-ce-is-null");
        }
        this.init(configTypeDSElement, configServer);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String className = this.getClass().getName();
        String typeName = className.substring(className.lastIndexOf(".") + 1);
        buffer.append(this.getName() + ":" + this.getVersion() + "  [" + typeName + "] =\n");
        buffer.append("{\n");
        buffer.append(this.toString(1));
        buffer.append("}\n");
        return buffer.toString();
    }

    @Override
    public Object clone() {
        try {
            ConfigTypeImpl copy = (ConfigTypeImpl)super.clone();
            copy.m_inputStream = null;
            copy.m_name = "";
            copy.m_isNew = true;
            return copy;
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException("ct-clone-failed", e);
        }
    }

    public boolean isRemoved() {
        return this.m_isRemoved;
    }

    protected void setRemoved() throws ConfigServiceException {
        if (this.isRemoved()) {
            return;
        }
        if (!this.m_name.equals("")) {
            this.m_configServer.getTypeCache().remove(this.m_name, this.getVersion());
        }
        this.m_isRemoved = true;
    }

    public boolean isModified() {
        return this.m_isModified || this.m_isNew;
    }

    protected void setModified() {
        this.m_isModified = true;
    }

    public boolean isNew() {
        return this.m_isNew;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getVersion() {
        return this.m_version;
    }

    public String getDSName() {
        return ConfigTypeImpl.convertTypeName2DSName(this.m_name, this.getVersion());
    }

    public void refresh() throws ConfigServiceException {
        try {
            this.m_configServer.refreshType(this);
        }
        catch (ConfigServiceException e) {
            if (e.getErrorKey().equals("ct-refresh-from-dse-ce-is-null")) {
                this.setRemoved();
            }
            throw e;
        }
    }

    public void setName(String name) throws ConfigServiceException {
        try {
            if (!ConfigTypeImpl.isNullOrEmpty(name)) {
                this.m_configServer.getTypeCache().add(name, this.m_version, this);
            }
            if (!ConfigTypeImpl.isNullOrEmpty(this.m_name)) {
                this.m_configServer.getTypeCache().remove(this.m_name, this.m_version);
            }
            this.m_name = name;
        }
        catch (Exception e) {
            throw new ConfigServiceException("ct-set-name-failed", e);
        }
    }

    public void setVersion(String version) throws ConfigServiceException {
        try {
            if (!ConfigTypeImpl.isNullOrEmpty(this.m_name)) {
                this.m_configServer.getTypeCache().add(this.m_name, version, this);
                this.m_configServer.getTypeCache().remove(this.m_name, this.m_version);
            }
            this.m_version = version;
        }
        catch (Exception e) {
            throw new ConfigServiceException("ct-set-version-failed", e);
        }
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    @Override
    public IConfigType getSuper() {
        return this.m_super;
    }

    protected void setSuper(IConfigType baseConfigType) throws ConfigServiceException {
        this.m_super = baseConfigType;
    }

    public void setInitialValues(String initialValues) {
        this.setInitialValues(initialValues, true);
    }

    void setInitialValues(String initialValues, boolean modify) {
        this.m_initialValues = initialValues;
        if (modify) {
            this.setModified();
        }
    }

    public boolean hasInitialValues() {
        return this.m_initialValues != null;
    }

    public void applyInitialValuesTo(IConfigBean newBean) throws ConfigServiceException {
        InitialValuesImpl.apply(newBean, this.m_initialValues);
    }

    @Override
    public void toAttributeSet(IAttributeSet attrSet) {
        super.toAttributeSet(attrSet);
        if (this.m_super != null) {
            try {
                attrSet.setStringAttribute(SUPER_ATTRIBUTE, this.m_super.getName());
                attrSet.setStringAttribute(SUPER_VERSION_ATTRIBUTE, this.m_super.getVersion());
            }
            catch (Exception e) {
                throw new ConfigServiceRuntimeException("ct-to-attr-set-failed", e);
            }
        }
        if (this.m_initialValues != null) {
            try {
                attrSet.setStringAttribute(INITIAL_VALUES, this.m_initialValues);
            }
            catch (Exception e) {
                throw new ConfigServiceRuntimeException("ct-to-attr-set-failed", e);
            }
        }
    }

    public IBasicElement doneUpdate() throws ConfigServiceException {
        IBasicElement storeThis = null;
        if (this.m_name == null || this.m_name.length() == 0) {
            throw new ConfigServiceException("ce-done-update-no-name");
        }
        if (this.isNew()) {
            IDirElement localDirElement = ElementFactory.createElement((String)ConfigTypeImpl.convertTypeName2DSName(this.m_name, this.m_version), (String)IDENTITY_ELEMENT_TYPE_STRING, (String)this.m_version);
            this.toAttributeSet(localDirElement.getAttributes());
            try {
                storeThis = localDirElement.doneUpdate();
            }
            catch (Exception e) {
                throw new ConfigServiceException("ce-done-update-failed", e);
            }
        }
        IDirElement loadedDirElement = this.m_configServer.loadDirTypeElement(ConfigTypeImpl.convertTypeName2DSName(this.m_name, this.m_version));
        IDirElement localDirElement = (IDirElement)loadedDirElement.createWritableClone();
        this.toAttributeSet(localDirElement.getAttributes());
        try {
            MergeUtil.mergeModifications((IDirElement)loadedDirElement, (IDirElement)localDirElement);
            storeThis = loadedDirElement.doneUpdate();
        }
        catch (Exception e) {
            throw new ConfigServiceException("ce-done-update-failed", e);
        }
        this.m_isModified = false;
        this.m_isNew = false;
        return storeThis;
    }

    protected IDirElement getNextVersion(INextVersionToken token) {
        return null;
    }

    public Set getSubElements() throws ConfigServiceException {
        return new HashSet();
    }

    public String getDSDirectory() {
        return TYPE_NAME_PREFIX + this.getVersion() + "/";
    }

    public static String convertTypeName2DSName(String typeName, String version) {
        return TYPE_NAME_PREFIX + version + "/" + typeName;
    }

    public static String convertDSName2TypeName(String dsName, String version) {
        String prefix = TYPE_NAME_PREFIX + version + "/";
        return dsName.substring(prefix.length());
    }

    @Override
    public IConfigServer getConfigServer() {
        return this.m_configServer;
    }
}

