/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.tools;

import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class GenerateBeanProperties
extends ConfigServerUtility {
    private static final String DEFAULT_URL = "localhost";
    private static final String DEFAULT_USER = "Administrator";
    private static final String DEFAULT_PASSWORD = "Administrator";
    private static final String DEFAULT_DOMAIN = "Domain1";
    private static final String DEFAULT_CVERSION = "100";
    private ArrayList m_argList = new ArrayList();
    private String m_url = "localhost";
    private String m_user = "Administrator";
    private String m_password = "Administrator";
    private String m_domain = "Domain1";
    private String m_cVersion = "100";
    private String m_output = null;
    private boolean m_merge = false;
    private String m_type = null;
    private boolean m_tooltip = false;
    private PrintWriter m_propWriter;
    private HashMap m_mergeProperties = new HashMap();

    public GenerateBeanProperties(String[] args) throws Exception {
        try {
            this.parseArgs(args);
        }
        catch (Exception e) {
            this.printUsage();
            throw e;
        }
        this.connect(this.m_domain, this.m_url, this.m_user, this.m_password, false);
        this.generate();
        this.cleanup();
    }

    private void generate() throws Exception {
        String[] types = this._split(this.m_type, ",");
        for (int i = 0; i < types.length; ++i) {
            this.generateFile(types[i]);
        }
    }

    private void generateFile(String type) throws Exception {
        if (this.m_merge) {
            this.loadProperties(type);
        }
        String propFilename = this.m_output + File.separator + type + ".properties";
        this.m_propWriter = new PrintWriter(new FileWriter(propFilename));
        IConfigType typeConfig = this.getConfigServer().loadConfigType(type, this.m_cVersion);
        if (type == null) {
            throw new Exception("Failed to load config type " + type + " " + this.m_cVersion);
        }
        for (String key : typeConfig.getAttributeDescriptionNames()) {
            IAttributeDescription desc = typeConfig.getAttributeDescription(key);
            if (desc.getType() == IAttributeMap.class || desc.getType() == IAttributeList.class) {
                this.mergePropertyKeyWithTooltip(key, type);
                this.generateKey(desc, key, type);
                continue;
            }
            this.mergePropertyKeyWithTooltip(key, type);
        }
        if (this.m_propWriter != null) {
            this.m_propWriter.flush();
            this.m_propWriter.close();
        }
    }

    private void mergePropertyKeyWithTooltip(String key, String type) {
        if (this.isMerged() && this.containsKey(type, key)) {
            this.mergePropertyValue(key, this.getProperty(type, key));
            if (this.m_tooltip && this.containsKey(type, key + ".tooltip")) {
                this.mergePropertyValue(key + ".tooltip", this.getProperty(type, key + ".tooltip"));
            }
        } else {
            this.println(this.m_propWriter, 0, key + " = ");
            if (this.m_tooltip) {
                this.println(this.m_propWriter, 0, key + ".tooltip = ");
            }
        }
    }

    private void generateKey(IAttributeDescription descrAttr, String name, String type) {
        for (String key : descrAttr.getAttributeDescriptionNames()) {
            IAttributeDescription desc = descrAttr.getAttributeDescription(key);
            if (desc.getType() == IAttributeMap.class || desc.getType() == IAttributeList.class) {
                this.mergePropertyNameKeyWithTooltip(key, name, type);
                this.generateKey(desc, name + "." + key, type);
                continue;
            }
            this.mergePropertyNameKeyWithTooltip(key, name, type);
        }
    }

    private void mergePropertyNameKeyWithTooltip(String key, String name, String type) {
        if (this.isMerged() && this.containsKey(type, name + "." + key)) {
            this.mergePropertyValue(name + "." + key, this.getProperty(type, name + "." + key));
            if (this.m_tooltip && this.containsKey(type, name + "." + key + ".tooltip")) {
                this.mergePropertyValue(name + "." + key + ".tooltip", this.getProperty(type, name + "." + key + ".tooltip"));
            }
        } else {
            this.println(this.m_propWriter, 0, name + "." + key + " = ");
            if (this.m_tooltip) {
                this.println(this.m_propWriter, 0, name + "." + key + ".tooltip = ");
            }
        }
    }

    private void parseArgs(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            if (args[i].trim().length() == 0) {
                ++i;
                continue;
            }
            if (args[i].equals("-url")) {
                this.m_url = args[++i];
            } else if (args[i].equals("-user")) {
                this.m_user = args[++i];
            } else if (args[i].equals("-password")) {
                this.m_password = args[++i];
            } else if (args[i].equals("-domain")) {
                this.m_domain = args[++i];
            } else if (args[i].equals("-output")) {
                this.m_output = args[++i];
            } else if (args[i].equals("-type")) {
                this.m_type = args[++i];
            } else if (args[i].equals("-cVersion")) {
                this.m_cVersion = args[++i];
            } else if (args[i].equals("-merge")) {
                this.m_merge = new Boolean(args[++i]);
            } else if (args[i].equals("-tooltip")) {
                this.m_tooltip = new Boolean(args[++i]);
            } else {
                throw new Exception("Unsupported argument " + args[i]);
            }
            ++i;
        }
        if (this.m_output == null) {
            throw new Exception("'output' is not specified");
        }
        if (this.m_type == null) {
            throw new Exception("'type' is not specified");
        }
    }

    private void loadProperties(String type) throws Exception {
        String propFilename = this.m_output + File.separator + type + ".properties";
        Properties property = new Properties();
        FileInputStream in = new FileInputStream(new File(propFilename));
        property.load(in);
        in.close();
        this.m_mergeProperties.put(type, property);
    }

    private boolean containsKey(String type, String key) {
        boolean result = false;
        Properties property = (Properties)this.m_mergeProperties.get(type);
        if (property != null) {
            result = property.containsKey(key);
        }
        return result;
    }

    private String getProperty(String type, String key) {
        String value = null;
        Properties property = (Properties)this.m_mergeProperties.get(type);
        if (property != null) {
            value = property.getProperty(key);
        }
        return value;
    }

    private void mergePropertyValue(String key, String valueParam) {
        String value = valueParam;
        if (value == null) {
            return;
        }
        value = this._replaceAll(value, "\\=", "\\\\=");
        String[] result = this._split(value = this._replaceAll(value, "\\:", "\\\\:"), "\n");
        if (result.length == 1) {
            this.println(this.m_propWriter, 0, key + " = " + result[0]);
            return;
        }
        for (int i = 0; i < result.length; ++i) {
            if (i == result.length - 1) {
                this.println(this.m_propWriter, key.length() + 3, result[i]);
                continue;
            }
            if (i == 0) {
                this.println(this.m_propWriter, 0, key + " = " + result[i] + " \\n\\");
                continue;
            }
            this.println(this.m_propWriter, key.length() + 3, result[i] + " \\n\\");
        }
    }

    private void println(PrintWriter writer, int indent, String text) {
        for (int i = 0; i < indent; ++i) {
            writer.print(" ");
        }
        writer.println(text);
    }

    private boolean isMerged() {
        return this.m_merge && !this.m_mergeProperties.isEmpty();
    }

    private void cleanup() {
        if (!this.m_mergeProperties.isEmpty()) {
            this.m_mergeProperties.clear();
        }
        this.m_mergeProperties = null;
    }

    private void printUsage() {
        System.out.println("com.sonicsw.mf.gui.config.tools.GenerateBeanProperties");
        System.out.println("    [-url <DS URL>]                                (Default = localhost)");
        System.out.println("    [-user <DS user name>]                         (Default = Administrator)");
        System.out.println("    [-password <DS password>]                      (Default = Administrator)");
        System.out.println("    [-domain <DS domain>]                          (Default = Domain1)");
        System.out.println("    [-cVersion <config version>]                   (Default = 100)");
        System.out.println("    [-merge <merge keys if javadoc file exists>]   (Default = false");
        System.out.println("    [-tooltip, <generate key for tooltip>]         (Default = false)");
        System.out.println("    [-output <path to the javadoc file>]           (Default = None)");
        System.out.println("    [-type <config type name, or comma-separated types list>]  (Default = None)");
    }

    private String[] _split(String str, String regex) {
        StringTokenizer st = new StringTokenizer(str, regex);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    private String _replaceAll(String str, String regex, String replacement) {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        do {
            int newIndex;
            if ((newIndex = str.indexOf(regex, index)) == -1) {
                sb.append(str.substring(index));
                index = newIndex;
                continue;
            }
            sb.append(str.substring(index, newIndex));
            sb.append(replacement);
            index = newIndex + regex.length();
        } while (index != -1);
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            GenerateBeanProperties bean = new GenerateBeanProperties(args);
            bean.disconnect();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            while (e != null && e instanceof ConfigServiceException) {
                if ((e = ((ConfigServiceException)((Object)e)).getLinkedException()) == null) continue;
                System.out.println(e.getMessage());
            }
            System.exit(-1);
        }
        System.exit(0);
    }
}

