/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config;

import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.IConfigChangeFilter;
import com.sonicsw.mx.config.IConfigPath;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AttributeChangeFilter
implements IConfigChangeFilter {
    Set m_enabledAttributes = new HashSet();

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.m_enabledAttributes.equals(((AttributeChangeFilter)obj).m_enabledAttributes);
        }
        return false;
    }

    public int hashCode() {
        return this.m_enabledAttributes.hashCode();
    }

    public void disableAllAttributes() {
        this.m_enabledAttributes.clear();
    }

    public void enableAttribute(IConfigPath attribute) {
        this.m_enabledAttributes.add(attribute);
    }

    public void disableAttribute(IConfigPath attribute) {
        this.m_enabledAttributes.remove(attribute);
    }

    public Set getEnabledAttributes() {
        return this.m_enabledAttributes;
    }

    @Override
    public boolean isConfigChangeEnabled(ConfigChange configChange) {
        if (configChange.getChangeType() == 2) {
            return true;
        }
        if (configChange.getChangeType() == 1) {
            Iterator it = configChange.getDeletedAttributeNames().iterator();
            while (it.hasNext()) {
                if (!this.m_enabledAttributes.contains(it.next())) continue;
                return true;
            }
            it = configChange.getModifiedAttributeNames().iterator();
            while (it.hasNext()) {
                if (!this.m_enabledAttributes.contains(it.next())) continue;
                return true;
            }
        }
        return false;
    }
}

