/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.strm;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsAsyncWriteListener;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.util.BufferSizeManager;
import com.sonicsw.blackbird.evs.nio.nwlink.util.SelectableNetworkLinkResult;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;

public class EvsOutputStream
extends OutputStream
implements IEvsAsyncWriteListener {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PERFORMANCE = false;
    private static final boolean DEBUG_BYTES = false;
    private static final boolean DEBUG_UNEXPECTED = false;
    private final IEvsNetworkLink m_link;
    private final SelectableNetworkLinkResult m_netResult;
    private final boolean m_isBlocking;
    private final Selector m_selector;
    private final BufferSizeManager m_bufMan;
    private final int m_maxBufferSize;
    private final boolean m_buffered;
    private ByteBuffer m_outputBuffer = null;
    private int m_outDataPos = 0;
    private int m_writesOutstanding = 0;
    private final BufferHeap m_bufferHeap;
    private final boolean USE_SIMPLE_BUFFER;

    public EvsOutputStream(IEvsNetworkLink link, int maxBufferSize, int minBufferSize, int initialBufferSize) throws SocketException, IOException {
        this(null, null, link, maxBufferSize, minBufferSize, initialBufferSize);
    }

    private EvsOutputStream(EvsOutputStream parent, Selector selector, IEvsNetworkLink link, int maxBufferSize, int minBufferSize, int initialBufferSize) throws SocketException, IOException {
        this.m_link = link;
        this.m_netResult = parent != null ? parent.m_netResult : new SelectableNetworkLinkResult();
        this.m_isBlocking = this.m_link.isBlocking();
        this.m_selector = selector == null ? (!this.m_isBlocking ? Selector.open() : null) : selector;
        boolean bl = this.m_buffered = maxBufferSize > 0;
        if (this.m_buffered) {
            this.USE_SIMPLE_BUFFER = Boolean.valueOf(System.getProperty("USE_SIMPLE_OUTPUT_BUFFER", "false"));
            this.m_maxBufferSize = maxBufferSize;
            if (this.USE_SIMPLE_BUFFER) {
                this.m_bufMan = new BufferSizeManager(4096, 1.0E-5f, maxBufferSize, minBufferSize, initialBufferSize, 1);
                this.m_outputBuffer = ByteBuffer.allocateDirect(maxBufferSize);
                this.m_outputBuffer.position(this.m_link.getRequestedHeaderReserve());
                this.m_outDataPos = this.m_outputBuffer.position();
                this.m_outputBuffer.limit(this.m_outputBuffer.capacity() - this.m_link.getRequestedTrailerReserve());
                this.m_bufferHeap = null;
            } else {
                this.m_bufferHeap = new BufferHeap(maxBufferSize, minBufferSize, initialBufferSize, link.getNetworkLinkConfig().getSocketMaxSendBufferSize());
                this.m_bufMan = null;
            }
        } else {
            this.USE_SIMPLE_BUFFER = true;
            this.m_bufMan = null;
            this.m_maxBufferSize = 0;
            this.m_bufferHeap = null;
        }
    }

    public final EvsOutputStream createBufferedStream(int maxBufferSize, int minBufferSize, int initialBufferSize) throws IOException {
        if (this.m_buffered) {
            return this;
        }
        EvsOutputStream ret = new EvsOutputStream(this, this.m_selector, this.m_link, maxBufferSize, minBufferSize, initialBufferSize);
        return ret;
    }

    @Override
    public final void close() throws IOException {
        if (!this.m_isBlocking) {
            this.m_selector.close();
        }
    }

    @Override
    public final void onAsyncWriteComplete(ByteBuffer buffer) {
        if (buffer != null) {
            --this.m_writesOutstanding;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this.USE_SIMPLE_BUFFER) {
            if (!this.m_buffered) {
                return;
            }
            if (this.m_outputBuffer.position() <= this.m_outDataPos) {
                return;
            }
            try {
                this.m_outputBuffer.flip();
                this.m_outputBuffer.position(this.m_outDataPos);
                ++this.m_writesOutstanding;
                this.m_link.addWrite(this.m_outputBuffer, this);
                this.linkFlush();
            }
            catch (EEvsIOException eeioe) {
                Exception e = eeioe.getExtendedException();
                if (e != null && e instanceof IOException) {
                    throw (IOException)e;
                }
                IOException ioe = new IOException(eeioe.getMessage(), eeioe);
                throw ioe;
            }
            finally {
                this.m_outputBuffer.clear();
                this.m_outputBuffer.position(this.m_link.getRequestedHeaderReserve());
                this.m_outDataPos = this.m_outputBuffer.position();
                this.m_outputBuffer.limit(this.m_outputBuffer.capacity() - this.m_link.getRequestedTrailerReserve());
            }
        } else {
            this.m_bufferHeap.flush();
        }
    }

    @Override
    public final void write(int int0) throws IOException {
        if (this.USE_SIMPLE_BUFFER) {
            if (!this.m_buffered) {
                this.write(new byte[]{(byte)int0});
                return;
            }
            if (!this.m_outputBuffer.hasRemaining()) {
                this.flush();
            }
            this.m_outputBuffer.put((byte)int0);
        } else {
            this.m_bufferHeap.write(int0);
        }
    }

    @Override
    public final void write(byte[] byteArray) throws IOException {
        this.write(byteArray, 0, byteArray.length);
    }

    @Override
    public final void write(byte[] byteArray, int offset, int count) throws IOException {
        if (this.USE_SIMPLE_BUFFER) {
            if (!this.m_buffered || count >= this.m_outputBuffer.capacity()) {
                boolean preBuffered = this.m_buffered && this.m_outputBuffer.position() > this.m_outDataPos;
                try {
                    if (preBuffered) {
                        this.m_outputBuffer.flip();
                        this.m_outputBuffer.position(this.m_outDataPos);
                        ++this.m_writesOutstanding;
                        this.m_link.addWrite(this.m_outputBuffer, this);
                    }
                    this.m_link.addWrite(ByteBuffer.wrap(byteArray, offset, count), this);
                    ++this.m_writesOutstanding;
                    this.linkFlush();
                }
                catch (EEvsIOException eeioe) {
                    Exception e = eeioe.getExtendedException();
                    if (e != null && e instanceof IOException) {
                        throw (IOException)e;
                    }
                    IOException ioe = new IOException(eeioe.getMessage(), eeioe);
                    throw ioe;
                }
                finally {
                    if (preBuffered) {
                        this.m_outputBuffer.clear();
                        this.m_outputBuffer.position(this.m_link.getRequestedHeaderReserve());
                        this.m_outDataPos = this.m_outputBuffer.position();
                        this.m_outputBuffer.limit(this.m_outputBuffer.capacity() - this.m_link.getRequestedTrailerReserve());
                    }
                }
            } else {
                while (count > 0) {
                    if (!this.m_outputBuffer.hasRemaining()) {
                        this.flush();
                    }
                    int amountToWrite = this.m_outputBuffer.remaining() < count ? this.m_outputBuffer.remaining() : count;
                    this.m_outputBuffer.put(byteArray, offset, amountToWrite);
                    offset += amountToWrite;
                    count -= amountToWrite;
                }
            }
        } else {
            this.m_bufferHeap.write(byteArray, offset, count);
        }
    }

    private final void linkFlush() throws EEvsIOException, IOException {
        this.m_netResult.blockingOps = 0;
        this.m_link.write(this.m_netResult);
        while (this.m_writesOutstanding > 0) {
            if (!this.m_isBlocking && this.m_netResult.blockingOps != 0) {
                try {
                    this.m_netResult.select(this.m_selector, false);
                }
                catch (ClosedSelectorException cse) {
                    IOException ioe = new IOException(cse.getMessage(), cse);
                    throw ioe;
                }
            }
            this.m_link.write(this.m_netResult);
        }
    }

    private final void debug(String str) {
        System.out.println("EvsOutputStream" + this.hashCode() + ": " + str);
    }

    final class BufferHeap {
        final Heap m_heap;

        public BufferHeap(int maxBufferSize, int minBufferSize, int initialBufferSize, int socketMaxSendBufferSize) {
            this.m_heap = new Heap(maxBufferSize, minBufferSize, initialBufferSize, socketMaxSendBufferSize - 1);
            this.m_heap.setHeaderReserve(EvsOutputStream.this.m_link.getRequestedHeaderReserve());
            this.m_heap.setTrailerReserve(EvsOutputStream.this.m_link.getRequestedTrailerReserve());
        }

        final void write(byte[] byteArray, int offset, int count) throws IOException {
            while (count > 0) {
                this.ensureFreeSpace();
                int written = this.m_heap.write(byteArray, offset, count);
                if (count == written) {
                    return;
                }
                count -= written;
                offset += written;
            }
        }

        final void write(int int0) throws IOException {
            while (this.m_heap.write((byte)int0) == 0) {
                this.ensureFreeSpace();
            }
        }

        final void moveDataToLink() throws IOException {
            try {
                HeapBuffer buf = this.m_heap.takeBuffer();
                if (buf == null) {
                    return;
                }
                EvsOutputStream.this.m_link.addWrite(buf.heapView, buf);
            }
            catch (EEvsIOException eeioe) {
                Exception e = eeioe.getExtendedException();
                if (e != null && e instanceof IOException) {
                    throw (IOException)e;
                }
                IOException ioe = new IOException(eeioe.getMessage(), eeioe);
                throw ioe;
            }
            this.driveLink(false, false);
        }

        final void ensureFreeSpace() throws IOException {
            if (this.m_heap.hasSpace()) {
                return;
            }
            this.moveDataToLink();
            while (!this.m_heap.hasSpace()) {
                this.driveLink(true, true);
            }
        }

        final void flush() throws IOException {
            this.moveDataToLink();
            while (!this.driveLink(true, false)) {
            }
        }

        private final boolean driveLink(boolean block, boolean freeBuffers) throws IOException {
            if (!EvsOutputStream.this.m_isBlocking && ((EvsOutputStream)EvsOutputStream.this).m_netResult.blockingOps != 0) {
                int oldOps = ((EvsOutputStream)EvsOutputStream.this).m_netResult.blockingOps;
                try {
                    EvsOutputStream.this.m_netResult.select(EvsOutputStream.this.m_selector, !block);
                    if (!block && oldOps == ((EvsOutputStream)EvsOutputStream.this).m_netResult.blockingOps) {
                        return false;
                    }
                }
                catch (ClosedSelectorException cse) {
                    IOException ioe = new IOException(cse.getMessage(), cse);
                    throw ioe;
                }
            }
            try {
                ((EvsOutputStream)EvsOutputStream.this).m_netResult.freeBuf = freeBuffers;
                boolean success = EvsOutputStream.this.m_link.write(EvsOutputStream.this.m_netResult);
                this.m_heap.setHeaderReserve(EvsOutputStream.this.m_link.getRequestedHeaderReserve());
                this.m_heap.setTrailerReserve(EvsOutputStream.this.m_link.getRequestedTrailerReserve());
                return success;
            }
            catch (EEvsIOException eeioe) {
                Exception e = eeioe.getExtendedException();
                if (e != null && e instanceof IOException) {
                    throw (IOException)e;
                }
                IOException ioe = new IOException(eeioe.getMessage(), eeioe);
                throw ioe;
            }
        }
    }

    final class Heap {
        private ByteBuffer m_buf;
        private final int m_maxHeapSize;
        private final int m_maxBufferSize;
        private int m_takenBuffers = 0;
        private final BufferSizeManager m_bufMan;
        HeapBuffer m_head;
        HeapBuffer m_current;
        int m_headerReserve = 0;
        int m_trailerReserve = 0;
        boolean m_checkResize = false;
        boolean m_resizing = false;
        boolean m_prepared = false;

        Heap(int maxHeapSize, int minHeapSize, int initialHeapSize, int maxBufferSize) {
            this.m_maxHeapSize = maxHeapSize;
            this.m_maxBufferSize = Math.min(maxBufferSize, maxHeapSize);
            this.m_bufMan = new BufferSizeManager(8192, 0.001f, maxHeapSize, maxHeapSize, maxHeapSize, 2);
            this.allocateNewBuffer();
        }

        private final void allocateNewBuffer() {
            this.m_buf = null;
            this.m_current = null;
            this.m_head = null;
            this.m_buf = ByteBuffer.allocateDirect(this.m_bufMan.getBufferSize());
            this.m_head = this.m_current = new HeapBuffer(this, 0, this.m_buf.capacity());
        }

        final void setHeaderReserve(int reserve) {
            if (reserve > this.m_headerReserve && reserve + this.m_trailerReserve >= this.m_maxBufferSize) {
                throw new IllegalArgumentException("Header Reserve too large for heap buffer");
            }
            this.m_headerReserve = reserve;
        }

        final void setTrailerReserve(int reserve) {
            if (reserve > this.m_trailerReserve && reserve + this.m_headerReserve >= this.m_maxBufferSize) {
                throw new IllegalArgumentException("Trailer reserve too large for heap buffer");
            }
            this.m_trailerReserve = reserve;
        }

        final int write(byte[] data, int offset, int count) {
            int available = this.spaceAvailable();
            if (available < count) {
                this.m_buf.put(data, offset, available);
                return available;
            }
            this.m_buf.put(data, offset, count);
            return count;
        }

        final int write(byte b) {
            if (this.spaceAvailable() == 0) {
                return 0;
            }
            this.m_buf.put(b);
            return 1;
        }

        private final int spaceAvailable() {
            if (!this.m_prepared) {
                if (this.m_buf.capacity() - this.m_current.heapPos <= this.m_headerReserve + this.m_trailerReserve) {
                    if (this.m_current == this.m_head) {
                        throw new IllegalArgumentException("Requested reserve size too large!");
                    }
                    this.m_current = this.m_head;
                }
                if (this.m_checkResize && this.m_current == this.m_head) {
                    if (this.m_head.free) {
                        this.m_bufMan.updateDataSize(this.m_buf.capacity() - this.m_head.size);
                    } else {
                        this.m_bufMan.updateDataSize(this.m_buf.capacity());
                    }
                    if (this.m_bufMan.getBufferSize() != this.m_buf.capacity()) {
                        this.m_resizing = true;
                    }
                    this.m_checkResize = false;
                }
                if (this.m_resizing) {
                    if (this.m_takenBuffers > 0) {
                        return 0;
                    }
                    this.allocateNewBuffer();
                    this.m_resizing = false;
                }
                if (!this.m_current.free || this.m_current.size <= this.m_headerReserve + this.m_trailerReserve) {
                    return 0;
                }
                this.m_current.headerReserve = this.m_headerReserve;
                this.m_current.trailerReserve = this.m_trailerReserve;
                this.m_buf.limit(this.m_current.heapPos + Math.min(this.m_current.size, this.m_maxBufferSize) - this.m_trailerReserve);
                this.m_buf.position(this.m_current.heapPos + this.m_headerReserve);
                this.m_current.limit = Math.min(this.m_current.heapPos + this.m_maxBufferSize, this.m_buf.capacity()) - this.m_trailerReserve;
                this.m_prepared = true;
                this.m_checkResize = true;
            }
            this.m_buf.limit(this.m_current.heapPos + Math.min(this.m_current.size, this.m_maxBufferSize) - this.m_trailerReserve);
            return this.m_buf.remaining();
        }

        final HeapBuffer takeBuffer() {
            if (!this.hasData()) {
                return null;
            }
            int limit = this.m_buf.position() + this.m_current.trailerReserve;
            this.m_buf.position(this.m_current.heapPos);
            this.m_buf.limit(limit);
            this.m_current.heapView = this.m_buf.slice();
            this.m_current.heapView.position(this.m_current.headerReserve);
            this.m_current.heapView.limit(this.m_current.heapView.capacity() - this.m_current.trailerReserve);
            int newSize = this.m_current.heapView.capacity();
            int leftover = this.m_current.size - newSize;
            this.m_current.size = newSize;
            HeapBuffer ret = this.m_current;
            ret.free = false;
            ++this.m_takenBuffers;
            this.m_prepared = false;
            if (leftover > 0) {
                if (ret.next != null && ret.next.free) {
                    ret.next.heapPos -= leftover;
                    ret.next.size += leftover;
                } else {
                    HeapBuffer hb = new HeapBuffer(this, limit, leftover);
                    hb.next = ret.next;
                    hb.prev = ret;
                    ret.next = hb;
                    if (hb.next != null) {
                        hb.next.prev = hb;
                    }
                }
            }
            this.m_current = ret.next == null ? this.m_head : ret.next;
            return ret;
        }

        final void returnBuffer(HeapBuffer b) {
            --this.m_takenBuffers;
            if (b.prev != null && b.prev.free) {
                b.prev.next = b.next;
                if (b.next != null) {
                    b.next.prev = b.prev;
                }
                b.prev.size += b.size;
                b.prev = null;
                b.next = null;
            } else {
                b.heapView = null;
                b.free = true;
            }
        }

        final boolean hasSpace() {
            return this.spaceAvailable() > 0;
        }

        final boolean hasData() {
            return this.m_prepared && this.m_buf.position() > this.m_current.heapPos + this.m_current.headerReserve;
        }

        public String toString() {
            String str = "Heap: " + this.m_buf + "; Buffers: ";
            HeapBuffer b = this.m_head;
            while (b != null) {
                str = b == this.m_current ? str + "->" + b + "<-" : str + b;
                b = b.next;
            }
            return str;
        }
    }

    final class HeapBuffer
    implements IEvsAsyncWriteListener {
        HeapBuffer next;
        HeapBuffer prev;
        boolean free = true;
        int heapPos;
        int size;
        int headerReserve;
        int trailerReserve;
        int limit;
        ByteBuffer heapView;
        private final Heap m_heap;
        final boolean m_external;

        public HeapBuffer(Heap heap, int heapPos, int size) {
            this.m_external = false;
            this.m_heap = heap;
            this.heapPos = heapPos;
            this.size = size;
        }

        @Override
        public final void onAsyncWriteComplete(ByteBuffer buffer) {
            this.m_heap.returnBuffer(this);
        }

        public String toString() {
            return "HeapBuffer{free= " + this.free + ",size=" + this.size + ",hdr=" + this.headerReserve + ",trlr=" + this.trailerReserve + ",start=" + this.heapPos + ",end=" + (this.heapPos + this.size) + "}";
        }
    }
}

