/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.util;

import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

public class SelectableNetworkLinkResult
extends EvsNetworkLinkResult {
    private SelectionKey m_key = null;

    public final void select(Selector selector, boolean selectNow) throws IOException, ClosedSelectorException {
        if (this.blockingOps != 0) {
            SelectionKey key = null;
            try {
                key = this.channel.register(selector, this.blockingOps);
            }
            catch (ClosedChannelException cce) {
                this.blockingOps = 0;
                return;
            }
            catch (NullPointerException npe) {
                if (!selector.isOpen()) {
                    ClosedSelectorException cse = new ClosedSelectorException();
                    cse.initCause(npe);
                    throw cse;
                }
                this.blockingOps = 0;
                return;
            }
            catch (CancelledKeyException cke) {
                this.blockingOps = 0;
                return;
            }
            if (this.m_key == null) {
                this.m_key = key;
            } else if (this.m_key != key) {
                this.m_key.cancel();
                this.m_key = key;
            }
            if (selectNow) {
                selector.selectNow();
            } else {
                selector.select(this.maxMsBeforeRetry);
            }
            selector.selectedKeys().clear();
            try {
                this.blockingOps &= ~this.m_key.readyOps();
            }
            catch (CancelledKeyException cke) {
                this.blockingOps = 0;
            }
        }
    }
}

