/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;

public class WakeupPipe {
    private final boolean DEBUG = false;
    private final boolean DEBUG_UNEXPECTED = true;
    private boolean m_awake = false;
    private final ByteBuffer m_wakeupBuf = ByteBuffer.allocateDirect(1);
    private final Pipe m_pipe = Pipe.open();

    public WakeupPipe() throws IOException {
        this.m_pipe.source().configureBlocking(false);
    }

    public final SelectableChannel getWakeupChannel() {
        return this.m_pipe.source();
    }

    public final void clearWakeup() throws IOException {
        if (this.m_awake) {
            this.m_wakeupBuf.clear();
            while (this.m_wakeupBuf.hasRemaining()) {
                try {
                    this.m_pipe.source().read(this.m_wakeupBuf);
                }
                catch (IOException ex) {
                    WakeupPipe.debug("Error clearing wakeup: ", ex);
                    this.close();
                    throw ex;
                }
            }
            this.m_awake = false;
        }
    }

    public final void wakeup() throws IOException {
        if (this.m_awake) {
            return;
        }
        this.m_wakeupBuf.clear();
        this.m_pipe.sink().write(this.m_wakeupBuf);
        if (this.m_wakeupBuf.hasRemaining()) {
            throw new RuntimeException("Unable to add wakeup data");
        }
        this.m_awake = true;
    }

    public final void close() throws IOException {
        try {
            this.m_pipe.source().close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            this.m_pipe.sink().close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected static final void debug(String str, Throwable thrown) {
        if (thrown != null) {
            System.out.println("Wakeup Pipe: " + str + " Related Exception: " + thrown.getMessage());
            thrown.printStackTrace();
        } else {
            System.out.println("Wakeup Pipe: " + str);
        }
    }

    public final String toString() {
        return "WakeupPipe, awake: " + this.m_awake;
    }

    protected static final void debug(String str) {
        WakeupPipe.debug(str, null);
    }
}

