/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.sys;

import com.sonicsw.blackbird.sys.SysConfig;
import java.io.PrintStream;
import java.util.Properties;

public final class SysTrace {
    private volatile int level;
    private volatile String prefix;
    private PrintStream logger;

    private SysTrace(int level) {
        this.level = level;
        this.logger = System.out;
        this.prefix = "...";
    }

    public static SysTrace create(int level) {
        return new SysTrace(level);
    }

    public static SysTrace create(Properties props, String propName) {
        return new SysTrace(SysTrace.getLevelFromProperty(props, propName));
    }

    public static int getLevelFromProperty(Properties props, String propName) {
        String levelStr = SysConfig.getConfigValue(props, propName);
        int level = 2;
        if (levelStr != null) {
            switch (new Integer(levelStr)) {
                case 1: {
                    level = 1;
                    break;
                }
                case 2: {
                    level = 2;
                    break;
                }
                case 3: {
                    level = 3;
                    break;
                }
                case 9: {
                    level = 9;
                }
            }
        }
        return level;
    }

    public final void updateLevel(int level) {
        if (level < 0 || level > 9) {
            throw new IllegalArgumentException("Invalid trace level");
        }
        this.level = level;
    }

    public final void updateLevelFromProperty(Properties props, String propName) {
        if (SysConfig.getConfigValue(props, propName) != null) {
            this.updateLevel(SysTrace.getLevelFromProperty(props, propName));
        }
    }

    public final void updatePrefix(String prefix) {
        this.prefix = prefix;
    }

    public final void out(String s, int level) {
        if (level <= this.level) {
            String levelStr = level == -1 ? "always" : (level == 1 ? "error" : (level == 2 ? "warn" : (level == 3 ? "info" : (level == 9 ? "debug" : "unkwn"))));
            this.logger.print(System.currentTimeMillis() + ":" + Thread.currentThread().getName() + "[" + this.prefix + "] " + "(" + levelStr + ") " + s);
        }
    }

    public final void out(String s) {
        this.out(s, 3);
    }

    public final void outln(String s, int level) {
        this.out(s + "\n", level);
    }

    public void outln(String s) {
        this.outln(s, 3);
    }

    public final void debug(String s) {
        this.out(s, 9);
    }

    public final void debugln(String s) {
        this.outln(s, 9);
    }
}

