/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.api;

import com.sonicsw.ws.rm.api.ReliableSequenceEncodeHelperForJMS;
import com.sonicsw.ws.rm.api.ReliableSequenceInteractorConfiguration;
import com.sonicsw.ws.rm.api.ReliableSequenceInteractorException;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import progress.message.jclient.Session;
import progress.message.jclient.XMLMessage;
import progress.message.jimpl.Queue;

public class ReliableSequenceInteractorForJMS {
    private String m_httpRoutingQ = "sonic.http";
    private ReliableSequenceInteractorConfiguration m_config = null;

    public ReliableSequenceInteractorForJMS(ReliableSequenceInteractorConfiguration config) throws ReliableSequenceInteractorException, JMSException {
        this.m_config = config;
        if (this.m_config == null) {
            throw new ReliableSequenceInteractorException("Configuration may not be null.");
        }
        this.m_config.validate();
    }

    public String performCreateReliableSequenceInteraction() throws ReliableSequenceInteractorException, JMSException {
        String id = null;
        ReliableSequenceInteractorException rsie = null;
        Message response = null;
        Message jmsMessage = this.createSenderMessage();
        if (this.m_config.getReliableMessagingVersion().equalsIgnoreCase("WSRMVersionMAR2004")) {
            ReliableSequenceEncodeHelperForJMS.encodeCreateSequenceRequest(jmsMessage, this.m_config.getEndpointURL(), this.m_config.getSOAPVersion(), this.m_config.getReliableMessagingVersion());
        } else {
            ReliableSequenceEncodeHelperForJMS.encodeCreateSequenceRequest(jmsMessage, this.m_config.getEndpointURL(), this.m_config.getSequenceExpires(), this.m_config.getOfferedReturnSequenceExpires(), this.m_config.getOfferedReturnSequenceIdentifier(), this.m_config.getSOAPVersion());
        }
        QueueSender qs = this.m_config.getSender();
        QueueReceiver qr = this.m_config.getReceiver();
        jmsMessage.setJMSReplyTo(qr.getQueue());
        jmsMessage.setBooleanProperty("X-HTTP-ReplyAsSOAP", true);
        if (this.m_config.getSequenceFaultDestination() != null) {
            jmsMessage.setStringProperty("X-WS-SequenceFaultDestination", "$Q." + this.m_config.getSequenceFaultDestination().getQueueName());
        }
        jmsMessage.setStringProperty("X-WS-MessagePolicy", this.m_config.getPolicy());
        if (this.m_config.getTransportAcceptor() != null) {
            jmsMessage.setStringProperty("X-WS-TransportAcceptor", this.m_config.getTransportAcceptor());
        }
        this.applyProperties(jmsMessage);
        for (int i = 0; i < this.m_config.getRetries() + 1; ++i) {
            if (qs.getQueue() == null) {
                qs.send(new Queue(this.m_httpRoutingQ + "::" + this.m_config.getEndpointURL()), jmsMessage, qs.getDeliveryMode(), qs.getPriority(), qs.getTimeToLive());
            } else {
                jmsMessage.setStringProperty("X-HTTP-DestinationURL", this.m_config.getEndpointURL());
                qs.send(jmsMessage, qs.getDeliveryMode(), qs.getPriority(), qs.getTimeToLive());
            }
            response = qr.receive(this.m_config.getReplyTimeout());
            if (response != null) {
                try {
                    id = ReliableSequenceEncodeHelperForJMS.decodeCreateSequenceResponse(response);
                    rsie = null;
                    break;
                }
                catch (ReliableSequenceInteractorException e) {
                    rsie = e;
                }
            }
            if (i >= this.m_config.getRetries() || this.m_config.getRetryInterval() == 0L) continue;
            try {
                Thread.sleep(this.m_config.getRetryInterval());
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (rsie != null) {
            throw rsie;
        }
        if (response == null) {
            throw new ReliableSequenceInteractorException("Did not receive reply to create sequence.");
        }
        return id;
    }

    public void performTerminateReliableSequenceInteraction(String id) throws ReliableSequenceInteractorException, JMSException {
        Object response = null;
        QueueSender qs = this.m_config.getSender();
        QueueReceiver qr = this.m_config.getReceiver();
        Message jmsMessage = this.createSenderMessage();
        ReliableSequenceEncodeHelperForJMS.encodeTerminateSequenceRequest(jmsMessage, id, this.m_config.getEndpointURL(), this.m_config.getSOAPVersion(), this.m_config.getReliableMessagingVersion());
        jmsMessage.setJMSReplyTo(qr.getQueue());
        jmsMessage.setBooleanProperty("X-HTTP-ReplyAsSOAP", true);
        jmsMessage.setStringProperty("X-WS-MessagePolicy", this.m_config.getPolicy());
        jmsMessage.setStringProperty("Content-Type", "text/xml");
        this.applyProperties(jmsMessage);
        if (qs.getQueue() == null) {
            qs.send(new Queue(this.m_httpRoutingQ + "::" + this.m_config.getEndpointURL()), jmsMessage, qs.getDeliveryMode(), qs.getPriority(), qs.getTimeToLive());
        } else {
            jmsMessage.setStringProperty("X-HTTP-DestinationURL", this.m_config.getEndpointURL());
            qs.send(jmsMessage, qs.getDeliveryMode(), qs.getPriority(), qs.getTimeToLive());
        }
    }

    public void sendLast(String id, int nr) throws ReliableSequenceInteractorException, JMSException {
        QueueSender qs = this.m_config.getSender();
        XMLMessage jmsMessage = ((Session)this.m_config.getSenderSession()).createXMLMessage();
        ReliableSequenceEncodeHelperForJMS.encodeEmptyBody(jmsMessage, this.m_config.getSOAPVersion(), this.m_config.getReliableMessagingVersion());
        jmsMessage.setStringProperty("X-HTTP-DestinationURL", this.m_config.getEndpointURL());
        jmsMessage.setBooleanProperty("X-HTTP-ReplyAsSOAP", true);
        jmsMessage.setStringProperty("X-WS-MessagePolicy", this.m_config.getPolicy());
        if (this.m_config.getReliableMessagingVersion().equalsIgnoreCase("WSRMVersionFEB2005")) {
            jmsMessage.setStringProperty("SOAPAction", "http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
        }
        this.applyProperties(jmsMessage);
        jmsMessage.setObjectProperty("JMSXGroupID", id);
        jmsMessage.setObjectProperty("JMSXGroupSeq", new Integer(nr));
        jmsMessage.setObjectProperty("JMS_SonicMQ_lastMessageInGroup", new Boolean(true));
        if (qs.getQueue() == null) {
            qs.send(new Queue(this.m_httpRoutingQ + "::" + this.m_config.getEndpointURL()), (Message)jmsMessage, qs.getDeliveryMode(), qs.getPriority(), qs.getTimeToLive());
        } else {
            qs.send(jmsMessage, qs.getDeliveryMode(), qs.getPriority(), qs.getTimeToLive());
        }
    }

    protected void applyProperties(Message m) {
        try {
            Properties p = this.m_config.getProperties();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String nm = (String)e.nextElement();
                m.setObjectProperty(nm, p.get(nm));
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private Message createSenderMessage() throws JMSException {
        if (!this.m_config.getUseBytesMessage()) {
            return ((Session)this.m_config.getSenderSession()).createXMLMessage();
        }
        return this.m_config.getSenderSession().createBytesMessage();
    }
}

