/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IAckHandle;
import progress.message.msg.IAckListHandle;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IBrokerHandle;
import progress.message.msg.IConnectionSyncHandle;
import progress.message.msg.IErrorHandle;
import progress.message.msg.IExtendedTXNRequestHandle;
import progress.message.msg.IFailoverStatusNotificationHandle;
import progress.message.msg.IFlowControlHandle;
import progress.message.msg.IIDRHandle;
import progress.message.msg.IJMSClientHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.IOperationHandle;
import progress.message.msg.IPTPFlowControlHandle;
import progress.message.msg.IQueueFlowControlHandle;
import progress.message.msg.IReplicatedMgramHandle;
import progress.message.msg.IRoutingHandle;
import progress.message.msg.ISaverOpHandle;
import progress.message.msg.IStateEventHandle;
import progress.message.msg.ITXNRequestHandle;
import progress.message.msg.IWindowAckHandle;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.AckListPayload;
import progress.message.msg.v26.AckPayload;
import progress.message.msg.v26.BatchPayload;
import progress.message.msg.v26.DefaultDynamicHeader;
import progress.message.msg.v26.DefaultPayload;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.MgramCreator;
import progress.message.msg.v26.Payload;
import progress.message.msg.v26.SecureDynamicHeader;
import progress.message.msg.v26.SidebandData;
import progress.message.msg.v26.StaticHeader;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.IndexedList;
import progress.message.util.LongHashTable;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Connection;
import progress.message.zclient.CryptoInfoLinkedList;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.RejectionTracker;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.prAccessor;
import progress.message.zclient.xonce.MgramTrace;

public final class Mgram
implements Cloneable,
IMgram,
IMgramConverterHandle,
IBrokerHandle,
IJMSClientHandle {
    private static final boolean DEBUG_TRACE_DATA = false;
    static final int PROTECTED_HEADER_LEN = 8;
    public static final int RRS_SEND = 0;
    public static final int RRS_REQUEST = 2;
    public static final int RRS_REPLY = 3;
    static final int UNINITIALIZED_STATUS = 0;
    static final int STATIC_HEADER_INITIALIZED = 1;
    static final int DYNAMIC_HEADER_INITIALIZED = 2;
    static final int PAYLOAD_INITIALIZED = 3;
    static final int ID_LEN = 16;
    private int m_status = 0;
    private IMgramStatusListener m_listener = null;
    private byte[] m_staticHeader = null;
    private DynamicHeader m_dynamicHeader = null;
    private byte[] m_dynamicHeaderCache = null;
    private Payload m_payload = null;
    private byte[] m_payloadCache = null;
    private int m_dynamicHeaderMemLen = -1;
    private int m_payloadMemLen = -1;
    private boolean m_staticHeaderProtected = false;
    private long m_senderID = -1L;
    private long m_sequenceNumber;
    private volatile Object m_logEvent;
    private volatile boolean m_fromDb;
    private boolean m_ack_noreply;
    private int m_txnpublish_tid;
    private int m_txnpublish_tidseq;
    private boolean m_txnPublishFromLog;
    private boolean m_batchedPublished = false;
    private long m_batchId = -1L;
    private boolean m_dbSaveRequested;
    private boolean m_dbSaved;
    private IndexedList m_msgHeadersSaved = null;
    private byte m_sessionVer = (byte)32;
    private boolean m_isTTE_TTL = false;
    private long m_tte = 0L;
    private IMgram m_nextInTxn;
    private boolean m_enqueuedSizeSet = false;
    private int m_enqueuedSize;
    public static final byte CURR_VERSION = 26;
    static final int s_mgramMemSize = MemoryUtil.estimateBaseSize(Mgram.class);
    private String m_localQName;
    private boolean m_targeted = false;
    private boolean m_fromRemoteBroker = false;
    private long m_redirectAckTarget = -1L;
    private boolean m_pushBackAck = false;
    private LongHashTable m_proxyRecipsTable;
    private boolean m_isJMSAsynchronous = false;
    private boolean m_isPerMsgEncrypted = false;
    private Connection m_zConnection = null;
    private boolean m_trackedSizeSet = false;
    private int m_trackedSize;
    private boolean m_dbTrackingSet = false;
    private long m_dbTracking;
    private boolean m_guarFormatIncorrect = false;
    private int m_limiterSize = -1;
    private int m_limiterSizeIncrement = 0;
    private boolean m_noOutqueueExpire = false;
    private LongHashTable m_subjectFilters;
    private transient long m_groupccid = -1L;
    private boolean m_wasRejectable = false;
    private RejectionTracker m_rejectionTracker;
    private long m_ptpEnqTm;
    private byte m_reenqueues = 0;
    private boolean m_deliveryCancelled = false;

    public Mgram(boolean initialize) {
        this.m_listener = null;
        if (initialize) {
            this.m_staticHeader = StaticHeader.getDefaultByteArray();
            this.m_dynamicHeader = new DefaultDynamicHeader(this);
            this.m_payload = new DefaultPayload(this);
        }
        this.setStatus(3);
    }

    void setStatusListener(IMgramStatusListener listener) {
        this.m_listener = listener;
    }

    public void setStaticHeader(byte[] sh) {
        this.m_staticHeader = sh;
        this.m_staticHeaderProtected = false;
    }

    public void setDynamicHeader(DynamicHeader dh) {
        this.m_dynamicHeader = dh;
        this.m_dynamicHeaderCache = null;
    }

    public void setPayload(Payload p) {
        this.m_payload = p;
        this.m_payloadCache = null;
    }

    Mgram(byte[] value) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.m_listener = null;
        this.initMgramFromStream(new ByteArrayInputStream(value));
    }

    Mgram(Mgram m) {
        this.m_status = m.m_status;
        this.m_listener = m.m_listener;
        this.m_staticHeader = m.m_staticHeader;
        this.m_dynamicHeader = m.m_dynamicHeader;
        this.m_dynamicHeaderCache = m.m_dynamicHeaderCache;
        this.m_payload = m.m_payload;
        this.m_payloadCache = m.m_payloadCache;
        this.m_dynamicHeaderMemLen = m.m_dynamicHeaderMemLen;
        this.m_payloadMemLen = m.m_payloadMemLen;
        this.m_staticHeaderProtected = m.m_staticHeaderProtected;
        this.m_senderID = m.m_senderID;
        this.m_sequenceNumber = m.m_sequenceNumber;
        this.m_logEvent = m.m_logEvent;
        this.m_fromDb = m.m_fromDb;
        this.m_ack_noreply = m.m_ack_noreply;
        this.m_txnpublish_tid = m.m_txnpublish_tid;
        this.m_txnpublish_tidseq = m.m_txnpublish_tidseq;
        this.m_txnPublishFromLog = m.m_txnPublishFromLog;
        this.m_batchedPublished = m.m_batchedPublished;
        this.m_dbSaveRequested = m.m_dbSaveRequested;
        this.m_dbSaved = m.m_dbSaved;
        this.m_sessionVer = m.m_sessionVer;
        this.m_isTTE_TTL = m.m_isTTE_TTL;
        this.m_tte = m.m_tte;
        this.m_nextInTxn = m.m_nextInTxn;
        this.m_enqueuedSizeSet = m.m_enqueuedSizeSet;
        this.m_enqueuedSize = m.m_enqueuedSize;
        this.m_limiterSizeIncrement = m.m_limiterSizeIncrement;
        this.m_localQName = m.m_localQName;
        this.m_targeted = m.m_targeted;
        this.m_fromRemoteBroker = m.m_fromRemoteBroker;
        this.m_redirectAckTarget = m.m_redirectAckTarget;
        this.m_pushBackAck = m.m_pushBackAck;
        this.m_proxyRecipsTable = m.m_proxyRecipsTable;
        this.m_isJMSAsynchronous = m.m_isJMSAsynchronous;
        this.m_isPerMsgEncrypted = m.m_isPerMsgEncrypted;
        this.m_zConnection = m.m_zConnection;
        this.m_batchedPublished = m.m_batchedPublished;
        this.m_batchId = m.m_batchId;
        this.m_trackedSize = m.m_trackedSize;
        this.m_trackedSizeSet = m.m_trackedSizeSet;
        this.m_dbTrackingSet = m.m_dbTrackingSet;
        this.m_dbTracking = m.m_dbTracking;
        this.m_msgHeadersSaved = m.m_msgHeadersSaved;
        this.m_guarFormatIncorrect = m.m_guarFormatIncorrect;
        this.m_subjectFilters = m.m_subjectFilters;
        this.m_noOutqueueExpire = m.m_noOutqueueExpire;
        this.m_wasRejectable = m.m_wasRejectable;
        this.m_rejectionTracker = m.m_rejectionTracker;
        this.m_groupccid = m.m_groupccid;
        this.m_reenqueues = m.m_reenqueues;
    }

    public Object unprotectedClone() throws CloneNotSupportedException {
        Mgram m = new Mgram(this);
        if (this.m_dynamicHeader != null) {
            m.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(m);
        }
        if (this.m_payload != null) {
            m.m_payload = (Payload)this.m_payload.clone(m);
        }
        if (this.m_staticHeader != null) {
            m.m_staticHeader = new byte[this.m_staticHeader.length];
            System.arraycopy(this.m_staticHeader, 0, m.m_staticHeader, 0, this.m_staticHeader.length);
        }
        if (this.m_dynamicHeaderCache != null) {
            m.m_dynamicHeaderCache = new byte[this.m_dynamicHeaderCache.length];
            System.arraycopy(this.m_dynamicHeaderCache, 0, m.m_dynamicHeaderCache, 0, this.m_dynamicHeaderCache.length);
        }
        if (this.m_payloadCache != null) {
            m.m_payloadCache = new byte[this.m_payloadCache.length];
            System.arraycopy(this.m_payloadCache, 0, m.m_payloadCache, 0, this.m_payloadCache.length);
        }
        m.m_staticHeaderProtected = false;
        return m;
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        return this.unprotectedClone();
    }

    @Override
    public synchronized Object shallowClone() throws CloneNotSupportedException {
        Mgram m = new Mgram(this);
        if (this.m_dynamicHeader != null) {
            m.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.shallowClone(m);
        }
        if (this.m_payload != null) {
            m.m_payload = (Payload)this.m_payload.shallowClone(m);
        }
        return m;
    }

    @Override
    public synchronized Object protectedClone() throws CloneNotSupportedException {
        Mgram m = new Mgram(this);
        m.m_staticHeaderProtected = true;
        if (this.m_dynamicHeader != null) {
            m.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.protectedClone(m);
        }
        if (this.m_payload != null) {
            m.m_payload = (Payload)this.m_payload.protectedClone(m);
        }
        this.protect();
        return m;
    }

    @Override
    public synchronized void protect() {
        this.m_staticHeaderProtected = true;
        if (this.m_dynamicHeader != null) {
            this.m_dynamicHeader.protect();
        }
        if (this.m_payload != null) {
            this.m_payload.protect();
        }
    }

    private void unprotectStaticHeader() {
        if (this.m_staticHeaderProtected) {
            if (this.m_staticHeader != null) {
                byte[] staticHeader = new byte[this.m_staticHeader.length];
                System.arraycopy(this.m_staticHeader, 0, staticHeader, 0, this.m_staticHeader.length);
                this.m_staticHeader = staticHeader;
            }
            this.m_staticHeaderProtected = false;
        }
    }

    @Override
    public synchronized void unprotectSuccessor() {
        this.unprotectStaticHeader();
    }

    @Override
    public final void initMgramFromStream(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.initMgramFromStream((byte)-1, is, null, null, null, false, null);
    }

    @Override
    public void initMgramFromStream(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert, StreamUtilCounter sc) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.initMgramFromStream((byte)-1, is, sis, mp, csc, tteTTLConvert, sc);
    }

    public final void initMgramFromStream(byte version, InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert, StreamUtilCounter sc) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        try {
            if (sc != null) {
                sc.resetCounter();
            }
            this.initStaticHeaderFromStream(version, is, this.m_listener, tteTTLConvert);
            this.m_wasRejectable = StaticHeader.isRejectable(this.m_staticHeader);
            if (this.m_wasRejectable) {
                StaticHeader.setRejectable(false, this.m_staticHeader);
            }
            if (this.getType() == 4) {
                return;
            }
            this.initRemainingMgram(is, sis, mp, csc, sc);
        }
        catch (EIntegrityCompromised eic) {
            try {
                EIntegrityCompromised eic2 = new EIntegrityCompromised(MgramTrace.diagnosticString("eic: " + eic.getMessage(), null, this));
                eic2.initCause(eic);
                eic = eic2;
            }
            catch (Throwable thrown) {
                SessionConfig.logMessage("Error getting mgram trace: " + thrown.getMessage(), thrown, SessionConfig.SEVERE);
                this.dump();
            }
            throw eic;
        }
    }

    private void initRemainingMgram(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, StreamUtilCounter sc) throws EMgramVersionMismatch, EMgramFormatError, IOException {
        boolean isSecure = StaticHeader.isSecure(this.m_staticHeader);
        this.m_dynamicHeader = Mgram.initDynamicHeaderFromStream(is, isSecure, mp, this, csc);
        this.m_payload = Mgram.initPayloadFromStream(is, sis, mp, csc, this.m_staticHeader, this.m_dynamicHeader, this, sc);
    }

    private void initRemainingMgramNonSecure(InputStream is, StreamUtilCounter sc) throws EMgramVersionMismatch, EMgramFormatError, IOException {
        boolean isSecure = StaticHeader.isSecure(this.m_staticHeader);
        this.m_dynamicHeader = Mgram.initDynamicHeaderFromStream(is, isSecure, null, this, null);
        this.m_payload = Mgram.initPayloadFromStream(is, null, null, null, this.m_staticHeader, this.m_dynamicHeader, this, sc);
    }

    private void initStaticHeaderFromStream(byte version, InputStream is, IMgramStatusListener ml, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch {
        int offset = 0;
        this.m_staticHeader = new byte[20];
        if (version == -1) {
            if (ml != null) {
                ml.setStatus((byte)0);
            }
            StreamUtil.readBytes(is, this.m_staticHeader, offset, 1);
        }
        ++offset;
        if (ml != null) {
            ml.setStatus((byte)1);
        }
        StreamUtil.readBytes(is, this.m_staticHeader, offset, 20 - offset);
        if (version != -1) {
            StaticHeader.setVersion(version, this.m_staticHeader);
        }
        if (StaticHeader.getType(this.m_staticHeader) != 4 && StaticHeader.getVersion(this.m_staticHeader) != 26) {
            throw new EMgramVersionMismatch(StaticHeader.getVersion(this.m_staticHeader), this.m_staticHeader);
        }
        if (StaticHeader.getType(this.m_staticHeader) == 4) {
            if (StaticHeader.hasSessionVer(this.m_staticHeader)) {
                this.m_sessionVer = StreamUtil.readByte(is);
            }
            return;
        }
        if (StaticHeader.hasTTE(this.m_staticHeader) && tteTTLConvert) {
            long ttl = StaticHeader.getTTE(this.m_staticHeader);
            StaticHeader.setTTE(ttl += System.currentTimeMillis(), this.m_staticHeader);
            this.m_isTTE_TTL = false;
        }
    }

    public static DynamicHeader initDynamicHeaderFromStream(InputStream is, boolean isSecure, IMessageProtection mp, Mgram m, ClientSecurityContext csc) throws IOException, EMgramVersionMismatch {
        DynamicHeader result = null;
        if (isSecure) {
            result = new SecureDynamicHeader(m, mp);
            result.initDynamicHeaderFromStream(is, mp, csc);
        } else {
            result = new DefaultDynamicHeader(m);
            result.initDynamicHeaderFromStream(is, mp, csc);
        }
        return result;
    }

    private Payload getPayloadObject(byte type) {
        return MgramCreator.getPayloadObject(type, this);
    }

    public static Payload initPayloadFromStream(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, byte[] staticHeader, DynamicHeader dh, Mgram m, StreamUtilCounter sc) throws EMgramFormatError, IOException {
        Payload result = MgramCreator.getPayloadObject(StaticHeader.getType(staticHeader), m);
        result.readPreSecureData(is);
        if (StaticHeader.isSecure(staticHeader) && sis != null && mp != null && csc != null) {
            Mgram.decryptSecurePayload(is, dh, result, sis, mp, csc, sc);
            Mgram.verifyMacs(mp, csc, staticHeader, dh, result);
        } else {
            result.initPayloadFromStream(is, sc);
        }
        return result;
    }

    private static Payload decryptSecurePayload(InputStream is, DynamicHeader dh, Payload p, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, StreamUtilCounter sc) throws ESecurityGeneralException, IOException, EMgramFormatError {
        byte security = dh.getSecurity();
        if (SecurityLogic.isMKeyDigest(security) || SecurityLogic.isMKeyMacHeader(security)) {
            int mKeyLen = mp.getSecretKeyLength();
            byte[] mKey = new byte[mKeyLen];
            byte[] encryptedMKey = dh.getMessageKey();
            mp.decryptWithSessionKey(encryptedMKey, 0, encryptedMKey.length, mKey, 0);
            dh.setMessageKey(mKey);
            if (SecurityLogic.isMKeyEncryption(security)) {
                int keyLen = dh.getMessageKey().length;
                byte[] copyKey = new byte[keyLen];
                System.arraycopy(dh.getMessageKey(), 0, copyKey, 0, keyLen);
                sis.setMessageKey(copyKey);
                sis.bytesExpected(dh.getMessageLength() + dh.getMessagePad());
                InputStream ip = sis.getInputStream();
                p.initPayloadFromStream(ip, sc);
                return p;
            }
        } else if (SecurityLogic.isSKeyEncryption(security)) {
            sis.useSessionKey();
            sis.bytesExpected(dh.getMessageLength() + dh.getMessagePad());
            p.initPayloadFromStream(sis.getInputStream(), sc);
            return p;
        }
        p.initPayloadFromStream(is, sc);
        return p;
    }

    private static void verifyMacs(IMessageProtection mp, ClientSecurityContext csc, byte[] staticHeader, DynamicHeader dh, Payload p) throws ESecurityGeneralException, EIntegrityCompromised {
        boolean verified;
        byte[] DigestKey;
        boolean verified2;
        CryptoInfoLinkedList macLinkedList = null;
        byte security = dh.getSecurity();
        if (SecurityLogic.isSKeyDigest(security) || SecurityLogic.isMKeyDigest(security)) {
            macLinkedList = Mgram.createMacInfoLinkedList(p);
        }
        if (SecurityLogic.isSKeyDigest(security) ? !(verified2 = mp.verifyMac(DigestKey = csc.getDigestKey(), 0, DigestKey.length, macLinkedList, dh.getDigest(), 0, dh.getDigest().length)) : (SecurityLogic.isMKeyDigest(security) ? !(verified = mp.verifyMac(dh.getMessageKey(), 0, dh.getMessageKey().length, macLinkedList, dh.getDigest(), 0, dh.getDigest().length)) : SecurityLogic.isMKeyMacHeader(security) && !(verified = mp.verifyMac(dh.getMessageKey(), 0, dh.getMessageKey().length, staticHeader, 0, 8, dh.getDigest(), 0, dh.getDigest().length)))) {
            throw new EIntegrityCompromised();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] calculateMac(byte[] key, IMessageProtection mp) throws ESecurityGeneralException {
        this.createPayload();
        CryptoInfoLinkedList macLinkedList = Mgram.createMacInfoLinkedList(this.m_payload);
        IMessageProtection iMessageProtection = mp;
        synchronized (iMessageProtection) {
            byte[] result = new byte[mp.getHashSize()];
            mp.mac(key, 0, key.length, macLinkedList, result, 0, result.length);
            return result;
        }
    }

    @Override
    public synchronized void recalculatePad(IMessageProtection mp) {
        this.createPayload();
        int length = this.m_payload.length();
        int newSize = mp.getOutputSize(length);
        this.createDynamicHeader();
        this.m_dynamicHeader.setMessagePad(newSize - length);
    }

    private static CryptoInfoLinkedList createMacInfoLinkedList(Payload p) throws ESecurityGeneralException {
        return p.createMacInfoLinkedList();
    }

    @Override
    public synchronized IQueueFlowControlHandle getQueueFlowControlHandle() {
        this.createPayload();
        return this.m_payload.getQueueFlowControlHandle();
    }

    @Override
    public synchronized IFlowControlHandle getFlowControlHandle() {
        this.createPayload();
        return this.m_payload.getFlowControlHandle();
    }

    @Override
    public IPTPFlowControlHandle getPTPFlowControlHandle() {
        this.createPayload();
        return this.m_payload.getPTPFlowControlHandle();
    }

    @Override
    public IBrokerHandle getBrokerHandle() {
        return this;
    }

    @Override
    public synchronized IAckHandle getAckHandle() {
        this.createPayload();
        return this.m_payload.getAckHandle();
    }

    @Override
    public synchronized IWindowAckHandle getWindowAckHandle() {
        this.createPayload();
        return this.m_payload.getWindowAckHandle();
    }

    @Override
    public synchronized IAckListHandle getAckListHandle() {
        this.createPayload();
        return this.m_payload.getAckListHandle();
    }

    @Override
    public synchronized IFailoverStatusNotificationHandle getFailoverStatusNotificationHandle() {
        this.createPayload();
        return this.m_payload.getFailoverStatusNotificationHandle();
    }

    @Override
    public synchronized IIDRHandle getIDRHandle() {
        this.createPayload();
        return this.m_payload.getIDRHandle();
    }

    @Override
    public synchronized IConnectionSyncHandle getConnectionSyncHandle() {
        this.createPayload();
        return this.m_payload.getConnectionSyncHandle();
    }

    @Override
    public synchronized ITXNRequestHandle getTXNRequestHandle() {
        this.createPayload();
        return this.m_payload.getTXNRequestHandle();
    }

    @Override
    public synchronized IExtendedTXNRequestHandle getExtendedTXNRequestHandle() {
        this.createPayload();
        return this.m_payload.getExtendedTXNRequestHandle();
    }

    @Override
    public synchronized IErrorHandle getErrorHandle() {
        this.createPayload();
        return this.m_payload.getErrorHandle();
    }

    @Override
    public final IMgramConverterHandle getMgramConverterHandle() {
        return this;
    }

    @Override
    public final synchronized IStateEventHandle getStateEventHandle() {
        this.createPayload();
        return this.m_payload.getStateEventHandle();
    }

    @Override
    public final synchronized IRoutingHandle getRoutingHandle() {
        this.createPayload();
        return this.m_payload.getRoutingHandle();
    }

    @Override
    public final synchronized IReplicatedMgramHandle getReplicatedMgramHandle() {
        this.createPayload();
        return this.m_payload.getReplicatedMgramHandle();
    }

    @Override
    public final synchronized boolean supportsRouting() {
        this.createPayload();
        return this.m_payload.supportsRouting();
    }

    @Override
    public boolean supportsOperationHandle() {
        return this.getType() == 25 || this.getType() == 27;
    }

    @Override
    public final synchronized IMgramConverterHandle.IDynamicHeader getInternalDynamicHeader() {
        this.createDynamicHeader();
        return this.m_dynamicHeader;
    }

    @Override
    public final byte[] getInternalStaticHeader() {
        return this.m_staticHeader;
    }

    @Override
    public final synchronized IMgramConverterHandle.IPayload getInternalPayload() {
        this.createPayload();
        return this.m_payload;
    }

    @Override
    public boolean isSecure() {
        return StaticHeader.isSecure(this.m_staticHeader);
    }

    @Override
    public boolean isGuarenteed() {
        boolean result = StaticHeader.isGuarenteed(this.m_staticHeader);
        if (this.m_guarFormatIncorrect) {
            result = !result;
        }
        return result;
    }

    public boolean isGuarenteedInternal() {
        return StaticHeader.isGuarenteed(this.m_staticHeader);
    }

    @Override
    public synchronized long getGuarenteedTrackingNum() {
        this.createPayload();
        if (this.m_guarFormatIncorrect) {
            return this.m_dbTracking;
        }
        return this.m_payload.getGuarenteedTrackingNum();
    }

    @Override
    public synchronized void setSuccessor(boolean value) {
        this.unprotectStaticHeader();
        StaticHeader.setSucessor(value, this.m_staticHeader);
    }

    @Override
    public synchronized byte getSecurity() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getSecurity();
    }

    @Override
    public synchronized int getMessageLength() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getMessageLength();
    }

    @Override
    public synchronized int getBodyLength() {
        this.createPayload();
        return this.m_payload.getBodyLength();
    }

    @Override
    public synchronized int getMessagePad() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getMessagePad();
    }

    @Override
    public synchronized byte[] getMessageKey() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getMessageKey();
    }

    @Override
    public IMessageProtection getMessageProtection() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getMessageProtection();
    }

    public synchronized int getDestinationAddressFormat() {
        return StaticHeader.getDestinationAddressFormat(this.m_staticHeader);
    }

    @Override
    public int getRequestReplyFieldType() {
        return StaticHeader.getRequestReplyFieldType(this.m_staticHeader);
    }

    @Override
    public byte getType() {
        return StaticHeader.getType(this.m_staticHeader);
    }

    @Override
    public synchronized void setType(byte type) {
        if (this.getType() != 27) {
            this.unprotectStaticHeader();
            StaticHeader.setType(type, this.m_staticHeader);
        } else {
            this.createPayload();
            this.m_payload.setType(type);
        }
    }

    @Override
    public synchronized void sync() {
        this.unprotectStaticHeader();
        if (this.m_dynamicHeader != null) {
            this.m_dynamicHeader.sync();
        }
        if (this.m_payload != null) {
            this.m_payload.sync();
        }
    }

    void resetCachedPayloadMemLen() {
        this.m_payloadMemLen = -1;
    }

    void resetCachedDynamicHeaderMemLen() {
        this.m_dynamicHeaderMemLen = -1;
    }

    @Override
    public boolean hasTxn() {
        return StaticHeader.hasTxn(this.m_staticHeader);
    }

    @Override
    public synchronized int getChannel() {
        return StaticHeader.getChannel(this.m_staticHeader);
    }

    @Override
    public synchronized void setChannel(int channel) {
        this.unprotectStaticHeader();
        StaticHeader.setChannel(channel, this.m_staticHeader);
    }

    @Override
    public boolean isPostSV22() {
        return StaticHeader.isPostSV22(this.m_staticHeader);
    }

    @Override
    public boolean hasSessionVer() {
        return StaticHeader.hasSessionVer(this.m_staticHeader);
    }

    @Override
    public synchronized void setSessionVer(byte version) {
        this.m_sessionVer = version;
        StaticHeader.setSessionVer(version, this.m_staticHeader);
    }

    @Override
    public void setSenderID(long id) {
        this.m_senderID = id;
    }

    @Override
    public long getSenderID() {
        return this.m_senderID;
    }

    @Override
    public boolean isTargeted() {
        return this.m_targeted;
    }

    @Override
    public void setTargeted(boolean val) {
        this.m_targeted = val;
    }

    @Override
    public void setRedirectAckTarget(long clientId) {
        this.m_redirectAckTarget = clientId;
    }

    @Override
    public long getRedirectAckTarget() {
        return this.m_redirectAckTarget;
    }

    @Override
    public void setProxyRecipsTable(LongHashTable table) {
        this.m_proxyRecipsTable = table;
    }

    @Override
    public LongHashTable getProxyRecipsTable() {
        return this.m_proxyRecipsTable;
    }

    @Override
    public void setAckNoReply(boolean value) {
        this.m_ack_noreply = value;
    }

    @Override
    public boolean isAckNoReply() {
        return this.m_ack_noreply;
    }

    @Override
    public boolean isFromDB() {
        return this.m_fromDb;
    }

    @Override
    public void setFromDB(boolean value) {
        this.m_fromDb = value;
    }

    @Override
    public boolean isDBSaveRequested() {
        return this.m_dbSaveRequested;
    }

    @Override
    public void setDBSaveRequested(boolean value) {
        this.m_dbSaveRequested = value;
    }

    @Override
    public boolean wasDBSaved() {
        return this.m_dbSaved;
    }

    @Override
    public void setDBSaved(boolean value) {
        this.m_dbSaved = value;
    }

    @Override
    public void addMsgHeaderSaved(long cid) {
        if (this.m_msgHeadersSaved == null) {
            this.m_msgHeadersSaved = new IndexedList();
        }
        this.m_msgHeadersSaved.appendNoDup(cid, new Long(cid));
    }

    @Override
    public void addMsgHeadersSaved(long[] cids) {
        for (int count = 0; count < cids.length; ++count) {
            this.addMsgHeaderSaved(cids[count]);
        }
    }

    @Override
    public boolean isMsgHeaderSaved(long cid) {
        if (this.m_msgHeadersSaved != null) {
            return this.m_msgHeadersSaved.get(cid) != null;
        }
        return false;
    }

    @Override
    public void clearMsgHeader(long cid) {
        if (this.m_msgHeadersSaved != null) {
            this.m_msgHeadersSaved.remove(cid);
            if (this.m_msgHeadersSaved.count() == 0) {
                this.m_msgHeadersSaved = null;
            }
        }
    }

    @Override
    public void setLocalQueueName(String name) {
        this.m_localQName = name;
    }

    @Override
    public String getLocalQueueName() {
        return this.m_localQName;
    }

    @Override
    public boolean isReply() {
        return StaticHeader.isReply(this.m_staticHeader);
    }

    @Override
    public boolean isRequest() {
        return StaticHeader.isRequest(this.m_staticHeader);
    }

    @Override
    public boolean isSend() {
        return StaticHeader.isSend(this.m_staticHeader);
    }

    @Override
    public byte getPriority() {
        return StaticHeader.getPriority(this.m_staticHeader);
    }

    @Override
    public int getRouteLimit() {
        return StaticHeader.getRouteLimit(this.m_staticHeader);
    }

    @Override
    public synchronized void setRouteLimit(int routeLimit) {
        this.unprotectStaticHeader();
        StaticHeader.setRouteLimit(routeLimit, this.m_staticHeader);
    }

    @Override
    public boolean isSuccessor() {
        return StaticHeader.isSucessor(this.m_staticHeader);
    }

    @Override
    public boolean isJMSPersistent() {
        return StaticHeader.isJMSPersistent(this.m_staticHeader);
    }

    @Override
    public boolean isNonPersistentReplicated() {
        this.createPayload();
        return this.m_payload.isNonPersistentReplicated();
    }

    @Override
    public boolean hasUndeliveredDestination() {
        this.createPayload();
        return this.m_payload.hasUndeliveredDestination();
    }

    @Override
    public boolean requiresXOnceDelivery() {
        return this.isJMSPersistent() || this.isNonPersistentReplicated();
    }

    @Override
    public boolean isPubSub() {
        if (this.getType() == 2) {
            return true;
        }
        if (this.getType() == 27) {
            this.createPayload();
            return this.m_payload.isPubSub();
        }
        if (this.getType() == 25 && this.getOperationHandle().getOperationType() == 25) {
            return ((IMgram)this.getOperationHandle().getMgramList().getFirst()).isPubSub();
        }
        return false;
    }

    @Override
    public boolean isPTP() {
        if (this.getType() == 12) {
            return true;
        }
        if (this.getType() == 27) {
            this.createPayload();
            return this.m_payload.isPTP();
        }
        if (this.getType() == 25 && this.getOperationHandle().getOperationType() == 25) {
            return ((IMgram)this.getOperationHandle().getMgramList().getFirst()).isPTP();
        }
        return false;
    }

    @Override
    public boolean isQueueMessage() {
        return this.getLocalQueueName() != null;
    }

    @Override
    public synchronized int getReplyPriority() {
        this.createPayload();
        return this.m_payload.getReplyPriority();
    }

    @Override
    public synchronized void setReplyPriority(int priority) {
        this.createPayload();
        this.m_payload.setReplyPriority(priority);
    }

    @Override
    public boolean isTTE() {
        return StaticHeader.hasTTE(this.m_staticHeader);
    }

    @Override
    public synchronized long getTTE() {
        this.convertTTE();
        return this.m_tte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertTTE() {
        boolean hasTTE = StaticHeader.hasTTE(this.m_staticHeader);
        if (hasTTE) {
            Mgram mgram = this;
            synchronized (mgram) {
                if (this.m_tte == 0L || this.m_isTTE_TTL) {
                    this.m_tte = StaticHeader.getTTE(this.m_staticHeader);
                    if (this.m_isTTE_TTL) {
                        this.m_tte = System.currentTimeMillis() + this.m_tte;
                        this.m_isTTE_TTL = false;
                        StaticHeader.setTTE(this.m_tte, this.m_staticHeader);
                    }
                }
            }
        }
    }

    void setTTE_TTL(boolean value) {
        this.m_isTTE_TTL = value;
    }

    @Override
    public synchronized void setTTE(long time) {
        this.unprotectStaticHeader();
        StaticHeader.setTTE(time, this.m_staticHeader);
        this.m_tte = time;
        this.m_isTTE_TTL = false;
    }

    @Override
    public synchronized void removeTTE() {
        this.unprotectStaticHeader();
        StaticHeader.enableTTE(false, this.m_staticHeader);
        this.m_tte = 0L;
    }

    @Override
    public synchronized void setDiscardable(boolean value) {
        if (value != this.isDiscardable()) {
            this.unprotectStaticHeader();
            StaticHeader.setDiscardable(value, this.m_staticHeader);
        }
    }

    @Override
    public boolean isDiscardable() {
        return StaticHeader.isDiscardable(this.m_staticHeader);
    }

    @Override
    public final synchronized void setRejectable(boolean rejectable) {
        if (rejectable != StaticHeader.isRejectable(this.m_staticHeader)) {
            this.unprotectStaticHeader();
            StaticHeader.setRejectable(rejectable, this.m_staticHeader);
        }
    }

    @Override
    public final synchronized boolean isRejectable() {
        return this.m_wasRejectable || StaticHeader.isRejectable(this.m_staticHeader);
    }

    @Override
    public final synchronized void setInstrumented(boolean instrumented) {
        if (instrumented != StaticHeader.isInstrumented(this.m_staticHeader)) {
            this.unprotectStaticHeader();
            StaticHeader.setInstrumented(instrumented, this.m_staticHeader);
        }
    }

    @Override
    public final synchronized boolean isInstrumented() {
        return this.m_wasRejectable || StaticHeader.isInstrumented(this.m_staticHeader);
    }

    @Override
    public synchronized void setJMSPersistent(boolean value) {
        this.unprotectStaticHeader();
        StaticHeader.setJMSPersistent(value, this.m_staticHeader);
    }

    @Override
    public void setNonPersistentReplicated(boolean value) {
        if (value) {
            this.setJMSPersistent(true);
        }
        this.createPayload();
        this.m_payload.setNonPersistentReplicated(value);
    }

    @Override
    public void setUndeliveredDestination(boolean value) {
        this.createPayload();
        this.m_payload.setUndeliveredDestination(value);
    }

    @Override
    public synchronized void setSecurityAttribute(byte value) {
        this.createDynamicHeader();
        this.m_dynamicHeader.setSecurityAttributeByte(value);
    }

    @Override
    public synchronized void setMgramSecure(IMessageProtection mp) {
        this.unprotectStaticHeader();
        this.createDynamicHeader();
        StaticHeader.setMgramSecure(true, this.m_staticHeader);
        this.createDynamicHeader();
        this.m_dynamicHeader = this.m_dynamicHeader.getSecureDynamicHeader(mp);
    }

    @Override
    public synchronized void setMessageKey(byte[] messageKey) {
        this.createDynamicHeader();
        this.m_dynamicHeader.setMessageKey(messageKey);
    }

    @Override
    public synchronized void setMgramNonSecure() {
        this.unprotectStaticHeader();
        this.createDynamicHeader();
        StaticHeader.setMgramSecure(false, this.m_staticHeader);
        this.createDynamicHeader();
        this.m_dynamicHeader = this.m_dynamicHeader.getNonSecureDynamicHeader();
    }

    @Override
    public synchronized void setPriority(byte value) {
        this.unprotectStaticHeader();
        StaticHeader.setPriority(value, this.m_staticHeader);
    }

    @Override
    public synchronized boolean hasSubject() {
        this.createPayload();
        ISubject s = this.getSubject();
        return s != null && s.isSubjectSet();
    }

    @Override
    public synchronized ISubject getSubject() {
        if (this.getSubjectFormat() == 4) {
            this.createDynamicHeader();
            return this.m_dynamicHeader.getSubject();
        }
        this.createPayload();
        return this.m_payload.getSubject();
    }

    @Override
    public int getSubjectFormat() {
        return StaticHeader.getDestinationAddressFormat(this.m_staticHeader);
    }

    @Override
    public synchronized void setSubject(ISubject subject, int format) {
        boolean SFChanged = false;
        if (StaticHeader.getDestinationAddressFormat(this.m_staticHeader) != format) {
            this.unprotectStaticHeader();
            StaticHeader.setDestinationAddressFormat(format, this.m_staticHeader);
            SFChanged = true;
        }
        switch (format) {
            case 4: {
                this.createDynamicHeader();
                this.m_dynamicHeader.setSubject(subject);
                this.m_payload.setSubject(null, SFChanged);
                break;
            }
            default: {
                this.createPayload();
                this.m_payload.setSubject(subject, SFChanged);
                this.createDynamicHeader();
                this.m_dynamicHeader.setSubject(null);
            }
        }
    }

    @Override
    public synchronized boolean hasBody() {
        this.createPayload();
        return this.m_payload.hasBody();
    }

    @Override
    public void setBody(byte[] body) {
        if (body != null) {
            this.setBody(body, body.length);
        } else {
            this.setBody(body, 0);
        }
    }

    @Override
    public synchronized void setBody(byte[] body, int length) {
        this.createPayload();
        this.m_payload.setBody(body, length);
    }

    @Override
    public synchronized int getPayloadLength() {
        if (this.m_payload == null) {
            return this.m_payloadCache.length;
        }
        return this.m_payload.length();
    }

    @Override
    public synchronized void setSidebandData(ISidebandData sd) {
        this.createPayload();
        this.m_payload.setSidebandData(sd);
    }

    @Override
    public synchronized ISidebandData getSidebandData() {
        this.createPayload();
        return this.m_payload.getSidebandData();
    }

    @Override
    public synchronized ISidebandData getSidebandDataReadOnly() {
        this.createPayload();
        return this.m_payload.getSidebandDataReadOnly();
    }

    @Override
    public synchronized boolean hasSidebandData() {
        this.createPayload();
        return this.m_payload.hasSidebandData();
    }

    @Override
    public synchronized void createSidebandDataIfNeeded() {
        this.createPayload();
        this.m_payload.createSidebandDataIfNeeded();
    }

    @Override
    public synchronized String getRouting() {
        return this.getRoutingHandle().getRouting();
    }

    @Override
    public synchronized boolean forRemoteNode(String localNodeName) {
        String node = this.getRouting();
        return node != null && !node.equals(localNodeName) && !node.equals("");
    }

    @Override
    public String getCorrectedRemoteNode(String localNodeName) {
        this.createPayload();
        if (this.m_payload.supportsRouting()) {
            String node;
            IRoutingHandle handle = this.m_payload.getRoutingHandle();
            if (handle.isMultiHopRouting()) {
                handle.removeNextRouting(localNodeName);
            }
            if ((node = this.getRouting()) == null || node.length() == 0 || node.equals(localNodeName)) {
                return null;
            }
            return node;
        }
        return null;
    }

    @Override
    public synchronized byte[] getRawBody() {
        this.createPayload();
        return this.m_payload.getRawBodyBuffer();
    }

    @Override
    public boolean hasID() {
        return StaticHeader.hasID(this.m_staticHeader);
    }

    @Override
    public synchronized void setID(byte[] value) {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.enableID(this.m_staticHeader);
        this.m_payload.setID(value);
    }

    @Override
    public synchronized byte[] getID() {
        this.createPayload();
        return this.m_payload.getID();
    }

    @Override
    public synchronized long getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    @Override
    public void setSequenceNumber(long sequence_number) {
        this.m_sequenceNumber = sequence_number;
    }

    @Override
    public synchronized void clearID() {
        this.createPayload();
        this.m_payload.clearID();
    }

    @Override
    public synchronized void setRequestReplySend() {
        this.unprotectStaticHeader();
        StaticHeader.setRequestReplyType(0, this.m_staticHeader);
    }

    @Override
    public synchronized void setRequestReplyReply() {
        this.unprotectStaticHeader();
        StaticHeader.setRequestReplyType(3, this.m_staticHeader);
    }

    @Override
    public synchronized void setGuarenteed(long tracking) {
        this.unprotectStaticHeader();
        this.createPayload();
        this.m_guarFormatIncorrect = false;
        StaticHeader.setGuarenteed(true, this.m_staticHeader);
        this.m_payload.setGuarenteed(tracking);
    }

    @Override
    public synchronized void setReliable() {
        this.unprotectStaticHeader();
        this.createPayload();
        this.m_guarFormatIncorrect = false;
        StaticHeader.setGuarenteed(false, this.m_staticHeader);
        this.m_payload.setGuarenteed(0L);
    }

    @Override
    public synchronized void setTxn(int tid) {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.setTxn(true, this.m_staticHeader);
        this.m_payload.setTxn(tid);
    }

    @Override
    public synchronized void setTxnPublish(int tid, int txnseq) {
        this.unprotectStaticHeader();
        StaticHeader.setTxnPublish(true, this.m_staticHeader);
        this.m_txnpublish_tid = tid;
        this.m_txnpublish_tidseq = txnseq;
    }

    @Override
    public void setBatchedPublish(boolean value) {
        this.m_batchedPublished = value;
    }

    @Override
    public boolean isBatchedPublish() {
        return this.m_batchedPublished;
    }

    @Override
    public void setBatchId(long value) {
        this.m_batchId = value;
    }

    @Override
    public long getBatchId() {
        return this.m_batchId;
    }

    @Override
    public int getTxnPublishTid() {
        return this.m_txnpublish_tid;
    }

    @Override
    public int getTxnPublishTidSeqNo() {
        return this.m_txnpublish_tidseq;
    }

    @Override
    public synchronized int getTxnId() {
        this.createPayload();
        return this.m_payload.getTxnId();
    }

    @Override
    public synchronized void removeTxn() {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.setTxn(false, this.m_staticHeader);
        this.m_payload.removeTxn();
    }

    @Override
    public synchronized void setRequest(long tracking, String subject) {
        this.unprotectStaticHeader();
        StaticHeader.setRequestReplyType(2, this.m_staticHeader);
        this.createPayload();
        this.m_payload.setRequest((int)tracking, subject);
    }

    @Override
    public synchronized int memoryLength() {
        boolean isDHDirty = false;
        boolean isPayloadDirty = false;
        if (this.m_dynamicHeader != null) {
            isDHDirty = this.m_dynamicHeader.isDirty();
        }
        if (this.m_payload != null) {
            isPayloadDirty = this.m_payload.isDirty();
        }
        this.sync();
        if (this.m_dynamicHeader != null && (isDHDirty || this.m_dynamicHeaderMemLen == -1)) {
            this.m_dynamicHeaderMemLen = this.m_dynamicHeader.memoryLength();
        } else if (this.m_dynamicHeaderMemLen == -1 && this.m_dynamicHeaderCache != null) {
            this.m_dynamicHeaderMemLen = this.m_dynamicHeaderCache.length;
        }
        if (this.m_payload != null && (isPayloadDirty || this.m_payloadMemLen == -1)) {
            this.m_payloadMemLen = this.m_payload.memoryLength();
        } else if (this.m_payloadMemLen == -1 && this.m_payloadCache != null) {
            this.m_payloadMemLen = this.m_payloadCache.length;
        }
        int operationLength = 0;
        if (this.supportsOperationHandle()) {
            operationLength += this.getOperationHandle().getMgramListMemoryLength();
        }
        int result = s_mgramMemSize + 20 + this.m_dynamicHeaderMemLen + this.m_payloadMemLen + operationLength;
        return result;
    }

    @Override
    public synchronized void saveMemory() {
        if (this.m_dynamicHeader != null) {
            this.m_dynamicHeader.saveMemory();
        }
        if (this.m_payload != null) {
            this.m_payload.saveMemory();
        }
    }

    @Override
    public synchronized int networkLength() {
        int result = 20 + (this.m_dynamicHeader != null ? this.m_dynamicHeader.length() : this.m_dynamicHeaderCache.length) + (this.m_payload != null ? this.m_payload.length() : this.m_payloadCache.length);
        int operationLength = 0;
        if (this.supportsOperationHandle()) {
            operationLength += this.getOperationHandle().getMgramListNetworkLength();
        }
        return result + operationLength;
    }

    @Override
    public synchronized void macMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.macPrimaryMessageWithMessageKey(mp);
        if (this.supportsOperationHandle()) {
            this.getOperationHandle().macMgramListMessagesWithMessageKey(mp);
        }
    }

    synchronized void macPrimaryMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.createDynamicHeader();
        byte[] messageKey = this.m_dynamicHeader.getMessageKey();
        byte[] result = this.calculateMac(messageKey, mp);
        this.m_dynamicHeader.setMessageDigest(result);
    }

    @Override
    public ISubject getReplySubject() {
        this.createPayload();
        return this.m_payload.getReplySubject();
    }

    @Override
    public final synchronized int getReplyFormat() {
        this.createPayload();
        return this.m_payload.getReplyFormat();
    }

    @Override
    public synchronized void setReplyFormat(int type) {
        this.createPayload();
        this.m_payload.setReplyFormat(type);
    }

    @Override
    public synchronized void setReply(IMgram nm) {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.setRequestReplyType(3, this.m_staticHeader);
        this.setSubject(nm.getReplySubject().protectedClone(), 5);
    }

    @Override
    public synchronized void setRequestReplyType(int type) {
        this.unprotectStaticHeader();
        StaticHeader.setRequestReplyType(type, this.m_staticHeader);
    }

    @Override
    public synchronized int getReplyTracking() throws ENoTrackingNum {
        this.createPayload();
        if (!StaticHeader.canHaveReplyTracking(this.m_staticHeader) || !this.m_payload.canHaveReplyTracking()) {
            throw new ENoTrackingNum();
        }
        return (int)this.m_payload.getSubject().getSubjectTracking();
    }

    @Override
    public void writeMgramToNetworkStream(OutputStream os, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        this.writeMgramToStream(os, -1, csc, sos, mp, true, ctx);
    }

    @Override
    public void writeMgramToNetworkStream(OutputStream os, int channel, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        this.writeMgramToStream(os, channel, csc, sos, mp, true, ctx);
    }

    @Override
    public void writeMgramToStream(OutputStream os) throws IOException {
        this.writeMgramToStream(os, null, null, null, false);
    }

    @Override
    public void writeMgramToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeMgramToStream(os, null, null, null, tteTTLConvert);
    }

    @Override
    public void writeMgramToStream(OutputStream os, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, boolean tteTTLConvert) throws IOException {
        this.writeMgramToStream(os, -1, csc, sos, mp, tteTTLConvert);
    }

    public void writeMgramToStream(OutputStream os, int channel, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, boolean tteTTLConvert) throws IOException {
        this.writeMgramToStream(os, channel, csc, sos, mp, tteTTLConvert, null);
    }

    private void writeMgramToStream(OutputStream os, int channel, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, boolean tteTTLConvert, MgramDeliveryContext ctx) throws IOException {
        this.writeStaticHeaderToStream(os, channel, tteTTLConvert);
        if (this.m_staticHeader != null && StaticHeader.getType(this.m_staticHeader) == 4) {
            return;
        }
        this.writeDynamicHeaderToStream(os, csc, mp, ctx);
        this.writePayloadToStream(os, sos);
    }

    @Override
    public void writeMgramToStreamNonSecure(OutputStream os, boolean tteTTLConvert, MgramDeliveryContext ctx) throws IOException {
        this.writeMgramToNetworkStreamNonSecure(os, -1, tteTTLConvert, ctx);
    }

    @Override
    public void writeMgramToNetworkStreamNonSecure(OutputStream os, int channel, boolean tteTTLConvert, MgramDeliveryContext ctx) throws IOException {
        this.writeStaticHeaderToStream(os, channel, tteTTLConvert);
        if (this.m_staticHeader != null && StaticHeader.getType(this.m_staticHeader) == 4) {
            return;
        }
        this.writeDynamicHeaderToStream(os, (ClientSecurityContext)null, null, ctx);
        if (this.isSecure()) {
            this.m_dynamicHeader.setMessagePad(0);
        }
        this.writePayloadToStream(os, null);
    }

    @Override
    public void writeStaticHeaderToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeStaticHeaderToStream(os, -1, tteTTLConvert);
    }

    public void writeStaticHeaderToStream(OutputStream os, int channel, boolean tteTTLConvert) throws IOException {
        this.convertTTE();
        StaticHeader.writeToStream(os, this.m_staticHeader, channel, tteTTLConvert);
        if (this.getType() == 4 && StaticHeader.hasSessionVer(this.m_staticHeader)) {
            os.write(this.m_sessionVer);
        }
    }

    @Override
    public void writeDynamicHeaderToStream(OutputStream os, ClientSecurityContext csc, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        byte[] digestKey = csc == null ? null : csc.getDigestKey();
        this.writeDynamicHeaderToStream(os, digestKey, mp, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDynamicHeaderToStream(OutputStream os, byte[] digestKey, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        if (this.isSecure() && mp != null) {
            this.createDynamicHeader();
            if (SecurityLogic.isSKeyDigest(this.getSecurity())) {
                byte[] mac = this.calculateMac(digestKey, mp);
                this.m_dynamicHeader.setMessageDigest(mac);
            }
            this.recalculatePad(mp);
            this.m_dynamicHeader.writeToStream(os, mp, ctx);
        } else {
            byte[] dhCache;
            DynamicHeader dh;
            Mgram mgram = this;
            synchronized (mgram) {
                dh = this.m_dynamicHeader;
                dhCache = this.m_dynamicHeaderCache;
            }
            if (dh != null) {
                dh.writeToStream(os, ctx);
            } else {
                os.write(dhCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePayloadToStream(OutputStream os, ISecureOutputStream sos) throws IOException {
        if (this.isSecure()) {
            this.createPayload();
            this.m_payload.writePreSecureData(os);
            if (SecurityLogic.isSKeyEncryption(this.getSecurity()) && sos != null) {
                OutputStream ios = sos.getOutputStream();
                this.m_payload.writeToStream(ios);
                ios.flush();
            } else {
                this.m_payload.writeToStream(os);
            }
        } else {
            byte[] payloadCache;
            Payload payload;
            Mgram mgram = this;
            synchronized (mgram) {
                payload = this.m_payload;
                payloadCache = this.m_payloadCache;
            }
            if (payload != null) {
                payload.writePreSecureData(os);
                payload.writeToStream(os);
            } else {
                os.write(payloadCache);
            }
        }
    }

    @Override
    public synchronized int serializedLength() {
        this.sync();
        this.createDynamicHeader();
        this.createPayload();
        int result = this.calcSerializedHeaderLength();
        result += this.isEncrypted() ? this.calcEncryptedSerializedLength() : this.calcUnencryptedSerializedLength();
        result += this.isTransactionalPublish() ? 8 : 0;
        result += this.isEnqueuedSizeSet() ? 4 : 0;
        if (this.supportsOperationHandle()) {
            result += this.getOperationHandle().getMgramListSerializedLength();
        }
        return result;
    }

    private int calcSerializedHeaderLength() {
        int result = 4 + this.m_staticHeader.length + this.m_dynamicHeader.length();
        if (this.isSecure()) {
            result += 4;
        }
        return result;
    }

    private int calcEncryptedSerializedLength() {
        int subjectLength = 0;
        if (this.hasSubject()) {
            switch (this.getSubjectFormat()) {
                case 0: 
                case 4: {
                    break;
                }
                case 5: {
                    subjectLength = this.getSubject().getSerializedLength();
                    break;
                }
                default: {
                    subjectLength = this.getSubject().getSubjectUTFLength();
                }
            }
        }
        int result = 25 + subjectLength + (this.isGuarenteedInternal() ? 8 : 0) + (this.getSidebandData() == null ? 4 : this.m_payload.getSidebandData().getSerializedLength() * 2 + 4 + 4) + 4 + this.m_payload.getPreBodyLength() + 4 + this.m_payload.getBodyLength() + 4 + (this.m_payload.getPadBuffer() == null ? 0 : this.m_payload.getPadBuffer().length) + 1 + (this.m_payload.getRoutingHandle().getRouting() == null ? 0 : StringUtil.lengthUTF(this.m_payload.getRoutingHandle().getAllRoutingString()) + 1);
        return result;
    }

    private int calcUnencryptedSerializedLength() {
        int result = this.m_payload.length();
        if (this.isSecure()) {
            result += this.getMessagePad();
        }
        return result;
    }

    @Override
    public synchronized void serialize(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.createDynamicHeader();
        this.createPayload();
        this.sync();
        os.write(26);
        StreamUtil.writeBoolean(this.isSecure(), os);
        StreamUtil.writeBoolean(this.m_payload.isEncrypted(), os);
        StreamUtil.writeBoolean(this.isEnqueuedSizeSet(), os);
        if (this.isEnqueuedSizeSet()) {
            StreamUtil.writeInt(this.m_enqueuedSize, os);
        }
        int pad = 0;
        if (this.isSecure()) {
            pad = this.getMessagePad();
            StreamUtil.writeInt(pad, os);
        }
        this.writeStaticHeaderToStream(os, tteTTLConvert);
        this.m_dynamicHeader.writeToStream(os, null);
        if (this.m_payload.isEncrypted()) {
            byte[] buffer;
            ISidebandData sidebandData;
            StreamUtil.writeLong(this.getSenderID(), os);
            StreamUtil.writeLong(this.getSequenceNumber(), os);
            StreamUtil.writeInt(this.getReplyFormat(), os);
            StreamUtil.writeInt(this.getReplyPriority(), os);
            if (this.hasSubject()) {
                switch (this.getSubjectFormat()) {
                    case 0: 
                    case 4: {
                        StreamUtil.writeBoolean(false, os);
                        break;
                    }
                    case 5: {
                        StreamUtil.writeBoolean(true, os);
                        this.getSubject().writeToStream(os);
                        break;
                    }
                    default: {
                        StreamUtil.writeBoolean(true, os);
                        os.write(this.getSubject().getSubjectUTF());
                        break;
                    }
                }
            } else {
                StreamUtil.writeBoolean(false, os);
            }
            if (this.isGuarenteedInternal()) {
                StreamUtil.writeLong(this.m_payload.getGuarenteedTrackingNum(), os);
            }
            if ((sidebandData = this.m_payload.getSidebandData()) != null) {
                buffer = sidebandData.getNewByteArray();
                int bufferLength = ArrayUtil.readInt(buffer, 0);
                StreamUtil.writeInt(bufferLength, os);
                os.write(buffer, 0, bufferLength);
                buffer = this.m_payload.getRawSidebandBuffer();
                int length = this.m_payload.getSidebandData().getSerializedLength();
                StreamUtil.writeInt(length, os);
                os.write(buffer, 0, length);
            } else {
                StreamUtil.writeInt(-1, os);
            }
            buffer = this.m_payload.getRawPreBody();
            StreamUtil.writeInt(this.m_payload.getPreBodyLength(), os);
            os.write(buffer);
            if (this.m_payload.hasBody()) {
                buffer = this.m_payload.getRawBodyBuffer();
                StreamUtil.writeInt(this.m_payload.getBodyLength(), os);
                os.write(buffer);
            } else {
                StreamUtil.writeInt(0, os);
            }
            if (pad > 0) {
                os.write(this.m_payload.getPadBuffer(), 0, pad);
            }
            int bitField1 = this.m_payload.getBitField1();
            StreamUtil.writeInt(this.m_payload.getBitField1(), os);
            if ((bitField1 & 1) > 0) {
                StreamUtil.writeUTF(this.getRoutingHandle().getAllRoutingString(), os);
            }
            if (this.isTransactionalPublish()) {
                StreamUtil.writeInt(this.getTxnPublishTid(), os);
                StreamUtil.writeInt(this.getTxnPublishTidSeqNo(), os);
            }
            return;
        }
        this.m_payload.writeToStream(os);
        if (this.isTransactionalPublish()) {
            StreamUtil.writeInt(this.getTxnPublishTid(), os);
            StreamUtil.writeInt(this.getTxnPublishTidSeqNo(), os);
        }
    }

    public static IMgram unserialize(InputStream is, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        Mgram result = new Mgram(false);
        boolean isSecure = StreamUtil.readBoolean(is);
        boolean isEncrypted = StreamUtil.readBoolean(is);
        boolean isEnqueuedSizeSet = StreamUtil.readBoolean(is);
        if (isEnqueuedSizeSet) {
            result.setEnqueuedSize(StreamUtil.readInt(is));
        }
        int pad = 0;
        if (isSecure) {
            pad = StreamUtil.readInt(is);
        }
        DynamicHeader dh = new DefaultDynamicHeader(result);
        if (isSecure) {
            dh = dh.getSecureDynamicHeader(null);
            dh.setMessagePad(pad);
        }
        result.setDynamicHeader(dh);
        result.initStaticHeaderFromStream((byte)-1, is, null, tteTTLConvert);
        dh.initDynamicHeaderFromStream(is, null, null);
        byte type = result.getType();
        Payload payload = null;
        switch (type) {
            case 3: 
            case 14: {
                payload = new AckPayload(result);
                break;
            }
            case 27: {
                payload = new BatchPayload(result);
                break;
            }
            case 28: {
                payload = new AckListPayload(result);
                break;
            }
            case 36: {
                payload = new AckPayload(result);
                break;
            }
            default: {
                payload = new DefaultPayload(result);
            }
        }
        result.setPayload(payload);
        if (isEncrypted) {
            boolean hasUndeliveredDestination;
            int bitField1;
            int bufferLength;
            DefaultPayload dp = (DefaultPayload)payload;
            result.setSenderID(StreamUtil.readLong(is));
            result.setSequenceNumber(StreamUtil.readLong(is));
            result.setReplyFormat(StreamUtil.readInt(is));
            result.setReplyPriority(StreamUtil.readInt(is));
            boolean hasSubject = StreamUtil.readBoolean(is);
            if (hasSubject) {
                switch (result.getSubjectFormat()) {
                    case 0: 
                    case 4: {
                        break;
                    }
                    case 5: {
                        result.setSubject(Subject.createFromStream(is), result.getSubjectFormat());
                        break;
                    }
                    default: {
                        Subject s = new Subject();
                        s.initSubjectUTF(StreamUtil.readUTFString(is));
                        result.setSubject(s, result.getSubjectFormat());
                        break;
                    }
                }
            }
            if (result.isGuarenteedInternal()) {
                result.setGuarenteed(StreamUtil.readLong(is));
            }
            if ((bufferLength = StreamUtil.readInt(is)) != -1) {
                byte[] sidebandBytes = new byte[bufferLength];
                StreamUtil.readBytes(is, sidebandBytes, 0, bufferLength);
                SidebandData sidebandData = new SidebandData();
                try {
                    sidebandData.fromByteArray(sidebandBytes, 0);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    EMgramFormatError emf = new EMgramFormatError(prAccessor.getString("ERROR_READING_MGRAM"));
                    emf.initCause(ex);
                    throw emf;
                }
                result.setSidebandData(sidebandData);
                bufferLength = StreamUtil.readInt(is);
                sidebandBytes = new byte[bufferLength];
                StreamUtil.readBytes(is, sidebandBytes, 0, bufferLength);
                dp.setSidebandBuffer(sidebandBytes);
            }
            bufferLength = StreamUtil.readInt(is);
            byte[] preBodyBuffer = new byte[bufferLength];
            StreamUtil.readBytes(is, preBodyBuffer, 0, bufferLength);
            dp.setPreBodyBuffer(preBodyBuffer);
            bufferLength = StreamUtil.readInt(is);
            byte[] body = null;
            if (bufferLength > 0) {
                body = new byte[bufferLength];
                StreamUtil.readBytes(is, body, 0, bufferLength);
            }
            payload.setBody(body, bufferLength);
            if (pad > 0) {
                byte[] padArray = new byte[pad];
                StreamUtil.readBytes(is, padArray, 0, pad);
                dp.setPadBuffer(padArray);
            }
            boolean hasRouting = ((bitField1 = StreamUtil.readInt(is)) & 1) > 0;
            boolean isGSAPublication = (bitField1 & 2) > 0;
            boolean isNonPersistentReplicated = (bitField1 & 4) > 0;
            boolean bl = hasUndeliveredDestination = (bitField1 & 8) > 0;
            if (hasRouting) {
                dp.setRouting(StreamUtil.readUTF(is));
            }
            dp.setGSAPublication(isGSAPublication);
            dp.setNonPersistentReplicated(isNonPersistentReplicated);
            dp.setUndeliveredDestination(hasUndeliveredDestination);
            dp.unsetDirtyFlagInPrebody();
            dp.setEncrypted();
            result.setStatus(3);
        } else {
            payload.initPayloadFromStream(is);
        }
        if (result.isTransactionalPublish()) {
            result.setTxnPublish(StreamUtil.readInt(is), StreamUtil.readInt(is));
        }
        result.setTTE_TTL(false);
        return result;
    }

    @Override
    public synchronized byte[] toByteArray() {
        this.createDynamicHeader();
        this.createPayload();
        byte[] staticHeader = this.m_staticHeader;
        byte[] dynamicHeader = this.m_dynamicHeader.toByteArray();
        byte[] payload = this.m_payload.toByteArray();
        int staticLength = staticHeader.length;
        int dynamicLength = dynamicHeader.length;
        int payloadLength = payload.length;
        int totalLength = staticLength + dynamicLength + payloadLength;
        byte[] newByteArray = new byte[totalLength];
        System.arraycopy(staticHeader, 0, newByteArray, 0, staticLength);
        System.arraycopy(dynamicHeader, 0, newByteArray, staticLength, dynamicLength);
        System.arraycopy(payload, 0, newByteArray, staticLength + dynamicLength, payloadLength);
        return newByteArray;
    }

    @Override
    public byte getVersion() {
        return StaticHeader.getVersion(this.m_staticHeader);
    }

    @Override
    public byte getSessionVersion() {
        return this.m_sessionVer;
    }

    public void setPostV22() {
        StaticHeader.setPostV22(true, this.m_staticHeader);
    }

    @Override
    public Object getLogEvent() {
        return this.m_logEvent;
    }

    @Override
    public void setLogEvent(Object event) {
        this.m_logEvent = event;
    }

    @Override
    public boolean isFromLog() {
        return this.m_logEvent != null;
    }

    synchronized void setVersion(byte version) {
        this.unprotectStaticHeader();
        StaticHeader.setVersion(version, this.m_staticHeader);
    }

    @Override
    public void setStatus(int value) {
        this.m_status = value;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    public void setDynamicHeaderCache(byte[] cache) {
        this.m_dynamicHeaderCache = cache;
        this.m_dynamicHeader = null;
    }

    public void setPayloadCache(byte[] cache) {
        this.m_payloadCache = cache;
        this.m_payload = null;
    }

    synchronized void createDynamicHeader() {
        if (this.m_dynamicHeader == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.m_dynamicHeaderCache);
            if (this.isSecure()) {
                throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
            }
            this.m_dynamicHeader = new DefaultDynamicHeader(this);
            try {
                this.m_dynamicHeader.initDynamicHeaderFromStream(bis, null, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_dynamicHeader.syncDynamicHeader();
            this.m_dynamicHeaderCache = null;
        }
    }

    synchronized void createPayload() {
        if (this.m_payload == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.m_payloadCache);
            this.m_payload = this.getPayloadObject(this.getType());
            try {
                this.m_payload.initPayloadFromStream(bis);
            }
            catch (EMgramFormatError e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_payload.syncPayload();
            this.m_payloadCache = null;
        }
    }

    @Override
    public boolean isFromRemoteBroker() {
        return this.m_fromRemoteBroker;
    }

    @Override
    public void setFromRemoteBroker(boolean fromRemoteBroker) {
        this.m_fromRemoteBroker = fromRemoteBroker;
    }

    @Override
    public synchronized void clearTransactionPublish() {
        this.unprotectStaticHeader();
        StaticHeader.setTxnPublish(false, this.m_staticHeader);
    }

    @Override
    public boolean isTransactionalPublish() {
        return StaticHeader.isTxnPublish(this.m_staticHeader);
    }

    @Override
    public boolean isTxnPublishFromLog() {
        return this.m_txnPublishFromLog;
    }

    @Override
    public void setTxnPublishFromLog(boolean value) {
        this.m_txnPublishFromLog = value;
    }

    @Override
    public synchronized void placeMessageKey(IMessageProtection mp, byte[] tempBuffer) {
        ProgressSecureRandom.theSecureRandom().nextBytes(tempBuffer);
        byte[] mk = new byte[mp.getSecretKeyLength()];
        System.arraycopy(tempBuffer, 0, mk, 0, mp.getSecretKeyLength());
        this.setMessageKey(mk);
    }

    @Override
    public synchronized void macHeaderWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.macPrimaryHeaderWithMessageKey(mp);
        if (this.supportsOperationHandle()) {
            this.getOperationHandle().macMgramListHeadersWithMessageKey(mp);
        }
    }

    synchronized void macPrimaryHeaderWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.createDynamicHeader();
        byte[] header = this.m_staticHeader;
        byte[] messageKey = this.m_dynamicHeader.getMessageKey();
        byte[] result = this.macByteArray(header, 8, messageKey, messageKey.length, mp);
        this.m_dynamicHeader.setMessageDigest(result);
    }

    @Override
    public synchronized byte[] macByteArray(byte[] buffer, int bufferLength, byte[] key, int keyLength, IMessageProtection mp) throws ESecurityGeneralException {
        int macLength = mp.getHashSize();
        byte[] result = new byte[macLength];
        mp.mac(key, 0, keyLength, buffer, 0, bufferLength, result, 0, macLength);
        return result;
    }

    @Override
    public boolean isTxnEOFMarker() {
        return this.getType() == -2;
    }

    @Override
    public boolean isTxnSavePointMarker() {
        return this.getType() == -3;
    }

    @Override
    public synchronized boolean isEncrypted() {
        this.createPayload();
        return this.m_payload.isEncrypted();
    }

    @Override
    public synchronized void encryptMessageKey(byte[] buffer, IMessageProtection mp) throws ESecurityGeneralException {
        System.arraycopy(this.getMessageKey(), 0, buffer, 0, this.getMessageKey().length);
        mp.encryptWithSessionKey(buffer, 0, this.getMessageKey().length, buffer, 0);
    }

    @Override
    public synchronized void encryptMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.createPayload();
        this.m_payload.encryptMessageWithMessageKey(mp);
    }

    @Override
    public synchronized void decryptMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.createPayload();
        this.m_payload.decryptMessageWithMessageKey(mp);
    }

    @Override
    public void setNextInTxn(IMgram m) {
        this.m_nextInTxn = m;
    }

    @Override
    public IMgram getNextInTxn() {
        return this.m_nextInTxn;
    }

    @Override
    public synchronized void setEnqueuedSize(int size) {
        this.m_enqueuedSizeSet = true;
        this.m_enqueuedSize = size;
    }

    @Override
    public synchronized void setTrackedSize(int value) {
        if (!this.m_trackedSizeSet) {
            this.m_trackedSizeSet = true;
            this.m_trackedSize = value;
        }
    }

    @Override
    public synchronized int getTrackedSize() {
        if (this.m_trackedSizeSet) {
            return this.m_trackedSize;
        }
        this.m_trackedSize = this.serializedLength();
        this.m_trackedSizeSet = true;
        return this.m_trackedSize;
    }

    @Override
    public synchronized boolean isTrackedSizeSet() {
        return this.m_trackedSizeSet;
    }

    @Override
    public boolean isDbTrackingSet() {
        return this.isGuarenteed() || this.m_dbTrackingSet;
    }

    @Override
    public long getDbTracking() {
        if (!this.isDbTrackingSet()) {
            throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
        }
        return this.isGuarenteed() ? this.getGuarenteedTrackingNum() : this.m_dbTracking;
    }

    @Override
    public void setDbTracking(long dbTracking) {
        this.m_dbTracking = dbTracking;
        this.m_dbTrackingSet = true;
    }

    @Override
    public boolean isGuarFormatIncorrect() {
        return this.m_guarFormatIncorrect;
    }

    @Override
    public void setGuarFormatIncorrect(boolean guarFormatIncorrect) {
        this.m_guarFormatIncorrect = guarFormatIncorrect;
    }

    @Override
    public boolean isEnqueuedSizeSet() {
        return this.m_enqueuedSizeSet;
    }

    @Override
    public synchronized void removeEnqueuedSize() {
        this.m_enqueuedSizeSet = false;
    }

    @Override
    public synchronized int getEnqueuedSize() {
        if (this.m_enqueuedSizeSet) {
            return this.m_enqueuedSize;
        }
        return this.getLimiterSize();
    }

    @Override
    public synchronized void setLimiterSizeIncrement(int size) {
        this.m_limiterSizeIncrement = size;
    }

    @Override
    public synchronized void markLimiterSize() {
        if (this.m_limiterSize == -1) {
            this.m_limiterSize = this.memoryLength() + this.m_limiterSizeIncrement;
        }
    }

    @Override
    public int getLimiterSize() {
        if (this.m_limiterSize == -1) {
            this.markLimiterSize();
        }
        return this.m_limiterSize;
    }

    @Override
    public synchronized void acknowledgeAndForward(IMessageProtection mp, IMgram ackForwardRequest) {
        this.setType((byte)12);
        this.getRoutingHandle().setGSAPublication(false);
        this.setPriority(ackForwardRequest.getPriority());
        this.setJMSPersistent(ackForwardRequest.isJMSPersistent());
        if (ackForwardRequest.isTTE()) {
            this.setTTE(ackForwardRequest.getTTE());
        }
        if (this.isSecure()) {
            this.setSecurityAttribute(ackForwardRequest.getSecurity());
        }
        this.setSubject(ackForwardRequest.getSubject(), ackForwardRequest.getSubjectFormat());
        this.getRoutingHandle().setRouting(ackForwardRequest.getRoutingHandle().getRouting());
        String origReplyTo = this.getSidebandData().getReplyTo();
        String newReplyTo = ackForwardRequest.getSidebandData().getReplyTo();
        if (origReplyTo != null && newReplyTo != null && origReplyTo.length() > 0 && newReplyTo.length() > 0) {
            this.getSidebandData().setReplyTo(ackForwardRequest.getSidebandData().getReplyTo());
        }
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof Mgram) {
            Mgram m = (Mgram)obj;
            if (m.equals(this)) {
                return true;
            }
            this.createPayload();
            if (this.m_payload.contains(m)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void acknowledgeAndForward(IMgram ackForwardRequest) {
        this.setLogEvent(null);
        this.setSenderID(ackForwardRequest.getBrokerHandle().getSenderID());
        this.setGuarenteed(ackForwardRequest.getGuarenteedTrackingNum());
    }

    public static Mgram createMgram(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(is, sis, mp, csc, null, null, tteTTLConvert);
    }

    public static Mgram createMgram(byte version, InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(version, is, sis, mp, csc, null, null, tteTTLConvert);
    }

    public static Mgram createMgram(byte version, InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, StreamUtilCounter sc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(version, is, sis, mp, csc, null, sc, tteTTLConvert);
    }

    public static Mgram createMgram(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, IMgramStatusListener listener, StreamUtilCounter sc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram((byte)-1, is, sis, mp, csc, listener, sc, tteTTLConvert);
    }

    public static final Mgram createMgramNonSecure(InputStream is, IMgramStatusListener listener, StreamUtilCounter sc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgramNonSecure((byte)-1, is, listener, sc, tteTTLConvert);
    }

    public static Mgram createMgram(byte version, InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, IMgramStatusListener listener, StreamUtilCounter sc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.setStatusListener(listener);
        mgram.initMgramFromStream(version, is, sis, mp, csc, tteTTLConvert, sc);
        return mgram;
    }

    public static Mgram createMgramNonSecure(byte version, InputStream is, IMgramStatusListener listener, StreamUtilCounter sc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.setStatusListener(listener);
        mgram.initMgramFromStream(version, is, null, null, null, tteTTLConvert, sc);
        return mgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() {
        PrintStream log = SessionConfig.getLog();
        try {
            PrintStream printStream = log;
            synchronized (printStream) {
                log.println("==========");
                log.println("Mgram Dump");
                log.println("==========");
                StaticHeader.dump(this.m_staticHeader);
                if (this.getType() != 4) {
                    this.createDynamicHeader();
                    this.m_dynamicHeader.dump();
                    this.createPayload();
                    this.m_payload.dump();
                    if (this.m_isTTE_TTL) {
                        log.println("TTE value is TTL");
                    } else {
                        log.println("TTE value is TTE");
                    }
                }
                log.println("==========");
            }
        }
        catch (Throwable e) {
            log.println("Error dumping mgram: " + e.toString());
        }
    }

    @Override
    public synchronized ObjectInput getPayloadInputStreamHandle() {
        this.createPayload();
        return this.m_payload.getPayloadInputStreamHandle();
    }

    @Override
    public synchronized ObjectOutput getPayloadOutputStreamHandle() {
        this.createPayload();
        return this.m_payload.getPayloadOutputStreamHandle();
    }

    @Override
    public final synchronized IOperationHandle getOperationHandle() {
        this.checkSupportsSubMgrams();
        this.createPayload();
        return this.m_payload.getOperationHandle();
    }

    @Override
    public final synchronized IBatchHandle getBatchHandle() {
        this.createPayload();
        return this.m_payload.getBatchHandle();
    }

    void checkSupportsSubMgrams() {
        if (this.getType() != 25 && this.getType() != 27) {
            throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
        }
    }

    @Override
    public IJMSClientHandle getJMSClientHandle() {
        return this;
    }

    @Override
    public ISaverOpHandle getSaverOpHandle() {
        this.createPayload();
        return this.m_payload.getSaverOpHandle();
    }

    @Override
    public boolean isJMSAsynchronous() {
        return this.m_isJMSAsynchronous;
    }

    @Override
    public void setJMSAsynchronous(boolean value) {
        this.m_isJMSAsynchronous = value;
    }

    @Override
    public void setPerMsgEncrypted(boolean value) {
        this.m_isPerMsgEncrypted = value;
    }

    @Override
    public boolean isPerMsgEncrypted() {
        return this.m_isPerMsgEncrypted;
    }

    @Override
    public void setConnection(Connection c) {
        this.m_zConnection = c;
    }

    @Override
    public Connection getConnection() {
        return this.m_zConnection;
    }

    @Override
    public void addSubjectFilter(long id, ISubjectFilter filter) {
        if (this.m_subjectFilters == null) {
            this.m_subjectFilters = new LongHashTable();
        }
        this.m_subjectFilters.put(id, filter);
    }

    @Override
    public ISubjectFilter getSubjectFilter(long id) {
        if (this.m_subjectFilters != null) {
            return (ISubjectFilter)this.m_subjectFilters.get(id);
        }
        return null;
    }

    @Override
    public LongHashTable getSubjectFilters() {
        return this.m_subjectFilters;
    }

    @Override
    public void setSubjectFilters(LongHashTable table) {
        this.m_subjectFilters = table;
    }

    @Override
    public void assignSubjectTrackingNumbers(long trk) {
        this.setSubject(this.getSubject().assignTrackingNumbers(trk, (byte)3), this.getSubjectFormat());
    }

    @Override
    public boolean hasStreamVersion() {
        return StaticHeader.hasStreamVersion(this.m_staticHeader);
    }

    @Override
    public byte getStreamVersion() {
        return StaticHeader.getStreamVersion(this.m_staticHeader);
    }

    @Override
    public byte getStreamFlags() {
        return StaticHeader.getStreamFlags(this.m_staticHeader);
    }

    @Override
    public void setStreamVersion(byte vers) {
        StaticHeader.setStreamVersion(vers, this.m_staticHeader);
    }

    @Override
    public void setStreamFlags(byte flags) {
        StaticHeader.setStreamFlags(flags, this.m_staticHeader);
    }

    @Override
    public void setCompressionEnabled(boolean b) {
        StaticHeader.setCompressionEnabled(b, this.m_staticHeader);
    }

    @Override
    public boolean isCompressionEnabled() {
        return StaticHeader.isCompressionEnabled(this.m_staticHeader);
    }

    @Override
    public byte getCompressionId() {
        return StaticHeader.getCompressionId(this.m_staticHeader);
    }

    @Override
    public void setCompressionId(byte id) {
        StaticHeader.setCompressionId(id, this.m_staticHeader);
    }

    @Override
    public void setNoOutqueueExpire(boolean value) {
        this.m_noOutqueueExpire = value;
    }

    @Override
    public boolean getNoOutqueueExpire() {
        return this.m_noOutqueueExpire;
    }

    @Override
    public RejectionTracker getRejectionTracker() {
        return this.m_rejectionTracker;
    }

    @Override
    public final void setRejectionTracker(RejectionTracker tracker) {
        this.m_rejectionTracker = tracker;
    }

    @Override
    public void setGroupSubscriptionCC(long id) {
        this.m_groupccid = id;
    }

    @Override
    public long getGroupSubscriptionCC() {
        return this.m_groupccid;
    }

    @Override
    public long getPtpEnqueueTime() {
        return this.m_ptpEnqTm;
    }

    @Override
    public void setPtpEnqueueTime(long tm) {
        this.m_ptpEnqTm = tm;
    }

    @Override
    public byte getReenqueueCount() {
        return this.m_reenqueues;
    }

    @Override
    public void setReenqueueCount(byte reenqueues) {
        this.m_reenqueues = reenqueues;
    }

    @Override
    public void setDeliveryCancelled() {
        this.m_deliveryCancelled = true;
    }

    @Override
    public boolean isDeliveryCancelled() {
        return this.m_deliveryCancelled;
    }
}

