/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.evs;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.strm.EvsInputStream;
import com.sonicsw.blackbird.evs.nio.nwlink.strm.EvsOutputStream;
import com.sonicsw.blackbird.evs.nio.nwlink.util.SelectableNetworkLinkResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressSocket;

public class ProgressEvsSocket
extends ProgressSocket {
    private static final boolean DEBUG = false;
    IEvsNetworkLink m_link = null;
    INetworkLinkConfig m_config = null;
    private EvsInputStream m_is;
    private EvsOutputStream m_os;

    public ProgressEvsSocket(IEvsNetworkLink link, INetworkLinkConfig config) throws IOException {
        this.m_link = link;
        this.m_config = config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void connect() throws IOException {
        try (Selector selector = null;){
            SelectableNetworkLinkResult result = new SelectableNetworkLinkResult();
            while (!this.m_link.connect(result)) {
                if (result.blockingOps == 0) continue;
                if (selector == null) {
                    selector = Selector.open();
                }
                try {
                    result.select(selector, false);
                }
                catch (ClosedSelectorException cse) {
                    IOException ioe = new IOException(cse.getMessage());
                    ioe.initCause(cse);
                    throw ioe;
                    return;
                }
            }
        }
    }

    @Override
    public InputStream getInputStream(int maxBufferSize, int minBufferSize, int initialBufferSize) throws IOException {
        this.m_is = this.m_is == null ? new EvsInputStream(this.m_link, maxBufferSize, minBufferSize, initialBufferSize) : this.m_is.createBufferedStream(maxBufferSize, minBufferSize, initialBufferSize);
        return this.m_is;
    }

    @Override
    public OutputStream getOutputStream(int maxBufferSize, int minBufferSize, int initialBufferSize) throws IOException {
        this.m_os = this.m_os == null ? new EvsOutputStream(this.m_link, maxBufferSize, minBufferSize, initialBufferSize) : this.m_os.createBufferedStream(maxBufferSize, minBufferSize, initialBufferSize);
        return this.m_os;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getInputStream(0, 0, 0);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(0, 0, 0);
    }

    @Override
    public long getKeepAliveTimeout() {
        return this.m_link.getKeepAlive();
    }

    @Override
    public void startTransportHandshake() throws IOException {
        this.connect();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void close() throws IOException {
        Selector selector = null;
        SelectableNetworkLinkResult result = new SelectableNetworkLinkResult();
        try {
            while (!this.m_link.close(result, false)) {
                if (result.blockingOps == 0) continue;
                if (selector == null) {
                    selector = Selector.open();
                }
                try {
                    result.select(selector, false);
                }
                catch (ClosedSelectorException cse) {
                    IOException ioe = new IOException(cse.getMessage());
                    ioe.initCause(cse);
                    throw ioe;
                    return;
                }
            }
        }
        catch (Throwable thrown) {
            Exception e;
            result.blockingOps = 0;
            try {
                this.m_link.close(result, true);
            }
            catch (EEvsIOException eeioe) {
                Exception e2 = eeioe.getExtendedException();
                if (e2 != null && e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                IOException ioe = new IOException(eeioe.getMessage());
                ioe.initCause(eeioe);
                throw ioe;
            }
            if (thrown != null && thrown instanceof IOException) {
                throw (IOException)thrown;
            }
            if (thrown instanceof EEvsIOException && (e = ((EEvsIOException)thrown).getExtendedException()) != null && e instanceof IOException) {
                throw (IOException)e;
            }
            IOException ioe = new IOException(thrown.getMessage());
            ioe.initCause(thrown);
            throw ioe;
        }
        finally {
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (Throwable thrown) {}
            try {
                if (this.m_os != null) {
                    this.m_os.close();
                }
            }
            catch (Throwable thrown) {}
            try {
                if (this.m_is != null) {
                    this.m_is.close();
                }
            }
            catch (Throwable thrown) {}
        }
    }

    @Override
    public int getPort() {
        return this.m_link.getRemotePort();
    }

    @Override
    public ProgressInetAddress getInetAddress() {
        return new ProgressInetAddress(this.m_link.getRemoteInetAddress());
    }

    @Override
    public int getLocalPort() {
        return this.m_link.getLocalPort();
    }

    @Override
    public ProgressInetAddress getLocalInetAddress() {
        return new ProgressInetAddress(this.m_link.getLocalInetAddress());
    }

    @Override
    public void setSoTimeout(int timeout) throws IOException {
    }

    @Override
    public String toString() {
        return this.m_config.getLinkType().toLowerCase() + "://" + this.m_config.getRemoteInterfaceAddress() + ":" + this.m_config.getRemotePort();
    }

    protected final void debug(String str, Throwable thrown) {
        if (thrown != null) {
            System.out.println(str + ", Related Exception: " + thrown.getMessage() + " (EvsSocket: " + this + " ) ");
            thrown.printStackTrace();
        } else {
            System.out.println(str + " (EvsSocket: " + this + " )");
        }
    }

    protected final void debug(String str) {
        this.debug(str, null);
    }
}

