/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security.cert;

import java.util.StringTokenizer;
import progress.message.security.cert.ECertificateException;
import progress.message.security.cert.prAccessor;

public class X500Name {
    private String country = null;
    private String state = null;
    private String locality = null;
    private String organization = null;
    private String organizationUnit = null;
    private String commonName = null;
    private String emailAddress = null;
    public static final int CN = 1;
    public static final int OU = 2;
    public static final int O = 3;
    public static final int L = 4;
    public static final int S = 5;
    public static final int C = 6;
    public static final int E = 7;
    private static String comma = ",";

    public X500Name(String dn) throws ECertificateException {
        try {
            StringTokenizer tok = new StringTokenizer(dn, ",");
            while (tok.hasMoreElements()) {
                String rdn = tok.nextToken();
                int index = rdn.indexOf("=");
                if (index == -1) continue;
                String oid = rdn.substring(0, index).trim();
                String value = rdn.substring(index + 1).trim();
                if ("CN".equalsIgnoreCase(oid)) {
                    this.setRDN(1, value);
                    continue;
                }
                if ("OU".equalsIgnoreCase(oid)) {
                    this.setRDN(2, value);
                    continue;
                }
                if ("O".equalsIgnoreCase(oid)) {
                    this.setRDN(3, value);
                    continue;
                }
                if ("L".equalsIgnoreCase(oid)) {
                    this.setRDN(4, value);
                    continue;
                }
                if ("S".equalsIgnoreCase(oid) || "ST".equalsIgnoreCase(oid)) {
                    this.setRDN(5, value);
                    continue;
                }
                if ("C".equalsIgnoreCase(oid)) {
                    this.setRDN(6, value);
                    continue;
                }
                if (!"E".equalsIgnoreCase(oid) && !"Email".equalsIgnoreCase(oid)) continue;
                this.setRDN(7, value);
            }
        }
        catch (Exception e) {
            String msg = prAccessor.getString(prAccessor.getString("STR141"));
            ECertificateException ce = new ECertificateException(msg + e.getMessage());
            ce.fillInStackTrace();
            throw ce;
        }
    }

    public final void setRDN(int oid, String value) throws ECertificateException {
        switch (oid) {
            case 6: {
                this.country = value;
                break;
            }
            case 5: {
                this.state = value;
                break;
            }
            case 4: {
                this.locality = value;
                break;
            }
            case 3: {
                this.organization = value;
                break;
            }
            case 2: {
                this.organizationUnit = value;
                break;
            }
            case 1: {
                this.commonName = value;
                break;
            }
            case 7: {
                this.emailAddress = value;
                break;
            }
            default: {
                String msg = prAccessor.getString(prAccessor.getString("STR142"));
                throw new ECertificateException(msg);
            }
        }
    }

    public String getRDN(int oid) throws ECertificateException {
        String value = null;
        switch (oid) {
            case 6: {
                value = this.country;
                break;
            }
            case 5: {
                value = this.state;
                break;
            }
            case 4: {
                value = this.locality;
                break;
            }
            case 3: {
                value = this.organization;
                break;
            }
            case 2: {
                value = this.organizationUnit;
                break;
            }
            case 1: {
                value = this.commonName;
                break;
            }
            case 7: {
                value = this.emailAddress;
                break;
            }
            default: {
                String msg = prAccessor.getString(prAccessor.getString("STR142"));
                throw new ECertificateException(msg);
            }
        }
        return value;
    }

    public String toString() {
        String ret = null;
        if (this.commonName != null) {
            ret = ret != null ? ret + comma : "";
            ret = ret + "CN=" + this.commonName;
        }
        if (this.emailAddress != null) {
            ret = ret != null ? ret + comma : "";
            ret = ret + "E=" + this.emailAddress;
        }
        if (this.organization != null) {
            ret = ret != null ? ret + comma : "";
            ret = ret + "O=" + this.organization;
        }
        if (this.organizationUnit != null) {
            ret = ret != null ? ret + comma : "";
            ret = ret + "OU=" + this.organizationUnit;
        }
        if (this.locality != null) {
            ret = ret != null ? ret + comma : "";
            ret = ret + "L=" + this.locality;
        }
        if (this.state != null) {
            ret = ret != null ? ret + comma : "";
            ret = ret + "S=" + this.state;
        }
        if (this.country != null) {
            ret = ret != null ? ret + comma : "";
            ret = ret + "C=" + this.country;
        }
        return ret;
    }
}

