/*
 * Decompiled with CFR 0.152.
 */
package progress.message.strm.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class CRCInputStream
extends FilterInputStream {
    private Checksum m_cksum;
    private boolean m_doCheck;
    private DebugObject m_debugObj;
    private boolean DEBUG;

    public CRCInputStream(InputStream in, Checksum cksum) {
        this(in, cksum, true);
    }

    public CRCInputStream(InputStream in, Checksum cksum, boolean doCheck) {
        super(in);
        this.m_cksum = cksum;
        this.m_doCheck = doCheck;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.m_debugObj = new DebugObject("CRCInputStream ");
            this.DEBUG = this.m_debugObj.getDebug();
        }
        if (this.DEBUG) {
            this.debug("CRCInputStream created doCheck= " + doCheck);
        }
    }

    public void setChecked(boolean value) {
        if (this.DEBUG) {
            this.debug("setChecked called: value= " + value + " Thread= " + Thread.currentThread());
        }
        this.m_doCheck = value;
    }

    public boolean isChecked() {
        return this.m_doCheck;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (this.m_doCheck && b != -1) {
            this.m_cksum.update(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        len = this.in.read(b, off, len);
        if (this.DEBUG) {
            this.debug("off= " + off + " len= " + len);
        }
        if (this.m_doCheck && len != -1) {
            this.m_cksum.update(b, off, len);
        }
        return len;
    }

    public Checksum getChecksum() {
        return this.m_cksum;
    }

    private void debug(String str) {
        this.m_debugObj.debug(str);
    }
}

