/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.Enumeration;
import progress.message.util.EDuplicateKey;
import progress.message.util.LinkedList;
import progress.message.util.ListNode;
import progress.message.util.LongHashTable;

public class IndexedList<V> {
    private LinkedList<V> m_list = new LinkedList();
    private LongHashTable<ListNode<V>> m_index = new LongHashTable();

    public synchronized ListNode<V> head() {
        return this.m_list.head();
    }

    public synchronized ListNode<V> append(long key, V obj) throws EDuplicateKey {
        if (this.m_index.containsKey(key)) {
            throw new EDuplicateKey();
        }
        ListNode<V> node = this.m_list.append(obj);
        this.m_index.put(key, (ListNode<ListNode<V>>)node);
        return node;
    }

    public synchronized ListNode<V> append(int key, V obj) throws EDuplicateKey {
        return this.append((long)key, obj);
    }

    public synchronized ListNode<V> append(Object key, V obj) throws EDuplicateKey {
        if (this.m_index.containsKey(key)) {
            throw new EDuplicateKey();
        }
        ListNode<V> node = this.m_list.append(obj);
        if (key instanceof Long) {
            this.m_index.put((Long)key, (ListNode<ListNode<V>>)node);
        } else {
            this.m_index.put(key.hashCode(), node);
        }
        return node;
    }

    public synchronized void appendNoDup(long key, V obj) {
        try {
            this.append(key, obj);
        }
        catch (EDuplicateKey e) {
            // empty catch block
        }
    }

    public synchronized void appendNoDup(int key, V obj) {
        this.appendNoDup((long)key, obj);
    }

    public synchronized void appendNoDup(Object key, V obj) {
        try {
            this.append(key, obj);
        }
        catch (EDuplicateKey eDuplicateKey) {
            // empty catch block
        }
    }

    public synchronized ListNode<V> prepend(long key, V obj) throws EDuplicateKey {
        if (this.m_index.containsKey(key)) {
            throw new EDuplicateKey();
        }
        ListNode<V> node = this.m_list.prepend(obj);
        this.m_index.put(key, (ListNode<ListNode<V>>)node);
        return node;
    }

    public synchronized void prependNoDup(long key, V obj) {
        try {
            this.prepend(key, obj);
        }
        catch (EDuplicateKey edk) {
            // empty catch block
        }
    }

    public synchronized ListNode<V> remove(long key) {
        ListNode<V> node = this.m_index.remove(key);
        this.m_list.remove(node);
        return node;
    }

    public synchronized ListNode<V> remove(int key) {
        return this.remove((long)key);
    }

    public synchronized ListNode<V> remove(Object key) {
        ListNode<V> node = this.m_index.remove(key);
        this.m_list.remove(node);
        return node;
    }

    public synchronized V get(long key) {
        ListNode<V> n = this.m_index.get(key);
        if (n == null) {
            return null;
        }
        return n.obj;
    }

    public synchronized V get(int key) {
        return this.get((long)key);
    }

    public synchronized V get(Object key) {
        ListNode<V> n = this.m_index.get(key);
        if (n == null) {
            return null;
        }
        return n.obj;
    }

    public synchronized Enumeration<V> elements() {
        return this.m_list.elements();
    }

    public synchronized Enumeration<V> elementsInReverse() {
        return this.m_list.elementsInReverse();
    }

    public synchronized int count() {
        return this.m_index.size();
    }

    public synchronized void clearList() {
        this.m_list.clearList();
        this.m_index.clear();
    }
}

