/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.client.EInterrupted;
import progress.message.client.ETimeout;
import progress.message.client.EUnsupportedMgramException;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramFactory;
import progress.message.strm.StreamFactory;
import progress.message.util.ArrayUtil;
import progress.message.util.AutoVec;
import progress.message.util.DebugState;
import progress.message.util.ICompressionFactory;
import progress.message.util.IDumpable;
import progress.message.util.LongHashTable;
import progress.message.util.OutputStreamWrapper;
import progress.message.util.capture.CaptureBuffer;
import progress.message.util.capture.CaptureOutputStream;
import progress.message.zclient.CDispatchListImpl;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Connection;
import progress.message.zclient.ConnectionContext;
import progress.message.zclient.ConnectionInfo;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ICDispatchList;
import progress.message.zclient.IDirectSender;
import progress.message.zclient.IDispatchable;
import progress.message.zclient.IErrorCodes;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.PayloadWrapper;
import progress.message.zclient.Publication;
import progress.message.zclient.Sender;
import progress.message.zclient.SessionConfig;

public class ClientSender
extends Sender
implements IErrorCodes,
IDirectSender {
    private static final String THREAD_NAME_PREFIX = "ClientSender";
    private static final int CMAX_CHANNELS_IN_DEF_DISPLIST = 100;
    private int MAX_CI_SEND_PER_CYCLE = 1;
    private boolean m_dataReceivedDuringPing;
    private boolean m_flushOnWrite = false;
    private AutoVec m_connections = new AutoVec();
    private ConnectionContext m_context = null;
    private boolean m_connDropped;
    private IMessageProtection m_mp = null;
    private LongHashTable m_qSenderState;
    private PingThread m_pingThread = null;
    private PingThread m_currentPingThread = null;
    private PingObject m_pingObject = new PingObject(false, 0L);
    private IMgramConverter m_converter;
    private ISecureOutputStream m_sos;
    private long m_monitorIntervalMillis = 0L;
    private long m_pingInterval = 0L;
    private long m_socketKeepAlive = 0L;
    private byte m_mgramVersion = (byte)26;
    private byte m_sessionVer = (byte)32;
    private final Connection m_parentConnection;
    private ICDispatchList m_dispatchList = null;
    private boolean m_resetDispatchClass = false;
    private boolean m_resetDispatchClassCompleted = false;
    private boolean m_isJMSConnection;
    private Throwable m_socketDropCause = null;
    private final boolean DIAG_MGRAM_HISTORY;
    private CaptureBuffer m_cb;
    private OutputStream m_socketStream;
    private OutputStreamWrapper m_compressionStreamWrapper = null;
    private boolean m_handShakeComplete = false;

    protected void setFlushOnWrite(boolean on) {
        this.m_flushOnWrite = on;
    }

    public ClientSender(Connection connection) throws IOException {
        super(THREAD_NAME_PREFIX, connection);
        super.debug(false);
        this.DIAG_MGRAM_HISTORY = (SessionConfig.DIAG_MGRAM_HISTORY || this.checkDebugFlags(8192)) && connection != Connection.getAdminConnection() && SessionConfig.matchCaptureFilterToUidAppid(connection.getEffectiveUid(), connection.getApplicationId());
        this.m_connections.setElementAt(connection.getConnectionInfo(), 0);
        this.setMonitorInterval(connection.getMonitorInterval());
        this.m_pingInterval = this.m_socketKeepAlive = connection.getKeepAliveTimeout();
        this.m_converter = MgramFactory.getMgramConverter(26);
        this.m_parentConnection = connection;
        this.m_dispatchList = new CDefaultDispatchList();
        this.m_isJMSConnection = this.m_parentConnection.getApplicationId().indexOf("$CONNECTION$") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectSuccess() {
        AutoVec autoVec = this.m_connections;
        synchronized (autoVec) {
            this.m_handShakeComplete = true;
        }
    }

    public void setMgramVersion(byte version) throws EUnsupportedMgramException {
        if (version != 26) {
            this.m_converter = MgramFactory.getMgramConverter(version);
        }
        this.m_mgramVersion = version;
    }

    public void setSessionVer(byte version) {
        this.m_sessionVer = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertStream(byte streamVersion, byte streamFlags, ICompressionFactory cf) throws IOException {
        if (this.DEBUG) {
            this.debug("ClientSender : about to call convertToSegmentedStream " + this.m_out);
        }
        OutputStream outputStream = this.m_out;
        synchronized (outputStream) {
            StreamFactory.setupSegmentedStream(this.m_socketStream, streamVersion, streamFlags, this.m_context.getSocket(), this.m_parentConnection.getMaxSendBufferSize(), this.m_parentConnection.getMinSendBufferSize(), this.m_parentConnection.getInitialSendBufferSize());
            if (cf != null) {
                OutputStream cos = cf.getDeflaterOutputStream(this.m_compressionStreamWrapper.getOutputStream(), this.m_parentConnection);
                this.m_compressionStreamWrapper.setOutputStream(cos);
            }
        }
    }

    public byte getMgramVersion() {
        return this.m_mgramVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void newChannel(Connection con, int channel) {
        int ct = 0;
        Object object = this.m_connections;
        synchronized (object) {
            if (channel != 0 && this.m_connections.elementAt(0) == null) {
                return;
            }
            this.m_connections.setElementAt(con.getConnectionInfo(), channel);
            ct = this.m_connections.numElements();
        }
        if (ct > 100) {
            object = this.m_enqueuedLock;
            synchronized (object) {
                if (!this.m_resetDispatchClass) {
                    this.m_resetDispatchClass = true;
                    this.notifySender();
                }
            }
        }
        if (this.m_qSenderState != null) {
            this.m_qSenderState.remove((long)channel);
        }
    }

    public IMessageProtection getMessageProtection() {
        return this.m_mp;
    }

    void removeChannel(int channel) {
        ConnectionInfo ci = (ConnectionInfo)this.m_connections.elementAt(channel);
        this.m_connections.setElementAt(null, channel);
        if (ci != null) {
            this.m_dispatchList.remove(ci);
        }
    }

    public synchronized boolean kill(boolean sync, int channel, boolean fromErrorThatCausesReconnect) {
        boolean stillOpen = false;
        try {
            stillOpen = this.kill(sync, channel, false, fromErrorThatCausesReconnect);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return stillOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean kill(boolean sync, int channel, boolean interruptOk, boolean fromErrorThatCausesReconnect) throws InterruptedException {
        boolean interrupted = false;
        if (this.DEBUG) {
            this.debug("stop sending on channel " + channel);
        }
        this.removeChannel(channel);
        if (this.m_connections.numElements() == 0) {
            Object object = this.m_pingObject;
            synchronized (object) {
                this.m_pingObject.enabled(false);
                if (this.m_pingThread != null && !this.m_parentConnection.isRecoveryInitiatingThread(this.m_pingThread.getThread())) {
                    this.m_pingThread.kill();
                    this.m_pingThread = null;
                }
            }
            if (this.m_parentConnection.isRecoveryInitiatingThread(this)) {
                return false;
            }
            if (sync) {
                object = this.m_enqueuedLock;
                synchronized (object) {
                    while (!interrupted && this.m_msgEnqueued && this.isAlive()) {
                        try {
                            this.m_enqueuedLock.wait(60000L);
                        }
                        catch (InterruptedException e) {
                            if (!interruptOk) continue;
                            interrupted = true;
                        }
                    }
                }
                object = this.m_dequeuedLock;
                synchronized (object) {
                    while (!interrupted && !this.m_allDequeued && this.isAlive()) {
                        try {
                            this.m_dequeuedLock.wait(60000L);
                        }
                        catch (InterruptedException e) {
                            if (!interruptOk) continue;
                            interrupted = true;
                        }
                    }
                }
            }
            if (this.DEBUG) {
                this.debug("thread exiting");
            }
            this.interrupt();
            if (interrupted) {
                throw new InterruptedException();
            }
            return false;
        }
        return true;
    }

    void clearPing() {
        this.m_dataReceivedDuringPing = true;
    }

    void setupSecurity(IMessageProtection mp, byte[] sessionKey) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.m_mp = mp;
        this.m_mp.init(1, sessionKey);
        byte[] buffer = this.m_mp.isSonicCipherSuite() ? new byte[SessionConfig.IO_SECURITY_BUFFER_SIZE] : null;
        Class<?> sosClass = Class.forName(this.m_mp.isSonicCipherSuite() ? "progress.message.crypto.SecureOutputStream" : "com.sonicsw.security.pcs.PluggableSecureOutputStream");
        this.m_sos = (ISecureOutputStream)sosClass.newInstance();
        this.m_sos.initSecureOutputStream(this.m_out, this.m_mp, buffer);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put(MgramConstants.MESSAGE_PROTECTION, this.m_mp);
        props.put(MgramConstants.SECURE_OUTPUT_STREAM, this.m_sos);
        this.m_converter.initializeConverter(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsyncPingInterval(long interval) {
        if (this.m_socketKeepAlive > 0L) {
            if (interval > 0L) {
                this.m_pingInterval = Math.min(interval * 1000L, this.m_socketKeepAlive);
            }
        } else {
            this.m_pingInterval = interval * 1000L;
        }
        Object object = this.m_enqueuedLock;
        synchronized (object) {
            this.m_enqueuedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSyncPingInterval(long interval) {
        ConnectionContext conn = this.m_context;
        PingObject pingObject = this.m_pingObject;
        synchronized (pingObject) {
            ConnectionInfo ci = (ConnectionInfo)this.m_connections.elementAt(0);
            if (ci == null) {
                return;
            }
            if (this.m_pingThread == null) {
                this.m_currentPingThread = this.m_pingThread = new PingThread(this.m_pingObject, "Ping Thread for " + ci.getConnection());
            }
            if (interval <= 0L) {
                this.m_pingObject.enabled(false);
                conn.getClientListener().setPingState(false);
            } else {
                this.m_pingObject.enabled(true);
                this.m_pingObject.setPingInterval(interval * 1000L);
                conn.getClientListener().setPingState(true);
            }
            this.m_pingObject.notifyAll();
        }
    }

    Thread getPingThread() {
        if (this.m_currentPingThread != null) {
            return this.m_currentPingThread.getThread();
        }
        return null;
    }

    public IMgram ack(long trkNum, IMgram ack) {
        int channel = ack.getChannel();
        ConnectionInfo ci = (ConnectionInfo)this.m_connections.elementAt(channel);
        if (ci == null) {
            return null;
        }
        return ci.ack(trkNum, ack);
    }

    public boolean isAsyncDelivery(long tracking, IMgram m) {
        int channel = m.getChannel();
        ConnectionInfo ci = (ConnectionInfo)this.m_connections.elementAt(channel);
        boolean async = false;
        async = ci.isAsyncDelivery(tracking);
        return async;
    }

    public void notifyBlockedSenders(int channel) {
        ConnectionInfo ci = (ConnectionInfo)this.m_connections.elementAt(channel);
        if (ci == null) {
            return;
        }
        ci.notifyBlockedSenders();
    }

    public PayloadWrapper removeNackedMsg(long trkNum, IMgram m) {
        int channel = m.getChannel();
        ConnectionInfo ci = (ConnectionInfo)this.m_connections.elementAt(channel);
        if (ci == null) {
            return null;
        }
        return ci.removeNackedMsg(trkNum);
    }

    @Override
    public void setMinSendPriority(int prio, int channel) {
        ConnectionInfo ci = (ConnectionInfo)this.m_connections.elementAt(channel);
        if (ci == null) {
            return;
        }
        ci.setMinSendPriority(prio);
        this.notifyMsgEnqueued(ci);
    }

    @Override
    public void sendDirect(IMgram mg) {
        this.send(mg);
    }

    @Override
    public void send(IMgram mg) {
        ConnectionInfo ci = (ConnectionInfo)this.m_connections.elementAt(mg.getChannel());
        if (ci == null) {
            return;
        }
        ci.send(mg);
    }

    public void notifyMsgEnqueued(IDispatchable ci) {
        this.notifyMsgEnqueued(ci, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMsgEnqueued(IDispatchable ci, boolean okToDelay) {
        Object object = this.m_enqueuedLock;
        synchronized (object) {
            if (!okToDelay || this.m_flushOnWrite) {
                this.m_canDelayFlush = false;
            }
            this.m_msgEnqueued = true;
            if (ci != null) {
                this.m_dispatchList.addDispatchable(ci);
            }
            this.m_enqueuedLock.notifyAll();
        }
    }

    private void switchDispatchList() throws IOException {
        CDispatchListImpl dispatchList = new CDispatchListImpl();
        IDispatchable disp = this.m_dispatchList.startDispatch();
        while (disp != null) {
            dispatchList.addDispatchable(disp);
            disp = this.m_dispatchList.getNextDispatchable(disp, false);
        }
        this.m_dispatchList.removeAll();
        this.m_dispatchList = dispatchList;
        this.MAX_CI_SEND_PER_CYCLE = 10;
        if (this.checkDebugFlags(64)) {
            this.debug("Switched DispatchList to " + this.m_dispatchList.getClass().getName() + " MAX_CI_SEND_PER_CYCLE= " + this.MAX_CI_SEND_PER_CYCLE);
        }
    }

    private void monitor() {
        for (int channel = 0; channel < this.m_connections.size(); ++channel) {
            String appid;
            ConnectionInfo ci = (ConnectionInfo)this.m_connections.elementAt(channel);
            if (ci == null || !SessionConfig.isJMSSession(appid = ci.getConnection().getApplicationId())) continue;
            ci.monitor();
        }
    }

    public void setConnectionContext(ConnectionContext context) throws IOException {
        this.m_context = context;
        this.m_out = this.m_socketStream = StreamFactory.getSenderOutputStream(this.m_context.getSocket(), this.m_parentConnection.getMaxSendBufferSize(), this.m_parentConnection.getMinSendBufferSize(), this.m_parentConnection.getInitialSendBufferSize(), this.m_isJMSConnection);
        if (this.DEBUG) {
            this.debug("ClientSender: created OutputStream " + this.m_out);
        }
        if (this.m_isJMSConnection && this.m_parentConnection.getCompressionFactory() != null) {
            this.m_compressionStreamWrapper = new OutputStreamWrapper(this.m_socketStream);
            this.m_out = this.m_compressionStreamWrapper;
        }
        if (this.DIAG_MGRAM_HISTORY) {
            CaptureOutputStream cos = new CaptureOutputStream(this.m_out, SessionConfig.SENDER_CAPTURE_BUFFER_SIZE);
            this.m_cb = cos.getCaptureBuffer();
            this.m_out = cos;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void threadMain() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [47[CATCHBLOCK]], but top level block is 15[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupAll() {
        ConnectionInfo parent = null;
        boolean handShaking = false;
        AutoVec autoVec = this.m_connections;
        synchronized (autoVec) {
            parent = (ConnectionInfo)this.m_connections.elementAt(0);
            handShaking = !this.m_handShakeComplete;
            AutoVec cloned = new AutoVec();
            for (int i = 0; i < this.m_connections.size(); ++i) {
                Object o = this.m_connections.elementAt(i);
                if (o == null) continue;
                cloned.setElementAt(o, i);
            }
            Enumeration enu = cloned.elements();
            while (enu.hasMoreElements()) {
                ConnectionInfo ci = (ConnectionInfo)enu.nextElement();
                if (ci == null) continue;
                Connection con = ci.getConnection();
                int channel = con.getChannel();
                this.m_connections.setElementAt(null, channel);
                if (this.m_connections.numElements() != 0) continue;
                try {
                    this.m_context.getSocket().close();
                }
                catch (Exception e) {}
            }
        }
        if (parent != null && !handShaking) {
            parent.getConnection().socketDropped(-5, 0, this.m_context, this.m_socketDropCause);
        }
    }

    public void setThreadName() {
        String brokerUrl = "url unavailable";
        try {
            brokerUrl = this.m_parentConnection.getBrokerURL();
        }
        catch (Throwable t) {
            // empty catch block
        }
        String threadName = "ClientSender " + this.m_parentConnection;
        if (this.m_parentConnection != Connection.getAdminConnection()) {
            threadName = threadName + " (" + brokerUrl + ")";
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName(threadName);
        }
        try {
            this.setName(threadName);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMonitorInterval(int secs) {
        if (secs >= 0) {
            long millis = secs * 1000;
            Object object = this.m_enqueuedLock;
            synchronized (object) {
                if (millis != this.m_monitorIntervalMillis) {
                    this.m_monitorIntervalMillis = millis;
                    this.m_enqueuedLock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpMgramHistory() {
        if (this.m_out instanceof IDumpable) {
            ClientSecurityContext csc;
            StringBuffer buf = new StringBuffer();
            buf.append("Sender History Dump:\n");
            buf.append("CSC:\n");
            Connection c = this.m_parentConnection;
            if (c != null && (csc = c.getSecurityContext()) != null) {
                csc.dump(buf);
            }
            OutputStream outputStream = this.m_out;
            synchronized (outputStream) {
                ((IDumpable)((Object)this.m_out)).dump(buf);
            }
            SessionConfig.logMessage(buf.toString(), SessionConfig.SEVERE);
        } else {
            SessionConfig.logMessage("Sender output not dumpable: " + this.m_out, SessionConfig.SEVERE);
        }
    }

    class CDefaultDispatchList
    extends DebugObject
    implements ICDispatchList {
        private long m_numStartDispatch;
        private long m_loops;
        private int m_nextIndx;
        private int m_reenqueued;

        public CDefaultDispatchList(String ident) {
            super(DebugState.GLOBAL_DEBUG_ON ? "CDefaultDispatchList " + ident : null);
            if (this.DEBUG && ident == null) {
                this.debugNameHelper("CDefaultDispatchList " + this.hashCodeHelper());
            }
            if (this.DEBUG) {
                this.debug("Constructed");
            }
        }

        private void debugNameHelper(String string) {
            this.debugName(string);
        }

        private int hashCodeHelper() {
            return this.hashCode();
        }

        public CDefaultDispatchList() {
            this(null);
        }

        @Override
        public final boolean addDispatchable(IDispatchable obj) {
            return true;
        }

        public final int getSize() {
            return ClientSender.this.m_connections.size();
        }

        @Override
        public final void remove(IDispatchable obj) {
        }

        @Override
        public final void removeAll() {
        }

        @Override
        public final IDispatchable startDispatch() {
            IDispatchable obj = this.startLoop();
            if (this.DEBUG) {
                this.startDispatchCtr();
            }
            return obj;
        }

        private IDispatchable startLoop() {
            this.m_nextIndx = 0;
            this.m_reenqueued = 0;
            if (this.DEBUG) {
                this.loopCtr();
            }
            IDispatchable obj = this.findNextDispatchable();
            return obj;
        }

        private IDispatchable findNextDispatchable() {
            IDispatchable obj = null;
            while (this.m_nextIndx < ClientSender.this.m_connections.size()) {
                obj = (IDispatchable)ClientSender.this.m_connections.elementAt(this.m_nextIndx);
                ++this.m_nextIndx;
                if (obj == null) continue;
                break;
            }
            return obj;
        }

        @Override
        public final IDispatchable getNextDispatchable(IDispatchable last, boolean reenqueue) {
            IDispatchable obj = null;
            if (reenqueue) {
                ++this.m_reenqueued;
            }
            if ((obj = this.findNextDispatchable()) == null && this.m_reenqueued > 0) {
                obj = this.startLoop();
            }
            return obj;
        }

        final void setIdent(String ident) {
            this.debugName("CDefaultDispatchList " + ident);
        }

        private void startDispatchCtr() {
            ++this.m_numStartDispatch;
            this.printCounts();
        }

        private void loopCtr() {
            ++this.m_loops;
            this.printCounts();
        }

        private void printCounts() {
            if (this.m_numStartDispatch == 100000L) {
                this.debug("Num cycles= " + this.m_numStartDispatch + "; numloops= " + this.m_loops);
                this.m_numStartDispatch = 0L;
                this.m_loops = 0L;
            }
        }
    }

    private class PingThread
    implements Runnable {
        boolean DEBUG = false;
        volatile boolean stayAlive = true;
        Thread m_thread = null;
        PingObject m_ping = null;

        PingThread(PingObject sync, String name) {
            this.m_ping = sync;
            this.m_thread = new Thread((Runnable)this, name);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }

        Thread getThread() {
            return this.m_thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionInfo ci;
            if (this.DEBUG) {
                System.out.println("starting the ping thread ...");
            }
            if ((ci = (ConnectionInfo)ClientSender.this.m_connections.elementAt(0)) == null) {
                return;
            }
            Connection conn = ci.getConnection();
            ClientSender.this.m_context.getClientListener().setPingState(true);
            try {
                long endtime = 0L;
                long interval = 0L;
                while (this.stayAlive && ClientSender.this.m_connections.size() != 0) {
                    long sleepTime;
                    block22: {
                        PingObject pingObject = this.m_ping;
                        synchronized (pingObject) {
                            while (!this.m_ping.isEnabled()) {
                                this.m_ping.wait();
                            }
                            interval = this.m_ping.interval();
                        }
                        if (this.DEBUG) {
                            System.out.println("pinging the broker");
                        }
                        long tracking = conn.genPubTrackingNum();
                        if (this.DEBUG) {
                            System.out.println("ping tracking number is " + tracking);
                        }
                        Publication p = new Publication(conn, null);
                        conn.addJob(tracking, p);
                        byte[] payload = new byte[8];
                        ArrayUtil.writeLong(payload, 0, tracking);
                        ClientSender.this.m_dataReceivedDuringPing = false;
                        ClientSender.this.send(MgramFactory.getMgramFactory().buildPingRequest(payload, 0));
                        if (this.DEBUG) {
                            System.out.println("waiting for ping response from the broker allow " + interval + " ms");
                        }
                        endtime = System.currentTimeMillis() + interval;
                        try {
                            p.joinMillis(interval);
                            if (this.DEBUG) {
                                System.out.println("received ping response from the broker");
                            }
                        }
                        catch (ETimeout ex) {
                            if (this.DEBUG) {
                                System.out.println("ping request timed out after " + interval + " milliseconds");
                            }
                            if (ClientSender.this.m_dataReceivedDuringPing) break block22;
                            this.kill();
                            Thread.currentThread();
                            Thread.interrupted();
                            ClientSender.this.m_socketDropCause = ex;
                            ClientSender.this.cleanupAll();
                            break;
                        }
                        catch (EInterrupted ei) {
                            conn.removeJob(tracking);
                            throw new InterruptedException();
                        }
                        catch (Exception ex) {
                            if (!this.DEBUG) break block22;
                            SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
                        }
                    }
                    if ((sleepTime = endtime - System.currentTimeMillis()) <= 0L) continue;
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException e) {
                if (this.DEBUG) {
                    SessionConfig.logMessage(e, SessionConfig.getLevelInfo());
                }
            }
            finally {
                ClientSender.this.m_context.getClientListener().setPingState(false);
            }
        }

        synchronized void kill() {
            if (this.stayAlive) {
                this.stayAlive = false;
                this.m_thread.interrupt();
            }
        }
    }

    private class PingObject {
        boolean m_state;
        long m_interval;

        PingObject(boolean state, long interval) {
            this.m_state = state;
            this.m_interval = interval;
        }

        void enabled(boolean state) {
            this.m_state = state;
        }

        boolean isEnabled() {
            return this.m_state;
        }

        void setPingInterval(long interval) {
            this.m_interval = interval;
        }

        long interval() {
            return this.m_interval;
        }
    }
}

