/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.client.EGeneralException;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.prAccessor;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.util.IndexedList;
import progress.message.util.ListNode;
import progress.message.zclient.ClientData;
import progress.message.zclient.Connection;
import progress.message.zclient.ConnectionListener;
import progress.message.zclient.DebugThread;

public class ConnectionManager
extends DebugThread {
    private String[] _hosts = null;
    private boolean _enableLoadBalancing = false;
    private boolean _enableRandomize = false;
    private int[] _randomFactors = null;
    private ClientData _clientData = null;
    private IHttpProxyConfig _pConfig;
    private IndexedList _tunnels = new IndexedList();
    private Hashtable<Connection, ConnectionListener> _listeners = new Hashtable();
    private Connection _connection = null;
    private boolean _running = false;
    private long _reconnectInterval = 30000L;
    private long _reconnectTimeout = 0L;
    private boolean _waitForStart;

    public ConnectionManager(Connection connection) {
        super("ConnectionManager");
        this._connection = connection;
        this._connection.setDisableConnectException(true);
        this._connection.setFollowRedirect(true);
    }

    public synchronized void requestConnect(String[] hosts, boolean enableLoadBalancing, boolean enableRandomize, int[] randomFactors, ClientData clientdata, IHttpProxyConfig pConfig) throws EGeneralException {
        this.requestConnect(hosts, enableLoadBalancing, enableRandomize, randomFactors, clientdata, pConfig, false);
    }

    public synchronized void requestConnect(String[] hosts, boolean enableLoadBalancing, boolean enableRandomize, int[] randomFactors, ClientData clientdata, IHttpProxyConfig pConfig, boolean useConnectThread) throws EGeneralException {
        if (useConnectThread) {
            this._waitForStart = true;
        }
        this._hosts = hosts;
        this._enableLoadBalancing = enableLoadBalancing;
        this._enableRandomize = enableRandomize;
        this._randomFactors = randomFactors;
        this._clientData = clientdata;
        this._pConfig = pConfig;
        if (!useConnectThread) {
            this._connection.connect(this._hosts, this._enableLoadBalancing, this._enableRandomize, this._randomFactors, this._clientData, pConfig);
            if (this._connection.getBrokerSessionVer() < 23) {
                throw new EBrokerVersionMismatch(prAccessor.getString("VERSION_MISMATCH"), (int)this._connection.getBrokerSessionVer(), 32);
            }
            ConnectionListener listener = this._listeners.get(this._connection);
            if (listener != null && this._connection.isConnected()) {
                listener.connected(this._connection);
            }
        } else {
            this._connection.initCon0Data(this._hosts[0]);
        }
        this.startReconnectThread();
    }

    public synchronized void enableConnect() {
        this._waitForStart = false;
    }

    synchronized void startReconnectThread() {
        if (!this._running) {
            this._running = true;
            this.start();
        }
    }

    public synchronized void stopReconnectThread() {
        this._running = false;
        try {
            this.interrupt();
            this.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void setConnectionListener(ConnectionListener l, Connection c) {
        this._listeners.put(c, l);
    }

    public synchronized void removeConnectionListener(Connection c) {
        this._listeners.remove(c);
    }

    public synchronized boolean requestConnect(String host, boolean useConnectThread) throws EGeneralException {
        this._hosts = new String[]{host};
        this._enableLoadBalancing = false;
        this._enableRandomize = false;
        this._randomFactors = null;
        this._clientData = null;
        this._pConfig = null;
        boolean rc = false;
        if (!useConnectThread) {
            rc = this._connection.connect(host);
            if (rc && this._connection.getBrokerSessionVer() < 23) {
                throw new EBrokerVersionMismatch(prAccessor.getString("VERSION_MISMATCH"), (int)this._connection.getBrokerSessionVer(), 32);
            }
            ConnectionListener listener = this._listeners.get(this._connection);
            if (listener != null && rc) {
                listener.connected(this._connection);
            }
        } else {
            this._connection.initCon0Data(this._hosts[0]);
        }
        this.startReconnectThread();
        return rc;
    }

    public synchronized boolean requestConnect(String host) throws EGeneralException {
        return this.requestConnect(host, false);
    }

    public synchronized void requestTunnel(Connection child) throws EGeneralException {
        this.requestTunnel(child, this._connection.getClientId());
    }

    public synchronized void requestTunnel(Connection child, long parentID) throws EGeneralException {
        ConnectionListener listener;
        this._tunnels.appendNoDup(child, child);
        if (this.DEBUG) {
            this.debug("requestTunnel: added Tunnel " + child.getApplicationId() + " parentAppid= " + this._connection.getApplicationId() + " numTunnels= " + this._tunnels.count());
        }
        if (this.DEBUG && parentID != this._connection.getClientId()) {
            this.debug("requestTunnel: *********** parentID != _connection.getClientId() parentID= " + parentID + " _connection.getClientId()= " + this._connection.getClientId());
        }
        if (this._connection.isConnected()) {
            try {
                if (this.CALLBACK) {
                    this.callback("ConnectionManager", 2, new Object[]{this._connection, new Integer(this._tunnels.count())});
                }
                child.connect(this._connection, this._connection.getClientId());
            }
            catch (ENetworkFailure enf) {
                // empty catch block
            }
        }
        if ((listener = this._listeners.get(child)) != null && child.isConnected()) {
            listener.connected(child);
        }
    }

    private void preAssignDelegateManagedData(Connection child) {
        child.assignChannelAddresses(this._connection);
    }

    public synchronized void requestSetSyncPingInterval(long interval) {
        this._connection.setSyncPingInterval(interval);
    }

    public synchronized void requestSetAsyncPingInterval(long interval) {
        this._connection.setAsyncPingInterval(interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestDisconnect(boolean forced) throws EGeneralException {
        this._hosts = null;
        this._tunnels.clearList();
        try {
            this._connection.disconnect(forced);
            ConnectionListener listener = this._listeners.get(this._connection);
            if (listener != null) {
                listener.disconnected(this._connection, null, 0);
            }
        }
        catch (ENotConnected eNotConnected) {
        }
        finally {
            this.stopReconnectThread();
        }
    }

    public synchronized void requestTunnelClosed(Connection child, boolean forced) throws EGeneralException {
        ListNode obj = this._tunnels.remove(child);
        if (this.DEBUG) {
            if (obj != null) {
                this.debug("requestTunnelClosed: removed Tunnel " + child.getApplicationId());
            } else {
                this.debug("requestTunnelClosed: Tunnel not found " + child.getApplicationId());
            }
        }
        try {
            child.disconnect(forced);
            ConnectionListener listener = this._listeners.get(child);
            if (listener != null) {
                listener.disconnected(child, null, 0);
            }
        }
        catch (ENotConnected e) {
            // empty catch block
        }
    }

    public void setReconnectInterval(long ms) {
        this._reconnectInterval = ms;
    }

    public long getReconnectInterval() {
        return this._reconnectInterval;
    }

    public void setReconnectTimeout(long ms) {
        this._reconnectTimeout = ms;
    }

    public long getReconnectTimeout() {
        return this._reconnectTimeout;
    }

    private boolean checkForReconnectTimeout(long lastKnownGoodConnectTime) {
        if (this._reconnectTimeout == 0L) {
            return false;
        }
        long delta = System.currentTimeMillis() - lastKnownGoodConnectTime;
        return delta > this._reconnectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() {
        long lastKnownGoodConnectTime = System.currentTimeMillis();
        while (this._running) {
            try {
                Thread.sleep(this._reconnectInterval);
                ConnectionManager connectionManager = this;
                synchronized (connectionManager) {
                    if (!this._running) {
                        break;
                    }
                    if (this._waitForStart) {
                        lastKnownGoodConnectTime = System.currentTimeMillis();
                        continue;
                    }
                    String connAppidBeforeConnect = this._connection.getApplicationId();
                    if (this._hosts != null && !this._connection.isConnected()) {
                        ConnectionListener listener;
                        this._connection.connect(this._hosts, this._enableLoadBalancing, this._enableRandomize, this._randomFactors, this._clientData, this._pConfig);
                        if (this._connection.getBrokerSessionVer() < 23) {
                            throw new EBrokerVersionMismatch(prAccessor.getString("VERSION_MISMATCH"), (int)this._connection.getBrokerSessionVer(), 32);
                        }
                        if (this.DEBUG && this._connection.isConnected()) {
                            this.debug("connected con0: chan= " + this._connection.getChannel() + " appidBeforeConnect= " + connAppidBeforeConnect + " appidAfterConnect= " + this._connection.getApplicationId());
                        }
                        if ((listener = this._listeners.get(this._connection)) != null && this._connection.isConnected()) {
                            listener.connected(this._connection);
                        }
                    }
                    if (!this._connection.isConnected()) {
                        if (this.checkForReconnectTimeout(lastKnownGoodConnectTime)) {
                            throw new EGeneralException(-1, prAccessor.getString("CONNECTION_MANAGER_TIMEOUT"));
                        }
                        continue;
                    }
                    lastKnownGoodConnectTime = System.currentTimeMillis();
                    Enumeration tunnels = this._tunnels.elements();
                    while (tunnels.hasMoreElements()) {
                        ConnectionListener listener;
                        Connection tunnel = (Connection)tunnels.nextElement();
                        String appid = tunnel.getApplicationId();
                        int channel = tunnel.getChannel();
                        if (!this._connection.isConnected() || tunnel.isConnected()) continue;
                        boolean retry = false;
                        tunnel.connect(this._connection, this._connection.getClientId());
                        if (this.DEBUG && tunnel.isConnected()) {
                            this.debug("connected tunnel; chanBeforeConnect= " + channel + " appidBeforeConnect= " + appid + " channel= " + tunnel.getChannel() + " tunnelAppid= " + tunnel.getApplicationId());
                        }
                        if ((listener = this._listeners.get(tunnel)) == null || !tunnel.isConnected()) continue;
                        listener.connected(tunnel);
                    }
                }
            }
            catch (ENetworkFailure enf) {
            }
            catch (InterruptedException ie) {
                if (this._running) continue;
                return;
            }
            catch (EGeneralException e) {
                ConnectionListener listener = this._listeners.get(this._connection);
                if (listener == null) continue;
                listener.disconnected(this._connection, e.toString(), -1);
            }
        }
    }
}

