/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.applet.Applet;
import java.security.Principal;
import java.util.Hashtable;
import progress.message.client.EDefaultHandlerNotSet;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidUserId;
import progress.message.client.ENetworkFailure;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.msg.IMgram;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.zclient.ClientData;
import progress.message.zclient.ClientQopCache;
import progress.message.zclient.Connection;
import progress.message.zclient.ConnectionListener;
import progress.message.zclient.ConnectionManager;
import progress.message.zclient.EFlowControlException;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.IMgramEnqueuedToSendListener;
import progress.message.zclient.ISubject;
import progress.message.zclient.Job;
import progress.message.zclient.LightweightAddrUtil;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Request;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Solicitation;
import progress.message.zclient.Subscription;

public abstract class DelegatingConnection
extends Connection {
    private Connection _delegate = null;
    private ConnectionManager _delegateConnectionManager = null;
    private long _reconnectInterval = 30000L;
    private long _reconnectTimeout = 0L;
    private ConnectionListener _listener = null;
    private long _clientId = 0L;
    private long _desiredSyncPingInterval = -1L;
    private long _desiredAsyncPingInterval = -1L;

    public void setDelegateConnectionListener(ConnectionListener l) {
        this._listener = l;
    }

    public ConnectionListener getDelegateConnectionListener() {
        return this._listener;
    }

    public boolean delegateConnected() {
        return this._delegate != null && this._delegate.isConnected();
    }

    public final Connection getDelegate() {
        return this._delegate;
    }

    public ConnectionManager getDelegateManager() {
        return this._delegateConnectionManager;
    }

    public void setReconnectInterval(long ms) {
        this._reconnectInterval = ms;
    }

    public long getReconnectInterval() {
        return this._reconnectInterval;
    }

    public void setReconnectTimeout(long ms) {
        this._reconnectTimeout = ms;
    }

    public long getReconnectTimeout() {
        return this._reconnectTimeout;
    }

    @Override
    public long genPubTrackingNum() {
        return this._delegate.genPubTrackingNum();
    }

    @Override
    public void addJob(long jid, Job j) {
        this._delegate.addJob(jid, j);
    }

    @Override
    public Job getJob(long jid) {
        return this._delegate.getJob(jid);
    }

    @Override
    public Job removeJob(long jid) {
        return this._delegate.removeJob(jid);
    }

    @Override
    Object removeJobClass(long jid, Class c) {
        return this._delegate.removeJobClass(jid, c);
    }

    @Override
    public void terminateJob(long tracking, int status) {
        this._delegate.terminateJob(tracking, status);
    }

    @Override
    void terminateSyncOps(int i) {
        this._delegate.terminateSyncOps(i);
    }

    @Override
    public void resolveJob(Job j) {
        this._delegate.resolveJob(j);
    }

    @Override
    public int addRequest(Job j) {
        return this._delegate.addRequest(j);
    }

    @Override
    public synchronized Solicitation[] getSolicitations() throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        throw new RuntimeException("DelegatingConnection.getSolicitations(): unsupported");
    }

    @Override
    public Solicitation getSolicitation(Envelope e) {
        throw new RuntimeException("DelegatingConnection.getSolicitation(): unsupported");
    }

    @Override
    public Subscription[] getBrokerSubscriptions() throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        return super.getBrokerSubscriptions();
    }

    @Override
    void removeSubscription(ISubject subject) {
        super.removeSubscription(subject);
    }

    @Override
    Subscription addSubscription(ISubject subject) {
        return super.addSubscription(subject);
    }

    @Override
    public void setApplet(Applet applet) {
        this._delegate.setApplet(applet);
    }

    @Override
    public void setProperties(Hashtable props) {
        this._delegate.setProperties(props);
    }

    @Override
    public boolean isAppletConnection() {
        return this._delegate.isAppletConnection();
    }

    @Override
    public synchronized void setAsyncPingInterval(long interval) {
        this._desiredAsyncPingInterval = interval;
        this._desiredSyncPingInterval = -1L;
        if (this._delegateConnectionManager != null) {
            this._delegateConnectionManager.requestSetAsyncPingInterval(interval);
        }
    }

    @Override
    public synchronized void setSyncPingInterval(long interval) {
        this._desiredSyncPingInterval = interval;
        this._desiredAsyncPingInterval = -1L;
        if (this._delegateConnectionManager != null) {
            this._delegateConnectionManager.requestSetSyncPingInterval(interval);
        }
    }

    @Override
    public void setClientData(ClientData c) {
        this._delegate.setClientData(c);
    }

    @Override
    ClientData getClientData() {
        return this._delegate.getClientData();
    }

    @Override
    public void setEnableLoadBalancing(boolean t) {
        this._delegate.setEnableLoadBalancing(t);
    }

    @Override
    boolean isLoadBalancingEnabled() {
        return this._delegate.isLoadBalancingEnabled();
    }

    @Override
    public void setEnableFaultTolerance(boolean t) {
        this._delegate.setEnableFaultTolerance(t);
    }

    @Override
    public boolean isFaultToleranceEnabled() {
        return this._delegate.isFaultToleranceEnabled();
    }

    @Override
    public void setFailoverReconnectTimeout(long l) {
        this._delegate.setFailoverReconnectTimeout(l);
    }

    @Override
    long getFailoverReconnectTimeout() {
        return this._delegate.getFailoverReconnectTimeout();
    }

    @Override
    public void setInitialConnectTimeout(long timeout) {
        this._delegate.setInitialConnectTimeout(timeout);
    }

    @Override
    long getInitialConnectTimeout() {
        return this._delegate.getInitialConnectTimeout();
    }

    @Override
    public void setTxBufferSize(long l) {
        this._delegate.setTxBufferSize(l);
    }

    @Override
    long getTxBufferSize() {
        return this._delegate.getTxBufferSize();
    }

    @Override
    public long getNegotiatedTxBufferSize() {
        return this._delegate.getNegotiatedTxBufferSize();
    }

    @Override
    protected void setStandbyBrokerConnectAllowed(boolean t) {
        this.m_standbyBrokerConnectAllowed = t;
    }

    @Override
    boolean standbyBrokerConnectAllowed() {
        return this.m_standbyBrokerConnectAllowed;
    }

    @Override
    public void setLastSocketId(long lastSocketId) {
        this._delegate.setLastSocketId(lastSocketId);
    }

    @Override
    public long getLastSocketId() {
        return this._delegate.getLastSocketId();
    }

    @Override
    void setRedirectedHost(String nh) {
        throw new RuntimeException("DelegatingConnection.setRedirectedHost(): unsupported");
    }

    @Override
    public void setDisableConnectException(boolean b) {
        throw new RuntimeException("DelegatingConnection.setDisableConnectException(): unsupported");
    }

    @Override
    public void setFollowRedirect(boolean b) {
        this._delegate.setFollowRedirect(b);
    }

    @Override
    public boolean getFollowRedirect() {
        return this._delegate.getFollowRedirect();
    }

    @Override
    public byte getBrokerSessionVer() {
        return this._delegate.getBrokerSessionVer();
    }

    @Override
    public String getBrokerURL() {
        return this._delegate.getBrokerURL();
    }

    @Override
    public String[] getStandbyBrokerURLs() {
        return this._delegate.getStandbyBrokerURLs();
    }

    @Override
    public String[] getLocalBrokerURLs() {
        return this._delegate.getLocalBrokerURLs();
    }

    @Override
    public String getHost() {
        return this._delegate.getHost();
    }

    @Override
    public int getPort() {
        return this._delegate.getPort();
    }

    @Override
    public String getPrefix() {
        return this._delegate.getPrefix();
    }

    @Override
    public void setFlowControlDisabled(boolean disabled) {
        if (disabled) {
            throw new RuntimeException("setFlowControlDisabled: cannot disable");
        }
        this._delegate.setFlowControlDisabled(disabled);
    }

    @Override
    public boolean isFlowControlDisabled() {
        return this._delegate.isFlowControlDisabled();
    }

    @Override
    public short getAckMode() {
        return this._delegate.getAckMode();
    }

    @Override
    public void setAckMode(short ackMode) {
        this._delegate.setAckMode(ackMode);
    }

    public DelegatingConnection(String appId, Principal principal, MessageHandler h) throws EGeneralException, EDefaultHandlerNotSet, EInvalidApplicationId, EInvalidUserId {
        super(appId, principal, h);
        DelegateMessageHandler delegateHandler = new DelegateMessageHandler();
        MessageHandler proxy = new MessageHandler(delegateHandler, true, true);
        this._delegate = new Connection(appId, principal, proxy);
    }

    @Override
    public synchronized void cleanUp() {
        this._delegate.cleanUp();
    }

    @Override
    public void startDelivery() throws EGeneralException {
    }

    @Override
    public void stopDelivery() throws EGeneralException {
    }

    @Override
    public long getClientId() {
        long cid = this._delegate.getClientId();
        if (cid == 0L) {
            cid = this._clientId;
        }
        return cid;
    }

    @Override
    public String getClientAddrSubject() {
        String addrSubj = this._delegate.getClientAddrSubject();
        if (addrSubj == null || addrSubj.length() == 0) {
            addrSubj = super.getClientAddrSubject();
        }
        return addrSubj;
    }

    @Override
    public String getApplicationId() {
        return this._delegate.getApplicationId();
    }

    @Override
    public int getChannel() {
        return this._delegate.getChannel();
    }

    @Override
    protected void assignChannelAddresses(Connection parent) {
        Connection parentdelegate = ((DelegatingConnection)parent).getDelegate();
        this._delegate.assignChannelAddresses(parentdelegate);
    }

    @Override
    public Session getInternalSession() {
        return super.getInternalSession();
    }

    @Override
    public Session getDefaultSession() {
        return super.getDefaultSession();
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    public void connect(String[] hosts, boolean enableLoadBalancing, boolean enableRandomize, int[] randomFactors, ClientData clientdata, IHttpProxyConfig pConfig, boolean useConnectThread) throws EGeneralException {
        if (this._delegateConnectionManager == null) {
            this._delegateConnectionManager = new ConnectionManager(this.getDelegate());
            this._delegateConnectionManager.setReconnectInterval(this._reconnectInterval);
            this._delegateConnectionManager.setReconnectTimeout(this._reconnectTimeout);
            if (this._desiredSyncPingInterval >= 0L) {
                this._delegateConnectionManager.requestSetSyncPingInterval(this._desiredSyncPingInterval);
            } else if (this._desiredAsyncPingInterval >= 0L) {
                this._delegateConnectionManager.requestSetAsyncPingInterval(this._desiredAsyncPingInterval);
            }
        }
        if (this._listener != null) {
            this._delegateConnectionManager.setConnectionListener(this._listener, this.getDelegate());
        }
        this._delegateConnectionManager.requestConnect(hosts, enableLoadBalancing, enableRandomize, randomFactors, clientdata, pConfig, useConnectThread);
        this.assignAddresses();
        this.m_brethren.setElementAt(this, 0);
    }

    @Override
    public boolean connect(String host, boolean useConnectThread) throws EGeneralException {
        if (this._delegateConnectionManager == null) {
            this._delegateConnectionManager = new ConnectionManager(this.getDelegate());
            this._delegateConnectionManager.setReconnectInterval(this._reconnectInterval * 1000L);
            this._delegateConnectionManager.setReconnectTimeout(this._reconnectTimeout * 1000L * 60L);
            if (this._desiredSyncPingInterval >= 0L) {
                this._delegateConnectionManager.requestSetSyncPingInterval(this._desiredSyncPingInterval);
            } else if (this._desiredAsyncPingInterval >= 0L) {
                this._delegateConnectionManager.requestSetAsyncPingInterval(this._desiredAsyncPingInterval);
            }
        }
        if (this._listener != null) {
            this._delegateConnectionManager.setConnectionListener(this._listener, this.getDelegate());
        }
        this._delegateConnectionManager.requestConnect(host, useConnectThread);
        this.assignAddresses();
        this.m_brethren.setElementAt(this, 0);
        return true;
    }

    @Override
    public void connect(Connection parent) throws EGeneralException {
        this._delegateConnectionManager = ((DelegatingConnection)parent).getDelegateManager();
        if (this._listener != null) {
            this._delegateConnectionManager.setConnectionListener(this._listener, this.getDelegate());
        }
        this.m_principal = parent.getPrincipal();
        this._delegateConnectionManager.requestTunnel(this._delegate);
        this.m_brethren = parent.m_brethren;
        super.assignChannelAddresses(parent);
        this.assignAddresses();
    }

    @Override
    public void connect(Connection parent, long parentID) throws EGeneralException {
        this._delegateConnectionManager = ((DelegatingConnection)parent).getDelegateManager();
        if (this._listener != null) {
            this._delegateConnectionManager.setConnectionListener(this._listener, this.getDelegate());
        }
        this.m_principal = parent.getPrincipal();
        this._delegateConnectionManager.requestTunnel(this._delegate, parentID);
        this.m_brethren = parent.m_brethren;
        super.assignChannelAddresses(parent);
        this.assignAddresses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean forced) throws EGeneralException {
        try {
            if (this._delegate != null && super.getChannel() == 0) {
                this._delegateConnectionManager.requestDisconnect(forced);
            } else {
                this._delegateConnectionManager.requestTunnelClosed(this._delegate, forced);
            }
        }
        finally {
            this.m_brethren.setElementAt(null, super.getChannel());
            this._delegateConnectionManager.removeConnectionListener(this._delegate);
        }
    }

    private void assignAddresses() {
        Principal principal = this.getPrincipal();
        String uid = null;
        if (principal != null) {
            uid = principal.getName();
            this._clientId = SessionConfig.stringToClientId(uid, super.getApplicationId());
            this.m_clientAddrSubject = SessionConfig.getDirectedSubject(uid, super.getApplicationId(), LightweightAddrUtil.m_collective, uid, "reply");
        }
    }

    @Override
    public abstract void send(Envelope var1) throws ENetworkFailure, EInterrupted, EFlowControlException;

    @Override
    public abstract void send(Envelope var1, IMgramEnqueuedToSendListener var2) throws ENetworkFailure, EInterrupted, EFlowControlException;

    @Override
    public abstract void send(IMgram var1, IMgramEnqueuedToSendListener var2);

    @Override
    public abstract void send(IMgram var1);

    @Override
    public void flowControlMgramReceived(IMgram m) {
        throw new RuntimeException("DelegatingConnection.flowControlMgramReceived(): unsupported");
    }

    @Override
    IMgram sendAck(long tracking) {
        throw new RuntimeException("DelegatingConnection.sendAck(): unsupported");
    }

    @Override
    IMgram sendAck(long tracking, boolean txn, int tid, long clientID) {
        throw new RuntimeException("DelegatingConnection.sendAck(): unsupported");
    }

    @Override
    void sendQAck(long tracking, boolean txn, int tid, long clientID) {
        throw new RuntimeException("DelegatingConnection.sendQAck(): unsupported");
    }

    void sendSynchronousAck(long tracking, boolean txn, int tid) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        throw new RuntimeException("DelegatingConnection.sendSynchronousAck(): unsupported");
    }

    void sendSynchronousQAck(long tracking, boolean txn, int tid) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        throw new RuntimeException("DelegatingConnection.sendSynchronousQAck(): unsupported");
    }

    void sendSynchronousQAck(long tracking, boolean txn, int tid, long clientId) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        throw new RuntimeException("DelegatingConnection.sendSynchronousQAck(): unsupported");
    }

    @Override
    void sendFlowControlMgram(int priority) {
        throw new RuntimeException("DelegatingConnection.sendFlowControlMgram(): unsupported");
    }

    @Override
    void sendIntegrityFailure(long tracking) {
        throw new RuntimeException("DelegatingConnection.sendIntegrityFailure(): unsupported");
    }

    public byte getInternalQop(int[] subject, String identifier) {
        throw new RuntimeException("DelegatingConnection.getInternalQop(): unsupported");
    }

    @Override
    public ClientQopCache getQopCache() {
        throw new RuntimeException("DelegatingConnection.getQopCache(): unsupported");
    }

    @Override
    protected void createQopCache() {
        throw new RuntimeException("DelegatingConnection.createQopCache(): unsupported");
    }

    @Override
    public void setSocketId(long id) {
        throw new RuntimeException("DelegatingConnection.setSocketId(): unsupported");
    }

    protected void replyInternal(Envelope reply) throws ENoTrackingNum {
        int replyTracking = reply.getReplyTracking();
        long jid = (long)replyTracking & 0xFFFFFFFFL;
        Job j = this.getJob(jid);
        ((Request)j).setReply(reply);
    }

    protected void replyInternal(Job j, Envelope reply) throws ENoTrackingNum {
        ((Request)j).setReply(reply);
    }

    protected void dispatchLocalEnv(Envelope e) {
        this.m_msgSorter.dispatchLocalEnv(e);
    }

    class DelegateMessageHandler
    implements IMessageHandler {
        DelegateMessageHandler() {
        }

        @Override
        public void handleMessage(Session s, Envelope e) {
            if (e.getMessage().getSubject().getSubjectString().equals("$SYS.client.brokerConnectionDropped") && DelegatingConnection.this._listener != null) {
                DelegatingConnection.this._listener.disconnected(DelegatingConnection.this._delegate, "connection dropped", -5);
            }
        }
    }
}

