/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import progress.message.client.EConnectFailure;
import progress.message.client.EConnectionNotResumable;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.ENetworkFailure;
import progress.message.client.EUserAlreadyConnected;
import progress.message.net.ISocket;
import progress.message.util.AutoVec;
import progress.message.zclient.Connection;
import progress.message.zclient.ConnectionContext;
import progress.message.zclient.IVetoableOnConnectListener;
import progress.message.zclient.ReconnectHelper;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SocketDropHandler;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;
import progress.message.zclient.xonce.IRecoveryMutex;
import progress.message.zclient.xonce.SocketDoubtResolver;

public class FaultTolerantDropHandler
extends SocketDropHandler
implements IDoubtResolverCompletionListener,
IVetoableOnConnectListener {
    private boolean m_enteredOnce = false;
    private Connection m_con = null;
    private volatile SocketDoubtResolver m_resolver = null;
    private volatile boolean m_resolved = false;
    private volatile IOException m_resolver_exception = null;
    private Object m_resolvedMutex = new Object();

    public FaultTolerantDropHandler(Connection con) {
        super("FaultTolerantDropHandler");
        this.m_con = con;
        this.m_con.getReconnector().setVetoableOnConnectListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void socketDropped(int errcode, int errinfo, ConnectionContext sockContext) {
        Object linked;
        FaultTolerantDropHandler faultTolerantDropHandler = this;
        synchronized (faultTolerantDropHandler) {
            if (this.m_enteredOnce) {
                return;
            }
            this.m_enteredOnce = true;
        }
        sockContext.waitForPeersToTerminate();
        if (!this.m_con.isFaultToleranceEnabled()) {
            this.forward(errcode, errinfo, sockContext);
            return;
        }
        boolean recovering = false;
        Object object = this.m_resolvedMutex;
        synchronized (object) {
            recovering = this.m_con.getRecoveryMutex().isRecovering();
            if (recovering) {
                this.onDisconnectDuringResolution();
                return;
            }
        }
        if (this.m_con.getState() == 3) {
            this.m_con.connectionDropped(errcode, errinfo, 3);
            return;
        }
        if (this.m_con.getState() != 0) {
            this.forward(errcode, errinfo, sockContext);
            return;
        }
        this.m_con.getContext().waitNoConnectInProgress();
        AutoVec brethren = this.m_con.cloneBrethren();
        this.notifyStartOfRecovery(brethren);
        boolean interrupted = Thread.interrupted();
        int recoveryErrcode = 0;
        int recoveryErrinfo = 0;
        try {
            if (!this.recover()) {
                recoveryErrcode = errcode;
                recoveryErrinfo = errinfo;
            }
        }
        catch (EConnectionNotResumable enr) {
            recoveryErrcode = -39;
            linked = enr.getLinkedException();
            recoveryErrinfo = linked != null ? enr.getLinkedException().getErrorId() : 0;
        }
        catch (EUserAlreadyConnected enr) {
            recoveryErrcode = -39;
            recoveryErrinfo = enr.getErrorId();
        }
        catch (EConnectFailure ecf) {
            if (ecf.getErrorId() != 121) {
                SessionConfig.logMessage(ecf, SessionConfig.getLevelWarning());
            }
            recoveryErrcode = errcode;
            recoveryErrinfo = errinfo;
        }
        catch (ENetworkFailure enf) {
            recoveryErrcode = errcode;
            recoveryErrinfo = errinfo;
        }
        catch (Throwable t) {
            SessionConfig.logMessage(t, SessionConfig.getLevelWarning());
            recoveryErrcode = errcode;
            recoveryErrinfo = errinfo;
        }
        boolean success = recoveryErrcode == 0;
        linked = this.m_resolvedMutex;
        synchronized (linked) {
            if (success && this.m_resolver_exception != null) {
                success = false;
                recoveryErrcode = errcode;
                recoveryErrinfo = errinfo;
            }
            this.notifyEndOfRecovery(success, brethren);
        }
        if (!success) {
            this.m_con.m_dropHandler = null;
            ISocket socket = this.m_con.getSocket();
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.forward(recoveryErrcode, recoveryErrinfo, sockContext);
        }
    }

    private boolean recover() throws Throwable {
        ReconnectHelper reconnector = this.m_con.getReconnector();
        return reconnector.connect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStartOfRecovery(AutoVec brethren) {
        IRecoveryMutex iRecoveryMutex = this.m_con.getRecoveryMutex();
        synchronized (iRecoveryMutex) {
            for (int i = 0; i < brethren.size(); ++i) {
                Connection c = (Connection)brethren.elementAt(i);
                if (c == null || c.getState() != 0) continue;
                c.notifyStartOfRecovery();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEndOfRecovery(boolean success, AutoVec brethren) {
        IRecoveryMutex iRecoveryMutex = this.m_con.getRecoveryMutex();
        synchronized (iRecoveryMutex) {
            for (int i = 0; i < brethren.size(); ++i) {
                Connection c = (Connection)brethren.elementAt(i);
                if (c == null) continue;
                c.notifyEndOfRecovery(success);
            }
        }
    }

    public void onDisconnectDuringResolution() {
        SocketDoubtResolver resolver = this.m_resolver;
        if (resolver != null) {
            resolver.onDisconnectDuringResolution();
        }
        this.m_con.disallowRecoveryJobs();
        boolean zapRegularJobs = false;
        this.m_con.getConnectionInfo().onDisconnectDuringResolution();
        this.m_con.terminateSyncOps(-5, zapRegularJobs);
        this.failed(resolver, new IOException("asynchronous disconnect"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnect(boolean recovery) throws IOException, EGeneralException {
        if (!recovery) {
            return;
        }
        try {
            FaultTolerantDropHandler faultTolerantDropHandler = this;
            synchronized (faultTolerantDropHandler) {
                if (this.m_enteredOnce) {
                    throw new IOException("Connection Drop has already been detected");
                }
                this.m_con.allowRecoveryJobs();
                this.m_resolver = new SocketDoubtResolver(this.m_con);
                this.m_resolver.setCompletionListener(this);
                this.setUnresolved();
            }
            this.m_resolver.initiateResolution();
            this.waitForResolution();
            if (this.m_resolver_exception != null) {
                throw this.m_resolver_exception;
            }
            faultTolerantDropHandler = this;
            synchronized (faultTolerantDropHandler) {
                if (this.m_enteredOnce) {
                    throw new IOException("Connection Drop has already been detected");
                }
                this.setUnresolved();
            }
            this.m_resolver.initiateSecondaryStateResolution();
            this.waitForResolution();
            if (this.m_resolver_exception != null) {
                throw this.m_resolver_exception;
            }
        }
        finally {
            this.m_con.disallowRecoveryJobs();
            this.m_resolver = null;
        }
    }

    private void setUnresolved() {
        this.m_resolved = false;
        this.m_resolver_exception = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResolution() throws EInterrupted {
        Object object = this.m_resolvedMutex;
        synchronized (object) {
            while (!this.m_resolved) {
                try {
                    this.m_resolvedMutex.wait();
                }
                catch (InterruptedException ie) {
                    throw new EInterrupted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(IDoubtResolver resolver, int status) {
        Object object = this.m_resolvedMutex;
        synchronized (object) {
            if (resolver != this.m_resolver) {
                return;
            }
            if (this.m_resolved) {
                return;
            }
            this.m_resolved = true;
            this.m_resolvedMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(IDoubtResolver resolver, IOException ioe) {
        Object object = this.m_resolvedMutex;
        synchronized (object) {
            if (resolver != this.m_resolver) {
                return;
            }
            this.m_resolved = true;
            this.m_resolver_exception = ioe;
            this.m_resolvedMutex.notifyAll();
        }
    }
}

