/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Objects;
import progress.message.util.StreamUtil;
import progress.message.zclient.ILabelVisitor;

public class Label
implements Cloneable {
    private boolean m_guaranteed;
    private long m_expirationTime = -1L;
    private long m_publishTime = -1L;
    private boolean m_nonstop;
    private int m_route_limit;
    private boolean m_persistent;
    private byte m_priority;
    private byte m_replyPriority;

    public Label() {
        this.m_guaranteed = false;
        this.m_expirationTime = -1L;
        this.m_persistent = false;
        this.m_route_limit = 7;
        this.m_priority = 0;
        this.m_replyPriority = 0;
    }

    public Label(Label pattern) {
        this.m_guaranteed = pattern.m_guaranteed;
        this.m_expirationTime = pattern.m_expirationTime;
        this.m_route_limit = pattern.m_route_limit;
        this.m_publishTime = pattern.m_publishTime;
        this.m_persistent = pattern.m_persistent;
        this.m_nonstop = pattern.m_nonstop;
        this.m_priority = pattern.m_priority;
        this.m_replyPriority = pattern.m_replyPriority;
    }

    public synchronized void setGuaranteed(boolean on) {
        this.m_guaranteed = on;
    }

    public synchronized boolean isGuaranteed() {
        return this.m_guaranteed;
    }

    public synchronized void setExpirationTime(long expirationTime) {
        this.m_expirationTime = expirationTime;
    }

    public synchronized void setExpiration(Date expirationDate) {
        this.m_expirationTime = expirationDate == null ? -1L : expirationDate.getTime();
    }

    public synchronized long getExpirationTime() {
        return this.m_expirationTime;
    }

    public synchronized Date getExpiration() {
        if (this.m_expirationTime == -1L) {
            return null;
        }
        return new Date(this.m_expirationTime);
    }

    public synchronized void setPublishTime(long publishTime) {
        this.m_publishTime = publishTime;
    }

    public synchronized long getPublishTime() {
        return this.m_publishTime;
    }

    public synchronized void setPersistent(boolean persistent) {
        this.m_persistent = persistent;
    }

    public synchronized boolean isPersistent() {
        return this.m_persistent || this.m_guaranteed;
    }

    public boolean isNonStop() {
        return this.m_nonstop;
    }

    public void setNonStop(boolean ns) {
        this.m_nonstop = ns;
    }

    public synchronized void setRouteLimit(int route_limit) {
        this.m_route_limit = route_limit;
    }

    public synchronized int getRouteLimit() {
        return this.m_route_limit;
    }

    public void setPriority(byte priority) {
        if (priority > 12) {
            priority = (byte)12;
        } else if (priority < 0) {
            priority = 0;
        }
        this.m_priority = priority;
    }

    public byte getPriority() {
        return this.m_priority;
    }

    public byte getReplyPriority() {
        return this.m_replyPriority;
    }

    public void setReplyPriority(byte priority) {
        this.m_replyPriority = priority;
    }

    public void visit(ILabelVisitor visitor) {
        visitor.setGuaranteed(this.m_guaranteed);
        visitor.setPersistent(this.m_persistent);
        visitor.setRouteLimit(this.m_route_limit);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Label lab = (Label)obj;
        boolean ret = this.m_guaranteed == lab.m_guaranteed && this.m_nonstop == lab.m_nonstop && this.m_persistent == lab.m_persistent && this.m_route_limit == lab.m_route_limit && this.m_priority == lab.m_priority && this.m_replyPriority == lab.m_replyPriority && this.m_publishTime == lab.m_publishTime && this.m_expirationTime == lab.m_expirationTime;
        return ret;
    }

    public int hashCode() {
        return Objects.hash(this.m_guaranteed, this.m_nonstop, this.m_persistent, this.m_route_limit, this.m_priority, this.m_replyPriority, this.m_publishTime, this.m_expirationTime);
    }

    public void serialize(OutputStream out) throws IOException {
        this.serialize(out, false);
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeBoolean(this.m_guaranteed);
        out.writeLong(this.m_expirationTime);
        out.writeBoolean(this.m_persistent);
        out.writeInt(this.m_route_limit);
    }

    public void serialize(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeBoolean(this.m_guaranteed, os);
        if (this.m_expirationTime == -1L) {
            StreamUtil.writeLong(-1L, os);
        } else if (tteTTLConvert) {
            StreamUtil.writeLong(this.m_expirationTime - System.currentTimeMillis(), os);
        } else {
            StreamUtil.writeLong(this.m_expirationTime, os);
        }
        StreamUtil.writeBoolean(this.m_persistent, os);
        StreamUtil.writeInt(this.m_route_limit, os);
    }

    public static Label unserialize(InputStream is, boolean tteTTLConvert) throws IOException {
        Label lbl = new Label();
        lbl.m_guaranteed = StreamUtil.readBoolean(is);
        long result = StreamUtil.readLong(is);
        lbl.m_expirationTime = tteTTLConvert ? (result == -1L ? -1L : System.currentTimeMillis() + result) : (result == -1L ? -1L : result);
        lbl.m_persistent = StreamUtil.readBoolean(is);
        lbl.m_route_limit = StreamUtil.readInt(is);
        return lbl;
    }

    public static Label unserialize(DataInput in) throws IOException {
        Label lbl = new Label();
        lbl.m_guaranteed = in.readBoolean();
        lbl.m_expirationTime = in.readLong();
        lbl.m_persistent = in.readBoolean();
        lbl.m_route_limit = in.readInt();
        return lbl;
    }

    public static final int length() {
        return 14;
    }

    public Object clone() {
        return new Label(this);
    }

    public String toString() {
        return "Label: guar= " + this.m_guaranteed + " pers= " + this.m_persistent + " nonStop= " + this.m_nonstop;
    }
}

