/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.util.DebugState;
import progress.message.util.PriorityQueue;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;

public final class MessageHandlerQueue
extends DebugObject {
    private Envelope m_tempEnv = null;
    private PriorityQueue m_msgQueue = new PriorityQueue(13);
    private PriorityQueue m_imhQueue = new PriorityQueue(13);

    public MessageHandlerQueue() {
        super(DebugState.GLOBAL_DEBUG_ON ? "MessageHandlerQueue" : null);
    }

    public synchronized void addElement(Envelope msg, IMessageHandler imh) {
        byte prio = msg.getLabel().getPriority();
        this.m_msgQueue.enqueue(msg, prio);
        this.m_imhQueue.enqueue(imh, prio);
        this.notifyAll();
        if (this.DEBUG) {
            this.debug("just added message " + msg.toString());
        }
    }

    synchronized Envelope nextEnvelope() throws InterruptedException {
        this.m_tempEnv = null;
        while (this.m_msgQueue.isEmpty()) {
            this.wait();
        }
        this.m_tempEnv = (Envelope)this.m_msgQueue.dequeue();
        if (this.DEBUG) {
            this.debug("extracted message: " + this.m_tempEnv.toString());
        }
        return this.m_tempEnv;
    }

    synchronized IMessageHandler nextIHandler() throws InterruptedException {
        while (this.m_imhQueue.isEmpty()) {
            this.wait();
        }
        IMessageHandler imh = (IMessageHandler)this.m_imhQueue.dequeue();
        if (this.DEBUG) {
            this.debug("extracted ihandler: " + imh.toString());
        }
        return imh;
    }

    int getQueueSize() {
        return this.m_msgQueue.getEnqueued();
    }
}

