/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Vector;
import progress.message.util.DebugState;
import progress.message.zclient.ClientSearchResults;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.Envelope;
import progress.message.zclient.HandlerIHandlerContainer;
import progress.message.zclient.IPrioQueueLimiter;
import progress.message.zclient.IQuencher;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.SingleMessageLimiter;
import progress.message.zclient.SubjectSpace;

final class MessageSorter
extends DebugObject
implements IQuencher {
    private SubjectSpace m_subjects;
    private MessageHandler m_defaultHandler;
    private Connection m_connection;
    private ClientSearchResults m_matches;
    private int m_msgno;
    private IPrioQueueLimiter m_limiter;
    private boolean m_useSingleMessageLimiter = false;
    private Object m_syncObj = new Object();

    public MessageSorter(Connection connection, SubjectSpace subjects, boolean useSingleMessageLimiter) {
        super(DebugState.GLOBAL_DEBUG_ON ? "MessageSorter" : null);
        this.m_useSingleMessageLimiter = useSingleMessageLimiter;
        this.m_subjects = subjects;
        this.m_defaultHandler = null;
        this.m_connection = connection;
        this.m_matches = new ClientSearchResults();
        this.m_msgno = 0;
        if (useSingleMessageLimiter) {
            this.m_limiter = new SingleMessageLimiter(this);
            if (this.checkDebugFlags(8192)) {
                this.debug("connection appId = " + connection.getApplicationId() + " - using alternative limiter " + this.m_limiter.getClass().getName());
            }
        } else {
            PrioQueueLimiter.Builder builder = new PrioQueueLimiter.Builder();
            builder.normLimit(1000000).reserved(5000).highLimit(100000).restartThreshold(1000);
            this.m_limiter = builder.build(this);
        }
    }

    public final void defaultHandler(MessageHandler msgHandler) {
        this.m_defaultHandler = msgHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispatchRemoteEnv(Envelope env) throws InterruptedException {
        if (this.DEBUG) {
            try {
                if (env.isReply()) {
                    this.debug("got reply message " + env.getReplyTracking() + " for " + env.getMessage().getSubject());
                } else {
                    Message m = env.getMessage();
                    this.debug("got message for " + m.getSubject());
                }
            }
            catch (ENoTrackingNum e) {
                this.debug("got invalid reply message");
            }
        }
        int size = env.length();
        byte priority = env.getLabel().getPriority();
        env.setTrackHandlers(this);
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_limiter.add(size, priority);
        }
        this.dispatch(env, true);
    }

    public synchronized void dispatchLocalEnv(Envelope env) {
        env.getMgram().setSubject(env.getMessage().getSubject(), 0);
        this.dispatch(env, false);
    }

    public synchronized void redispatch(Envelope env) {
        Envelope newenv = (Envelope)env.clone();
        newenv.clearTrackHandlers();
        this.dispatch(newenv, false);
    }

    private void dispatch(Envelope env, boolean remote) {
        ++this.m_msgno;
        Message m = env.getMessage();
        this.m_matches = new ClientSearchResults();
        this.m_subjects.get(env.getSubject(), this.m_matches);
        boolean sysSubject = env.getSubject().isSystem();
        env.m_subject_ok = true;
        if (this.m_matches.m_handlers.m_count > 0) {
            int int_count = 0;
            if (this.m_matches.m_handlers.m_count > 0) {
                if (env.isGuaranteed() && !sysSubject && remote) {
                    if (env.isQueueMessage()) {
                        this.m_connection.getConnectionInfo().rcvdGuarQMsg(env.getMgram().getGuarenteedTrackingNum(), null);
                    } else {
                        this.m_connection.getConnectionInfo().rcvdGuarMsg(env.getMgram().getGuarenteedTrackingNum(), null);
                    }
                }
                for (int k = 0; k < this.m_matches.m_handlers.m_count; ++k) {
                    Vector mh_list = (Vector)this.m_matches.m_handlers.m_data[k];
                    int size = mh_list.size();
                    for (int i = size - 1; i >= 0; --i) {
                        HandlerIHandlerContainer hih = null;
                        try {
                            hih = (HandlerIHandlerContainer)mh_list.elementAt(i);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            continue;
                        }
                        MessageHandler mh = hih.getHandler();
                        if (this.DEBUG) {
                            this.debug("delivering to " + mh);
                        }
                        if (sysSubject && mh.getFilterStatus()) continue;
                        ++int_count;
                        hih.newMessage(env, this.m_msgno);
                    }
                }
            }
            if (!(int_count != 0 || sysSubject && this.m_defaultHandler.getFilterStatus())) {
                if (this.DEBUG) {
                    this.debug("delivering to default handler");
                }
                this.m_defaultHandler.newMessage(env, this.m_msgno);
            }
        } else if (!sysSubject || !this.m_defaultHandler.getFilterStatus()) {
            if (this.DEBUG) {
                this.debug("delivering to default handler");
            }
            this.m_defaultHandler.newMessage(env, this.m_msgno);
        }
        env.noMoreHandlers();
    }

    void sendAck(long tracking) {
        this.m_connection.sendAck(tracking);
    }

    void sendSyncSplitDeliveryAck(long tracking, short subjectTracking) {
        this.m_connection.sendSplitDeliveryAck(tracking, subjectTracking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeQueueMemory(int size, int priority) {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_limiter.add(-size, priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMinEnqueuePriority() {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_limiter.resetMinPriority(0);
        }
    }

    @Override
    public void setMinEnqueuePriority(int prio) {
        this.m_connection.sendFlowControlMgram(prio);
    }

    public void notifyStartOfRecovery() {
        if (this.m_useSingleMessageLimiter) {
            ((SingleMessageLimiter)this.m_limiter).beginDisableFlowControl();
        } else {
            this.resetMinEnqueuePriority();
        }
    }

    public void notifyEndOfRecovery() {
        if (this.m_useSingleMessageLimiter) {
            ((SingleMessageLimiter)this.m_limiter).endDisableFlowControl();
        }
    }
}

