/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.security.SecureRandom;

public final class ProgressSecureRandom {
    private static final boolean DEBUG = false;
    private static SecureRandom s_sr = null;
    private static Object s_syncObj = new Object();
    private static long startTime = -1L;
    private static boolean selfSeeded = false;

    public void nextBytes(byte[] bytes) {
        s_sr.nextBytes(bytes);
    }

    public int nextInt() {
        return s_sr.nextInt();
    }

    public long nextLong() {
        return s_sr.nextLong();
    }

    public float nextFloat() {
        return s_sr.nextFloat();
    }

    public double nextDouble() {
        return s_sr.nextDouble();
    }

    public double nextGaussian() {
        return s_sr.nextGaussian();
    }

    public static SecureRandom theSecureRandom() {
        return ProgressSecureRandom.theSecureRandom(ProgressSecureRandom.convertLongToByteArray(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecureRandom theSecureRandom(byte[] seed) {
        if (s_sr == null) {
            Object object = s_syncObj;
            synchronized (object) {
                if (s_sr == null) {
                    s_sr = new SecureRandom();
                    if (seed != null) {
                        s_sr.setSeed(seed);
                    } else {
                        selfSeeded = true;
                        s_sr.nextBytes(new byte[8]);
                    }
                }
            }
        }
        if (seed == null && !selfSeeded) {
            Object object = s_syncObj;
            synchronized (object) {
                if (!selfSeeded) {
                    s_sr = null;
                    selfSeeded = true;
                    s_sr = new SecureRandom();
                    s_sr.nextBytes(new byte[8]);
                }
            }
        }
        return s_sr;
    }

    public static byte[] convertLongToByteArray(long value) {
        byte[] b = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return b;
    }
}

